/*  A *.MSG --> Adept Outbound conversion Rexx Script

   Written by Robert Stephens.
   Internet : ourjs@net-unix.newcastle.edu.au
   Fidonet  : 3:622/421

   This script has been heavily modified to work with multiple
   network names, and provides a cleaner and more verbose output
   than Bre2Adept.Cmd it also lacks the phantom address bug that
   was featured in Bre2Adept.Cmd

   This Script was written because the current ones did not support
   enough features for a System that processes BRE/Lordnet attaches
   from many downlinks.

   Features Added :
        - Fully Configurable, from the directories to the Attributes.
        - Recognises full domains and allows use of multiple network
          Zones.
        - Optionally Kill/Backup Netmails from Unknown Systems.
        - Change Attributes on messages on a Per Node basis.
        - Full Logging of all processing.
        - Gives a fair bit of screen output too.

***| Begin Configuration |******************************************************/
    Outbound = 'D:\Adept\Mailer\Outbound_Mail'  /* DO NOT Put a "\" on the End */
    LogFile = 'D:\Bre\AdeptOut.log'             /* Path to a log File */

    Unknown = K                           /* Attribute for unknown netmails */
                                          /* H=Hold, N=Normal, C=Crash, K=Kill */
                                          /* B=Backup */

    Backup = 'D:\Bre\Backup\'         /* Directory to Move Netmail attaches
                                         to if the "B" Attribute is used */

                       /* Domains = '<zone> <domain> <zone> <domain> etc etc' */
   Domains = '1 fidonet 2 fidonet 3 fidonet 15 sbcnet 13 sbcnet 9 coastlink'


                      /* Downlinks = '<node> <attr> <node> <attr> etc etc'
                         Attributes are, N - Normal, C - Crash, H - Hold
                         Use 4D Addresses or else! */
   Downlinks = '3:622/407.0 N 3:622/421.1 H'

/**| End of Configuration |*****************************************************/

Cls
proc = 0
killed = 0
back_up = 0
C0 = ""
Start = Time()"   -- Begin AdeptOut -- "
Day = "            ** "Date()" **"
say '        AdeptOut v0.1 - *.MSG -> Adept Outbound Rexx Conversion Script'
say '                             by Robert Stephens'
say ''
say 'Searching for Netmail Attaches ...'

Log = lineout(LogFile,C0)
Log = lineout(LogFile,Start)
Log = lineout(LogFile,Day)
do i = 1 to 100
proc = proc + 1
infile = i'.msg'

a = charin(infile,1,0)
from = charin(infile,,25)

b = charin(infile,37,0)
to = charin(infile,,25)

c = charin(infile,197,0)
addrs = charin(infile,,28)

d = charin(infile,73,0)
filetosend = "^"charin(infile,,50)

if filetosend = '^' then signal finish

toaddr = word(addrs,1)
fromaddr = word(addrs,2)

remov = pos("",fromaddr)
remov = remov - 2
fromaddr = delstr(fromaddr,remov)

PARSE VAR fromaddr Zone ':' Net '/' Nodenum '.' Point

say ''
say 'From : 'from '('fromaddr')'
say 'To   : 'to '('toaddr')'
say 'File : 'filetosend

C0 = ""
B0 = "            Processing Netmail Attaches"
B1 = "            From : "fromaddr
B2 = "            To   : "toaddr
B3 = "            File : "filetosend

Log = lineout(LogFile,B0)
Log = lineout(LogFile,B1)
Log = lineout(LogFile,B2)
Log = lineout(LogFile,B3)

Number = wordpos(zone,domains)
Number = Number + 1
Dom = word(domains,Number)

PARSE VAR fromaddr Zone ':' Net '/' Nodenum '.' Point
IF Point = "" Then Point = 0
fromaddr = Zone':'Net'/'Nodenum'.'Point

Number1 = wordpos(fromaddr,downlinks)
IF Number1 = 0 Then DO
   Say '***** 'fromaddr' not found in Downlink List *****'
   Err = '***** 'fromaddr' not found in Downlink List *****'
   Log = lineout(LogFile,Err)
   Number2 = 10
END

Number1 = Number1 + 1
Down = word(downlinks,Number1)
Attr = Down

IF Number2 = 10 Then Attr = Unknown
     Number2 = 0
     f = lineout(outbound'\'attr'.'zone'.'net'.'nodenum'.'point'.'dom,filetosend)
     anyfile = outbound'\'attr'.'zone'.'net'.'nodenum'.'point'.'dom
     g = lineout(anyfile)
     IF attr = "K" Then Do
         '@Del 'outbound'\'attr'.'zone'.'net'.'nodenum'.'point'.'dom' >NUL'
         Say 'Killed Unknown Netmail from 'zone':'net'/'nodenum'.'point'@'dom
         Killed = Killed + 1
         Log = lineout(LogFile,'Killed Unknown Netmail from 'zone':'net'/'nodenum'.'point'@'dom)
     End
     IF attr = "B" Then Do
         '@Xcopy 'outbound'\'attr'.'zone'.'net'.'nodenum'.'point'.'dom' 'backup' >NUL'
         '@Del 'outbound'\'attr'.'zone'.'net'.'nodenum'.'point'.'dom' >NUL'
         Say 'Backed Up Unknown Netmail from 'zone':'net'/'nodenum'.'point'@'dom' to 'backup
         Back_Up = Back_Up + 1
         Log = lineout(LogFile,'Backed Up Unknown Netmail from 'zone':'net'/'nodenum'.'point'@'dom' to 'backup)
     End
     say ''
     say 'Created 'outbound'\'attr'.'zone'.'net'.'nodenum'.'point'.'dom''
     h = lineout(infile)  /* Closes the file */
     say 'Unlinking Fido file attach 'i'.MSG'
     here:
     '@del 'infile' >NUL'

end /* do loop */

finish:
proc = proc - 1
total = proc - killed
total = total - back_up
say ''
say 'Netmails Processed : 'proc
say 'Netmails Killed    : 'killed
say 'Netmails Backed Up : 'Back_Up
say ''
say 'Netmails Successfully Processed : 'Total
proc = "            Netmails Processed : "proc
Killed = "            Netmails Killed    : "Killed
Back_Up = "            Netmails Backed Up : "Back_Up
Total = "            Netmails Successfully Processed : "Total
Ending = Time()"   -- End AdeptOut -- "

Log = lineout(LogFile,C0)
Log = lineout(LogFile,Proc)
Log = lineout(LogFile,Killed)
Log = lineout(LogFile,Back_Up)
Log = lineout(LogFile,C0)
Log = lineout(LogFile,Total)
Log = lineout(LogFile,C0)
Log = lineout(LogFile,Ending)
exit
