
unit blditem;
{$O+,F+}
interface

uses dos,crt,bbskv,bbskern;

procedure makeitems;

implementation

uses readonce,rgoods;

var
    ps:pathstr; ds:dirstr; ns:namestr; es:extstr;

    thisitem:itemrec;
    itemno:word;
    item:idr;

    itemfile:file of idr;

    taskstr: string[2];
    workfile:text;
    fnam:string[80];
    linein:string[127];
    restofline:string[80];
    arg,arg2,arg3:string[64];
    parses:array[1..16] of string[20];
    v1,v2,v3,v4,v5,v6,v7,v8,v9:integer;
    v0:word;
    tmp1,tmp2,tmp3,tmp4:string;
    comd:char;
    linenum,index2:integer;
    addressindex:integer;
    cfilename:string;
    totalitems:integer;

procedure parse;
var index:integer;
begin
  fillchar(parses,sizeof(PARSES),chr(0));
  while (copy(linein,one,one)=' ') do delete (linein,one,one); {This gets rid of leading spaces}
  index2:=one;
  repeat
    begin
      index:=one; {reset the counter}
      while ((copy(linein,index,one)<>' ') and (index <= length(linein))) do index:=index+one; {Seek out space}
      parses[index2]:=copy(linein,one,(index-one)); {When it finds space the length of the first string is index-1}
      delete(linein,one,index); {Get rid of that part of the input string; it's now in parse1}
      while (copy(linein,one,one)=' ') do delete (linein,one,one); {This gets rid of leading spaces}
      if index2=1 then restofline:=linein;
      inc(index2);
    end
  until((index2>4) or (length(linein)<1));
end; {Procedure Parse}

procedure processline;
var cml,cmle:string[64];
    cmle2,cmle3:string[3];
    index:integer;
    zone,net,node,point:word;
begin
  itemno:=1;
  addressindex:=0;
  for index:=1 to 3 do parses[index]:=upcasestr(parses[index]);
  cml:=copy(parses[1],1,2); arg:=parses[2]; arg2:=parses[3]; arg3:=parses[4];
  v2:=str2int(arg); v3:=str2int(arg2); v4:=str2int(arg3);

  if
    (cml='IT')
  then
    begin
      inc(totalitems);
      gotoxy(1,wherey); textattr:=red; write('Item: ');
      textattr:=lightred; write(totalitems,'    ');
      fillchar(thisitem,sizeof(thisitem),#00);
      thisitem.attr:=$00;
      cmle:='';
      itemno:=v2;
      if (itemno>0) and (itemno<100) then
        begin
          thisitem:=item[itemno];
          repeat
            begin
              readln(workfile,linein);
              inc(linenum);
              parse;
              for index:=1 to 16 do parses[index]:=upcasestr(parses[index]);
              cmle:=parses[1]; arg:=parses[2]; arg2:=parses[3]; v2:=str2int(arg); v3:=str2int(arg2);
              cmle2:=copy(cmle,1,3); cmle3:=copy(arg,1,3);


              if (cmle2='NAM') then thisitem.name:=restofline;
{Battle}      if (cmle2='BAT') then begin thisitem.itemtype:=1; thisitem.effect:=v2; end;
{Transporter} if (cmle2='TRA') then begin thisitem.itemtype:=2; thisitem.effect:=v2; end;
{Antigrav}    if (cmle2='ANT') then begin thisitem.itemtype:=3; thisitem.effect:=v2; end;
{Heal}        if (cmle2='HEA') then begin thisitem.itemtype:=4; thisitem.effect:=v2; end;
{AllHeal}     if (cmle2='ALL') then begin thisitem.itemtype:=5; thisitem.effect:=v2; end;
{SuperHP}     if (cmle2='SUP') then begin thisitem.itemtype:=6; thisitem.effect:=v2; end;

              if (cmle2='CHA') then thisitem.charge:=v2;
              if (cmle2='REC') then begin thisitem.attr:=thisitem.attr or $0001; thisitem.chargecost:=v2; end; {recharge}
              if (cmle2='DES') then thisitem.attr:=thisitem.attr or $0002; {destruct}
              if (cmle2='PER') then thisitem.attr:=thisitem.attr or $0004; {perpetual}

            end;
          until (cmle2='END');

          item[itemno]:=thisitem;
        end;
    end;

end;

procedure makeitems;
begin
  linenum:=0;
  totalitems:=0;
  sendln('`LCompiling Maze...'+crlf);
  fillchar(thisitem,sizeof(thisitem),#0);

  cfilename:='ITEMS.CTL';
  if
    (not existfile(cfilename))
  then
    begin
      sendln('`JFatal Error!');
      sendln(crlf+'Critical file missing: ITEMS.CTL');
      halt;
    end;
  assign(workfile,cfilename);
  reset(workfile);
  repeat
    begin
      readln(workfile,linein);
      inc(linenum);
      parse;
      processline;
    end;
  until eof(workfile);
  close(workfile);

  writeln;
  textattr:=white;
  writeln(crlf+'Writing ',itemname);
  assign(itemfile,itemname);
  rewrite(itemfile);
  write(itemfile,item);
  close(itemfile);
  sendln(crlf+'`OAll Done!'+crlf);
  sendln('`L'+int2str(totalitems)+' `Gitems compiled!');
  gotoxy(1,22);
  quietquit:=true;
end;

begin
end.
