#!/bin/bash
# bcstathtml.sh - 28 Nov 06 - Robert J. Clay
#
BBBSDIR=/opt/bbbs
WORKPATH=$BBBSDIR/work
HTMLPATH=$BBBSDIR/htdocs/stats 
SCRPTDIR=$BBBSDIR/scripts

# 1st parameter should be "wk", or "mth"
PERIOD=$1
# 2nd parameter should be "Weekly", or "Monthly"
PERIODLY=$2
# 3rd parameter should be base of the conference name
CONF=$3
# 4th parameter should be middle part of the file name
MID=$4
# 5th parameter is the number of days for the 
DAYS=$5

cd $BBBSDIR
#   

$BBBSDIR/bbbs bcstat ^$CONF. -$DAYS |sort -r -o $WORKPATH/bcstat.txt.$PERIOD 

$BBBSDIR/bbbs btxt2bbs rocasa.stats $WORKPATH/bcstat.txt.$PERIOD /S $PERIODLY Stats

echo "<html>" > $WORKPATH/bcstat$PERIOD.html

echo "<head><title>Rocasa BBS Conference Stats:  $PERIODLY</title>" >> $WORKPATH/bcstat$PERIOD.html

echo "<link rel=stylesheet href=bbbs.css TYPE=text/css>"  >> $WORKPATH/bconf$PERIOD.html

echo "</head><body>"  >> $WORKPATH/bcstat$PERIOD.html

echo "<a name=top><h1>Rocasa BBS $PERIODLY Conference Stats</h1></a>"  >> $WORKPATH/bcstat$PERIOD.html

echo "<p>This is a $PERIODLY listing of the conference statistics for all $CONF message areas carried here at Rocasa BBS. </p> "  >> $WORKPATH/bcstat$PERIOD.html

echo "<p>Page last updated:  `date` </p>"  >> $WORKPATH/bcstat$PERIOD.html

echo "<p> <pre>"  >> $WORKPATH/bcstat$PERIOD.html

cat $WORKPATH/bcstat.txt.$PERIOD >> $WORKPATH/bcstat$PERIOD.html

echo "</pre></p>"  >> $WORKPATH/bcstat$PERIOD.html

cat $WORKPATH/statsel.tpl >> $WORKPATH/bcstat$PERIOD.html
cat $WORKPATH/tail1.tpl >> $WORKPATH/bcstat$PERIOD.html
cp  $WORKPATH/bcstat$PERIOD.html $HTMLPATH/$CONF$MID$PERIOD.html
#
## mirror to z1net web site
#$SCRPTDIR/wstatsftp.sh $CONF$MID$PERIOD
exit 0

