/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: msgs.h 110 2009-06-02 02:41:35Z frank $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/msgs.h $
// $LastChangedDate: 2009-06-01 22:41:35 -0400 (Mon, 01 Jun 2009) $
// $LastChangedRevision: 110 $
// $LastChangedBy: frank $

# ifndef MSGS_H
# define MSGS_H

# include <string>
# include "struct.h"

typedef struct msgs {

    int  read_emaillist(EmailIdx *em, int recno);
    int  save_emaillist(EmailIdx *em, int recno);


    int  mbaselist_lockSet(int onoff);
    int  read_mbaselist(mb_list_rec *mr, int recno);
    int  save_mbasetemp(mb_list_rec *mr, int recno);

    void purgeForums2();
    int  save_mbaselist(mb_list_rec *mr, int recno, int force2=FALSE);
    int  msg_count();
    void save_msgbase(mb_list_rec *mb);
	int  msg_find(char *tfile);

	int  jlr_lockSet(int onoff);
	int  readlr(LastRead *lr, int idx, mb_list_rec *mb);
	int  writelr(LastRead *lr, int idx, mb_list_rec *mb);

	unsigned long
		 JamAreaGetLast(long usernum, mb_list_rec *mb);
	void JamAreaSetLast(long usernum, long msgnum, mb_list_rec *mb);

	/* Useless, Can't determine deleted messages!
	int  readidx(JamIndex *dx, int idx, mb_list_rec *mb);
	int  countidx(mb_list_rec *mb);
	*/

	unsigned long
        CountEmailMsgs(unsigned long mbnum),
        CountMsgs(unsigned long mbnum),
        CountNewEmailMsgs(unsigned long mbnum, UserRec *usr),
        CountNewMsgs(unsigned long mbnum, UserRec *usr),
        CountCurrentNewMsgs(UserRec *usr),
        CountAllNewEmailMsgs(UserRec *usr),
        CountAllNewMsgs(UserRec *usr);

    void resetlastread(UserRec *usr);

	void ParseMArea(UserRec *usr, std::string &tmp);
	void MsgAreaScan(int newscan);

	//void msgarea_list(UserRec *usr);

}msgs;

# endif
