/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: pyenthral.cpp 118 2009-08-07 04:34:35Z frank $
// Source: $HeadURL:$
// $LastChangedDate: 2009-08-07 00:34:35 -0400 (Fri, 07 Aug 2009) $
// $LastChangedRevision: 118 $
// $LastChangedBy: frank $

# ifdef HAVE_CONFIG_H
    # include <config.h>
# endif

# include <iostream>
# include <fstream>
# include <string>

# ifdef HAVE_PYTHON > 0
# include <Python.h>


# include "pyenthral.h"
# include "conio.h"
# include "struct.h"

using namespace std;


//------------------------------------------------------------------------------
// Extend Python by creating a C/C++ function which will allow Python to GET an
// int value from the application.
//------------------------------------------------------------------------------

struct PyHotkey {

 char KeyCombination[32]; // Will hold something like "ctrl+alt+a".
 PyObject* Callback;      // Will point to the function - when the key combination is pressed it will be called.
};

PyHotkey p;


int g_someValue = 0;

PyObject* getApplicationValue( PyObject* self, PyObject* args )
{
    return Py_BuildValue( "i", g_someValue );
}

//------------------------------------------------------------------------------
// Extend Python by creating a C/C++ function which will allow Python to SET an
// int value in the application.
//------------------------------------------------------------------------------

PyObject* setApplicationValue( PyObject* self, PyObject* args )
{
    int nValue;

    if( PyArg_ParseTuple( args, "i", &nValue ) )
    {
        g_someValue = nValue;
        cout << "Script called \"setApplicationValue\" and passed: " << nValue << endl;
    }

    Py_INCREF( Py_None );
    return Py_None;
}

//------------------------------------------------------------------------------
// Extend & Embed Python by defining a function which will allow a Python script
// to set a call-back for the application to use. This will allow C++ to call
// into a Python script to have work done.
//------------------------------------------------------------------------------

PyObject *g_pythonCallback = NULL;

static PyObject* setCallback( PyObject* self, PyObject* args )
{
    PyObject *pResult = NULL;
    PyObject *temp   = NULL;

    if( PyArg_ParseTuple( args, "O", &temp ) )
    {
        if( !PyCallable_Check( temp ) )
        {
            PyErr_SetString( PyExc_TypeError, "parameter must be callable" );
            Py_INCREF( Py_None );
            return Py_None;
        }

        Py_XINCREF( temp );              // Ref the new call-back
        Py_XDECREF( g_pythonCallback );  // Unref the previous call-back
        g_pythonCallback = temp;         // Cache the new call-back

        Py_INCREF( Py_None );
        pResult =  Py_None;
    }
    return pResult;
}


// Testing, just wrote real fast...
static PyObject * pyGetline(PyObject *self, PyObject *args)
{

    SESSION s;

    static char str[1024]={0};
    memset(&str,0,sizeof(str));
    int *len;

    if (!PyArg_ParseTuple(args, "i", &len)) {
        return NULL;
    }

    if (len == 0) return NULL;
    s.getline(str,sizeof(str));
    return Py_BuildValue("s",&str);
}


static PyObject * pyGetkey(PyObject *self, PyObject *args)
{
    SESSION s;


    memset(&p,0,sizeof(PyHotkey));
    int ch = s.getkey(true);

    if (ch == 27) strcpy(p.KeyCombination,s.EscapeKey);
    char str[5]={0};

    sprintf(str,"%c",ch);
    return Py_BuildValue("s",&str);
}

static PyObject * pyStartpause(PyObject *self, PyObject *args)
{
    SESSION s;
    s.startpause();

    Py_INCREF( Py_None );
    return Py_None;
}

static PyObject * pyPipe2ansi(PyObject *self, PyObject *args)
{
    SESSION s;
    char *str;
    if (!PyArg_ParseTuple(args, "s", &str)) {
      return NULL;
    }
    s.pipe2ansi(str);
    Py_INCREF( Py_None );
    return Py_None;
}

static PyObject * pyPutline(PyObject *self, PyObject *args)
{
    SESSION s;
    char *str;
    if (!PyArg_ParseTuple(args, "s", &str)) {
      return NULL;
    }
    s.putline(str);
    Py_INCREF( Py_None );
    return Py_None;
}


static PyObject * pyAnsiprintf(PyObject *self, PyObject *args)
{
    SESSION s;
    char *str;
    if (!PyArg_ParseTuple(args, "s", &str)) {
      return NULL;
    }
    s.ansiPrintf(str);
    Py_INCREF( Py_None );
    return Py_None;
}


//------------------------------------------------------------------------------
// Make Python aware of our special C++ functions above.
//------------------------------------------------------------------------------

PyMethodDef g_methodDefinitions[] =
{
    { "pyGetline",    pyGetline, METH_VARARGS,     "Get Full Line of Input" },
    { "pyGetkey",     pyGetkey, METH_VARARGS,      "Get Hotkey Input" },
    { "pyStartpause", pyStartpause, METH_NOARGS,   "start pause prompt" },
    { "pyPipe2ansi",  pyPipe2ansi, METH_VARARGS,   "Parse String of MCI Codes and Output" },
    { "pyPutline",    pyPutline, METH_VARARGS,     "Send raw string to STDIO" },
    { "pyAnsiprintf", pyAnsiprintf, METH_VARARGS,  "Display an ansi file in ansi folder" },
    {NULL, NULL}
};


//-----------------------------------------------------------------------------
// Name: readPythonScript()
// Desc:
//-----------------------------------------------------------------------------
std::string *readPythonScript( std::string fileName )
{
    ifstream pythonFile;

    pythonFile.open( fileName.c_str() );

    if ( !pythonFile.is_open() )
    {
        cout << "Cannot open Python script file, \"" << fileName << "\"!" << endl;
        return NULL;
    }
    else
    {
        // Get the length of the file
        pythonFile.seekg( 0, ios::end );
        int nLength = pythonFile.tellg();
        pythonFile.seekg( 0, ios::beg );

        // Allocate  a char buffer for the read.
        char *buffer = new char[nLength];
        memset( buffer, 0, nLength );

        // read data as a block:
        pythonFile.read( buffer, nLength );

        std::string *scriptString = new std::string;
        scriptString->assign( buffer );

        delete [] buffer;
        pythonFile.close();

        return scriptString;
    }
}

//------------------------------------------------------------------------------
// Name: main()
// Desc: Application's main entry point.
//------------------------------------------------------------------------------
void pybbs_run( std::string script )
{

    std::string path;
    path += SCRIPTS;
    path += script;

    //
    // Setup Python to be embedded...
    //

    Py_Initialize();

    //
    // Define our custom module called "extendAndEmbedTest"...
    //

    PyImport_AddModule( "bbs" );
    Py_InitModule( "bbs", g_methodDefinitions );

    //
    // Access the "__main__" module and its name-space dictionary.
    //

    PyObject *pMainModule     = PyImport_AddModule( "__main__" );
    PyObject *pMainDictionary = PyModule_GetDict( pMainModule );

    //
    // Exercise embedding by calling a Python script from a C++ application.
    //

    std::string *pythonScript = readPythonScript( path );


   // s.putline((char *)pythonScript->c_str());

    if( pythonScript != NULL )
    {
        PyRun_String( pythonScript->c_str(), Py_file_input,
                      pMainDictionary, pMainDictionary );

        delete pythonScript;
    }

    //
    // Once the script has finished executing, extract one of it variables from
    // the name-space dictionary.
    //

/*
    PyObject *pResult = PyDict_GetItemString( pMainDictionary, "returnValue" );


    int nValue;
    PyArg_Parse( pResult, "i", &nValue );
    cout << "Script's \"returnValue\" variable was set to: " << nValue << endl;
*/

    //
    // If the Python script set the call-back function, call it...
    //

    /*
    if( g_pythonCallback )
    {
        int nArg1 = 123;

        PyObject *pArgList = Py_BuildValue( "(i)", nArg1 );
        PyObject *pResult  = PyEval_CallObject( g_pythonCallback, pArgList );

        Py_DECREF( pArgList );

        if( pResult != NULL )
            Py_DECREF( pResult );
    } */


    //
    // Cleanup after Python...
    //



    Py_Finalize();
    return;
}

# endif

