#ifndef __MSTATS_STRUCT_H
#define __MSTATS_STRUCT_H

#include <string>
//#include "mystic_struct.h"

using namespace std;

extern std::string PATH;

# define BBSVERSION            "Enthral BBS pre-a0.330"
//# define OSSYSTEM              "+linux+"
# define OSSYSTEM              "+BSD+"

// Fix this to work like Data Areas! and remove.
# define MAX_MENU_COMMANDS     256

# define BUFLEN 128000  // Fix this to Dynamic lateron!
# define CTLLEN 1024

# define SP              0x20
# define ESC             '\x1b'
# define BS              0x08
# define DEL             0x7f

# define CTRLA           0x01
# define CTRLB           0x02
# define CTRLC           0x03
# define CTRLD           0x04
# define CTRLE           0x05
# define CTRLF           0x06
# define CTRLG           0x07
# define CTRLH           0x08
# define CTRLI           0x09
# define CTRLJ           0x0a
# define CTRLK           0x0b
# define CTRLL           0x0c
# define CTRLM           0x0d
# define CTRLN           0x0e
# define CTRLO           0x0f
# define CTRLP           0x10
# define CTRLQ           0x11
# define CTRLR           0x12
# define CTRLS           0x13
# define CTRLT           0x14
# define CTRLU           0x15
# define CTRLV           0x16
# define CTRLW           0x17
# define CTRLX           0x18
# define CTRLY           0x19
# define CTRLZ           0x1a

// This holds the info for each Telnet Session
// For passing Between Classes
//________________________________________________________________


extern char BBSPATH[255];
extern char DATAPATH[255];
extern char MENUPATH[255];
extern char ANSIPATH[255];
extern char MESGPATH[255];
extern char FILEPATH[255];
extern char LOCKPATH[255];
extern char INIPATH[255];
extern char DAPATH[255];
extern char NODEPATH[255];
extern char NODEDIR[10];

extern char UsersIP[100];
extern int  UserLoggedIn;

extern char INPUT_COLOR[7];
extern int  CURRENT_MAREA;
extern int  CURRENT_FAREA;
extern int  USE_CHAR;
extern int  NODE_NUM;

extern int  isSysop;  // Exclusive Message Board Access to Sysop Areas!  HACK!!

# define BOOL int
# define BitSet(arg,posn) ((arg) | (1L << (posn)))
# define BitClr(arg,posn) ((arg) & ~(1L << (posn)))
# define BitTst(arg,posn) BOOL((arg) & (1L << (posn)))
# define BitFlp(arg,posn) ((arg) ^ (1L << (posn)))    z

extern int TRUE;
extern int FALSE;

// History Data.
enum {
    HIST_CALLS,
    HIST_EMAILS,
    HIST_POSTS,
    HIST_REPLIES,
    HIST_EDITS,
    HIST_DELETES,
    HIST_VIEWS,
    HIST_LOCAL,
    HIST_ECHOMAIL,
    HIST_UPLOADS,
    HIST_UPLOADKB,
    HIST_DOWNLOADS,
    HIST_DOWNLAODSKB,
    HIST_LASTCALLTIME,
    HIST_LASTCALLER
};


// Link List for Holding Message and Linklist Lines in FSE and msg_readll
typedef struct LineRec {

    std::string  data;      // Main Data String
    int          flag;      // Message Quote, Text Flagged True/False
    int          lineNum;   // Current Line Number
    LineRec     *up_link;
    LineRec     *dn_link;

}LineRec;

typedef struct __attribute__((packed)) FILEAREA {

    int  idx;           // Index in Dat files
    int  num;           // Number of Files in Base
    char name[30];      // Base Name
    char path[255];     // Path to files
                        // SL
                        // Password
} FILEAREA;

/*
struct ListItem {

    FILEAREA area;
    struct ListItem *next;
};
*/

typedef struct __attribute__((packed)) FILES {

    long idx;       // Index in Dat files
    char name[80];  // Filename
    //long Date;    // Date Uploaded
    long size;      // File Size in bytes
    char sSize;     // Converted size to KB, MEG, GIG
                    // Flag - Valid / Invalid
} FILES;

/*
struct ListItem2 {

    FILES  files;
    struct ListItem *next;
};
*/

typedef struct __attribute__((packed)) LangRec {

    char Lang[200];

}LangRec;

typedef struct __attribute__((packed)) MenuFlags {

    bool ClrScrBefore;  // clear screen before menu display
    bool NoMenuPrompt;  // no menu prompt whatsoever?
    bool ForcePause;    // force a pause before menu display?
    bool ClrScrAfter;   // clear screen after command received
    bool UseGlobal;     // use global menu commands?
    bool DigitPassing;  // Pass Though Digit Input for Functions
    bool EscPassing;    // Pass Though ESC Keys, Arrorw, Pgup/dn, Esc, Home etc...

}MenuFlags;

typedef struct __attribute__((packed)) MenuRec {

    char MenuName[20];        // menu name
    char Directive[20];       // normal menu text file
    char MenuPrompt[200];     // menu prompt
    char Acs[10];             // access requirements
    char Password[20];        // password required

    short ForceInput;         // 0 user defaults, 1 Hotkeys 1 ENTER
    short ForceHelpLevel;     // 0 user defaults, 1 force display, 0 force expert
    bool  Lightbar;           // Lightbar Menu?
    MenuFlags MFlags;         // menu status variables }

}MenuRec;

typedef struct __attribute__((packed)) CommandRec {

    char  LDesc[80];          // command description
    char  SDesc[40];          // command string
    char  CKeys[10];          // command execution keys
    char  Acs[10];            // access requirements
    char  CmdKeys[3];         // command keys
    char  MString[200];       // command data
    bool  SText;              // Is this a Scroll Test Comamnd
    short STLen;              // Length of Scroll Text
    bool  LBarCmd;            // Is This a Lighbar Cmd
    char  HiString[40];       // Highlighed
    char  LoString[40];       // Unhighlighted
    short Xcoord;             // Lightbar X coord
    short Ycoord;             // Lightbar Y coord

}CommandRec;

// Used for passing menu commands between threads for scrolling
typedef struct PASSING {
    bool                        Active;
    CommandRec                  *cmdr2;

}PASSING;


// Message Base Structes
typedef struct __attribute__((packed)) ACSrecL {

    unsigned long onn,off;

}ACSrecL;

typedef struct __attribute__((packed)) ACSrecS {

    unsigned short onn,off;

}ACSrecS;

typedef struct __attribute__((packed)) ACSrec {

    ACSrecL mgroup,
            fgroup;
    ACSrecS eflags,
            fflags;
    unsigned long
            since_mn;
    unsigned int
            dotm,
            dotw,
            min_logons,
            min_nodes,
            tI01,
            tI02,
            tI03;
    unsigned char
            min_sl,
            gender,
            min_age,
            tC01,
            tC02,
            tC03,
            tC04;

}ACSrec;



typedef struct __attribute__((packed)) Callers {

    long int idx;
    long dtLastOn;

}Callers;

typedef struct __attribute__((packed)) UserIdx {

    char handle[30];

    unsigned
    long num;

}UserIdx;

typedef struct __attribute__((packed)) UserRec {

    unsigned
    long   idx,
           num;

    // Stats Info
    char   handle[30],
           name[30],
           password[30],
           sex,
           email[40],
           usernote[40],
           startmenu[20],
           c_question[80],
           c_answer[80],
           msg_txtcolor[3],
           msg_quotecolor[3];

    // Stats
    unsigned
    long   dtbday,
           dtfirston,
           dtlaston,
           lastmbarea,
           lastmsg,
    // History
           Calls,
           Emails,
           Posts,
           Replies,
           Edits,
           Deletes,
           Views,
           Local,
           Echomail,
           Uploads,
           UploadKb,
           Downloads,
           DownloadKb;

    unsigned
    short  linelen,
           pagelen,
           emprivate;

    // FS Message Reader Options
    unsigned
    short  readertheme,
           fsetheme,
           pageDn,      // Arror Keys - Page Down or line down
           readerFs;    // Use FullScreen Reader or Old Fashon.

}UserRec;


typedef struct __attribute__((packed)) fidoaddr {

    unsigned
    short  zone,
           net,
           node,
           point;

    unsigned
    char   domain[13];

}fidoaddr;

typedef struct __attribute__((packed)) mbareaflags {

    char mbrealname;
    char mbvisible;
    char mbansi;
    char mb8bitx;
    char mbstrip;
    char mbaddtear;
    char mbnopubstat;
    char mbnocreadit;
    char mbinternet;
    char mbfileattach;
    char mbstripcolor;

}mbareaflags;

typedef struct __attribute__((packed)) mb_list_rec {

    int idx;
    int Type;
    int Kind;
    int Active;
    int Pubpriv;
    int Allowalias;
    int scantype;
    int fidoaddr;
    int sigtype;
    int reserved_int[15];
    char mbdisplay[61];
    char mbfile[36];
    char mbpath[81];
    char password[16];
    ACSrec ReadACS;
    ACSrec WriteACS;
    ACSrec SysopACS;
    ACSrec NetworkACS;
    char OriginLine[66];
    unsigned char colors[4];
    char infofile[36];
    char reserved_char[149];
    unsigned long MaxMsgs;
    unsigned long MaxAge;
    unsigned long first;
    unsigned long last;
    unsigned long current;
    unsigned long lastread;
    unsigned long status;
    long reserved_long[3];
    mbareaflags flags;
    struct fidoaddr aka;

}mb_list_rec;


typedef struct __attribute__((packed)) fb_list_rec {

    int idx;
    int Type;               // JAM
    int Kind;               // Local
    int Active;
    int Pubpriv;            // Private File Area
    int Allowalias;         // hmm ?!?
    int scantype;           //
    int fidoaddr;
    int sigtype;
    int reserved_int[15];
    char filepath[1024];    // Path to import files.
    char fbdisplay[61];     // Ansi File Header Name
    char fbfile[36];        // File Board DOS Filename
    char fbpath[81];        // File Board Path
    char password[16];
    char OriginLine[66];
    unsigned char colors[4];
    unsigned long MaxFiles;
    unsigned long MaxAge;
    unsigned long first;
    unsigned long last;
    unsigned long current;
    unsigned long lastread;
    unsigned long status;
    mbareaflags flags;
    struct fidoaddr aka;

}fb_list_rec;

typedef struct __attribute__((packed)) LastRead {

    unsigned long UserCRC;     // CRC-32 of user name (lowercase)  (1)
    unsigned long UserID;      // Unique UserID
    unsigned long LastReadMsg; // Last read message number
    unsigned long HighReadMsg; // Highest read message number

} LastRead;

typedef struct __attribute__((packed)) EmailIdx {

    unsigned long UserID;      // Unique UserID of Email TO:
    int           New;         // Read / Unread Message
    char          Subj[90];    // Message Subject

} EmailIdx;

typedef struct __attribute__((packed)) JamIndex {

    unsigned long CRC;     // CRC-32 of user name (lowercase)  (1)
    unsigned long OffSet;  // Message Text Offset

} JamIndex;

/*
typedef struct __attribute__((packed)) MsgStats {

    unsigned long Views;    // # of times message was viewed
    unsigned long Replies;  // # of Replies to this message
    unsigned long Date;     // Date Posted.
    unsigned char From[40]; // Posted From
    unsigned char Subj[90]; // Message Subject

} MsgStats; */


typedef struct __attribute__((packed)) NewScan {

    unsigned int set;      // TRUE / FALSE if this area is to be scanned.

} NewScan;


typedef struct DataArea {

    std::string     AreaName;
    std::string     AreaFileName;
    std::string     AnsiFile;
    std::string     AnsiMid;
    unsigned int    NumOfRecs;    // 0 Unlimited / 1 or More to Limit for Lists
    unsigned int    PageBreak;    // 0 Ignore, else break on this man for next page.

} DataArea;


typedef struct DataRec {

    int idx;                    // Command #, Used Internal for Input Record #.
    std::string Desc;           // # Description
    std::string Prompt;         // # Text Prompt To Display on Input Commands.
    unsigned long Size;         // # Max Number of Chars on Input
    std::string CKeys;          // # Accepted Input Keys
    std::string CmdType;        // # Command Type
    std::string MString;        // # Data to be Written {UserName}
    std::string MciCode;        // # MCI Code in ANSI For this Field
    std::string HiString;       // # LightBar High String
    std::string LoString;       // # LightBar Low String
    int Xcoord;                 // # X Coord of Lightbar
    int Ycoord;                 // # Y Coord of Lightbar
    int LBarCmd;                // # Is This a Lightbar Command?
    int MCICmd;                 // # Is This a MCI Code, Skip Input and Translate.

}DataRec;

typedef struct __attribute__((packed)) History {

    unsigned long Calls;
    unsigned long Emails;
    unsigned long Posts;
    unsigned long Replies;
    unsigned long Edits;
    unsigned long Deletes;
    unsigned long Views;
    unsigned long Local;
    unsigned long Echomail;
    unsigned long Uploads;
    unsigned long UploadKb;
    unsigned long Downloads;
    unsigned long DownloadKb;
    unsigned long LastCallTime;
    char LastCaller[40];

} History;


typedef struct __attribute__((packed)) MsgStats {

    unsigned long Unread;
    unsigned long Posts;
    unsigned long Replies;
    unsigned long Views;
    unsigned long dtLastPostTime;
    char LastPoster[40];
    char PostSubject[40];

} MsgStats;

typedef struct __attribute__((packed)) FileIdx {

    unsigned long idx;   // Extended Description Index
    unsigned long size;  // File Size
    unsigned long dls;   // # of Downloads
    unsigned long date;  // When it was uploaded
    char uploader [40];  // Uploader
    char filename [255]; // File Name w/ out path

} FileIdx;


/*--------------------------------------------------------------------------------*/
// Link List for Holding all Users in Users.dat no sorting
struct ListItem {

    UserRec user;
    struct ListItem *next;
};

/*--------------------------------------------------------------------------------*/
// Link List for Sorting all Users by Calls & Uploads
struct ListItem1 {

    UserRec user;
    struct ListItem1 *next;
};

/*--------------------------------------------------------------------------------*/
// Link List for Sorting all Users by Poasts & Downloads
struct ListItem2 {

    UserRec user;
    struct ListItem2 *next;
};

/*--------------------------------------------------------------------------------*/
// Link List for Sorting ANSI OUTPUT
struct ListItem3 {

    std::string ansi;
    struct ListItem3 *next;
};

/*--------------------------------------------------------------------------------*/
// Link List for Sorting ANSI OUTPUT
struct ListItem4 {

    std::string ansi;
    struct ListItem4 *next;
};


# endif


