/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose: Basic User Data I/O                                          *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: users.cpp 110 2009-06-02 02:41:35Z frank $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/users.cpp $
// $LastChangedDate: 2009-06-01 22:41:35 -0400 (Mon, 01 Jun 2009) $
// $LastChangedRevision: 110 $
// $LastChangedBy: frank $

# include <stdio.h>
# include <string>
# include <cctype>
# include <cstring>        // gcc 4.3
//# include <algorithm>    // gcc 4.3 transform() (Doesn't work!)
//# include <iterator>
//# include <parallel/algo.h>

# include "users.h"
# include "struct.h"
# include "conio.h" // testing. elog


using namespace std;


int users::users_lockSet(int onoff) {

	std::string path = LOCKPATH;
    path += "users.lck";

	if (!onoff) {
		remove((char *)path.c_str());
		return TRUE;
	}

	//While lock file missing, create, or loop until it disapears.
	FILE *stream;
	while(1) {
		stream = fopen(path.c_str(),"rb+");
   		if(stream == NULL) {
	   		stream = fopen(path.c_str(), "wb");
    		if(stream == NULL) {
    			printf("Error users.lck!");
        		return FALSE;
    		}
			else {
				fclose(stream);
				return TRUE;
			}
		}
		fclose(stream);
		usleep(10*20000);
	}
}

int users::uidx_lockSet(int onoff) {

	std::string path = LOCKPATH;
    path += "uidx.lck";

	if (!onoff) {
		remove((char *)path.c_str());
		return TRUE;
	}

	//While lock file missing, loop untill it disapears.
	FILE *stream;
	while(1) {
		stream = fopen(path.c_str(),"rb+");
   		if(stream == NULL) { // Lock File Missing
	   		stream = fopen(path.c_str(), "wb");
    		if(stream == NULL) {
    			printf("Error uidx.lck!");
        		return FALSE;
    		}
			else {
				fclose(stream);
				return TRUE;	// Created Lock File
			}
		}
		fclose(stream);
		usleep(10*20000);
	}
}

int users::users_writet(UserRec *usr, int idx) {

	std::string path = DATAPATH;
    path += "users.tmp";

    int x = 0;
	FILE *stream = fopen(path.c_str(),"rb+");
   	if(stream == NULL) {
	   	stream = fopen(path.c_str(), "wb");
    	if(stream == NULL) {
    		printf("Error users_write temp!");
        	return x;
    	}
	}
    if(fseek(stream,(int)idx*sizeof(UserRec),SEEK_SET)==0)
	    x = fwrite(usr,sizeof(UserRec),1,stream);
    fclose(stream);
    return x;
}

int users::users_write(UserRec *usr, int idx) {

	std::string path = DATAPATH;
    path += "users.dat";

	users_lockSet(TRUE);
    int x = 0;
	FILE *stream = fopen(path.c_str(),"rb+");
   	if(stream == NULL) {
	   	stream = fopen(path.c_str(), "wb");
    	if(stream == NULL) {
    		printf("Error users_write!");
			users_lockSet(FALSE);
        	return x;
    	}
	}
    if(fseek(stream,(int)idx*sizeof(UserRec),SEEK_SET)==0)
	    x = fwrite(usr,sizeof(UserRec),1,stream);
    fclose(stream);
	users_lockSet(FALSE);
    return x;
}

int users::users_read(UserRec *usr, int idx) {

    std::string path = DATAPATH;
    path += "users.dat";

	users_lockSet(TRUE);
    int x = 0;
    FILE *stream = fopen(path.c_str(),"rb+");
    if(stream == NULL) {
    	stream=fopen(path.c_str(), "wb");
    	if(stream == NULL) {
       		printf("Error users_read!");
			users_lockSet(FALSE);
      		return x;
    	}
	}
    fclose(stream);

	stream = fopen(path.c_str(), "rb");
    if(fseek(stream,(int)idx*sizeof(UserRec),SEEK_SET)==0)
    	x = fread(usr,sizeof(UserRec),1,stream);
    fclose(stream);
	users_lockSet(FALSE);
    return x;
}

int users::idx_writet(UserIdx *usr, int idx) {

	std::string path = DATAPATH;
    path += "uidx.tmp";

    int x = 0;
	FILE *stream = fopen(path.c_str(),"rb+");
   	if(stream == NULL) {
	   	stream = fopen(path.c_str(), "wb");
    	if(stream == NULL) {
    		printf("Error uidx_write temp!");
        	return x;
    	}
	}
    if(fseek(stream,(int)idx*sizeof(UserIdx),SEEK_SET)==0)
	    x = fwrite(usr,sizeof(UserIdx),1,stream);
    fclose(stream);
    return x;
}

int users::idx_write(UserIdx *usr, int idx) {

	std::string path = DATAPATH;
    path += "uidx.dat";

	uidx_lockSet(TRUE);
	int x = 0;
	FILE *stream=fopen(path.c_str(),"rb+");
	if(stream == NULL){
		stream=fopen(path.c_str(), "wb");
		if(stream == NULL) {
			printf("Error uidx_write!");
			uidx_lockSet(FALSE);
			return x;
		}
	}
	if(fseek(stream,(int)idx*sizeof(UserIdx),SEEK_SET)==0)
		x = fwrite(usr,sizeof(UserIdx),1,stream);
	fclose(stream);
	uidx_lockSet(FALSE);
	return x;
}

int users::idx_read(UserIdx *usr, int idx) {

	std::string path = DATAPATH;
    path += "uidx.dat";

	uidx_lockSet(TRUE);
	int x = 0;
	FILE *stream=fopen(path.c_str(),"rb+");
	if(stream == NULL) {
		stream=fopen(path.c_str(), "wb");
		if(stream == NULL) {
			printf("Error uidx_read!");
			uidx_lockSet(FALSE);
			return x;
		}
	}
	fclose(stream);

	stream = fopen(path.c_str(), "rb");
	if(fseek(stream,(int)idx*sizeof(UserIdx),SEEK_SET)==0)
		x = fread(usr,sizeof(UserIdx),1,stream);
	fclose(stream);
	uidx_lockSet(FALSE);
	return x;
}

int users::idx_count() {

	UserIdx usr;
    int i = 0;
	while(idx_read(&usr,i)) {++i;}
    ++i;

	(i < 1) ? i = -1 : i--;
	return(i);
}

int users::idx_find(char *name) {

	UserIdx usr;
	int idx = 0;
	std::string temp1, temp2;

	temp1 = (name);

    //move temp1 to lower case for testing!
    for (std::string::size_type i = 0; i < temp1.size(); ++i ) {
        temp1[i] = tolower( temp1[i] );
    }

	while(idx_read(&usr,idx)) {
		temp2 = (usr.handle);
	    //	transform(temp1.begin(),temp1.end(), temp1.begin(), tolower);
	    //	transform(temp2.begin(),temp2.end(), temp2.begin(), tolower);
        for (std::string::size_type i = 0; i < temp2.size(); ++i ) {
            temp2[i] = tolower( temp2[i] );
        }

		if(temp1 == temp2) return(idx);
        ++idx;
    }
	return(-1);
}

bool users::idx_match(char *name) {

	int index =- 1;
	index = idx_find(name);
	if (index == -1) return false;
	else return true;
}

void users::idx_new(char *name, int idx) {

	UserIdx usr;
	memset(&usr,0,sizeof(UserIdx));
	strcpy(usr.handle,name);
	usr.num = idx;
	idx_write(&usr,idx);

}

bool users::check_password(char *name, char *pass) {

	UserRec r;
	memset(&r,0,sizeof(UserRec));
	int idx = 0;
	std::string temp1, temp2;

	temp1 = (name);
	idx = idx_find(name);
	users_read(&r,idx);
	temp1 = r.password;
	temp2 = pass;

    SESSION s;
//    s.elog ("* NAME %s,%i",name,idx);
 //   s.elog ("Password %s,%s",(char *)temp1.c_str(),(char *)temp2.c_str());

	if(temp1 == temp2)
		return true;
	else return false;
}

/*
int users::getAllBDays() {

    UserRec usr;
    int  i = 0, iResult;
    long dtBdate;

    while(users_read(&usr,i++))
        iResult = isBday(dtBdate);
    }
}


*/
