"""
BigBrother maintains records of door activity - when were they installed, how often are they played,
that sort of thing.

A run is saved on a particular day's file if it ENDED during that day.
"""

import os
import Global
import time

class DoorRun:
    def __init__(self):
        self.DoorName = ""
        self.UserName = ""
        self.StartTime = None
        self.EndTime = None
        self.PlayTime = None

class BigBrother:
    def __init__(self):
        self.AllRuns = []
    def RecordRun(self, Run):
        self.AllRuns.append(Run)
    def RecordNewRun(self, DoorName, UserName, StartTime, EndTime):
        Run = DoorRun()
        Run.DoorName = DoorName
        Run.UserName = UserName
        Run.StartTime = StartTime
        Run.EndTime = EndTime
        Run.PlayTime = Run.EndTime - Run.StartTime
        self.RecordRun(Run)
        self.SaveStats(time.localtime())
    def GetFilePath(self, TimeTuple):
        FileName = "%04d%02d%02d.txt"%(TimeTuple[0], TimeTuple[1], TimeTuple[2])
        FilePath = os.path.join(Global.GetHomeDir(), "BigBrother", FileName)
        return FilePath
    def LoadStats(self, TimeTuple):
        FilePath = self.GetFilePath(TimeTuple)
        ###print "BB: %s, %s"%(str(TimeTuple), FilePath)
        if not os.path.exists(FilePath):
            return
        File = open(FilePath, "r")
        LineNumber = 0
        for FileLine in File.xreadlines():
            LineNumber += 1
            try:
                FileLine = FileLine.strip()
                if (not FileLine) or (FileLine[0]=="#"):
                    continue
                Bits = FileLine.split("\t")
                if len(Bits) < 4:
                    continue
                Run = DoorRun()
                Run.DoorName = Bits[0].strip()
                Run.UserName = Bits[1].strip()
                Run.StartTime = int(Bits[2])
                Run.EndTime = int(Bits[3])
                Run.PlayTime = Run.EndTime - Run.StartTime
                self.AllRuns.append(Run)
            except:
                traceback.print_exc()
    def GetStartOfDay(self, TimeTuple):
        Tuple = list(TimeTuple)[:]
        Tuple[3] = 0
        Tuple[4] = 0
        Tuple[5] = 0
        Start = time.mktime(Tuple)
        return Start
    def GetEndOfDay(self, TimeTuple):
        Tuple = list(TimeTuple)[:]
        Tuple[3] = 0
        Tuple[4] = 0
        Tuple[5] = 0
        Start = time.mktime(Tuple)
        return Start + 60*60*24
    def SaveStats(self, TimeTuple):
        FilePath = self.GetFilePath(TimeTuple)
        File = open(FilePath, "w")
        StartInstant = self.GetStartOfDay(TimeTuple)
        EndInstant = self.GetEndOfDay(TimeTuple)
        for Run in self.AllRuns:
            if StartInstant <= Run.EndTime < EndInstant:
                Line = "%s\t%s\t%d\t%d\t"%(Run.DoorName, Run.UserName, Run.StartTime, Run.EndTime)
                File.write(Line+"\n")
        File.close()
    def GetWeeklyStats(self):
        "Load stats for today and the previous 6 days"
        self.LoadDaysOfStats(7)
    def LoadDaysOfStats(self, Count, Timestamp = None):
        if not Timestamp:
            Timestamp = time.time()

        TimeTuple = list(time.localtime(Timestamp))
        TimeTuple[3] = 0
        TimeTuple[4] = 0
        TimeTuple[5] = 0
        Instant = time.mktime(TimeTuple)
        for Day in range(Count):
            Tuple = time.localtime(Instant)
            self.LoadStats(Tuple)
            Instant -= (60*60*24)
    def GetPopularGames(self, ReportCount = 10):
        RunCounts = {}
        RunTimes = {}
        for Run in self.AllRuns:
            if not RunCounts.has_key(Run.DoorName):
                RunCounts[Run.DoorName] = 0
            RunCounts[Run.DoorName] += 1
            if not RunTimes.has_key(Run.DoorName):
                RunTimes[Run.DoorName] = 0
            RunTimes[Run.DoorName] += Run.PlayTime
        print RunCounts
        print RunTimes
        # Trim list:
        for Key in RunCounts.keys()[:]:
            Door = Global.DoorDatabase.GetByName(Key)
            if Door and Door.SkipStatReporting:
                ##print "SKIP reporting of:", Door.Name
                del RunCounts[Key]
        for Key in RunTimes.keys()[:]:
            Door = Global.DoorDatabase.GetByName(Key)
            if Door and Door.SkipStatReporting:
                ##print "SKIP reporting of:", Door.Name
                del RunTimes[Key]
        ###
        SortedCounts = []
        for (Name, Count) in RunCounts.items():
            SortedCounts.append((Count, Name))
        SortedCounts.sort()
        SortedCounts.reverse()
        ###
        SortedTimes = []
        for (Name, Time) in RunTimes.items():
            SortedTimes.append((Time, Name))
        SortedTimes.sort()
        SortedTimes.reverse()
        return (SortedCounts[:ReportCount], SortedTimes[:ReportCount])
    def Reset(self):
        self.AllRuns = []
if __name__ == "__main__":
    Global.BigBrother = BigBrother()
    Global.BigBrother.GetWeeklyStats()