"""
This server handles virtual input and output from virtual modems.  (Virtual COM ports are
redirected to IP requests at 127.0.0.1:PortNum)  Useful for running doors that
don't do FOSSIL.
"""
from Utils import *
import SocketServer
import threading
import sys
import time

class COMPortServer(SocketServer.TCPServer):
    def __init__(self, *args, **kw):
        SocketServer.TCPServer.__init__(self, *args, **kw)
        self.Handlers = []
        self.HandlerLock = threading.Lock()
    def AddHandler(self, Handler):
        self.HandlerLock.acquire()
        self.Handlers.append(Handler)
        self.HandlerLock.release()
    def RemoveHandler(self, Handler):
        self.HandlerLock.acquire()
        try:
            self.Handlers.remove(Handler)
        except:
            pass
        self.HandlerLock.release()
    def handle_request(self):
        SocketServer.TCPServer.handle_request(self)
    def ClaimHandler(self, Owner):
        self.HandlerLock.acquire()
        TheHandler = None
        for Handler in self.Handlers[:]:
            if Handler.Owner == None:
                # Kill any really old ones:
                if time.clock() - Handler.StartTime > 10:
                    self.Handlers.remove(Handler)
                    continue
                Handler.Owner = Owner
                TheHandler = Handler
                break
        self.HandlerLock.release()
        return TheHandler

Log = open("SentToDoor.txt", "w")
    
class COMPortHandler(SocketServer.BaseRequestHandler):
    def __init__(self, *args, **kw):
        self.KeepRunning = 1
        self.Owner = None
        self.StartTime = time.clock()
        Log.write("COMPortHandler::init()\n")
        Log.flush()
        SocketServer.BaseRequestHandler.__init__(self, *args, **kw)
    def SendText(self, Text):
        Log.write(Text)
        Log.flush()
        self.request.send(Text)
    def handle(self, *args, **kw):
        self.server.AddHandler(self)        
        self.request.setblocking(0)
        #return self.HandleStdin() #%%%
        while self.KeepRunning:
            pass
    def HandleStdin(self):
        "For testing: Spew to standard in, standard out"
        s = self.request # Our socket
        self.AccumText = ""
        self.SocketReader = SocketReaderThread(self.request)
        self.SocketReader.start()
        self.FileReader = FileReaderThread(sys.stdin)
        self.FileReader.start()
        while (self.KeepRunning):
            Text = self.SocketReader.GetText()
            if Text:
                print Text,
            Text = self.FileReader.GetText()
            if Text:
                self.SendText(Text)
        # Shut down:
        if self.SocketReader:
            self.SocketReader.Kill()
            self.SocketReader = None
        
##        print ">>>NEW COM PORT REQUEST RECEIVED!"
##        
##        self.server.AddHandler(self)
##        try:
##            self.HandleInternal()
##        except:
##            traceback.print_exc()
##        self.server.RemoveHandler(self)
##        if self.SocketReader:
##            self.SocketReader.Kill()
##            self.SocketReader = None
##    def HandleInternal(self):
##        s = self.request # Our socket
##        self.AccumText = ""
##        self.SocketReader = SocketReaderThread(self.request)
##        self.SocketReader.start()
##        if UseStdin:
##            self.FileReader = FileReaderThread(sys.stdin)
##            self.FileReader.start()
##        while (self.KeepRunning):
##            if UseStdin:
##                Text = self.SocketReader.GetText()
##                if Text:
##                    print Text,
##                Text = self.FileReader.GetText()
##                if Text:
##                    #self.request.send(Text)
##                    self.SendText(Text)
##                    #self.request.flush()
##            pass
####            Text = self.SocketReader.GetText()
####            if Text and len(Text):                
####                self.AccumText += Text
##        # Shut down:
##        if self.SocketReader:
##            self.SocketReader.Kill()
##            self.SocketReader = None
##        print "<<<COM PORT REQUEST COMPLETE"

UseStdin = 0
        
if __name__ == "__main__":
    print "Intercepting COM port activity:"
    UseStdin = 1
    Server = COMPortServer(("", 8003), COMPortHandler)
    Server.serve_forever()
