"Run the DumpleBBS with a UI"
import traceback
from wxPython.wx import *
from Utils import *
import Dumple
import Global
import User
import BigBrother
import threading
import os
import sys
import time
from wxPython.lib.mixins.listctrl import wxColumnSorterMixin, wxListCtrlAutoWidthMixin

class TaskbarStates:
    NoUsers = "NoUsers"
    Users = "Users"

class DumpleFrame(wxFrame):
    def __init__(self, App):
        self.App = App
        wxFrame.__init__(self, None, -1, "DumpleBBS", style=wxRESIZE_BORDER|wxMINIMIZE_BOX|wxSYSTEM_MENU|wxCAPTION)
        self.CreateStatusBar()
        self.SetIcon(wxIcon('bubshead.ico', wxBITMAP_TYPE_ICO))
        EVT_ICONIZE(self, self.OnMinimize)
        EVT_CLOSE(self, self.OnClose)
        #EVT_SIZE(self, self.OnSize)
    def OnClose(self, Event):
        self.App.ShutDown()
        return true
    def OnMinimize(self, Event):
        self.Show(0)
    def OnSize(self, event):
        self.Layout()
        #self.ResizeColumns()

class UserListCtrl(wxListCtrl, wxListCtrlAutoWidthMixin):
    def __init__(self, parent, ID, pos=wxDefaultPosition,
                 size=wxDefaultSize):
        wxListCtrl.__init__(self, parent, ID, pos, size, wxLC_REPORT | wxSUNKEN_BORDER
                                 | wxLC_EDIT_LABELS)
        wxListCtrlAutoWidthMixin.__init__(self)
        
class SessionListPanel(wxPanel, wxColumnSorterMixin):
    def __init__(self, Parent):
        print "UserListPanel parent:", Parent
        wxPanel.__init__(self, Parent, -1, style=wxWANTS_CHARS)
        self.BuildWidgets()
        #self.PopulateList()
        wxColumnSorterMixin.__init__(self, 5)
        EVT_SIZE(self, self.OnSize)
    def OnSize(self, Event):
        self.Layout()
    # Used by the wxColumnSorterMixin, see wxPython/lib/mixins/listctrl.py
    def GetListCtrl(self):
        return self.UserListControl
    def BuildWidgets(self):
        Sizer = wxBoxSizer(wxVERTICAL)
        self.UserListControl = UserListCtrl(self, -1)
        self.UserListControl.InsertColumn(0, "SessionID")
        self.UserListControl.InsertColumn(1, "User")
        self.UserListControl.InsertColumn(2, "IP")
        self.UserListControl.InsertColumn(3, "Action")
        self.UserListControl.InsertColumn(4, "Logged on")
        self.ResizeColumns()
        Sizer.Add(self.UserListControl, 1, wxEXPAND)
        Sizer.SetSizeHints(self)
        self.SetSizer(Sizer)
    def ResizeColumns(self):
        for Index in range(5):
            OldWidth = self.UserListControl.GetColumnWidth(Index)
            self.UserListControl.SetColumnWidth(Index, wxLIST_AUTOSIZE)
            NewWidth = self.UserListControl.GetColumnWidth(Index)
            self.UserListControl.SetColumnWidth(Index, max(OldWidth, NewWidth, 80))
    def Fill(self, Sessions):
        self.UserListControl.DeleteAllItems()
        self.itemDataMap = {}
        for Session in Sessions:
            Pos = self.UserListControl.GetItemCount()
            Index = self.UserListControl.InsertStringItem(Pos, str(Session.ID))
            self.UserListControl.SetItemData(Index, Session.ID)
            self.UpdateListLine(Index, Session)
            
    def UpdateListLine(self, Index, Session):
        self.UserListControl.SetStringItem(Index, 0, str(Session.ID))
        self.UserListControl.SetStringItem(Index, 1, Session.GetUserName())
        Peer = Session.request.getpeername()
        Str = "%s"%(Peer[0]) # IP address they're connected from
        self.UserListControl.SetStringItem(Index, 2, Str)
        self.UserListControl.SetStringItem(Index, 3, Session.GetActionName())
        self.UserListControl.SetStringItem(Index, 4, time.asctime(time.localtime(Session.ConnectTime)))
        self.itemDataMap[Session.ID] = (Session.ID, Session.GetUserName(), Str, Session.GetActionName(), Session.ConnectTime)

class SessionPane(wxPanel):
    "Notebook page: List of sessions"
    def __init__(self, App, Parent):
        wxPanel.__init__(self, Parent, -1)
        self.App = App
        self.BuildWidgets()
    def BuildWidgets(self):
        self.Sizer = wxBoxSizer(wxVERTICAL)
        self.SessionList = SessionListPanel(self)
        self.Sizer.Add(self.SessionList, 1, wxEXPAND)
        Widget = wxStaticText(self, -1, "Above is a list of all active sessions. You can sort the list by clicking on the column headers.")
        self.Sizer.Add(Widget, 0)
        self.SetAutoLayout(true)
        self.Sizer.SetSizeHints(self)
        self.SetSizer(self.Sizer)        
    def OnTimer(self):
        if not Global.DumpleServer:
            self.SessionList.Fill([])
        else:
            self.SessionList.Fill(Global.DumpleServer.Sessions)
    def OnActivate(self):
        pass
class LogPane(wxPanel):
    "Notebook page: System log"
    def __init__(self, App, Parent):
        wxPanel.__init__(self, Parent, -1)
        self.App = App
        self.SourcePath = os.path.join(Global.GetHomeDir(), "SysLog.txt")
        self.BuildWidgets()
    def BuildWidgets(self):
        self.Sizer = wxBoxSizer(wxVERTICAL)
        self.TextBox = wxTextCtrl(self, -1, "", style = wxTE_READONLY | wxTE_MULTILINE)
        self.Sizer.Add(self.TextBox, 5, wxEXPAND)
        Button = wxButton(self, -1, "Refresh")
        self.Sizer.Add(Button, 0)
        EVT_BUTTON(self, Button.GetId(), self.UpdateLog)
        self.Sizer.SetSizeHints(self)
        self.SetSizer(self.Sizer)        
        self.UpdateLog()
    def UpdateLog(self, Event = None):
        File = open(self.SourcePath,"r")
        Text = File.read()
        File.close()
        self.TextBox.SetValue(Text)
        self.TextBox.ShowPosition(len(Text))
    def OnTimer(self):
        pass
    def OnActivate(self):
        self.UpdateLog()

class BigBrotherPanel(wxPanel, wxColumnSorterMixin):
    def __init__(self, Parent):
        wxPanel.__init__(self, Parent, -1, style=wxWANTS_CHARS)
        self.NextID = 1
        self.BuildWidgets()
        wxColumnSorterMixin.__init__(self, 5)
    def GetListCtrl(self): # used by sorter mixin
        return self.ListControl
    def BuildWidgets(self):
        Sizer = wxBoxSizer(wxVERTICAL)
        self.ListControl = UserListCtrl(self, -1)
        self.ListControl.InsertColumn(0, "User")
        self.ListControl.InsertColumn(1, "Door")
        self.ListControl.InsertColumn(2, "StartTime")
        self.ListControl.InsertColumn(3, "EndTime")
        self.ListControl.InsertColumn(4, "Duration")
        self.ResizeColumns()
        Sizer.Add(self.ListControl, 1, wxEXPAND)
        Sizer.SetSizeHints(self)
        self.SetSizer(Sizer)
    def ResizeColumns(self):
        for Index in range(5):
            OldWidth = self.ListControl.GetColumnWidth(Index)
            self.ListControl.SetColumnWidth(Index, wxLIST_AUTOSIZE)
            NewWidth = self.ListControl.GetColumnWidth(Index)
            self.ListControl.SetColumnWidth(Index, max(OldWidth, NewWidth, 80))
        
    def Fill(self, Runs):
        self.ListControl.DeleteAllItems()
        self.NextID = 1
        self.itemDataMap = {}
        for Run in Runs:
            Pos = self.ListControl.GetItemCount()
            Index = self.ListControl.InsertStringItem(Pos, Run.UserName)
            #self.ListControl.SetItemData(Index, Session.ID)
            self.UpdateListLine(Index, Run)
    def UpdateListLine(self, Index, Run):
        self.ListControl.SetStringItem(Index, 0, Run.UserName)
        self.ListControl.SetStringItem(Index, 1, Run.DoorName)
        self.ListControl.SetStringItem(Index, 2, time.asctime(time.localtime(Run.StartTime)))
        self.ListControl.SetStringItem(Index, 3, time.asctime(time.localtime(Run.EndTime)))
        self.ListControl.SetStringItem(Index, 4, CuteDuration(Run.PlayTime))
        ID = self.NextID
        self.NextID += 1
        self.ListControl.SetItemData(Index, ID)
        self.itemDataMap[ID] = (Run.UserName, Run.DoorName, Run.StartTime, Run.EndTime, Run.PlayTime)
        

class BigBrotherPane(wxPanel):
    "Notebook page: System log"
    def __init__(self, App, Parent):
        wxPanel.__init__(self, Parent, -1)
        self.App = App
        self.BigBrother = BigBrother.BigBrother()
        self.ShowSpans = ["Day", "Week", "30 Days", "100 Days"]
        self.ShowSpanLenghts = {"Day":1,
                                "Week":7,
                                "30 Days":30,
                                "100 Days":100,}
        self.ShowSpan = "Day"
        self.EndingTime = time.time()
        self.BuildWidgets()
        self.BigBrother.Reset()
        self.BigBrother.LoadDaysOfStats(1, self.EndingTime)
        self.ReRender()
    def ReRender(self):
        self.ListBox.Fill(self.BigBrother.AllRuns)
    def BuildWidgets(self):
        self.Sizer = wxBoxSizer(wxVERTICAL)
        ################################
        # ListCtrl for all the games:
        self.ListBox = BigBrotherPanel(self)
        self.Sizer.Add(self.ListBox, 5, wxEXPAND)
        #########################################
        # And a panel containing the date control widgets:
        LowerSizer = wxBoxSizer(wxVERTICAL)
        self.Sizer.Add(LowerSizer, 1, wxEXPAND)
        LowerLeftSizer = wxBoxSizer(wxHORIZONTAL)
        LowerSizer.Add(LowerLeftSizer, 1, wxCENTER)
        ## DATE selection:
        Button = wxButton(self, -1, "Back week")
        LowerLeftSizer.Add(Button, 1, wxCENTER)
        EVT_BUTTON(self, Button.GetId(), lambda Event,X=-7:self.MoveLog(X))
        Button = wxButton(self, -1, "Back")
        LowerLeftSizer.Add(Button, 1, wxCENTER)
        LowerLeftSizer.Add(20, 20)
        EVT_BUTTON(self, Button.GetId(), lambda Event,X=-1:self.MoveLog(X))
        TimeTuple = time.localtime(self.EndingTime)
        Str = "Stats through:\n%s"%time.strftime("%b %d, %Y", TimeTuple)
        self.DayText = wxStaticText(self, -1, Str) #, style = wxALIGN_CENTRE)
        LowerLeftSizer.Add(self.DayText, 1, wxCENTER)
        Button = wxButton(self, -1, "Forward")
        LowerLeftSizer.Add(Button, 1, wxCENTER)
        EVT_BUTTON(self, Button.GetId(), lambda Event,X=1:self.MoveLog(X))
        Button = wxButton(self, -1, "Forward week")
        LowerLeftSizer.Add(Button, 1, wxCENTER)
        EVT_BUTTON(self, Button.GetId(), lambda Event,X=7:self.MoveLog(X))
        ##############################
        # And a panel for durations:
        #LowerRightSizer = wxBoxSizer(wxVERTICAL)
        RadioBox = wxRadioBox(self, -1, "Days to show",
                              wxDefaultPosition, wxDefaultSize,
                              self.ShowSpans)
        EVT_RADIOBOX(self, RadioBox.GetId(), self.OnRadioBox)
        #LowerRightSizer.Add(RadioBox)
        LowerSizer.Add(RadioBox, 1, wxCENTER)
        
        ##############################
        # Set sizer:
        self.Sizer.SetSizeHints(self)
        self.SetSizer(self.Sizer)
    def OnRadioBox(self, Event):
        print Event.GetInt()
        self.ShowSpan = self.ShowSpans[Event.GetInt()]
        SpanLength = self.ShowSpanLenghts[self.ShowSpan]
        self.BigBrother.Reset()
        self.BigBrother.LoadDaysOfStats(SpanLength, self.EndingTime)
        self.ReRender()
    def MoveLog(self, Days):
        self.EndingTime = self.EndingTime + 60*60*24*Days
        self.EndingTime = min(self.EndingTime, time.time())
        TimeTuple = time.localtime(self.EndingTime)
        self.EndingTime = self.BigBrother.GetStartOfDay(TimeTuple)
        Str = "Stats through:\n%s"%time.strftime("%b %d, %Y", TimeTuple)
        self.DayText.SetLabel(Str)
        self.BigBrother.Reset()
        SpanLength = self.ShowSpanLenghts[self.ShowSpan]
        self.BigBrother.LoadDaysOfStats(SpanLength, self.EndingTime)
        self.ReRender()
    def OnTimer(self):
        pass
    def OnActivate(self):
        self.ReRender()
    
    
class DumpleApp(wxApp):
    def __init__(self):
        self.Title = "DumpleBBS"
        self.TaskBarIcon = None
        wxApp.__init__(self, 0) # NB: Nothing after this call here will execute until shutdown !
    def UpdateSystemTray(self):
        if Global.DumpleServer and len(Global.DumpleServer.Sessions):
            ProperState = TaskbarStates.Users
        else:
            ProperState = TaskbarStates.NoUsers
        self.SetTaskbarState(ProperState)
    def SetTaskbarState(self,State):
        if State != self.TaskBarIcon.State:
            self.TaskBarIcon.State = State
            self.TaskBarIcon.SetIcon(self.TaskBarIcons[State],self.Title)
    def InitTaskbar(self):
        self.TaskBarIcons = {}
        self.TaskBarIcons[TaskbarStates.NoUsers] = wxIcon('bubshead.ico', wxBITMAP_TYPE_ICO)
        self.TaskBarIcons[TaskbarStates.Users] = wxIcon('sbhead.ico', wxBITMAP_TYPE_ICO)
        self.TaskBarIcon = wxTaskBarIcon()
        self.TaskBarIcon.State = None
        self.SetTaskbarState(TaskbarStates.NoUsers)
        EVT_TASKBAR_LEFT_DOWN(self.TaskBarIcon, self.OnTaskBarIconClick)
    def OnTaskBarIconClick(self, *args):
        self.Frame.Raise()
        self.Frame.Iconize(0)
        self.Frame.Show(1)
    def OnTimer(self, Event):
        self.UpdateSystemTray()
        NotePageIndex = self.Notebook.GetSelection()
        Page = self.NotebookPanes[NotePageIndex]
        Page.OnTimer()
        # Tick!
    def OnInit(self):
        try:
            self.InitializeUI()
        except:
            traceback.print_exc()
            return false
        try:
            self.InitializeBBS()
        except:
            traceback.print_exc()
        return true
    def InitializeBBS(self):
        # Initialize stuff:
        Global.HomeDir = os.path.abspath(os.getcwd())
        Global.UserDict = User.UserDictClass()
        Global.BigBrother = BigBrother.BigBrother()
        Global.BigBrother.GetWeeklyStats()    
        Log("*** %s Starting up the server"%time.asctime())
        # Activate COM port servers (relevant only if we're using COM redirection rather than FOSSIL drivers)
        Config = Dumple.DumpleConfig()
        Port = Config.Config["Port"]
        DumpleServer = Dumple.DumpleServerClass(Config.Config, ("", Port), Dumple.DumpleSession)
        Global.DumpleServer = DumpleServer 
        print "Server object created!", Global.DumpleServer
        print Global.DumpleServer.Config
        Dumple.COMPortServerInit()
        # Activate the primary server in a worker thread:
        Thread = threading.Thread(None, Global.DumpleServer.serve_forever)
        Thread.setDaemon(1)
        Thread.start()
        #Global.DumpleServer.serve_forever()
    def ShutDown(self):
        self.TaskBarIcon.Destroy()
        self.Frame.Destroy()
    def OnNotebookPageChanged(self, Event):
        Index = Event.GetSelection()
        if Index>=len(self.NotebookPanes):
            return # Not in the list yet
        Page = self.NotebookPanes[Index]
        Page.OnActivate()
    def InitializeUI(self):
        wxInitAllImageHandlers()
        self.Frame = DumpleFrame(self)
        self.Frame.SetAutoLayout(true)
        Sizer = wxBoxSizer(wxVERTICAL)
        self.InitTaskbar()
        # NOTEBOOK and PAGES:
        self.NotebookPanes = []
        self.Notebook = wxNotebook(self.Frame, -1)
        Sizer.Add(self.Notebook, 1, wxEXPAND)
        EVT_NOTEBOOK_PAGE_CHANGED(self, -1, self.OnNotebookPageChanged)
        #
        self.SessionPane = SessionPane(self, self.Notebook)
        self.Notebook.AddPage(self.SessionPane, "Sessions")
        self.NotebookPanes.append(self.SessionPane)
        #
        self.LogPane = LogPane(self, self.Notebook)
        self.Notebook.AddPage(self.LogPane, "SysLog")
        self.NotebookPanes.append(self.LogPane)
        #
        self.BigBrotherPane = BigBrotherPane(self, self.Notebook)
        self.Notebook.AddPage(self.BigBrotherPane, "DoorLog")
        self.NotebookPanes.append(self.BigBrotherPane)
        
        self.Notebook.SetSelection(0)
        self.Timer = wxTimer(self)
        EVT_TIMER(self, -1, self.OnTimer)
        self.Timer.Start(1000) #msec
##        accelerators = wxAcceleratorTable([(wxACCEL_ALT, ord('X'), WidgetID.MenuShutdown)])
##        self.Frame.SetAcceleratorTable(accelerators)
##        EVT_MENU(self, WidgetID.MenuShutdown, self.OnMenuExit)
        #Notebook = wxNotebook(self.Frame, -1)
        self.SetTopWindow(self.Frame)
        self.Frame.SetAutoLayout(true)
        Sizer.SetSizeHints(self.Frame)
        self.Frame.SetSizer(Sizer)        
        self.Frame.Center()
        self.Frame.SetSize((800,600))
        self.Frame.Show(1) #self.startVisible)
        
def BBSMain():
    Global.SysLog = open("Syslog.txt", "wa")
    app = DumpleApp()
    app.MainLoop()
    print "MainLoop() call is now done."
    

if __name__=="__main__":
    BBSMain()