"""
This module is an example of a "login" door - one that sets the user.
"""
import time
import os
import User
import Global
import Door

class LoginState:
    Welcome = -1
    GetUserName = 0
    ConfirmNewUser = 1
    NewUserPassword = 2
    GetUserPassword = 3
    Done = 4

class LoginDoor(Door.Door):
    def __init__(self, Session):
        Door.Door.__init__(self, Session)
        self.State = LoginState.GetUserName
        self.BadTries = 0
        self.User = None
        try:
            self.Socket.recv(1024) # Discarded
        except:
            pass
        self.Welcome()
    def Welcome(self):
        self.Socket.send("\r\n\r\nDumpleBBS Online\r\n")
        FilePath = os.path.join(Global.GetHomeDir(), "MOTD.txt")
        if os.path.exists(FilePath):
            File = open(FilePath, "r")
            self.Session.request.send(File.read())
            File.close()
    def Run(self):
        self.Line = ""
        self.StartTime = time.clock()
        while (self.KeepRunning):
            try:
                if self.State == LoginState.GetUserName:
                    self.GetUserName()
                elif self.State == LoginState.GetUserPassword:
                    self.GetUserPassword()
                elif self.State == LoginState.ConfirmNewUser:
                    self.ConfirmNewUser()
                elif self.State == LoginState.NewUserPassword:
                    self.NewUserPassword()
                else:
                    # invalid state?  Better just quit.
                    self.KeepRunning = 0
            except Door.TimeoutError:
                self.Socket.send("\r\n\r\nInactivity timeout - dropping carrier.\r\nPlease call back soon.\r\n")
                break
            # Don't hang out in this door too long
            if (time.clock() - self.StartTime) > 300:
                self.Socket.send("\r\n\r\nLogin too slow - dropping carrier.\r\nPlease call back soon.\r\n")
                break
    def GetUserName(self):
        self.Session.request.send("\r\nPlease enter your name: ")
        UserName = self.GetLine()
        if len(UserName)==0:
            return None # We'll re-show the prompt
        UserDict = self.Session.GetUserDict()
        TheUser = UserDict.GetUser(UserName)
        if TheUser:
            self.User = TheUser
            self.State = LoginState.GetUserPassword
            return
        UserName = UserName[:50]
        self.User = User.UserClass(UserName)
        self.Socket.send("User not found.\r\n\r\n")
        self.State = LoginState.ConfirmNewUser
    def ConfirmNewUser(self):
        self.Socket.send("Create new user named '%s'  (y/N)? "%self.User.Name)
        Char = self.GetKey()
        self.Socket.send("\r\n")
        if Char==None:
            return
        if Char.upper() == "Y":
            self.State = LoginState.NewUserPassword
            return
        self.State = LoginState.GetUserName
    def GetUserPassword(self):
        self.Socket.send("Password for %s: "%self.User.Name)
        Line = self.GetLine()
        if not Line:
            # Back up to username entry
            self.User = None
            self.State = LoginState.GetUserName
            return
        if self.User.Password != Line:
            self.BadTries += 1
            self.Socket.send("Invalid password.\r\n")
            if self.BadTries>=3:
                self.Socket.send("\r\nToo many bad passwords!\r\nContact SYSOP for assistance.\r\n")
                self.User = None
                self.KeepRunning = 0
            return
        self.Session.User = self.User
        self.Socket.send("Welcome back, %s\r\n"%self.User.Name)
        self.KeepRunning = 0
    def NewUserPassword(self):
        self.Socket.send("Enter a password for %s: "%self.User.Name)
        Line = self.GetLine()
        if not Line:
            return
        self.User.Password = Line
        self.Socket.send("New user %s created with password %s\r\nPlease don't forget to remember your password\r\n"%(self.User.Name, self.User.Password))
        UserDict = self.Session.GetUserDict()
        UserDict.AddUser(self.User)
        UserDict.Save()
        self.Session.User = self.User
        self.KeepRunning = 0
            
def DumpleLogin(Session):
    Door = LoginDoor(Session)
    Door.Run()

