"""
Utility to run a door.
"""
import os
import sys
import time
import threading
import traceback

class FileReaderThread(threading.Thread):
    "File reader thread - for non-blocking i/o"
    def __init__(self, File, **kw):
        threading.Thread.__init__(self,**kw)
        self.File = File
        self.Text = ""
        self.StringLock = threading.Lock()
        self.setDaemon(1)
    def run(self):
        "* Subthread function"
        print "File thread activated.  You can count on me, boss."
        while (1):
            #self.File.flush()
            Str = self.File.read(1)
            self.StringLock.acquire()
            self.Text = self.Text + Str
            self.StringLock.release()
            #print self.Text
    def GetText(self):
        self.StringLock.acquire()
        Str = self.Text
        self.Text = ""
        self.StringLock.release()
        return Str

def RunDoor(Command):
    print "Running door command:", Command
    (Stdin, Stdout, Stderr) = os.popen3(Command)
    print Stdin, dir(Stdin)
    Reader = FileReaderThread(Stdout)
    Reader.start()
    print "Door is now active."
    while (1):
        time.sleep(0.1)
        print Reader.GetText()
        Text = sys.stdin.readline()
        if len(Text):
            try:
                Stdin.write(Text)
            except:
                traceback.print_exc()

if __name__=="__main__":
    #Command = r"c:\python23\python.exe Door.py"
    Command = r"c:\winnt\system32\ftp.exe"
    RunDoor(Command)        