import Global
import os
from Utils import *
from xml.dom.minidom import parse, parseString

class UserClass:
    def __init__(self, Name, Password = None, ID = None):
        self.ID = ID
        self.Name = Name
        self.Alias = Name
        self.Password = Password
        self.ANSI = 1
    def IsValid(self):
        if self.ID!=None and self.Name!=None:
            return 1
        
class UserDictClass:
    def __init__(self):
        self.Users = {} # lower-case keys
        self.UsersByID = {}
        self.NextUserID = 1
        self.Load()
        self.Save()
    def Load(self):
        User = UserClass("swt", "pants") #%%% for testing
        self.AddUser(User)
        FilePath = os.path.join(Global.GetHomeDir(), "Users.xml")
        if not os.path.exists(FilePath):
            return # No users - that's ok
        DOM = parse("Users.xml")
        RootNode = DOM.getElementsByTagName("Users")[0]
        for UserNode in RootNode.getElementsByTagName("User"):
            ##print "Load a user:"
            User = self.LoadUser(UserNode)
            if User and User.IsValid():
                self.AddUser(User)
                self.NextUserID = max(self.NextUserID, User.ID + 1)
    def LoadUser(self, Node):
        TheUser = UserClass("")
        self.LoadUserAttribute(TheUser, Node, "Name")
        self.LoadUserAttribute(TheUser, Node, "Alias")
        self.LoadUserAttribute(TheUser, Node, "ID")
        TheUser.ID = int(TheUser.ID)
        self.LoadUserAttribute(TheUser, Node, "Password")
        return TheUser
    def LoadUserAttribute(self, User, Node, TagName, AttributeName = None):
        if not AttributeName:
            AttributeName = TagName
        Tags = Node.getElementsByTagName(TagName)
        if not Tags:
            return
        Value = GetXMLText(Tags[0])
        setattr(User, AttributeName, Value)
    def GetUser(self, Name):
        Name = Name.lower()
        return self.Users.get(Name, None)
    def GetUserByID(self, ID):
        return self.UsersByID.get(ID, None)
    def Save(self):
        File = open("Users.xml", "w")
        File.write("<Users>\n")
        for User in self.Users.values():
            File.write("  <User>\n")
            File.write("    <ID>%s</ID>\n"%User.ID)
            File.write("    <Alias>%s</Alias>\n"%User.Alias)
            File.write("    <Password>%s</Password>\n"%User.Password)
            File.write("    <Name>%s</Name>\n"%User.Name)
            File.write("  </User>\n")
        File.write("</Users>\n")
    def AddUser(self, User):
        if User.ID == None:
            User.ID = self.NextUserID
            self.NextUserID += 1
        self.Users[User.Name.lower()] = User
        self.UsersByID[User.ID] = User

if __name__ == "__main__":    
    Global.UserDict = UserDictClass()        