/* strhtml.c - function to return HTML strings
 *
 * $Id: strhtml.c,v 1.3 2001/11/14 00:04:37 ivarch Exp $
 */

#include <stdio.h>
#include <string.h>
#include "mstring.h"


/* Return a string containing HTML tags to change from "current" attributes
 * to "desired". If "desired" is MTR_{FORE,BACK}_COLOUR then the colour is
 * to be changed to "c".
 */
char * conv_html_str (long * current, int * fg, int * bg, long desired, int c) {
  static char * rgb[] = {
    "000000",			/* black */
    "CC0000",			/* red */
    "00CC00",			/* green */
    "CCCC00",			/* yellow */
    "0000CC",			/* blue */
    "CC00CC",			/* magenta */
    "00CCCC",			/* cyan */
    "CCCCCC",			/* white */
    "444444",			/* bold black */
    "FF0000",			/* bold red */
    "00FF00",			/* bold green */
    "FFFF00",			/* bold yellow */
    "0000FF",			/* bold blue */
    "FF00FF",			/* bold magenta */
    "00FFFF",			/* bold cyan */
    "FFFFFF"			/* bold white */
  };
  static char outbuf[256];
  char tmpbuf[128];
  long switch_on;
  long switch_off;
  long current_attributes;
  int actual_current_fg, actual_current_bg;
  int actual_desired_fg, actual_desired_bg;

  if ((!current) || (!fg) || (!bg)) return ("");

  current_attributes = *current;

  actual_current_fg = *fg;
  actual_current_bg = *bg;
  if (current_attributes & MTR_REVERSE) {
    actual_current_fg = *bg;
    actual_current_bg = *fg;
  }
  if (current_attributes & MTR_BOLD) actual_current_fg += 8;

  switch_on = 0;
  switch_off = 0;

  if (desired == MTR_FORE_COLOUR) {
    if (c == MTR_COL_DEFAULT) c = MTR_COL_WHITE;
    *fg = c;
    desired = current_attributes;
  } else if (desired == MTR_BACK_COLOUR) {
    if (c == MTR_COL_DEFAULT) c = MTR_COL_BLACK;
    *bg = c;
    desired = current_attributes;
  } else {
    switch_on  = desired            - (desired & current_attributes);
    switch_off = current_attributes - (desired & current_attributes);
    (*current) = desired;
  }

  actual_desired_fg = *fg;
  actual_desired_bg = *bg;
  if (desired & MTR_REVERSE) {
    actual_desired_fg = *bg;
    actual_desired_bg = *fg;
  }
  if (desired & MTR_BOLD) actual_desired_fg += 8;

  if ((current_attributes == desired)
      && (actual_current_fg == actual_desired_fg)
      && (actual_current_bg == actual_desired_bg))
    return ("");				/* no changes to make */

  outbuf[0] = 0;

  if ((actual_current_fg != actual_desired_fg)
      || (actual_current_bg != actual_desired_bg)) {
    switch_off = current_attributes;
    switch_on = desired;
  }

  if (switch_off & MTR_BOLD)      strcat (outbuf, "</B>");
  if (switch_off & MTR_UNDERLINE) strcat (outbuf, "</U>");
  if (switch_off & MTR_STANDOUT)  strcat (outbuf, "</I>");
  if (switch_off & MTR_FLASH)     strcat (outbuf, "</BLINK>");

  if ((actual_current_fg != actual_desired_fg)
      || (actual_current_bg != actual_desired_bg)) {
    strcat (outbuf, "</FONT>");
    sprintf (tmpbuf, "<FONT COLOR=\"#%s\"", rgb[actual_desired_fg]);
    strcat (outbuf, tmpbuf);
    if (actual_desired_bg > 0) {
      sprintf (tmpbuf, " STYLE=\"background: #%s;\"", rgb[actual_desired_bg]);
      strcat (outbuf, tmpbuf);
    }
    strcat (outbuf, ">");
  }

  if (switch_on & MTR_BOLD)      strcat (outbuf, "<B>");
  if (switch_on & MTR_UNDERLINE) strcat (outbuf, "<U>");
  if (switch_on & MTR_STANDOUT)  strcat (outbuf, "<I>");
  if (switch_on & MTR_FLASH)     strcat (outbuf, "<BLINK>");

  return (outbuf);
}

/* EOF */
