/* strip.c - replace <, >, & with HTML equivalents
 *
 * $Id: strip.c,v 1.1.1.1 1999/12/02 20:00:34 ivarch Exp $
 */

#include "mstring.h"


/* Replace <, > and & with &lt; &gt; and &amp; respectively; if "spaces" is
 * nonzero, spaces are replaced by &#160; as well.
 */
void conv_html_strip (char * str, long size, int spaces) {
  int a;
  char * c;

  if (!str) return;

  a = 0;
  while ((a >= 0) && (str[a] != 0) && (str[a] != 10)) {
    c = 0;
    switch (str[a]) {
      case '<' : c = "&lt;"; break;
      case '>' : c = "&gt;"; break;
      case '&' : c = "&amp;"; break;
      case ' ' : if (spaces) c = "&#160;"; break;
      default  : break;
    }
    if (c) {
      mstrdelete (str, a, 1);
      mstrinsert (str, c, &a, size);
    } else a ++;
  }
}

/* EOF */
