/* info.c - output information about a menu
 *
 * $Id: info.c,v 1.1.1.1 1999/12/02 20:00:21 ivarch Exp $
 */

#include <stdio.h>
#include "menu.h"


/* Output information about "menu" on standard output.
 */
void mtrib_menu_info (menu_t * menu) {
  menuentry_t * m;
  int i;

  printf ("Owner: %s\n", menu->owner);
  if (menu->title) printf ("Title: [%s] %s\n",
                           (menu->title_type == MENU_TITLE_ANIMATED) ?
                           "ANIM" : (menu->title_type == MENU_TITLE_CENTRE) ?
                           "CENTRE" : "LEFT",
                           menu->title);
  if (menu->logfile) printf ("Menu logfile: [%s] %s\n",
                             (menu->log_type == MENU_LOG_TITLE) ? "TITLE" :
                             "USER",
                             menu->logfile);
  if (menu->viewfile) printf ("Menu viewfile: [%s] %s\n",
                              (menu->viewalways) ? "VIEWALWAYS" : "NORMAL",
                              menu->viewfile);
  printf ("Menu editable: %s\n", menu->allow_edit ? "Yes" : "No");
  printf ("Menu entries: %d\n", menu->num_entries);

  for (i = 0; i < menu->num_entries; i ++) {		/* output entries */
    m = &(menu->menu[i]);
    printf ("\nEntry: %d\nType: %c\n", i + 1, m->type);
    if (m->title) printf ("Title: %s\n", m->title);
    if (m->filename) printf ("Action: %s\n", m->filename);
    if (m->commentfile) printf ("Comment file: %s\n", m->commentfile);
    if (m->viewfile) printf ("Viewfile: [%s] %s\n",
                             (m->viewalways) ? "VIEWALWAYS" : "NORMAL",
                             m->viewfile);
    if (m->logfile) printf ("Logfile: [%s] %s\n",
                             (m->log_type == MENU_LOG_TITLE) ? "TITLE" :
                             "USER",
                             m->logfile);
    if (m->key) printf ("Keypress: %c\n", m->key);
    if (m->param) printf ("Parameter: %d (%c)\n", m->param,
                          (m->param > 31 && m->param != 127) ? m->param : '-');
    if (m->status) printf ("Status:%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s\n",
      (m->status & MENU_STATUS_ADD) ?		" ADD" : "",
      (m->status & MENU_STATUS_DELETE) ?	" DELETE" : "",
      (m->status & MENU_STATUS_EDIT) ?		" EDIT" : "",
      (m->status & MENU_STATUS_ANONYMOUS) ?	" ANONYMOUS" : "",
      (m->status & MENU_STATUS_XRATED) ?	" XRATED" : "",
      (m->status & MENU_STATUS_NOTIME) ?	" NOTIME" : "",
      (m->status & MENU_STATUS_BARINFO) ?	" BARINFO" : "",
      (m->status & MENU_STATUS_BARMAIL) ?	" BARMAIL" : "",
      (m->status & MENU_STATUS_BARPRINT) ?	" BARPRINT" : "",
      (m->status & MENU_STATUS_BARSENDRPLY) ?	" BARSENDREPLY" : "",
      (m->status & MENU_STATUS_LOWPRIORITY) ?	" LOWPRIORITY" : "",
      (m->status & MENU_STATUS_NOSCAN) ?	" NOSCAN" : "",
      (m->status & MENU_STATUS_NOLAST) ?	" NOLAST" : "",
      (m->status & MENU_STATUS_NOERRORS) ?	" NOERRORS" : "",
      (m->status & MENU_STATUS_NOINDEX) ?	" NOINDEX" : "",
      (m->status & MENU_STATUS_HIDETITLE) ?	" HIDETITLE" : "",
      (m->status & MENU_STATUS_READONLY) ?	" READONLY" : "",
      (m->status & MENU_STATUS_BARLOG) ?	" BARLOG" : "",
      (m->status & MENU_STATUS_BARDELETE) ?	" BARDELETE" : "");
  }
}

/* EOF */
