/* help.c - display online help
 *
 * $Id: help.c,v 1.2 2001/10/11 13:59:00 ivarch Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "viewmenu.h"
#include "viewfile.h"


/* View the online help for the menu viewer.
 */
void menuview_help (menudata_t data) {
  struct LDB d;
  char * tmp;
  int fd;
  static char * help = "\
\n\
                             \035CB\035Cc\035R                    \n\
                             \035CB\035Cc\035B\035R  Menu Viewer Help  \n\
                             \035CB\035Cc\035R                    \n\
\n\
The first few keys control menu navigation:\n\
\n\
      [\035B+\035b]: \035CCScroll down menu\035CA                  [\035B-\035b]: \035CCScroll up menu\n\
 [\035BRETURN\035b]: \035CCExit current menu\035CA                 [\035BQ\035b]: \035CCExit current menu / quit\n\
\n\
If the current menu is the top level menu, [\035BQ\035b] will exit the viewer.\n\
\n\
The next few entries control scanning and last access information. Files and\n\
menus may be marked so that when a scan for unread files is done, they are\n\
not picked up. This is called \"\035Bunsubscribing\035b\".\n\
\n\
  [\035BSPACE\035b]: \035CCStart scanning\035CA                    [\035B=\035b]: \035CCSet subscriptions\n\
   [\035B=\035b][\035B=\035b]: \035CCSet for all entries\035CA          [\035BDELETE\035b]: \035CCMark all entries as read\n\
\n\
The following only work if you have edit permissions to the current menu and\n\
it is not a listed directory:\n\
\n\
   [\035B.\035b][\035BM\035b]: \035CCEdit menu code\035CA                 [\035B.\035b][\035BT\035b]: \035CCEdit menu title, if has one\n\
\n\
Alternatively, if the current menu is a listed directory and you have the\n\
appropriate permissions, the following keys can be used.\n\
\n\
   [\035B.\035b][\035BA\035b]: \035CCAdd new file\035CA                   [\035B.\035b][\035BM\035b]: \035CCAdd new menu\n\
   [\035B.\035b][\035BR\035b]: \035CCRename file\035CA\n\
   [\035B.\035b][\035BD\035b]: \035CCDelete entry\n\
\n\
Finally, some miscellaneous keys:\n\
\n\
     [\035B^L\035b]: \035CCRedraw the screen\035CA                [\035B^X\035b]: \035CCShell out\n\
      [\035B?\035b]: \035CCView this help\n\
\n\
Any key pressed which is not one of the above will activate the appropriate\n\
menu entry.\n\
\n\
Press [\035BQ\035b] now to return to the menu viewer.\n\
\n";

  tmp = (char *) malloc (strlen (P_tmpdir) + 32);
  if (!tmp) return;
  strcpy (tmp, P_tmpdir);
  strcat (tmp, "/mviewXXXXXX");
  fd = mkstemp (tmp);
  if (fd < 0) {
    remove (tmp);
    free (tmp);
    return;
  }
  write (fd, help, strlen (help));
  close (fd);

  memset (&d, 0, sizeof (d));
  strcpy (d.realname, tmp);
  strcpy (d.filename, tmp);

  read_file (&d, "Help", MENU_STATUS_BARINFO | MENU_STATUS_READONLY, 0);

  remove (d.realname);
  free (tmp);
  rf_redraw = 1;
}

/* EOF */
