/* ldb.h - header file for LDB manipulation functions
 *
 *   ldb_init         - initialise LDB functions
 *   ldb_filename     - follow all symbolic links
 *   ldb_find         - find an entry in an LDB file
 *   ldb_read         - read an entry from an LDB file
 *   ldb_write        - write an entry to an LDB file
 *   ldb_load         - load LDB file into cache if changed
 *   ldb_save         - save LDB file from cache if changed
 *
 * $Id: ldb.h,v 1.1.1.1 1999/12/02 20:03:07 ivarch Exp $
 */

#ifndef _MT_LDB_H
#define _MT_LDB_H

#ifndef _TIME_H
#include <time.h>
#endif	/* _TIME_H */

#define LDB_FLAG_ALTERED	1
#define LDB_FLAG_DELETED	2


struct LDB {			/* last access information for a file (LDB) */
  char filename [1024];			/* filename to record and show */
  char realname [1024];			/* actual filename */
  time_t last_accessed;			/* time it was last accessed */
  time_t last_datestamp;		/* last datestamp seen */
  long datestamp_line;			/* line of last datestamp seen */
  long current_line;			/* number of last line seen */
  int at_end;				/* set if at end of file */
  int sub_status;			/* 0 if subbed, 1 skip 1st, 2 unsub */
};

typedef struct LDB * ldb_t;

extern char * ldb_lbuf;			/* workspace: line buffer */
extern char * ldb_fbuf;			/* workspace: filename buffer */

extern char * ldb_cache;		/* workspace: LDB cache */
extern char * ldb_cached_file;		/* name of cached file */

extern char ** ldb_cache_names;		/* array of cached filenames */
extern char ** ldb_cache_data;		/* array of cached data */
extern long * ldb_cache_offset;		/* array of line positions */
extern char * ldb_cache_flags;		/* array of entry flags */
extern long ldb_cached_entries;		/* length of above arrays */

void ldb_init (void);
char * ldb_filename (char *);
long ldb_find (char *, char *);
void ldb_read (char *, char *, ldb_t);
void ldb_write (char *, ldb_t);
void ldb_load (char *);
void ldb_save (char *);

#endif	/* _MT_LDB_H */

/* EOF */
