/* viewmenu.h - internal header file for menu viewer
 *
 * $Id: viewmenu.h,v 1.1.1.1 1999/12/02 20:03:07 ivarch Exp $
 */

#ifndef _MT_VIEWMENU_H
#define _MT_VIEWMENU_H

#ifndef _MT_MENU_H
#include "menu.h"
#endif	/* _MT_MENU_H */

#ifndef _TIME_H
#include <time.h>
#endif	/* _TIME_H */

#define MENUVIEW_BUFLEN		1024
#define MENUVIEW_KEYPATHLEN	64
#define MENUVIEW_TITLELINES	9

#define MENUFLAG_SUB		1		/* sub menu */
#define MENUFLAG_SCAN		2		/* scanned into menu */
#define MENUFLAG_LISTED		8		/* menu is listed directory */
#define MENUFLAG_HIDETITLE	16		/* hide menu title */
#define MENUFLAG_SPECIAL	32		/* special menu */
#define MENUFLAG_READNOW	64		/* special: read now */

#define MENUQUIT_RETURN		1
#define MENUQUIT_QUIT		2
#define MENUQUIT_ERROR		2
#define MENUQUIT_SCAN		4
#define MENUQUIT_DUMMY		10

extern int rf_redraw;		/* redraw flag */
extern int menuview_exitup;
extern char ** menuview_files;


struct MenuData {		/* information about the current menu */
  menu_t * menu;			/* the menu itself */
  char file [MENUVIEW_BUFLEN + 1];	/* filename of the menu */
  char * ldbfile;			/* LDB file */
  char keypath [MENUVIEW_KEYPATHLEN+1];	/* current keypath */
  char title [MENUVIEW_BUFLEN + 1];	/* menu title */
  char buf [MENUVIEW_BUFLEN + 1];	/* workspace */
  long status;				/* status for listed directory */
  int flags;				/* flags, as passed to read_menu() */
  int quit;				/* 0=no, 1=RET, 2=Q, 4=scan out */
  unsigned long last_accessed;		/* time menu file last accessed */
  char * titleline[MENUVIEW_TITLELINES];/* top lines of menu (inc. title) */
  int title_lines;			/* number of title lines */
  int offset;				/* number of top displayed menu line */
  int maxlen;				/* max length of menu title */
  int fd;				/* open descriptor, or -1 if shut */
  time_t last_resize;			/* last resize time known about */
};

typedef struct MenuData * menudata_t;

extern long menuview_listed_status;	/* status for listed directories */

int read_menu (char *, char *, char *, char *, int);
int menuview_loadmenu (menudata_t);
void menuview_redraw (menudata_t);
void menuview_footer (menudata_t);
void menuview_wipe_footer (menudata_t);
void menuview_action (menudata_t, menuentry_t *);
void menuview_edit (menudata_t);
void menuview_scan (menudata_t);
void menuview_setsubs (menudata_t);
void menuview_shell (menudata_t);
void menuview_help (menudata_t);
void menuview_readfile (menudata_t, char *, char *, unsigned long, char *);
int  menuview_viewfile (menudata_t, char *, char *);
int  menuview_viewalways (menudata_t, char *, char *);
void menuview_system (char *, char *);
void menuview_read (menudata_t, menuentry_t *);
void menuview_execute (menudata_t, menuentry_t *);
void menuview_spooled (menudata_t, menuentry_t *);
void menuview_telnet (menudata_t, menuentry_t *);
void menuview_animation (menudata_t, menuentry_t *);
void menuview_catchup (menudata_t, menuentry_t *);
void menuview_edit_listed (menudata_t);

menu_t * menuview_loadlisted (menudata_t);

int mview_edit_file (char *, long, int, char *, char *);

#endif	/* _MT_VIEWMENU_H */

/* EOF */
