/* free.c - free all memory associated with a menu structure
 *
 * $Id: free.c,v 1.1.1.1 1999/12/02 20:03:15 ivarch Exp $
 */

#include <stdlib.h>
#include "menu.h"


/* Free the menu structure "menu", along with all entries and data inside it.
 */
void menu_free (menu_t * menu) {
  int i;

  free (menu->filename);
  free (menu->title);
  free (menu->logfile);
  free (menu->owner);
  free (menu->viewfile);

  for (i = 0; i < menu->num_entries; i ++) {
    free (menu->menu[i].title);
    free (menu->menu[i].filename);
    free (menu->menu[i].commentfile);
    free (menu->menu[i].viewfile);
    free (menu->menu[i].logfile);
  }

  free (menu->menu);
  free (menu);
}

/* EOF */
