/* delete.c - delete a substring from a string
 *
 * $Id: delete.c,v 1.1.1.1 1999/12/02 20:03:24 ivarch Exp $
 */

#include <string.h>


/* Remove "size" bytes of "str" starting from index "start".
 */
void mstrdelete (char * str, int start, int size) {
  int l;

  if (!str) return;
  l = strlen (str);
  if ((start >= l) || (start < 0) || (size < 1)) return;

  if ((start + size) >= l) {	/* trying to delete past end of string */
    str[start] = 0;
    return;
  }

  memmove (str + start, str + start + size, 1 + l - (start + size));
}

/* EOF */
