/* index.c - find index of "n"th printable character
 *
 * $Id: index.c,v 1.1.1.1 1999/12/02 20:03:24 ivarch Exp $
 */

#include <string.h>
#include <ctype.h>
#include "mstring.h"


/* Return the index into "str" of the "n"th printable character. Note that
 * newlines are ignored (treated as any other character), as are tabs.
 */
int mstrindex (char * str, int n) {
  int s = 0;

  if (!str) return (0);

  while (n > 0) {
    if (str[s] == 0) return (s);	/* end of buffer - return its index */
    if (miscntl(str[s])) {
      mtribval (str, &s);			/* skip attributes */
    } else {
      s ++;
      n --;
    }
  }

  return (s);
}

/* EOF */
