/* since.c - return a string describing elapsed time
 *
 * $Id: since.c,v 1.1.1.1 1999/12/02 20:03:25 ivarch Exp $
 */

#include <stdio.h>


/* Return a string containing a "(", 14 characters, and a ")", describing
 * the time period "t" (time ago, in seconds).
 *
 * The returned pointer points to an internal static buffer, so the string
 * will not persist across calls. Copy it elsewhere.
 */
char * mstrsince (long t) {
  static char buf[32];

  if (t < 1) return ("(       No time)");		/* < 1 second */

  if (t < 60) {						/* < 1 minute */
    sprintf (buf, "(    %2ld Second%s)", t, (t == 1) ? " " : "s");
    return (buf);
  }

  if (t < (60*60)) {					/* < 1 hour */
    sprintf (buf, "( %2ld Min %2ld Sec)", t / 60, t % 60);
    return (buf);
  }

  if (t < (60*60*24)) {					/* < 1 day */
    t = t / 60;
    sprintf (buf, "(%2ld Hour %2ld Min)", t / 60, t % 60);
    return (buf);
  }

  if (t < (60*60*24*7)) {				/* < 1 week */
    t = t / (60*60);
    sprintf (buf, "(%2ld Day %2ld Hour)", t / 24, t % 24);
    return (buf);
  }

  if (t < (60*60*24*7*2)) {				/* < 2 weeks */
    t = t / (60*60*24);
    t -= 7;
    sprintf (buf, "( 1 Week %1ld Day%s)", t, (t == 1) ? " " : "s");
    return (buf);
  }

  if (t < (60*60*24*365*2)) {				/* < 2 years */
    t = t / (60*60*24);
    sprintf (buf, "(%3ld Wks %1ld Day%s)", t / 7, t % 7,
             ((t % 7) == 1) ? " " : "s");
    return (buf);
  }

  t = t / (60*60*24*7);					/* >= 2 years */

  sprintf (buf, "(%3ld Yrs %2ld Wk%s)", t / 52, t % 52,
             ((t % 52) == 1) ? " " : "s");
  return (buf);
}

/* EOF */
