#include "CocoaInitializer.h"
#include <iostream>
#include <AppKit/AppKit.h>
#include <Cocoa/Cocoa.h>
#include <QtDebug>

@interface DockIconClickEventHandler : NSObject
{
@public
    CocoaInitializer* app;
}
- (void)handleDockClickEvent:(NSAppleEventDescriptor*)event withReplyEvent:(NSAppleEventDescriptor*)replyEvent;
@end

@implementation DockIconClickEventHandler
- (void)handleDockClickEvent:(NSAppleEventDescriptor*)event withReplyEvent:(NSAppleEventDescriptor*)replyEvent {
    if (app)
        app->dockIconClickEvent();
}
@end


class CocoaInitializer::Private
{
    public:
    Private();
    void setupCocoaEventHandler() const;

    NSAutoreleasePool* autoReleasePool_;
    DockIconClickEventHandler* dockIconClickEventHandler;

};

CocoaInitializer::CocoaInitializer()
{
    d = new CocoaInitializer::Private();
    d->dockIconClickEventHandler->app = this;
    d->setupCocoaEventHandler();
    NSApplicationLoad();
}

CocoaInitializer::~CocoaInitializer()
{
    [d->autoReleasePool_ release];
    delete d;
}

CocoaInitializer::Private::Private() {
    autoReleasePool_ = [[NSAutoreleasePool alloc] init];
    dockIconClickEventHandler = [[DockIconClickEventHandler alloc] init];
}

void CocoaInitializer::Private::setupCocoaEventHandler() const {
    [[NSAppleEventManager sharedAppleEventManager]
     setEventHandler:dockIconClickEventHandler
     andSelector:@selector(handleDockClickEvent:withReplyEvent:)
     forEventClass:kCoreEventClass
     andEventID:kAEReopenApplication];
}

void CocoaInitializer::dockIconClickEvent() {
    if (mw->isHidden()) {
        mw->setUnseenNotifications(0);
        mw->show();
    }
}

void CocoaInitializer::setMainWindow(MainWindow *mw) {
    this->mw = mw;
}

void CocoaInitializer::onSetupDockEventMonitor() {
    d->setupCocoaEventHandler();
}
