#include <QPainter>
#include <QApplication>
#include <QStyledItemDelegate>
#include "logitem.h"

LogItem::LogItem(QString p, QString s, QString m) {
    program = p;
    system = s;
    message = m;
}


void LogItem::paint(QPainter *painter, const QRect &rect, const QPalette &pallet) const {
    QFont font = QApplication::font();
    QFontMetrics fm(font);
    int sysWide = fm.width(system);
    int prgWide = fm.width(program);
    painter->save();
    painter->setRenderHint(QPainter::Antialiasing, true);
    painter->setFont(font);
    painter->setPen(QPen(Qt::GlobalColor::green));
    painter->drawText(5, rect.y() + fm.height(), system);
    painter->setPen(QPen(Qt::GlobalColor::cyan));
    painter->drawText(sysWide + 10, rect.y() + fm.height(), program);
    painter->setPen(pallet.foreground().color());
    painter->drawText(sysWide + prgWide + 15, rect.y() + fm.height(),  message);
    painter->restore();

}

QSize LogItem::sizeHint() const
{
    QFont font = QApplication::font();
    QFontMetrics fm(font);

    return QSize((fm.width(system) + fm.width(program) + fm.width(message) + 20), fm.height() + 5);
}
