#include <QPainter>
#include "logitemdelegate.h"
#include "logitem.h"
void logitemdelegate::paint(QPainter *painter, const QStyleOptionViewItem &option,
                         const QModelIndex &index) const
{

    if (index.data().canConvert<LogItem>()) {
        LogItem logItem = qvariant_cast<LogItem>(index.data());

        if (option.state & QStyle::State_Selected) painter->fillRect(option.rect, option.palette.highlight());

        logItem.paint(painter, option.rect, option.palette);
    } else {
        QStyledItemDelegate::paint(painter, option, index);
    }
}

QSize logitemdelegate::sizeHint(const QStyleOptionViewItem &option,
                             const QModelIndex &index) const
{
    if (index.data().canConvert<LogItem>()) {
        LogItem logItem = qvariant_cast<LogItem>(index.data());
        return logItem.sizeHint();
    } else {
        return QStyledItemDelegate::sizeHint(option, index);
    }
}
