#include <ctype.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/shm.h>
#include <unistd.h>
#include "areas.h"
#include "inc.h"
#include "output.h"
#include "status.h"
#include "transfer.h"
#include "varlist.h"

extern varlist list;
extern int ansi;
extern char no_key, cont_key, *out_buf;

extern void init_error(char *, ...);
extern void dprintf(char *, ...);

char *msg_buf = NULL;

int msg_id = -1;

void init_inc()
{
  key_t key;
   
  key = ftok(KEYFILE, node);
   
  msg_id = msgget(key, IPC_CREAT | SHM_PERM);
  if(msg_id == -1) {
    perror("msgget");
    init_error("could not allocate message queue");
  }

  msg_buf = (char *)malloc(1024);

  signal(SIGUSR2, handle_inc);
   
  atexit(kill_inc);
}

int inc_request()
{
  struct msgbuf *in_msg, *out_msg;
  char *reply, num_buf[16], *tmp;
  variable *v;
  int cmd;
   
  in_msg = (struct msgbuf *)malloc(sizeof(long) + 1024 + 1);
   
  if(msgrcv(msg_id, in_msg, 1024, INC_REPLY, IPC_NOWAIT | MSG_EXCEPT) == -1) {
    free(in_msg);
    return 1;
  }

  cmd = in_msg -> mtype & 255;
  dprintf(">Got INC request: %d (%s)\n", cmd, in_msg -> mtext);
      
  switch(cmd) {
  case INC_GET:
    v = list[in_msg -> mtext];
    if(!v) 
      reply = "error";
    else if(v -> get_type() == STRING)
      reply = v -> get_s();
    else {
      sprintf(num_buf, "%d", v -> get_i());
      reply = num_buf;
    }
  break;
     
  case INC_SETS:
    reply = NULL;
    tmp = strchr(in_msg -> mtext, ' ');
    if(!tmp)
      break;
    *tmp++ = 0;
    v = list[in_msg -> mtext];
    if(!v)
      list.add(in_msg -> mtext, tmp);
    else if(v -> get_type() == STRING)
      *v = tmp;
  break;
     
  case INC_SETN:
    reply = NULL;
    tmp = strchr(in_msg -> mtext, ' ');
    if(!tmp)
      break;
    *tmp++ = 0;
    v = list[in_msg -> mtext];
    if(!v)
      list.add(in_msg -> mtext, atoi(tmp));
    else if(v -> get_type() == NUMERIC)
      *v = atoi(tmp);
  break;
     
  case INC_SHUTDOWN:
    reply = NULL;
    raise(SIGTERM);
  break;
  
  case INC_SEND:
    send_file(in_msg -> mtext);
    reply = NULL;
  break;
  }

  // Is it just me or is Sys V IPC extremely weird?
  if(reply) {
    out_msg = (struct msgbuf *)malloc(sizeof(long) + strlen(reply) + 1);
    out_msg -> mtype = INC_REPLY;
    strcpy(out_msg -> mtext, reply);
    msgsnd(msg_id, out_msg, strlen(reply) + 1, 0);
    free(out_msg);
  }

  free(in_msg);
  return 0;
}

void handle_inc(int sig)
{
  status_p -> flags |= SF_INCBUSY;
  signal(SIGUSR2, SIG_IGN);

  while(inc_request() == 0);
   
  signal(SIGUSR2, handle_inc);
  status_p -> flags &= (~SF_INCBUSY);
}

void kill_inc()
{
  if(msg_id != -1)
    msgctl(msg_id, IPC_RMID, NULL);
  if(msg_buf)
    free(msg_buf);
}

void nodelist()
{
  int t, lineno = 0, lines;
  struct status_t *st_buf;
  variable *u, *n, *b;
  char c, forever = 0;
  
  lines = number("lines") - 1;
  
  n = list.add_sys("nodenum", 0);
  u = list.add_sys("username", "");
  b = list.add_sys("userbusy", "");
  
  for(t = 0;t < MAX_NODES;t++) {
    if(!isanode(t))
      continue;

    st_buf = &(status_pool -> status[t]);

    *n = t;
    inc(t, INC_GET, "user");
    *u = msg_buf;
    inc(t, INC_GET, "busy");
    *b = msg_buf;
    cook(string("nodefmt"));
    output_cooked(out_buf);
    output_cooked("\n");
    
    if(!forever)
      lineno++;
    
    if(lineno == lines) {
      output_cooked(string("moreprompt"));
      c = tolower(read_char());
      if(c == no_key)
        break;
      if(c == cont_key)
        forever = 1;
      lineno = 0;
    }
  }
  
  if(lineno) {
    output_cooked(string("pressanykey"));
    read_char();
  }
} 
