#include <unistd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/shm.h>
#include <sys/types.h>
#include "inc.h"
#include "status.h"

#define CHAT 42

status_t *tmp;
int n;
char *msg_buf;

void error(char *msg) 
{
  fprintf(stderr, "oscmd: %s\n", msg);
  exit(1);
}

void init()
{
  if(init_pool(0))
    error("there are no active nodes");
}

int chat()
{
//  tmp = attach_other(n);
  tmp = &status_pool -> status[n];

  if(!tmp)
    return 1;
   
  while(!(tmp -> flags & SF_INTERRUPT))
    usleep(1000);
   
  kill(tmp -> pid, SIGUSR1);
   
  return 0;
}

int main(int argc, char *argv[])
{
  int cmd, n0, n1, args, t, failure = 1, result;
  char *par;

  msg_buf = (char *)malloc(1024);
  par = (char *)malloc(1024);
   
  *par = 0;
   
  if(argc == 1) {
    fprintf(stderr, "usage: oscmd node#/all <cmd> [par1] [par2]...\n");
    exit(1);
  }
 
  if(!strcasecmp(argv[1], "all"))
    n = -1;
  else
    n = atoi(argv[1]);
   
  if(argc < 3)
    error("need command");

  if(!strcasecmp(argv[2], "get"))  {
    args = 1;  
    cmd = INC_GET;
  }
  else if(!strcasecmp(argv[2], "chat")) {
    args = 0;
    cmd = CHAT;
  }
  else if(!strcasecmp(argv[2], "sets")) {   
    args = 2;
    cmd = INC_SETS;
  }
  else if(!strcasecmp(argv[2], "setn")) {
    args = 2;
    cmd = INC_SETN;
  }
  else if(!strcasecmp(argv[2], "shutdown")) {
    args = 0;
    cmd = INC_SHUTDOWN;
  }
  else if(!strcasecmp(argv[2], "send")) {
    args = 1;
    cmd = INC_SEND;
  }
  else
    error("unknown command");
   
  if(argc <= (args + 2))
    error("missing parameter(s)");  

  for(t = 0;t < args;t++) {
    strcat(par, argv[3 + t]); 
    if(t != args - 1)
      strcat(par, " ");
  }
   
  if(n == -1) {
    n0 = 0; 
    n1 = MAX_NODES;  
  }
  else {
    n0 = n;
    n1 = n0 + 1;
  }

  init();
   
  if(cmd == CHAT)
    return chat();

  for(n = n0;n < n1;n++) {  
    result = inc(n, cmd, par);
    if(!result) {
      failure = 0;
      if(cmd == INC_GET)
        printf("%s\n", msg_buf);
    }
  }
   
  return failure;
}

