#ifndef __VARLIST_H
#define __VARLIST_H

#define NUMERIC 0
#define STRING  1

#define V_ANSI      1
#define V_NICK      2
#define V_USER      3
#define V_AREANUM   4 
#define V_MARKED    5
#define V_TOUSER    6
#define V_DATE      7
#define V_RED       8
#define V_BRED      9
#define V_BLUE     10
#define V_BBLUE    11
#define V_CYAN     12
#define V_BCYAN    13
#define V_GREEN    14
#define V_BGREEN   15
#define V_PURPLE   16
#define V_BPURPLE  17
#define V_BLACK    18
#define V_BROWN    19
#define V_YELLOW   20
#define V_DGREY    21
#define V_GREY     22
#define V_WHITE    23
#define V_YESKEY   24
#define V_NOKEY    25
#define V_MARKKEY  26
#define V_QUITKEY  27
#define V_CONTKEY  28
#define V_PROTOCOL 29
#define V_MAYBE    30
#define V_AREATAG  31
#define V_TODAY    32
#define V_FILESORT 33

#define number(x) (list[x] -> get_i())
#define string(x) (list[x] -> get_s())
#define exists(x) (list[x])

char *format_date(int);
char *initials(char *);
char *format_user(char *);
int unformat_date(char *);
void busy(int);

class variable {
friend class varlist;
friend void save_varlist(FILE *, variable *);
friend void do_menu(char *);
friend int load_user(char *, varlist *);
   
private:
  variable *left, *right;

  char *name, type;
  char save;

  int magic;
   
  union {
    char *s;
    int i;
  };

public:
  char get_type() { return type; }
  int   get_i();
  char *get_s();
  variable(char *, int);
  variable(char *, char *);
  ~variable();
  int operator=(int);
  char *operator=(char *);
  int operator==(int a) { return i == a; }
  int operator==(char *a) { return strcmp(a, s) == 0; }
  void check_magic();
  void sync_num();
  void sync_string();
};

class varlist {
friend void save_varlist(variable *);
friend void save_user();
private:
  variable *base;
  int count;

public:
  varlist();
  ~varlist();
  variable *add(char *, char *);
  variable *add(char *, int);
  variable *operator[](char *);
  variable *add_sys(char *, char *);  
  variable *add_sys(char *, int);
};

#endif // __VARLIST_H

