// Filename:   bbshdr.h
// Purpose:    a general repository for standard and system includes
// Author:     Greg Shaw
// Created:    6/1/93

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _BBSHDR_H_
#define _BBSHDR_H_

// bbs definitions


// define the below if you're going to run the BBS program on multiple
// machines.  This will result in the name of the machine that the
// information came from being included in the message.
#define MULTIPLE_MACHINE_BBS
// english is default
#define DEFAULT_LANGUAGE   "english"
// try to be as secure as possible
#define SECURE
// enable message subsystem (and database)
#define USE_DATABASE

// files area size defaults
#define MAX_FILES      256       // maximum open files available
#define MAX_LOCK_TRIES     3    // try 3 times for file lock
#define MAX_FILENAMELENGTH 50   // max filename size
#define MAX_SECTION_LENGTH 50   // max files section name length
#define MAX_FILES_ON_SCREEN	80	// no more than 80 files on the screen
#define MAX_LARGE_DESCRIPTION	1024	// largest large description (CDROM)

// message area size defaults
// max subject definition
#define MAX_SUBJECT             71
// max subject definition
#define MAX_SECTION             50
// max from and to
#define MAX_FROM_TO             51

// max number of editors on system
#define MAX_EDITORS		10


// no more than 50 macros
#define MAX_MACRO_LEVEL        50

// definitions (recursive) allowed in a menu
// max number of dl protocols
#define MAX_DL_COMMANDS        15

// found in $BBSDIR/config/protocols
// error logger file path
#define MAX_CHAT_ROOMS     30   // 30 public/club rooms + 30 private rooms
#define MAX_CHAT_MSG   255      // largest chat message
                                // broadcasts last 15 seconds max
#define MAX_BROADCAST_TIMEOUT  15
#define ERR_LOG_PATH   "/bbs/admin/bbserr"
// user record definitions
#define MAX_LOGIN_LENGTH   11   // 10, really
#define MAX_ALIAS_LENGTH   21   // 20, really
#define MAX_TERM_LENGTH    21   // terminal length
#define MAX_FIRSTNAME	21      // max first name
#define MAX_LASTNAME	21      // max last name
#define MAX_PROGNAME	51	// max program length


// chat information
                                // max number of people in a kill file
#define MAX_CHAT_KILL_USERS    25


// posix doesn't define the u_type shortcuts.  internetworking does.  So ...

#ifndef u_short
#define u_short unsigned short
#define u_long  unsigned long
#define u_char  unsigned char
#define u_float unsigned float
#endif

// system includes

#include <stdio.h>              // standard output
#include <ctype.h>              // standard isxxxx functions
#include <stdarg.h>             // arguments from command line
#include <fcntl.h>              // file control
#include <assert.h>             // assert system call (for sanity checking)
#include <termio.h>             // non blocking read system calls
#include <string.h>             // string functions
#include <limits.h>             // system data limits
#include <sys/types.h>          // system types
#include <sys/time.h>           // time and date
#include <rpc/types.h>          // system rpc types
#include <sys/stat.h>           // the stat() (status) system call
#include <errno.h>              // standard errors (+ perror)
#include <signal.h>             // signal handling routines
#include <sys/socket.h>         // internet socket ipc interface
#include <stdlib.h>             // standard libraries
#include <sys/wait.h>           // wait
#include <sys/utsname.h>        // system name
#include <netinet/in.h>         // more socket definitions
#include <netdb.h>              // ??
#include <unistd.h>             // standard unix (not covered elsewhere)
#include <pwd.h>                // password file reading routines
#include <dirent.h>             // directory reading routines
#include <math.h>               // math (float) routines
#include <getopt.h>             // getopt()
#include <ncurses.h>            // curses
#include <alloca.h>		// alloca
#ifdef USE_DATABASE
#include <msql.h>		// mSQL database headers
#endif

// bbs specific includes
#include "version.h"            // bbs version
#include "bbsipc.h"             // bbs ipc object
#include "bbsutil.h"            // generic bbs utilities
#include "bbsinfo.h"            // generic bbs information
#include "ports.h"              // port connection definitions
#include "errlog.h"             // error logger (object and daemon)
#include "filelock.h"           // automatic file locking
#ifndef _SERVER_
#ifdef USE_DATABASE
#include "msqldb.h"		// mSQL database connectivity
#include "msqllock.h"		// mSQL record locking facility
#include "mllist.h"             // thread list
#include "msqlmsg.h"		// mSQL -> message connectivity
#endif
#include "sysexec.h"            // sub-process execution
#include "bbsint.h"             // bbs input/output interface
#include "lang/bbsstring.h"     // strings not possible to put in language obj.
#include "color.h"              // colorizing features
#include "lang.h"               // multiple language features
#include "bbsmon.h"		// sysop monitoring
#ifdef USE_DATABASE
#include "message.h"		// messages
#endif
#include "user.h"               // user object definitions
#include "door.h"		// door operations
#include "chat.h"               // Multi-user chatting
#include "menu.h"               // menu system
#include "bbs.h"                // bbs top level definitions
#include "dllist.h"             // doubly linked list section
#include "files.h"              // files section
#else
#include "chat.h"               // Multi-user chatting
#endif
#include "moncon.h"             // monitor connection object

// definition below for gethostname.  I don't define BSD, so it doesn't
// get included in unistd.h.  I'd rather have it POSIX than BSD.

extern "C" int gethostname(char *__name, unsigned int __len);

// definition below for putenv.  I don't define __USE_SVID, so it doesn't
// get included from stdlib.h.  Bizarre, yet true.

extern "C" int putenv(const char *string);

// definition below for getdtablesize.  I don't define __USE_BSD, so it doesn't
// get included from unistd.h.

extern "C" int getdtablesize(void);

// definition below for mktemp.  I don't define __USE_MISC, so it doesn't
// get included from unistd.h.
// (I really don't know what 'misc' means -- every un*x I know of has the 
// same definition for mktemp)

extern "C" char*    mktemp __P((char *__template));
extern "C" char*    crypt __P((__const char *__key, __const char *__salt));



#endif                          // _BBSHDR_H_







