// Filename:   fileutil.h
// Contents:   the methods for the files utility object
// Author: Greg Shaw
// Created:    8/24/93

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _FILEUTIL_H_
#define _FILEUTIL_H_

#include "bbshdr.h"

// days to look back in new files search
#define DAYS   7                // look for new files in last 7 days
#define MAX_RECS   20           // display 20 most popular files

// Class:  fileutil
// Purpose:    add some additional functions to the files object
// Attributes: filelist - list of files (general use)
// Methods:    update - update files sections (for new and removed files)
//         most - create list of most popular files for entire BBS
//     newfiles - create list of new files lately
//     cycle_sections - cycle through all possible sections doing
//     a command.
// Author: Greg Shaw
// Created:    8/24/93

class fileutil:public files
{
	char sec[MAX_RECS][80];     // section name
	FInfo  recs[MAX_RECS];
	int  numrecs;
	public:
		fileutil();             // constructor
		update(char *section);  // update a section
		most(char *section);    // search for most popular files
		// delete missing files
		delete_missing(char *sname, char *secname);
		// search for new files in # days
		newfiles(char *section, FILE *outfile);
		// cycle sections to do one of the above functions
		cycle_sections(int type, char *fname);
};


#endif                          // _FILEUTIL_H_






