// Filename:	message.h
// Contents:	the message object definition
// Author:	Greg Shaw
// Created:	2/14/96

#ifndef _MESSAGE_H_
#define _MESSAGE_H_

#include "bbshdr.h"

// path to sendmail (for email forwarding)
#define MAIL_PATH	"/bin/mail"

// definition of a quote character
#define	QUOTE_CHAR	'>'

// maximum number of single quotes that could be in a message
// (quotes have to be back-ticked to be put into the database)
#define MAX_QUOTE	1000

// maximum size of a tagline
#define MAX_TAGLINE	321

// name of the private email section
#define PRIVATE_SECTION	"private"

// message base types
#define PRIVATE_MESSAGE	0	// private message base
#define PUBLIC_MESSAGE	1	// public message base (rocat, local)
#define FIDO_MESSAGE	2	// FIDO message base
#define USENET_MESSAGE	3	// USENET (news) message base

// modifiers (acl and flags)
#define ACLGREATER	1	// user access level must be greater
#define ACLEQUAL	2	// user access level must match
#define ACLLESSER	4	// user access level must be greater
#define FLAGSMATCH	1<<8	// user flags must match
#define FLAGSNOTMATCH	2<<8	// user flags must not match

// name of the rocat groups file (in each user's home directory)
#define GROUPFILENAME	".rgroups"	 




// Object:	message
// Purpose:	handle the user interface to messages for the BBS 
// Author:	Greg Shaw
// Created:	2/14/96

class Message:public language
{
	SectionHdr *cur_hdr;	// current header
	Group	*glist;		// selected message group list
	mllist	tlist;		// thread list	
	Msg	*cur_msg;	// current message (being displayed)
	msqlmsg	msql;	// database interface object
	int clear_grouplist(void);	// nuke the group list
	int add_to_grouplist(char *section, int group, int high_message, int selected);// add to the grouplist
	Group *check_grouplist(char *section);	// look for group in list
public:
	Message();	// constructor
	~Message();	// destructor

	int can_view(char *section, int del, char *from);	// can a user delete this message?
	int delete_message(char *section, Msg *msg, int has_thread); // delete a message
	int delete_mail(char *section);	// delete mail from mailbox

	void expire(void)	// expire messages (frontend to msql expire)
		{ msql.expire(); };
	int forward_to_sendmail(Msg *newmsg);	// send message to sendmail 

	int high_message(char *section, int message);	// set (or get) highest message in a section

	int list_threads(int groups, int lines, Group *glist);	// list message threads
	int list_messages(char *section);	// list messages in mailbox

	int mailavail(void);	// check for private mail to the user
	int move_message(char *section, Msg *msg);	// move message to another section

	int post(char *section, Msg *reply, int priv, char *to);	// post public message
	int post_msg(char *section, Msg *reply, int local_origin, int priv);// post - non interactive

	int read_groupfile(void);	// read user's $HOME/.rgroups file
	int read_private(char *section, int *highest);	// read private mail
	int read_public(char *section, int group, int lines);	// read messages

	int save_groupfile(void);	// save contents of group file
	int scan(time_t last_logon);	// scan for messages to the user
	int scan_section(time_t last_logon, char *section); // scan for new messages
	int section_information(char *section);	// show section information
	int select_sections(void);	// select sections for grouping
	int show_groups(void);	// show groups currently selected

	int view(char *section, int thread_number,int high_message);// view messages
};



#endif // _MESSAGE_H_
