// Filename:   moncon.h
// Contents:   the sysop monitor connection object
// Author: Greg Shaw
// Created:    8/26/93

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _MONCON_H_
#define _MONCON_H_

// (OLD - unused) monitor message definitions
// tab-o-tab-n-tab
#define MONITOR_ON     "\to\tn\t"
// tab-o-tab-f-tab-f
#define MONITOR_OFF        "\to\tf\tf"
// command signal
#define COMMAND_MSG        "\tc\tm"

// new monitor message definitions (1.0)
#define POLL_NO_MESSAGE		"2 0"
#define POLL_MESSAGE_AVAIL	"2 1"

// buffer size definitions
#define CBUF_MAX   100          // character buffer size
#define COMMANDS_MAX    20       // commands buffer size

// delay between monitor connections
#define MONITOR_CONNECT_DELAY	10	// 10 seconds
// maximum outgoing message to monitor
#define MONITOR_MESSAGE_MAX	125	// 124 chars

#ifndef _SERVER_                // server shouldn't know about this object
// Object: MonCon
// Purpose:    the sysop monitor connection object
// Attributes:
//     watch_on;        is sysop process 'watching'?
//     mon_connected;   is sysop monitor process connected?
//     last_attempt;    last connection attempt time (10 sec between)
// Methods:
//     connected   - is monitor connected?
//     watching    - is sysop watch on?
//     get_msg     - get a message from the monitor process
//     connect_monitor - try to connect to monitor
// Author: Greg Shaw
// Created:    7/12/93

class moncon: public filelock
{
	bbsipc ipc_obj;             // monitor interface object
	char   watch_on;            // is sysop process 'watching'?
	char   mon_connected;       // is sysop monitor process connected?
	char   locked_out;	    // lock out user keyboard?
	time_t last_attempt;        // last connection attempt time (10 sec between)
	char   outmsg[MONITOR_MESSAGE_MAX];	// maximum monitoring message
	char   lastmsg[MONITOR_MESSAGE_MAX];	// previous message
	char   cbuf[CBUF_MAX];      // character buffer storage for chars from monitor
	int    cstart,cend;         // start and end of char buffer
	// buffer for commands from monitor
	int    commands[COMMANDS_MAX];
	int    costart,coend;       // start and end of commands buffer
	public:
		moncon();               // constructor
		char get_char(void);    // get character from monitor
		int connect_mon(void);  // attempt to connect to monitor process
		int watching(void);     // is sysop watching?
		int connected(void);    // is monitor connected?
		int get_command(void);  // get a command from the monitor
		// send a message to the monitor
		int send_monitor(char *msg);	// send output to monitor
		int send_message(char *msg);    // send message to monitor master

};


#endif

#endif                          // _MONCON_H_






