// Filename:	msqllock.C
// Contents:	the methods for the msqllock object
// Author:	Greg Shaw
// Created:	3/6/96

#ifndef _MSQLLOCK_C_
#define _MSQLLOCK_C_

#include "bbshdr.h"

#ifdef USE_DATABASE

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


// Function:	constructor
// Purpose:	initialize the object variables
// Input:	none
// Output:	object is initialized
// Author:	Greg Shaw
// Created:	3/6/96

msqllock::msqllock()
{
	dbsock = get_sock(DATABASE_NAME);
}

// Function:	destructor
// Purpose:	clean up the object
// Input:	none
// Output:	data areas are freed, sockets closed
// Author:	Greg Shaw
// Created:	3/6/96

msqllock::~msqllock()
{
}

// Function:	clear_lock
// Purpose:	clear an existing lock
// Input:	table - the name of the table
//		id - the record id (-1 for table lock)
//		date - date of lock
//		username - holder of the lock
// Output:	1 if successful, 0 if failure
// Author:	Greg Shaw
// Created:	3/6/96

int msqllock::clear_lock(char *table, int id)
{
	char tmpstr[255];

	// build query
	sprintf(tmpstr,"delete from %s where table_name='%s' and record_id=%d",LOCK_TABLE_NAME,table,id);
	if (query(dbsock,tmpstr) == -1)
	{
		sprintf(tmpstr,"Unable to clear lock for %s, record %d: %s",table,id,dberror());
		ap_log(tmpstr);
		return(0);
	}
	return(1);
}

// Function:	get_lock_owner
// Purpose:	return the owner of an existing lock
// Input:	table - the name of the table
//		id - the record id (-1 for table lock)
// Output:	the username or NULL if no lock exists
// Author:	Greg Shaw
// Created:	3/13/96

char    *msqllock::get_lock_owner(char *table, int id) // get owner of existing lock
{
	char tmpstr[255];
	m_result *dbresult;	// result of query pointer
	m_row	cur_row;	// current row
	int rows;
	static char username[11];	// owner

	if (!lock_set(table,id))	// check for existing lock
		return(NULL);
	// check for trivial case -- no locks set
	sprintf(tmpstr,"select username from %s where table_name='%s' and record_id=%d",LOCK_TABLE_NAME,table,id);
	if (query(dbsock,tmpstr) == -1)
	{
		sprintf(tmpstr,"Unable to query lock table: %s",dberror());
		ap_log(tmpstr);
		return(0);
	}
	dbresult = storeresult();
	if (rows = numrows(dbresult), rows != 0)	// no locks for this table
	{	
		cur_row = fetchrow(dbresult);
		sscanf(cur_row[1],"%s",username);
	}
	else
	{
		ap_log("get_lock_owner: Locks set for table, but no locks found.");
		freeresult(dbresult);
		return(NULL);
	}
	freeresult(dbresult);
	return(username);
}

// Function:	lock_set
// Purpose:	return a value based on whether a lock is set
// Input:	table - the name of the table
//		id - the record id (-1 for table lock)
//		date - date of lock
//		username - holder of the lock
// Output:	0 for no lock set
//		1 for record lock
//		2 for table lock
// Author:	Greg Shaw
// Created:	3/13/96

int msqllock::lock_set(char *table, int id)
{
	char tmpstr[255];
	int pos;	// position
	int rid;	// read in ID
	m_result *dbresult;	// result of query pointer
	m_row	cur_row;	// current row
	int rows;

	// check for trivial case -- no locks set
	sprintf(tmpstr,"select * from %s where table_name='%s'",LOCK_TABLE_NAME,table);
	if (query(dbsock,tmpstr) == -1)
	{
		sprintf(tmpstr,"Unable to query lock table: %s",dberror());
		ap_log(tmpstr);
		return(0);
	}
	dbresult = storeresult();
	if (rows = numrows(dbresult), rows != 0)	// no locks for this table
	{	// yup.  got to get tricky
		for ( pos = 0; pos < rows; pos++)
		{
			cur_row = fetchrow(dbresult);
			sscanf(cur_row[1],"%d",&rid);
			if (rid == -1)
			{
				freeresult(dbresult);
				return(2);
			}
			else if (rid == id)
			{	
				freeresult(dbresult);
				return(1);
			}
		}
	}
	freeresult(dbresult);
	return(0);
}

// Function:	set_lock
// Purpose:	set a table or record lock
// Input:	table - the name of the table
//		id - the record id (-1 for table lock)
//		date - date of lock
//		username - holder of the lock
// Output:	1 if successful, 0 if failure
// Author:	Greg Shaw
// Created:	3/6/96

int msqllock::set_lock(char *table, int id, int date, char *username)
{
	char tmpstr[255];

	// look for an existing lock that would disallow our capability
	if (lock_set(table,id))
	{
		// try once more time 
		sleep(LOCK_WAIT);
		if (lock_set(table,id))
			return(0);
	}
	// set lock
	sprintf(tmpstr,"insert into %s values ('%s',%d,%d,'%s')",LOCK_TABLE_NAME,table,id,date,username);
	if (query(dbsock,tmpstr) == -1)
	{
		sprintf(tmpstr,"Unable to insert into lock table: %s",dberror());
		ap_log(tmpstr);
		sprintf(tmpstr,"Lock owned by: %s",get_lock_owner(table,id));
		ap_log(tmpstr);
		return(0);
	}
	return(1);
}

#endif // USE_DATABASE

#endif // _MSQLLOCK_C_
