// Filename:   userupdate.c
// Contents:   a program to update the userlog for the new format
// Author: Greg Shaw
// Created:    12/6/94

#include "bbshdr.h"

int iseol(int c)
{
	if (c == '\r' || c == '\n')
		return(1);
	return(0);
}

int update(int version)
{
	FILE   *ufile = NULL;       // old userlog
	FILE   *nfile= NULL;        // new userlog
	char   *bbsdir;
	char   finame[255];         // filename
	char   line[255];           // one line in file (255 max)
	char   bline[255];          // one line in file (255 max)
	char   cline[255];          // one line in file (255 max)
	char   linenum;             // used to look for appropriate line
	char   c;                   // input char
	unsigned char  of;          // offset into line
	int    has_color;           // has color?
	char    editor[15];         // favorite editor
	int    lines;               // lines on screen
	int    cols;                // columns on screen
	int        credited;        // credited time
	int        priv_msgs;       // private messages
	int     pub_msgs;           // private messages
	int    acl, timelimit, timeused, kused;
	long   flags;
	time_t anniversary;
	time_t expiration;



	if (bbsdir = getenv("BBSDIR"), bbsdir == NULL)
	{
		fprintf(stderr,"BBSDIR environment variable not set\n");
		return(-1);
	}
	sprintf(finame,"%s/admin/userlog",bbsdir);

	switch(version)
	{
	case 1:
		linenum = 0;            // look for first line first
		if (ufile = fopen(finame,"r"), ufile != NULL)
		{
			strcat(finame,".new");
			if (nfile = fopen(finame,"w"), nfile == NULL)
			{
				fprintf(stderr,"Unable to open new userlog.\n");
				return(-1);
			}
			while (!feof(ufile))
			{
				of = 0;
				while (c = fgetc(ufile), !iseol(c) && !feof(ufile))
					// skip trailing left bracket
					if (c != ']')
						line[of++] = c;
				line[of] = 0;   // add null
				switch(linenum)
				{
					case 0:     // first line
						// got line 1?
						if (line[0] == '[' && line[1] == 'A')
						{
							sscanf(&line[2],"%s %*s %*s %*s %*s %*s",finame);
							fprintf(nfile,"%s]\n",line);
							// get next line
							linenum++;
						}
						break;
					case 1:     // second line
						// got line 2?
						if (line[0] == '[' && line[1] == 'B')
						{
							fprintf(nfile,"%s]\n",line);
							// get next line
							linenum++;
						}
						break;
					case 2:     // third line
						// got line 3?
						if (line[0] == '[' && line[1] == 'C')
						{
							if (sscanf(&line[2],"%d %d %d %d %s %d %d ",&priv_msgs,&pub_msgs,&credited, &has_color, editor, &lines, &cols)
								!= 7)
							{
								fprintf(stderr,"bad read from user  file.  (%s)(line C) Corrupted?",finame);
								return(-1);
							}
							fprintf(nfile,"[C %d %d %d %d %s %d %d english ]\n",priv_msgs,pub_msgs,credited, has_color, editor, lines, cols);
							// get next line
							linenum++;
						}
						break;
					case 3:     // fourth line
						// got line 4?
						printf("line d\n");
						if (line[0] == '[' && line[1] == 'D')
						{
							fprintf(nfile,"%s]\n",line);
							// get next line
							linenum=0;
						}
						break;
					default:
						printf("Unknown switch value: %d",linenum);
						linenum = 0;
				}
			}
		}
		else
		{
			fprintf(stderr,"Unable to open userlog.\n");
		}
		break;
	case 2:	// 0.86 to 0.89
		linenum = 0;            // look for first line first
		if (ufile = fopen(finame,"r"), ufile != NULL)
		{
			strcat(finame,".new");
			if (nfile = fopen(finame,"w"), nfile == NULL)
			{
				fprintf(stderr,"Unable to open new userlog.\n");
				return(-1);
			}
			while (!feof(ufile))
			{
				of = 0;
				while (c = fgetc(ufile), !iseol(c) && !feof(ufile))
					// skip trailing left bracket
					if (c != ']')
						line[of++] = c;
				line[of] = 0;   // add null
				switch(linenum)
				{
					case 0:     // first line
						// got line 1?
						if (line[0] == '[' && line[1] == 'A')
						{
							sscanf(&line[2],"%s %*s %*s %*s %*s %*s",finame);
							fprintf(nfile,"%s]\n",line);
							// get next line
							linenum++;
						}
						break;
					case 1:     // second line
						// got line 2?
						if (line[0] == '[' && line[1] == 'B')
						{
							fprintf(nfile,"%s]\n",line);
							// get next line
							linenum++;
						}
						break;
					case 2:     // third line
						// got line 3?
						if (line[0] == '[' && line[1] == 'C')
						{
							fprintf(nfile,"%s]\n",line);
							// get next line
							linenum++;
						}
						break;
					case 3:     // fourth line
						// got line 4?
						if (line[0] == '[' && line[1] == 'D')
						{
							if (sscanf(&line[2],"%lx %d %d %d %ld %d",&flags, &acl, &timelimit, &timeused, &anniversary, &kused ) != 6)
							{
								fprintf(stderr,"bad read from user  file.  (%s)(line D) Corrupted?",finame);
								return(-1);
							}
							fprintf(nfile,"[D %lx %d %d %d %ld %d 0 3 1]\n",flags, acl, timelimit, timeused, anniversary, kused );
							// get next line
							linenum=0;
						}
						break;
				}
			}
		}
		else
		{
			fprintf(stderr,"Unable to open userlog.\n");
		}
		break;
	case 3:      // 0.89-0.96 to 1.0
		linenum = 0;            // look for first line first
		if (ufile = fopen(finame,"r"), ufile != NULL)
		{
			strcat(finame,".new");
			if (nfile = fopen(finame,"w"), nfile == NULL)
			{
				fprintf(stderr,"Unable to open new userlog.\n");
				return(-1);
			}
			while (!feof(ufile))
			{
				of = 0;
				while (c = fgetc(ufile), !iseol(c) && !feof(ufile))
					// skip trailing left bracket
					if (c != ']')
						line[of++] = c;
				line[of] = 0;   // add null
				switch(linenum)
				{
					case 0:     // first line
						// got line 1?
						if (line[0] == '[' && line[1] == 'A')
						{
							sscanf(&line[2],"%s %*s %*s %*s %*s %*s",finame);
							fprintf(nfile,"%s]\n",line);
							// get next line
							linenum++;
						}
						break;
					case 1:     // second line
						// got line 2?
						if (line[0] == '[' && line[1] == 'B')
						{
							// save for later
							strcpy(bline, line);
							// get next line
							linenum++;
						}
						break;
					case 2:     // third line
						// got line 3?
						if (line[0] == '[' && line[1] == 'C')
						{
							// save for later
							strcpy(cline, line);
							// get next line
							linenum++;
						}
						break;
					case 3:     // fourth line
						// got line 4?
						if (line[0] == '[' && line[1] == 'D')
						{
							if
								(sscanf(&line[2],"%lx %d %d %d %ld %d %ld",&flags, &acl, &timelimit, &timeused, &anniversary, &kused,&expiration ) != 7)
							{
								fprintf(stderr,"bad read from user  file.  (%s)(line D) Corrupted?",finame);
								return(-1);
							}
							// get next line
							linenum=0;
							// modified B
							fprintf(nfile,"%s %d %d %ld]\n",bline,kused,timeused,anniversary);
							// unmodified C
							fprintf(nfile,"%s]\n",cline);
							// unmodified D
							fprintf(nfile,"%s]\n",line);
						}
						break;
				}
			}
		}
		else
		{
			fprintf(stderr,"Unable to open userlog.\n");
		}
		break;
	}
	fclose(ufile);              // close file
	fclose(nfile);              // close file
	printf("\nThe userlog has been updated.\n");
	printf("It is called 'userlog.new', and must be renamed to userlog\n");
	printf("prior to using the new version of the BBS.\n");
	printf("Use the following commands (as root):\n");
	printf("mv $BBSDIR/admin/userlog $BBSDIR/admin/userlog.pre-update\n");
	printf("mv $BBSDIR/admin/userlog.new $BBSDIR/admin/userlog\n");
	printf("chown bbs.bbs $BBSDIR/admin/userlog");
	printf("chmod 775 $BBSDIR/admin/userlog\n");
	return(0);
}


void usage(void)
{
	printf("Usage: userupdate -v current_revision\n");
	printf("Example:\n");
	printf("\tTo update userlog from 0.85 to 0.86\n");
	printf("\tuserupdate -v 0.85\n");
	printf("\nSupported versions:\n");
	printf("\t0.85 to 0.86\n");
	printf("\t0.86 to 0.89\n");
	printf("\t(0.89)-0.96 to 1.0\n");
}


main(int argc,char *argv[])
{
	char   c;                   // character sent back by getopt
	int retval = 0;



	c = getopt(argc,argv,"v:");
	if (c == -1)
		usage();
	else
	{
		switch (c)
		{
			case 'v':           // version
				// 0.85 to 0.86
				if (!strcmp(optarg,"0.85"))
					retval = update(1);
				// 0.86 to 0.89
				else if (!strcmp(optarg,"0.86"))
					retval = update(2);
				// 0.89-0.96 to 1.0
				else if (!strcmp(optarg,"0.89"))
					retval = update(3);
				break;
			default:
				usage();
		}
	}
	return(retval);
}


