{ Data Unit }

Unit Dats;

Interface

Uses Dos, Crt;

procedure OpenDataFiles;
procedure CloseDataFiles;

{ Modem data }
type
  Cfg = record
     ComPort     : Integer;
     BaudRate    : Byte;
     InitString1 : String[40];
     InitString2 : String[40];
     InitString3 : String[40];
     LockBaud    : Boolean;
     L1T,
     L2T,
     L3T,
     L4T,
     L5T,
     L6T,
     L7T,
     L8T,
     L9T        : Word;
     L1C,
     L2C,
     L3C,
     L4C,
     L5C,
     L6C,
     L7C,
     L8C,
     L9C       : Word;
     SysDir,    { System Directories }
     ScriptDir,
     MenuDir,
     BBSMailDir,
     MsgDir,
     TempDir    : String[30];
     SysopFirst : String[15];
     SysopSec   : String[15];
     BBSName    : String[30];
     BBSTele    : String[20];
     Calls      : integer;
     NuLevel    : integer;
     IdleTime,
     MaxUsers,
     MaxMsg     : Word;
     LogFile,
     ErrFile    : String[12];
     Bulletin   : word;
end;


{ Sauron BBS File Areas }
type
  FileAreas = record
    DirNo   : Integer;     { Number Of File Directorys }
    Dir     : String[30];  { Directory path       }
    DirDes  : String[30];  { Directory Area Name  }
    FileLst : String[30];  { Files List & Path    }
    Uploads : Integer;     { Uploads Allowed      }
    DnLoads : Integer;     { DownLoads Allowed    }
    Access  : integer;     { Minimum Level Access }
end;

{ Tag File }
type
  FileTags = record
    FileName  : String[12];
    Dir       : String[80];
    DirLst    : String[80];
    Des       : String[40];
    Tagged    : Byte;
    Size      : LongInt;
    DLTimes   : Integer;
    ULUser    : String[30];
    Date      : String[8];
    RecNumber : integer;
end;

{ Sauron BBS File Information }
type
  FileInfo = Record
    FileName : String[12];
    Size     : LongInt;      { FileSize }
    FDate    : String[8];    { FileDate }
    Descript : String[40];   { File Description }
    DLTimes  : Integer;      { Number Of Times File Has Been Downloaded }
    ULUser   : String[30];   { User Who Uploaded File }
end;

{ Sauron BBS Data Information  SIMPBBS.DAT }
type
  bbs = record
    NextUser   : integer;
    Line       : string;
    From       : string;
    Date       : String;
    Time       : Word;
end;

{ Sauron Message Index File }
type
  Index = Record
     MsgNumber : Integer;
end;

{ Sauron Message Areas Data Files }
type
  MsgArea = Record
    MsgNumber : String;
    AreaName  : String[30];
end;

{ Sauron Message Number }
type
  MS = record
    MsgNumber : integer;
end;

{ User Information  USERDAT.DAT}
type
  User = record
    UserAcc    : String[3];
    UserAnsi   : byte;
    UserColour : byte;
    Userlevel  : byte;
    UserName   : string[30];
    UserPass   : string[10];
    UserTown   : string[30];
    UserInfo1  : string[30];
    UserInfo2  : string[30];
    UserInfo3  : string[30];
    Userinfo4  : string[30];
    Userinfo5  : string[30];
    Userinfo6  : string[30];
    Userinfo7  : string[30];
    Userinfo8  : string[30];
    UserLines  : byte;
    Bulletin   : word;         { Current Bulletin Number Read }
    MailCount  : integer;      { User Mail }
    LastMsgNum : integer;
    Calls      : integer;
    CallsToday : integer;
    LCallDate  : String[10];
    LastCall   : string[30];
    CallNumber : integer;
    TimeOnLine : word;
    FileArea   : integer;
    DownLoads  : integer;
    Uploads    : integer;
    BytesDL    : LongInt;
    BytesUL    : LongInt;
end;

const
  { Sauron Colour Codes }
  { Foreground }
    FBlack   = 224;
    FRed     = 225;
    FGreen   = 226;
    FYellow  = 227;
    FBlue    = 228;
    FMagenta = 229;
    FCyan    = 230;
    FWhite   = 231;
  { Background }
    BBlack   = 232;
    BRed     = 233;
    BGreen   = 234;
    BYellow  = 235;
    BBlue    = 236;
    BMagenta = 237;
    BCyan    = 238;
    BWhite   = 239;

var
  bbsinfo    : bbs;
  Userinfo   : user;
  Areas      : FileAreas;
  BBSCfg     : Cfg;
  FInfo      : FileInfo;
  Idx        : Index;
  Msg        : MsgArea;
  MsIndex    : Ms;
  Tags       : FileTags;
  UserSize   : LongInt;
  AreaSize   : LongInt;
  TagSize    : LongInt;
  InFile     : Text;
  DataFile   : File of user;       { UserFile }
  BBSini     : File of bbs;        { BBS Data File }
  FileArea   : File of FileAreas;  { File Directorys }
  SBBSCfg    : File of Cfg;
  Files      : File of FileInfo;
  TagInfo    : File of FileTags;
  IdxFile    : File of Index;
  MsgFile    : File of MsgArea;
  MsgNum     : File of MS;
  Temp       : String;
  Loop       : Integer;

  FileNumber : byte;     { Record Number Of File DownLoaded }


  Tagged,
  Local,
  OnLine     : Boolean;

  Regs       : Registers;
  Response   : string;

  LineCount,                { Keeps Count On Lines Scrolled In PrintFile }
  BBSlines,                 { Keeps Count of BBS Screen Lines }
  CurrentLine : Integer;

  ScriptFile : String;          { Holds ScriptFile Name }
  FinScript  : Boolean;

  Error      : Integer;{ Error Holds The Error Number Returned In %error% }
  Errored    : Boolean;{ This Sets To True On Every Logon, Used In LogError }

  DlFile,                    { Dload Filename      }
  ULFile     : String;       { File to be uploaded }

  YN         : Byte;

  Echo,
  PassEcho,
  NoUpper    : Boolean;

  Finish     : Boolean;

  LastCall,
  CallAway   : Integer;
  LastCalls,
  LastCaller : String;

  SessionTime,
  SessionLength,
  StartTime,
  Times          : Word;

  LineBaud       : Word;
  ActualBaud     : String;
  ConnectString  : String;

  ColourSelect   : Byte;
  ColourCode     : String;

  {AVATAR}
  AvatarChar,
  AvatarCode,
  AvatarCol      : byte;

  {ANSI}
  AnsiCode       : Byte;
  AnsiDetect     : Boolean;  { True Ansi Detected }

  SaveCurX,
  SaveCurY       : integer;
  CurSaved       : Boolean;
  CaseKey,
  CaseKey2,
  Back,
  Fore,
  Flash,
  High          : integer;
  Delimiter     : Boolean;
  AnsiCommand,
  Fst,
  Snd,
  Command       : String;
  temps,
  I,
  Code,
  Pntr,
  Fval,
  Sval,
  Cval          : integer;

Implementation

{ Open All Data Files needed To Run SimpleBBS }

procedure OpenDataFiles;
begin
  FileNumber  := 0;
  LineCount   := 0;
  BBSLines    := 0;
  CurrentLine := 24;
  LineBaud    := 0;
  LastCall    := 0;
  CallAway    := 0;
  Echo        := True;
  Tagged      := False;
  PassEcho    := False;
  NoUpper     := False;

  ColourSelect := 0;
  AvatarChar  := 0;
  AvatarCode  := 0;
  AvatarCol   := 0;

  AnsiCode    := 0;
  AnsiDetect  := False;

  Back := 0;
  Fore := White;
  Flash := 0;
  High := 0;

  UserInfo.UserAnsi := 1; { Default User To ANSI }

  ConnectString := 'LOCAL';
  Assign(BBSini,'SIMPBBS.DAT');
  {$I-} Reset(BBSini); {$I+}
  if IOResult = 0 then
    begin
      Seek(BBSINI, 0);
      Read(BBSINI, BBSInfo);
    end
  else
    begin
      writeln;
      writeln;
      writeln('   ERROR :- Unable To Open SIMPBBS.DAT   ');
      writeln(' Please Run HelpBBS for more information ');
      Halt(1);
    end;
  Assign(DataFile,'USERLOG.DAT');
  {$I-} Reset(DataFile); {$I+}
  if IOResult = 0 then
    begin
      UserSize := FileSize(DataFile);
      If UserSize <> 0 then
        begin
          Seek(DataFile, 0);
          Read(DataFile, UserInfo);
        end;
    end
  else
    begin
      writeln;
      writeln;
      writeln('   ERROR :- Unable To Open USERLOG.DAT   ');
      writeln(' Please Run HelpBBS for more information ');
      Halt(1);
    end;
  Assign(FileArea,'FAREAS.DAT');
  {$I-} Rewrite(FileArea); {$I+}
  if IOResult = 0 then
    begin
      AreaSize := FileSize(FileArea);
      if AreaSize <> 0 then
       begin
         Seek(FileArea, 0);
         Read(FileArea, Areas);
       end;
    end
  else
    begin
      writeln;
      writeln;
      writeln('   ERROR :- Unable To Open FAREAS.DAT   ');
      writeln(' Please Run HelpBBS for more information ');
      Halt(1);
    end;
  Assign(SBBSCfg,'SBBS.CFG');
  {$I-} Reset(sbbscfg); {$I+}
  if IOResult = 0 then
    begin
      If FileSize(SBBSCfg) <> 0 then
        begin
          Seek(sbbscfg, 0);
          Read(sbbscfg, bbscfg);
        end;
    end
  else
    begin
      writeln;
      writeln;
      writeln('    ERROR :- Unable To Open SBBS.CFG     ');
      writeln(' Please Run HelpBBS for more information ');
      Halt(1);
    end;
  Assign(MsgFile,'MESSAGE.DAT');
  {$I-} Reset(MsgFile); {$I+}
  if IOResult = 0 then
    begin
      If FileSize(MsgFile) <> 0 then
        begin
          Seek(MsgFile, 0);
          Read(MsgFile, Msg);
        end;
    end
  else
    begin
      writeln;
      writeln;
      writeln('   ERROR :- Unable To Open MESSAGE.DAT   ');
      writeln(' Please Run HelpBBS for more information ');
      Halt(1);
    end;
  Assign(MsgNum,'MSINDEX.DAT');
  {$I-} Reset(MsgNum); {$I+}
  if IOResult = 0 then
    begin
      If FileSize(MsgNum) <> 0 then
        begin
          Seek(MsgNum, 0);
          Read(MsgNum, MsIndex);
        end;
    end
  else
    begin
      writeln;
      writeln;
      writeln('   ERROR :- Unable To Open MSINDEX.DAT   ');
      writeln(' Please Run HelpBBS for more information ');
      Halt(1);
    end;
end;


procedure CloseDataFiles;
Var
  Rec, Code : Integer;
begin
  Close(DataFile);
  Close(BBSINI);
  Close(FileArea);
  Close(SBBSCfg);
end;

end.