
#define __MBD

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>

#include "mbox.h"
#include "s_global.h"
#include "alias.update/defs.h"

#undef DEBUG 
#undef DEBUG2

#define ADD_RECEIVE   /* Rec.-Feld bei fehlerhaften Mails/News */

char tmp[STRING],h[STRING],
	HOME[STRING],
	UUCPID2[STRING],
	ORGANIZATION[STRING],
	LOCATION[STRING],
	TAG_MODE;
	
	
 char buf[2*STRING];	

struct MAIL_TYP {
 char to[STRING],to_err[STRING];
 char from[STRING],from_err[STRING];
 char subject[STRING],subject_err[STRING];
 int rmail;	/* USR-Perm.*/
 int news;	/* USR-PERM */
 int imail;     /* USR-Perm for intern. Mail*/
 int print; /* OPT-Flag */
 unsigned char mail [STRING];
} MAIL;

UNSIGNED char PIPE_RECEIVER[STRING];
char CC[STRING];
char ORG_NAME[STRING];

FILE *fp;
int HEADER_ERR=0;
static int ret_rev=0;


struct list_t
 {
   char line[2*STRING];
   void *n;
 };
 
struct list_t *BAD_TOP=NULL;
struct list_t *BAD_MSG_TOP=NULL;

int BASE64_CONT=0; PGP_CONT=0, UUE_CONT=0,BIN_CONT=0,bin_typ=0;

 

int main(argc, argv)
int argc;
UNSIGNED char *argv[];
{

 setgid(GUEST_GID);
 setuid(GUEST_GID); 
         
     
 SetMain();
 SetClean();
   
 CommandOptions (argc, argv);
 if (MAIL.print) PrintAll();
 L_Init();
 chdir(HOME);
 Pipe();
 unlink(MAIL.mail);
}



unsigned char *leer2punkt(s)
unsigned char s[];
{
  static unsigned char b[STRING];
    int j ;
    
    for (j=0;j<=(strlen(s));j++)
    {
     b[j]=s[j];
      if (b[j]==32) b[j]=46;
      }
       b[j]=0;
       
         return (UNSIGNED char *) (b);
}
         





/* User darf UUE-Mails versenden und auch 'bad mails' (mails mit schimpfworten) ? */
int TestUUE_Member(char *user)
{
int ret=0;
FILE *fd=NULL;
static char s[2*STRING],s2[2*STRING];


if (strpos("GAST",user)==1) return (0);
if (strpos("Administration",user)==1) return (1);

sprintf(s,"%s/etc/list.ip.access",((char *) HOME));
fd = fopen(((char *) s),"r");
if (fd == NULL) {
      nerror("boerde_list.c", 147, "TestIP_MEMBER()", "Can't read", s);
      exit(-12);
}
/* Einsprung finden */
sprintf(s2,"%s ",leer2punkt(user));  /* Kompatibilitaet zur alten ix-mbox */
while ((strpos("----------------------------------------------",s)!=1)&&(fgets(s,STRING,fd)!=NULL));
while (fgets(s,2*STRING,fd)!=NULL) 
{
 strcpy(buf,(char *) strings(s));
/* printf("\n(%s)??(%-40.40s)",s2,buf);*/
 if (nstrpos(s2, buf)>3) /* User gefunden */
 {
#ifdef DEBUG
   printf("\nUser gefunden: (%s)\ns:(%s)",s2,buf);
#endif     
    if ((buf[C3]=='x')||(buf[C3]=='x'))      
     ret=1;
   fclose(fd);
   return(ret);
 }

}

                      
fclose(fd);
return(0);
}




/* wandelt alle Zeilchen in Grossbuchstaben */
char *touppers(s)
char s[];
{
  static char b[STRING];
    int j = 0 ;
    
    for (j=0;j<=(strlen(s));j++)
    {
     b[j]=s[j];
      if ((b[j]>64)&&(b[j]<91)) b[j]=b[j]+32;
      }
       b[j]=0;
       
       
return ((char *) b);
}
         




int CommandOptions (argc, argv)
int argc;
char *argv[];
{

	int i;
	unsigned char s[STRING];
	extern int USER_language;
	
	USER_language=1; /* voreinstellung :-) */
	if (argc<2){
		Help();
		exit(0);	
	}
	CC[0]=0;TAG_MODE=32;

	for (i=1; i<argc; i++)
	{
		switch (argv[i][0])
		{
		
		case '+':
			switch (argv[i][1])
			{
						
			case 'T':	strcpy(MAIL.to,&argv[i][2]);
					break;
					

			case 'F':	strcpy(MAIL.from,&argv[i][2]);
					strcpy((char *)ORG_NAME,(char *) GetOrgName());
					break;
			
			case 'S':	strcpy(MAIL.subject,&argv[i][2]);
					break;
					
			
			case 'C':	strcpy(CC,&argv[i][2]);
					break;					
					
			case 'L':	strcpy(h,&argv[i][2]);
					USER_language=atoi(h);
					break;
			
			case 'm':	MAIL.rmail = 1;
					break;
		        case 'p':
		        		ret_rev=1;
		        		break;					

			case 'i':	MAIL.imail = 1;
					break;
										
			case 'x':	TAG_MODE = (char ) argv[i][2];
					break;
																				
			case 'n':	MAIL.news = 1;
					break;	
									
			default:	BadFlag (argv[i]);
					break;
					
			}
			break;


		case '-':
			switch (argv[i][1])
			{
						
			case 'p':	MAIL.print = 1;
					break;
			
			case 'h':	Help();
					exit(0);
					break;
			
					
			default:	BadFlag (argv[i]);
					break;
					
			}
			break;



		default:
			BadFlag (argv[i]);
			break;
		}
	}

return(1);
}


void Help()
{
	printf("\n\n ++++ bbs-mail (bbs-tools %s) 	(c) <runge@nina.boerde.de> 94/95\n",VERSION);
	printf("\noption for mail:\n");
	printf("\n-p 		print config-state");
	printf("\n+n		use cnews for transmit");		
	printf("\n+m		use external mail");
	printf("\n+T		to:");
	printf("\n+F		form:");
	printf("\n+p		Return-Receipt-To - Line");
	printf("\n+x		enh. info for msg-id-line");
	printf("\n+L{id}	user-language-id (1..3)");
	printf("\n+S		subject:\n");
}

BadFlag (c)
char *c;
{
	fprintf (stderr, "%s: bad flag: %s\n", "bbs_mail", c);
	exit (0);
}


void SetClean()
{
 MAIL.rmail=MAIL.news=MAIL.print=MAIL.imail=0;
 strcpy(MAIL.to,"Sysop");
 strcpy(MAIL.from,"Sysop");
 strcpy(MAIL.subject,"no subject");
 strcpy(MAIL.mail,"$$$$$$$$$$$$$$$$");
}



void PrintAll()
{ 
  printf("\n\nremote-mail:			%d",MAIL.rmail);
  printf("\nremote-news:			%d",MAIL.news);
  printf("\nto:				%s",MAIL.to);
  printf("\nsubject:			%s",MAIL.subject);
  printf("\nfrom:				%s\n",MAIL.from);
  exit(0);
}


/* strings-funct */
unsigned char *strings(s)
unsigned char s[];
{
static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if ((b[j]>127)||(b[j]<32)) b[j]=32;
}
 b[j]=0;
  	     
  	     
  return (UNSIGNED char *) (b);
}









/* gibt die MailAlias-Adresse eines Users zurueck */
char *GetUsrMailAlias(mode,user)
char mode;
unsigned char *user;
{
static char s[STRING];
unsigned char name[STRING];
FILE *fd;
int fp,id,i;
struct userdaten LOOSER;


#ifdef DEBUG
  printf("\nGetUsrMailAlias(mode=%c,%s)\n",user);
#endif

  strcpy(name,touppers(user));
  chdir(HOME);
  fp = open(UDBASE, O_RDONLY);
  if (fp == -1) 
  {
	printf("\nbbs_mail: 242 GetUsrMailAlias(), Can't read %s",UDBASE);
  }
  lseek(fp, 0L, SEEK_SET);
  id=0;
  while 
  (
   (read(fp,(char *)  &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) 
    && (id == 0) 
  ) 
  {
#ifdef DEBUG
  if (LOOSER.id=255)
   printf("\nSTOOOOOOOP !!!");
#endif  
          if ((strpos(name, touppers(LOOSER.name)) == 1) ||
	      (strpos(name, touppers(LOOSER.nick)) == 1) ||
	      (strpos(name, touppers(LOOSER.sh_name)) == 1))
          {
		id = LOOSER.id;
		strcpy(name, LOOSER.name);
		
          }
  }
  close(fp);
#ifdef DEBUG
   printf("\nnach read: name=(%s)\n",name);
#endif  
 if (!id) return(NULL);

sprintf(s,"%s/usr/%c/%d/.MailAlias",HOME,name[0],id);
fd=fopen(s,"r");
if (!fd) return(NULL);
fgets(s,STRING,fd);
strcpy(s,(char *) cut_leer(strings(s)));
s[strlen(s)-1]=0;

for (i=0; i<STRING; i++) 
{
 if (s[i]==SPACE) s[i]=0;
}

fclose(fd);
strcpy(MAIL.to,s);
MAIL.rmail=1;

#ifdef DEBUG
  printf("GetUsrMailAlias-Return((char *) (%s))\n",s);
#endif

     if (mode!='?')
     {
                printf("\n >%s:\n  \"%s\" -> \"%s\"\n",GetText("MAL51_MSG"),name,s);
     }   
return((char *) s); 
}





/* #BR - Mail to a BBS user [arg]. */

int brief(arg)
UNSIGNED char arg[];
{
  FILE *fp;
  FILE *ff;
  int fd;
  int i, a, b;
  int ok;
  struct userdaten LOOSER;

  struct tm *timeptr;
  time_t timer;
  int ALIAS=0;

  int receiver;
  static int mail_id,kk;
  int lines   = 0;
  int local   = 0;
  int arrived = 1;

  int yet_new = 0;


  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char subject[STRING];
  UNSIGNED char autor[STRING];
  UNSIGNED char rec_char[STRING];
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char user[STRING];
  UNSIGNED char destination[STRING];
  UNSIGNED char receipt[STRING];
  unsigned char _ALIAS[STRING];
  char *ttt;
  time_t k;

  i = 0;
  ok = 0;

#ifdef DEBUG
printf("\nbrief(%s)\n",arg);
#endif

  strcpy(user, (UNSIGNED char *) stripped(arg));
  strcpy(user,(char *) punkt2leer(stripped(user)));
  strcpy(subject, XMD01_MSG);

  JUNK:	receiver = 0;




  ALIAS=0;
        strcpy(s,arg); kk=0;
        strcpy(_ALIAS,s);
        ttt=(char *) GetUsrMailAlias(kk,s);
        if (ttt!=NULL) {
         strcpy(s,ttt);
         sprintf(arg,"%s%c",s,kk);        
         ALIAS++;
         receiver=1;
         mailing();
         return(1);
        }
  i=0;
  strcpy(arg,(char *) strings(arg));









  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	printf("\nCan't read %s\n", UDBASE);
	exit(-1);
  }
  lseek(fd, 0L, SEEK_SET);
  strcpy(rec_char,"");
  while ((read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) && (receiver == 0)   ) 
  {
	if ((strcomp(user, LOOSER.name) == 0) ||
	    (strcomp(LOOSER.name, user) == 0) ||
	    (strcomp(user, LOOSER.nick) == 0) ||
	    (strcomp(user, LOOSER.sh_name) == 0)) 
	{
		receiver = LOOSER.id;
		strcpy(rec_char, LOOSER.name);
	}
  }
  close(fd);
                
#ifdef DEBUG 
  printf("\nbrief(): USER_TO:%s (id:%d)\n",rec_char,receiver);
#endif

  printf("mail to bbs-user: %s (id=%d)  ",rec_char,receiver);
  if (receiver==0) 
  {
   sprintf(s,"BBS-User <%s> unknown!",arg);
   printf(" %s\n",s);
   MailErrTo(MAIL.mail,MAIL.from,s );
   return(1);
  }
  printf("\n");

#ifdef DEBUG2
  printf("\nbrief(): USER_TO:(%s) (id:%d)\nfrom: %s\n",rec_char,receiver,MAIL.from);
#endif
  


if (!strlen(rec_char))
{
 if ((MAIL.rmail)&&(!HEADER_ERR)) return(0);  /* User hat Berechtigung fuer externe Mails, ich versuch's mal... */
 if (MAIL.news) { /* no inews-permission !!!! */
  strcpy(MAIL.to_err,MAIL.to);
  strcpy(MAIL.from_err,MAIL.from);
  strcpy(MAIL.subject_err,MAIL.subject);
 } else
 {
  strcpy(MAIL.to_err,MAIL.to);
  strcpy(MAIL.from_err,MAIL.from);
  strcpy(MAIL.subject_err,MAIL.subject);
  sprintf(s,(char *) GetText("BBSMD01_MSG"),(char *) MAIL.to);
  strcpy(MAIL.to,MAIL.from);
  strcpy(MAIL.from,BBSMD00_MSG);
  strcpy(MAIL.subject,s);
 }
#ifdef DEBUG2
  printf("\nbrief(): subject: %s\n",MAIL.subject);
#endif 
 brief(MAIL.to);
 return(1);
}

	sprintf(t, "%s/usr/%c/%d/seq", HOME, rec_char[0], receiver);
	fp = fopen(t, "r");
	if(fp == NULL){
		printf("\nCan't read %s\n", t);
		exit(-1);
	}
  fgets(s, STRING, fp);
  mail_id = atoi( s );
  fclose(fp);

  fp = fopen(t, "w");
  if(fp == NULL){
	printf("\nCan't write to %s\n", t);
  }
  fprintf(fp, "%d\n", (int) (mail_id + 1));
  fclose(fp);



  sprintf(destination, "%s/usr/%c/%d/%d", HOME, rec_char[0], receiver, mail_id);

  fp = fopen(destination, "w");
  if(fp == NULL){
	printf("\nCan't write to %s\n", destination);
  }
  if (!strlen(MAIL.from))
     sprintf(s, "%s %s\n", GBL01_MSG, BBSMD00_MSG); /* from bbsd-daemon :-) */
  else  sprintf(s, "%s %s\n", GBL01_MSG, MAIL.from); /* from USER*/
  
  fputs(s, fp);

  time(&timer);
  timeptr = localtime(&timer);
  strcpy(t, (UNSIGNED char *) asctime(timeptr));

  sprintf(s, "%s %s", GBL02_MSG, t);  /* time */
  fputs(s, fp);

  if (!strlen(MAIL.subject))  sprintf(s, "%s %s\n\n", GBL03_MSG, subject);
   else  sprintf(s, "%s %s\n\n", GBL03_MSG, MAIL.subject);
  fputs(s, fp); lines = 5;

  autor[0] = 0;
  subject[0] = 0;
  strcpy(tmp,destination);
#ifdef DEBUG
  printf("\nbrief(): brief=%s \n",tmp);
#endif
  ff = fopen(MAIL.mail /* tmp*/, "r");
  if (ff == NULL) {
	return(1);
  }
  while (fgets(s, STRING, ff) != NULL) {
	i = 0;
	
	if ((((!strpos(GBL01_MSG,s)==1)&&(!strpos(GBL02_MSG,s)==1)&&
	  (!strpos(GBL03_MSG,s)==1)))||(strpos(BBSMD00_MSG,MAIL.from))
	  ||(MAIL.news))
	  fputs(s, fp);
	lines++;
  }
  fclose(ff);
  fclose(fp);

  i = 0; 

                
#ifdef DEBUG
  printf("\nbrief(): mailing..ok\n");
#endif



  sprintf(s, "%s/usr/%c/%d/INDEX", HOME, rec_char[0], receiver);

  fp = fopen(s, "a");
  if(fp == NULL){
	printf("\nbbs-mail: Can't append to %s\n", s);
	return(1);
  }
                
#ifdef DEBUG
  printf("\nbrief(): INDEX:%s\n",s);
#endif

  sprintf(s, "%d              ", mail_id);
  s[6] = 0;
  fputs(s, fp);

  sprintf(ex, "%s                                  ", MAIL.subject/*subject*/);
  ex[26] = 0;
  fputs(ex, fp);

  sprintf(ex, "  %s                                        ", MAIL.from/*autor*/);
  ex[22] = 0;
  fputs(ex, fp);


  strcpy(s, (UNSIGNED char *) mydate(1));
  strcpy(t, (UNSIGNED char *) mytime(1));
  sprintf(ex, "  %s  %s         ", s, t);
  ex[19] = 0;
  fputs(ex, fp);
  sprintf(s, "%s\n", GetText("LE215_MSG"));
  fputs(s, fp);

  fclose(fp);
  mbunlock(s);


  fprintf(ff, "%5.5s  %5.5s   %-29.29s   %-31.31s\n", 
	  (UNSIGNED char *) mydate( 1 ), (UNSIGNED char *) mytime( 1 ),
	  (UNSIGNED char *) stripped(arg), subject);
  fclose(ff);

  if(receipt[0] != 0){
	i = 0; b = 0;
	while(receipt[i] != 0){
		if(receipt[i] == '!') b = i;
		if(receipt[i] == '@') b = i;
		i++;
	}
	if(b == 0) return;
 	i = b; a = 0;
	while((i > 0) && (a == 0)){
		if((receipt[i] == ' ') ||
		   (receipt[i] == '<') ||
		   (receipt[i] == '(')) a = i + 1;
		i--;
	}
  	i = b; b = 0;
 	while((receipt[i] != 0) && (b == 0)){
		if((receipt[i] == ' ') ||
		   (receipt[i] == '>') ||
		   (receipt[i] == ')')) b = i -1;
		i++;
	}
	if(b == 0) b = i -1;
 	strcpy(receipt, (UNSIGNED char *) strcopy(receipt, a, b));

	sprintf(t, "%s/%d.REC", TMP, getpid());
	ff = fopen( t, "w" );	
	if(ff == NULL){
		printf("\nCan't write to %s\n", t);
  	}

	time(&timer);
	fprintf(fp, "Path: %s!%s\n", UUCPID2,"bbs"); 
	fprintf(ff, "From: T-BBS_MAILER-DAEMON@%s (bbs-mail)\n", UUCPID2); 
	fprintf(ff, "Sender: postmaster@%s (Die Postmeisterei)\n", UUCPID2);
	fprintf(ff, "Organization: %s\n", ORGANIZATION);
	fprintf(ff, "To: %s\n", receipt);

	fprintf(ff, "Subject: Delivering Report\n");
	fprintf(ff, "X-Mailer: %s %s\n", VERSION,  AUTOR2);	
	fprintf(ff, "Message-Id: <%x.xmd@%s>\n", timer, UUCPID2);
	fputs("\n", ff);

	fprintf(ff, "%s, %s at %s\n\n", LOCATION, mydate( 1 ), mytime( 1 ));

	fprintf(ff, "Your mail \"%s\" ...\n", subject);
	if(arrived == 1){
		fprintf(ff, "... reached %s.\n\nBye for now!\n", (UNSIGNED char *) stripped(arg));
	}
	else{
		fprintf(ff, "... couldn't be delivered to %s.\n\n", (UNSIGNED char *) stripped(arg));
		fprintf(ff, "The local postmaster got a copy of your mail! Maybe he is able to forward it\nto the correct receipient!\n\n");
	}
	fclose(ff);

	/*
	sprintf(s, "/bin/sh %s/etc/rmail.sh %s %s", HOME, t, receipt);
	system(s);
	*/
	MailTo(t, receipt);
	unlink( t );
  }
}

void Pipe(argc, argv)
int argc;
char *argv[];
{
unsigned char c;
unsigned char maildrop[STRING],s[STRING];
FILE *ff;
int toggle;



		strcpy(PIPE_RECEIVER, MAIL.to);

printf("\nmail to: <%s>\n",PIPE_RECEIVER);
		
		sprintf(maildrop, "%s/%dPIP", TMP, getpid());
		strcpy(MAIL.mail,maildrop);
		fp = fopen(maildrop, "w");
		if(fp == NULL){
			printf( "\nCan't write to: %s\n", maildrop);
			printf( "\7Mail LOST! No SETUID for BBS_MAIL!!! \nCHMOD ug+s bbs_mail\n" );
			return;
		}
		c = 0;
		do{
			c = fgetc(stdin);
			if((c != EOF) && (c != 4) && (c!=255)){
				fputc(c, fp);
				
			}
		}while((c != EOF) && (c!=4) && (c !=255));
		
		
		fclose(fp);
		CheckMailForBadActions(maildrop);
		
  
  if ( 
       ((BAD_MSG_TOP!=NULL)||(BIN_CONT>0))
         &&(!TestUUE_Member(ORG_NAME))
     )
   MailBadMail(MAIL.mail);
  else
   mailing();
  
  sprintf(MAIL.mail,"%s/%s/%dPIP",HOME,TMP, getpid());
  unlink(MAIL.mail);
                


}











/* Position eines Strings in einem anderen -> strpos alias PAS */
int strpos(s, t)
unsigned char s[], t[];
{
  int j=0, i = 0, a = 0;


  while (t[i] != 0) {
	j=0;
	if (t[i] == s[0]){
	    a=i+1;
	    while ((s[j]==t[i])&&(s[j]!=0)) {
	       j++; i++;
	     }
	    if (s[j]==0) return (int) a ; else a='0';
	 }
	i++;
  }

  return (int) NULL;
}




/* Position eines Strings in einem anderen -> strpos alias PAS */
int nstrpos(s, t)
unsigned char *s, *t;
{
  int j=0, i = 0, a = 0;



  while (t[i] != 0) {
	j=0;
	if (t[i] == s[0]){
	    a=i+1;
	    while ((s[j]==t[i])&&(s[j]!=0)) {
	       j++; i++;
	     }
	    if (s[j]==0) return (int) a ; else a='0';
	 }
	i++;
  }

  return (int) NULL;
}




unsigned char *punkt2leer(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if (b[j]==46) b[j]=32;
}
 b[j]=0;
  	     
  	     
  return (UNSIGNED char *) (b);
}




int TestRMail()
{
int i=0;

if (strpos("@",MAIL.to)||strpos("!",MAIL.to)) i=1;
return(i); 
}



unsigned char *cut_arg(s)
unsigned char s[];
{
  static unsigned char arg[STRING];
  int i = 0, a = 0;
  while (s[i] > 32) i++;
  if (s[i] == 0) return (unsigned char *) "";
  while (s[i] == 32) i++;
  while (s[i] != 0) {
	arg[a] = s[i];
	i++;
	a++;
  }
  arg[a] = 0;
  while((arg[(a-1)] < 33) && (a > 1)){
	a--;
	arg[a] = 0;
  }
  return (unsigned char *) arg;
}


unsigned char *cut_bef(s)
unsigned char s[];
{
  static unsigned char bef[STRING];
  int i = 0;


  while (s[i] > 32) {
	bef[i] = s[i];
	i++;
  }
  bef[i] = 0;
  return (unsigned char *) bef;
}




/* #MI - Finding a BBS username in a UUCP address and calling "brief()"
   with this address. */

int mailing()
{
char s[STRING];

  if(!TestRMail())
  {
#ifdef DEBUG
printf("\nmailing(): to:%s \n",PIPE_RECEIVER);
#endif
	if (brief(PIPE_RECEIVER)) return(1); 	
  } 
  else
  {
    
   if (MAIL.rmail)
   { 
    if ((!checkdomaintype(MAIL.to))||(MAIL.imail))
     MailTo(MAIL.mail,MAIL.to);
    else 
    { /* keine internationalen Mails */
        sprintf(s,"user-level to small to write international mail! \n Please contact your Sysop!");
	MailErrTo(MAIL.mail,MAIL.from,s)   ;     
    } 
   } else
   {
#ifdef DEBUG
	printf("\nlevel to small for rmail!\n");
#endif
	MailErrTo(MAIL.mail,MAIL.from,"user-level to small for remoute mail, please contact your sysop :)")   ;
   }
  }

 return(0);
}







/* mailt fertige Mail-File 's' zu Empfaenfger 'rec_char' */
int MailTo(s,rec_char)
unsigned char *s,*rec_char;
{
FILE *fd,*fp;
time_t timer;
char ss[3*STRING];

if (!(fd=fopen(s,"r"))) return (0);
sprintf(ss,"%s -F%s -f%s '%s'", SYSTEM_MAIL,MAIL.from,MAIL.from,rec_char);
if ((fp = popen(ss, "w")) == NULL)
{
 printf("bbs_mail.c - MailTo(): Can't open pipe to Mailer (%s)!\n",SYSTEM_MAIL);
 exit(-2);
}
time(&timer);
fprintf(fp, "Path: %s!%s\n", UUCPID2,leer2punkt(ORG_NAME));
fprintf(fp,"To: %s\n",rec_char);
fprintf(fp,"From: %s (%s)\n",MAIL.from,ORG_NAME);
if (strlen(CC)>2) 
	fprintf(fp, "Cc: %s\n", CC);
fprintf(fp,"Organization: %s\n",ORGANIZATION);
fprintf(fp,"Subject: %s\n",MAIL.subject);
if (ret_rev==1) fprintf(fp,"Return-Receipt-To: %s\n",MAIL.from);
fprintf(fp, "X-Mailer: %s%s#%c\n", VERSION,PATCHLEVEL,TAG_MODE);
fprintf(fp, "Message-Id: <%x.%d@%s>\n\n", timer,timer, UUCPID2);
                

            
while (fgets(ss,STRING,fd)!=NULL)   fprintf(fp,"%s",ss);
pclose(fp);
fclose(fd);
return (1);                                                          

}



/* mailt das fertige Mail-File 's' zu Sender mit Fehlermeldung zurueck */
int MailErrTo(s,rec_char,error)
unsigned char *s,*rec_char,*error;
{
FILE *fd,*fp;
time_t timer;
char ss[STRING];

if (!(fd=fopen(s,"r"))) return (0);
sprintf(ss,"%s -F%s -f%s '%s'", SYSTEM_MAIL,MAIL.from,MAIL.from,rec_char);
if ((fp = popen(ss, "w")) == NULL)
{
 printf("bbs_mail.c - MailTo(): Can't open pipe to Mailer (%s)!\n",SYSTEM_MAIL);
 exit(-2);
}
time(&timer);
fprintf(fp,"To: %s\n",rec_char);
fprintf(fp, "Path: %s!%s\n", UUCPID2,"bbs"); 
fprintf(fp,"From: MAILER-DAEMON@%s\n",UUCPID2);
fprintf(fp,"Organization: %s\n",ORGANIZATION);
fprintf(fp,"Subject: mail failed, returning to sender\n");
fprintf(fp,"Sender: TBBS-MAILER-DAEMON@%s\n",UUCPID2);
fprintf(fp, "X-Mailer: %s :e3\n", VERSION);
fprintf(fp, "Message-Id: <%x.%d@%s>\n\n", timer,timer, UUCPID2);
                
fprintf(fp, "|------------------------- Message log follows: -------------------------|\n");
fprintf(fp, " Your mail can't send!\n");
fprintf(fp, "|------------------------- Failed request follow: -----------------------|\n");
fprintf(fp, " %s\n",error);   
fprintf(fp, "|------------------------- Message text follows: ------------------------|\n\n");                                                                

fprintf(fp,"To: %s\n",MAIL.to);
fprintf(fp, "Path: %s!%s\n", UUCPID2,leer2punkt(ORG_NAME));
fprintf(fp,"From: %s (%s)\n",MAIL.from,ORG_NAME);
fprintf(fp,"Organization: %s\n",ORGANIZATION);
fprintf(fp,"Subject: %s\n",MAIL.subject);
fprintf(fp, "X-Mailer: %s :rep2\n", VERSION);            
while (fgets(ss,STRING,fd)!=NULL)   fprintf(fp,"%s",ss);
pclose(fp);
fclose(fd);
return (1);                                                          
}




/* prueft, ob internationale Domain oder nicht! */
int checkdomaintype(arg)
char arg[];
{
  int i = 0, l, a, e = 0, f = 0, g = 0, international = 0;
  char s[STRING];


  while(arg[i] != 0){
	if(arg[i] == '!') e++;
	if(arg[i] == '@') g++;
	i++;
  }
  s[0] = 0;

  if((e == 0) && (g == 0)) return (int) 0;

  if(e > 1) international++;

  if(e == 0){

	l = strlen( ( char *) arg);


	a = strlen((char *) GetSection("[mail_domain]","nat1"));
	strcpy(s, (char *) strcopy(arg, (l-a), l));
	if(strcomp(s, GetSection("[mail_domain]","nat1")) == 0) f++;

	a = strlen( (char *) GetSection("[mail_domain]","nat2"));
	strcpy(s, (char *) strcopy(arg, (l-a), l));
	if(strcomp(s, GetSection("[mail_domain]","nat2")) == 0) f++;

	a = strlen( (char *) GetSection("[mail_domain]","nat3") );
	strcpy(s, (char *) strcopy(arg, (l-a), l));
	if(strcomp(s, GetSection("[mail_domain]","nat3")) == 0) f++;  	

	if(f == 0) international++;
  }  

  if(international != 0){
  	/*
	printf("\n\n%s (%d) %s\n", GetText("MAL01_MSG"), ZOPT.OPT->WRITE_INTERNAT, GetText("MAL02_MSG"));
	ansi2("me", 0 ,0);
	*/
	return (int) -1;	
  }

  return (int) 0;
}


char *GetOrgName()
{
static char s[STRING];
int i;

strcpy(s,MAIL.from);
s[strpos("@",s)-1]=0; /* Namen aus Adresse ausloesen */
for (i=0; i<STRING; i++)
{
 if (s[i]=='.') s[i]=32;
}
 
 return((char *) &s);
}
 









 
 
 
/* veranlasst die zuruecksendung des 'bad mails' :) */ 
void MailBadMail(mail)
char *mail;
{
struct list_t *dat; 
FILE *fd,*fp;
time_t timer;
char ss[2*STRING];

if (!(fd=fopen(mail,"r"))) return;
sprintf(ss,"%s -F%s -f%s '%s'", SYSTEM_MAIL,MAIL.from,MAIL.from,MAIL.from);
if ((fp = popen(ss, "w")) == NULL)
{
 printf("bbs_mail.c - MailTo(): Can't open pipe to Mailer (%s)!\n",SYSTEM_MAIL);
 exit(-2);
}
time(&timer);
fprintf(fp,"To: %s\n",MAIL.from);
/*fprintf(fp, "Path: %s!%s\n", UUCPID2,"bbs"); */
fprintf(fp,"From: MAILER-DAEMON@%s\n",UUCPID2);
fprintf(fp,"Organization: %s\n",ORGANIZATION);
fprintf(fp,"Subject: mail-message failed, returning to sender\n");
fprintf(fp,"Sender: TBBS-MAILER-DAEMON@%s\n",UUCPID2);
fprintf(fp, "X-Mailer: %s%s :e5\n", VERSION,PATCHLEVEL);
fprintf(fp, "Message-Id: <%x.%d@%s>\n\n", timer,timer, UUCPID2);
                
fprintf(fp, "|------------------------- Message log follows: -------------------------|\n");
fprintf(fp, " Your mail can't send!\n");
fprintf(fp, "|------------------------- Failed request follow: -----------------------|\n");

if (!BIN_CONT)
{


 dat=BAD_MSG_TOP;
 while (dat) 
 {
  fprintf(fp, " %s\n",dat->line);   
  dat=dat->n;
 }
} else
{
 printf("\nSTOP!
 ----------------------------------------------------------------------------
 %s\n %s
 ----------------------------------------------------------------------------
 \n",GetText("UUD50_MSG"),GetText("UUD50aMSG"));
 switch (bin_typ)
 {
  case 1: /* UUEncode */
        fprintf(fp, " can't send binary-mail (typ-1), please contact admin!\n");
        break;
  case 2: /* BASE64*/
        fprintf(fp, " can't send binary-mail (typ-2), please contact admin!\n"); 
        break;
  case 3: /* PGP*/
        fprintf(fp, " can't send binary-mail (typ-3), please contact admin!\n"); 
        break;        
  default:
  	fprintf(fp, " can't send binary-mail (typ-unknown), please contact admin!\n");
  	break;
 }

}

fprintf(fp, "|------------------------- Message text follows: ------------------------|\n\n");                                                                

fprintf(fp,"To: %s\n",MAIL.to);
/*fprintf(fp, "Path: %s!%s\n", UUCPID2,leer2punkt(ORG_NAME));*/
fprintf(fp,"From: %s (%s)\n",MAIL.from,ORG_NAME);
fprintf(fp,"Organization: %s\n",ORGANIZATION);
fprintf(fp,"Subject: %s\n",MAIL.subject);
fprintf(fp, "X-Mailer: %s%s#e\n\n", VERSION,PATCHLEVEL);            
while (fgets(ss,STRING,fd)!=NULL)   fprintf(fp,"%s",ss);
pclose(fp);
fclose(fd);
} 
 
 
 
 
 
 
/* liest alle 'bad words' in eine Heap-Liste */ 
void LoadBadWord()
{
FILE *fd;
int i;
struct list_t *dat,*dat2;

  sprintf(buf,"%s/etc/list.dirty.dictionary",HOME);

  dat=BAD_TOP;
  if ((fd=fopen(buf,"r"))!=NULL)
  {
   while (fgets(buf,STRING,fd)!=NULL)
   {
   if ((buf[0]!='#')&&(strlen(buf)>3)) /* kein Kommentar, bzw. leerzeile :) */  
   {
     strcpy(buf,(char *) strings(buf));
     i=strlen(buf)-1;
     while ((buf[i]==SPACE)&&(i>0))
     {
      buf[i]=0;
      i--;
     }
     
     dat2=(struct list_t*) malloc(sizeof(struct list_t));
     dat2->n=NULL;
     strcpy(dat2->line,buf);
     if (!BAD_TOP)  /* anfang */
     {
       BAD_TOP=dat2;
       dat=BAD_TOP;
     } else
     {
       dat->n=(void *) dat2;    
       dat=dat2;
     }
   
   }
   } /* while fgets() */
   fclose(fd); 
  }

}


/* haengt Zeile an Heap-Logfile an */
void AddLog(line)
char *line;
{
struct  list_t *dat,*dat2;


printf("\n%s",line);
 dat2=(struct list_t*) malloc(sizeof(struct list_t));
 dat2->n=NULL;
 strcpy(dat2->line,line);
 dat=BAD_MSG_TOP;
 if (!dat)  /* anfang */
 {
    BAD_MSG_TOP=dat2;
 } else
 {
    dat=BAD_MSG_TOP;
    while(dat->n!=NULL) dat=dat->n;
    dat->n=(void *) dat2;    
 }
 

}
 
 
/* prueft eine Mail-Zeile nach 'bad words' und legt bei Treffer ein
   Heap-Log-File an */ 
 CheckBadLine(line)
 char *line;
 {
 struct list_t *dat,*ldat,*dat2;
 char s[2*STRING];
 
  dat=BAD_TOP;
  
  while (dat!=NULL) 
  {
    strcpy(s,(char *) strings(line));
    if ((nstrpos((char *) &dat->line, (char *) s)!=0)&&(!TestUUE_Member(ORG_NAME)))
    {
      sprintf(s,"bad word: \"%s\" (resolution of \"communications decency act 1995\" (P314)), please contact admin for full access!",dat->line);
      AddLog(s);
      sprintf(s,"orginal-line: %s",(char *) strings(line));
      AddLog(s);         
      AddLog("---");
    }
    dat=dat->n;
  }
 }
 
 
 
 
 void CheckBinLine(line)
 char *line;
 {
 char ss[2*STRING];
 int i;
 
  strcpy(ss,(char *) strings(line));
  i=strlen(ss)-1;
  while ((ss[i]==SPACE)&&(i>0))
  {
    ss[i]=0;
    i--;
  }
 
/*  printf("\n(%s)=%d,",ss,strlen(ss));*/
  if (strlen(ss)==BASE64_LEN) BASE64_CONT++; else BASE64_CONT=0;
  
  if (strlen(ss)==PGP_LEN) PGP_CONT++; else PGP_CONT=0;
  
  if ((strlen(ss)==UUE_LEN)&&(ss[0]=='M')) UUE_CONT++; else UUE_CONT=0;
  
  if ((BASE64_CONT>BIN_LINES)||(UUE_CONT>BIN_LINES)||(PGP_CONT>BIN_LINES))
  {
   BIN_CONT++;
   if (UUE_CONT>1) { bin_typ=1; 
                     UUE_CONT=0;
                   }
   if (PGP_CONT>1) { bin_typ=3; 
                     PGP_CONT=0;
                   }                   
   if (BASE64_CONT>1) 
                   {
                    BASE64_CONT=0;
                    bin_typ=2;
                   }
  }
 
 }
 
 
 
 
 /* Checkt Mail nach BIN-Mail und 'bad words'  
    es wird dadurch z.B. UUE-Mail usw. abgefangen!
 */
 int CheckMailForBadActions(mail)
 char *mail;
 {
 FILE *fd;
 char ss[2*STRING];

 
 
 LoadBadWord();
 
 fd=fopen(mail,"r");
 while (fgets(ss,2*STRING,fd)!=NULL) 
 {
   ss[2*STRING]=0;
   CheckBadLine((char *) &ss);
   CheckBinLine((char *) &ss); 

 }
 fclose(fd);
 
}
