/** 
 ** FRAMTEST.C 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "../grafik.h"

f_test(framtest)
{
	int x = GrSizeX();
	int y = GrSizeY();
	int ww = (x * 2) / 3;
	int wh = (y * 2) / 3;
	int c,ii,jj,bg;
	GrFBoxColors bcolors,ocolors,icolors;
	int wdt = ww / 150;
	int bw = x / 16;
	int bh = y / 16;
	int bx,by;

	bcolors.fbx_intcolor = GrAllocColor(160,100,30);
	bcolors.fbx_topcolor = GrAllocColor(240,150,45);
	bcolors.fbx_leftcolor = GrAllocColor(240,150,45);
	bcolors.fbx_rightcolor = GrAllocColor(80,50,15);
	bcolors.fbx_bottomcolor = GrAllocColor(80,50,15);

	ocolors.fbx_intcolor = GrAllocColor(0,120,100);
	ocolors.fbx_topcolor = GrAllocColor(0,180,150);
	ocolors.fbx_leftcolor = GrAllocColor(0,180,150);
	ocolors.fbx_rightcolor = GrAllocColor(0,90,60);
	ocolors.fbx_bottomcolor = GrAllocColor(0,90,60);

	icolors.fbx_intcolor = bg = GrAllocColor(30,30,30);
	icolors.fbx_bottomcolor = GrAllocColor(0,180,150);
	icolors.fbx_rightcolor = GrAllocColor(0,180,150);
	icolors.fbx_leftcolor = GrAllocColor(0,90,60);
	icolors.fbx_topcolor = GrAllocColor(0,90,60);

	c = GrAllocColor(250,250,0);


	for(ii = 0,by = -(bh / 3); ii < 17; ii++) {
	    for(jj = 0,bx = (-bw / 2); jj < 17; jj++) {
		GrFramedBox(bx+2*wdt,by+2*wdt,bx+bw-2*wdt-1,by+bh-2*wdt-1,2*wdt,&bcolors);
		bx += bw;
	    }
	    by += bh;
	}

	GrFramedBox(ww/4-5*wdt-1,wh/4-5*wdt-1,ww/4+5*wdt+ww+1,wh/4+5*wdt+wh+1,wdt,&ocolors);
	GrFramedBox(ww/4-1,wh/4-1,ww/4+ww+1,wh/4+wh+1,wdt,&icolors);

	GrSetClipBox(ww/4,wh/4,ww/4+ww,wh/4+wh);

	drawing(ww/4,wh/4,ww,wh,c,bg);
	getkey();

}



void frame_test(mode)
int mode;
{
extern int RIP_TEST;
	int x = 0;
	int y = 0;
	int c = 0;

	x=640;
	y=480;
	c=16;
	if(c >= 2)
	    GrSetMode(GR_width_height_color_graphics,x,y,c);
	else if((x >= 320) && (y >= 200))
	    GrSetMode(GR_width_height_graphics,x,y);
	else GrSetMode(GR_default_graphics);
	f_test();
	if ((!RIP_TEST)&&(!mode))	GrSetMode(GR_default_text);
}

#define XP(x)	(int)((((long)(x) * (long)xsize) / 100L) + xpos)
#define YP(y)	(int)((((long)(y) * (long)ysize) / 100L) + ypos)

void drawing(int xpos,int ypos,int xsize,int ysize,int fg,int bg)
{
	int ii;

	if(bg != GrNOCOLOR) {
	    GrFilledBox(xpos,ypos,xpos+xsize-1,ypos+ysize-1,bg);
	}
	GrLine(XP(10),YP(10),XP(40),YP(40),fg);
	GrLine(XP(40),YP(10),XP(10),YP(40),fg);
	GrLine(XP(35),YP(10),XP(65),YP(40),fg);
	GrLine(XP(35),YP(40),XP(65),YP(10),fg);
	GrLine(XP(70),YP(10),XP(90),YP(40),fg);
	GrLine(XP(70),YP(40),XP(90),YP(10),fg);
	for(ii = 0; ii < 5; ii++) {
	    GrBox(XP(70+2*ii),YP(10+3*ii),XP(90-2*ii),YP(40-3*ii),fg);
	}
	GrFilledBox(XP(10),YP(50),XP(60),YP(90),fg);
	GrBox(XP(70),YP(50),XP(90),YP(90),fg);
	for(ii = 0; ii < 100; ii++) {
	    GrPlot(XP((random() % 20) + 70),YP((random() % 40) + 50),fg);
	}
}

