
/* ix/MBox (RipTest.c) by Sylvio Runge 6/94

   This C source code contains the following functions:

*/





#include <dirent.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/stat.h>
#include <dirent.h>
#include "../mbox.h"

#include "../s_global.h"
#include "../compile.h"


#include <string.h>
#include <time.h>
#include <stdlib.h>
#include "../rip/ripwraps.h"
int RIP_INIT=1;

void RipInit()
{
       ZOPT.OPT->USER.terminal=5; /* ANSI fuer RIP */
       sprintf(ZOPT.OPT->TERMINAL, "ansi-color");
       init_user("",0);
       ZOPT.OPT->USER.terminal=6; /*  RIP */
       init_user("",0);
       printf("\n");	
}


void RipClean()
{
	ripio_set_autoflush(0); 
        if (RIP_INIT) return; else  printf(" \n%c[2 \n!",ESC); /*Enable All Rip-CMD*/
	rip_kill_mouse_fields();
	rip_reset_windows();
	rip_erase_window();
	rip_home();

	rip_text_window(0, 0, 79, 42, 1, 0);
	rip_fill_style(RIP_SOLID_FILL, RIP_DARKGRAY);
	rip_line_style(RIP_SOLID_LINE, 0, RIP_NORM_WIDTH);
	rip_font_style(RIP_SMALL_FONT, RIP_HORIZ_DIR, 6, 0);

	rip_color(RIP_DARKGRAY);
	RipFlush();
	printf("\n");
}



/* ++++++++++ Main-Menu +++++++++++++++++ */
void View_Rip_Main()
{
 unsigned char s[2*STRING],d[STRING];

 ZOPT.OPT->RIPMAIL_ON=0;
 /* hintergrund + Titel */
 sprintf(s,"%s/%s/main/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 
 /* BBS-System */
 printf("\n!|1B0000020W8G03000E0F080300000F07000000|1U1J05G0160000<>%s<>\n"
 	,ZOPT.OPT->system);
 
 strcpy(d,s);
 chdir(s);
 sprintf(s,"%s/%s/main/2",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);

 printf("!|@051E %-60s  %s : %s\n",ZOPT.OPT->ORGANIZATION,mydate(),mytime());
#ifdef _LINUX 
 printf("!|Y02000400|c0D|@0823 user: %d/%s (bbs/system)    ",
   user_anzahl(),sprint_user());
 printf(" load average: %s\n",sprint_load());
#endif 
 sprintf(s,"%s/%s/main/3",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 
  /* BBS-VERSION */
 printf("!|@0294%s %s %s\n",VERSION, PATCHLEVEL,AUTOR_0);
 /* Last-login*/
 printf("!|c%d|@028KUSER: %s (%s)     level:%d\n",RIP_EGA_YELLOW,
         ZOPT.OPT->USER.name,ZOPT.OPT->USER.nick,ZOPT.OPT->USER.level);
 printf("!|c%d|@028Ulast login: %s %s,  %s: %08.8d min, %s: %-04.4d min\n",
         RIP_RED,
         ZOPT.OPT->USER.lastlog,
         (UNSIGNED char *) timereconv(ZOPT.OPT->USER.lasttime),
         GetText("RIP41"),
 	 ZOPT.OPT->USER.elapsed / 60,
 	 GetText("RIP40"),  
 	 (GetAktTimeRatio()/60)
    );
 
 sprintf(s,"%s/%s/main/4",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 printf("!|c%d|@809ELizens:%s\n",RIP_DARKGRAY,
    COPYWRITE);
 printf("!|@049FOS: %s\n!|#|#|#\n",BBS_UNAME);
 
}




void RipIntro()
{
 unsigned char s[STRING];

 whodo("rip:intro");
 sprintf(s,"%s/%s/intro/1",ZOPT.OPT->HOME,RIPDIR);
 if (!RipPrintFile(3,s))
 {
  DrawRipEnter();
  gets(s);
 } else 
 {
   sleep(2);
   ansi("cl");
   ansi("me");
   printf("\nRIP1.54-Support not installed, sorry! (RTFM: READ THE README)\n");
   exit(-1);
 } 
}

void RipFlush()
{
	(void)fflush(stdout); 
}




/* Zeichnet eine Enter-MausRegion als OK-Knopf */
void DrawRipEnter(arg)
int arg;
{
 unsigned char s[STRING];

 sprintf(s,"%s/%s/CR/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
}




/* Zeichnet eine Enter-MausRegion als OK-Knopf */
void RipDrawMore(arg)
int arg;
{
 unsigned char s[STRING];

 sprintf(s,"%s/%s/CR/more",ZOPT.OPT->HOME,RIPDIR);
}



/* Zeichnet eine Enter-MausRegion als OK-Knopf */
void DrawRipEnter2(arg)
int arg;
{

 printf("\n!");
 rip_load_icon(400,250,RIP_COPY_PUT,0,RIP_OR_PUT,"ret.icn");
 RipFlush();
 printf("\n!|###");
}


char *whatstr31 = "@(#) RIPLib - tbbs1.3  94/95  by 'runge@nina.boerde.de' ";