
#ifdef TTTTTTTTTTTTTTTTTTTTTTTTTTT

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#define __MBD
#include "uqwk.h"

#define MAXFILENAME 128

#ifdef SERVER
#include "nntp.h"
extern void connect_nntp();
extern FILE *getactive_nntp(); 
extern void group_nntp(char *);
extern FILE *nntpopen(int,int);
#endif

#include "../nntp.h"
#include <sys/param.h>                      
#include <sys/socket.h>                     
#include <netinet/in.h>                     
#include <netdb.h>                          


/*
 *  All sorts of stuff to do news processing
 */

DoNews ()
/*
 *  Collect unread news into QWK packet
 */
{
	char active_name[MAXFILENAME];
	struct act_ent *ap;
	struct nrc_ent *np;

	/* Read .newsrc file */
	if (!ReadNewsrc()) return (0);

#ifdef SERVER
	/* connect to nntp news server */
	connect_nntp();
#endif

	/* And active file */
	if (!ReadActive()) return (0);

	/* Look through the newsrc file */
	np = nrc_list;
	while (np != NULL)
	{
		/* Check if too many blocks already */
		if ( (blk_cnt >= max_blks) && (max_blks > 0) )
		{
			return (0);
		}

		if ( (np->subscribed) &&
		     (NULL != (ap = FindActive (np->name))) )
		{
			/* Do this group */
			DoGroup (np, ap);
		}
		np = np->next;
	}
#ifdef SERVER
                                        /* make a temporary name */
	sprintf(active_name,"/tmp/rrnact.%d",getpid());
	unlink(active_name);

	close_server();
#endif
	return (1);
}


struct act_ent *FindActive (c)
char *c;
/*
 *  Look for group's active entry given group name
 */
{
	struct act_ent *ap;

	ap = act_list;
	while (NULL != ap)
	{
		if (!strcmp (c, ap->name)) return (ap);
		ap = ap->next;
	}
	return (NULL);
}

DoGroup (np, ap)
struct nrc_ent *np;
struct act_ent *ap;
/*
 *  Process given group
 */
{
	char news_path[PATH_LEN];
	char art_file[PATH_LEN];
	int i, n;

	printf ("%s: %s\n", progname, np->name);

	/* Make a new conference with this name */
	NewConference (conf_cnt,np->name);

#ifdef SERVER
	/* select group name from news server */
	group_nntp(np->name);
#else
	/* Construct path name for articles in this group */
	strcpy (news_path, news_dir);
	strcat (news_path, "/");
	strcat (news_path, np->name);
	strcat (news_path, "/");
	n = strlen (news_path);
	for (i=0; i<n; i++) if (news_path[i] == '.') news_path[i] = '/';
#endif

	/* If highest read article is greater than highest available
	   article, assume group has been reset */
	if (np->hi > ap->hi) np->hi = ap->lo;

	/* Look through unread articles */
	for (i=np->hi+1; i<=ap->hi; i++)
	{
		/* Check max block count */
		if ( (blk_cnt >= max_blks) && (max_blks > 0) )
		{
			fclose (ndx_fd);
			np->hi = i;
			return (0);
		}

		/* Process this article */
		DoArticle (news_path, i);
	}
	fclose (ndx_fd);

	/* Reset hi article number */
	np->hi = ap->hi;

	return (1);
}

DoArticle (news_path, artnum)
char *news_path;
int artnum;
{
	struct qwk_hdr hdr;
	struct stat stat_buf;
	long txt_offset, end_offset;
	int n, out_bytes;
	char ndx[5], *eof, from[PATH_LEN];
	FILE *art_fd;
	char art_file[PATH_LEN];

#ifdef SERVER
	/* retrieve article from news server */
/*	printf("retrieving article %d\n",artnum); */
	art_fd = nntpopen(artnum, GET_ARTICLE);

	/* Construct article's file name */ 
    	sprintf(art_file,"/tmp/rrn%ld.%ld", (long) artnum, getpid());
#else
	/* Construct article's file name */ 
	sprintf (art_file, "%s%d", news_path, artnum);

	/* Forget it if we can't open the article */
	if (NULL == (art_fd = fopen (art_file, "r"))) return (0);

#endif
	/* stat() the article to get file size */
	if (0 != stat (art_file, &stat_buf))
	{
		fclose (art_fd);
		return (0);
	}

	end_offset = stat_buf.st_size;

	/* Skip empty articles */
	if (end_offset == 0)
	{
		fclose (art_fd);
		return (0);
	}

	/* Write the index file entry */
	inttoms (blk_cnt, ndx);
	ndx[4] = conf_cnt - 1;
	fwrite (ndx, 5, 1, ndx_fd);

	Spaces (&hdr, 128);

	/* Fill in some header fields */
	hdr.status = QWK_PUBLIC;
	PadNum (msg_cnt, hdr.number, 7);
	Spaces (hdr.password, 12);
	Spaces (hdr.refer, 8);
	hdr.flag = QWK_ACT_FLAG;
	IntNum (conf_cnt-1, hdr.conference);
	IntNum (msg_cnt+1, hdr.msg_num);
	hdr.tag = ' ';
	PadString ("ALL", hdr.to, 25);

	msg_cnt++;

	/* Process header lines */
	eof = Fgets (buf, BUF_LEN, art_fd);
	while ( (0 != strlen(buf)) && (eof != NULL) )
	{
		if (!strncmp (buf, "Date: ", 6))
		{
			ParseDate (&buf[6], &hdr);
		}
		else if (!strncmp (buf, "Subject: ", 9))
		{
			PadString (&buf[9], hdr.subject, 25);
		}
		else if (!strncmp (buf, "From: ", 6))
		{
			sscanf (&buf[6], "%s", from);
			PadString (from, hdr.from, 25);
		}

		eof = Fgets (buf, BUF_LEN, art_fd);
	}

	txt_offset = ftell (art_fd);

	/* Compute block count */
	if (inc_hdrs)
	{
		PadNum (2+end_offset/128, hdr.blocks, 6);
		blk_cnt += 1+end_offset/128;
	}
	else
	{
		PadNum (2+(end_offset-txt_offset)/128, hdr.blocks, 6);
		blk_cnt += 1+(end_offset-txt_offset)/128;
	}

	/* Write the message header */
	fwrite (&hdr, 128, 1, msg_fd);
	blk_cnt++;

	/* Now write the article's text */
	if (inc_hdrs) fseek (art_fd, 0, 0);
	out_bytes = 0;

	while (NULL != Fgets (buf, BUF_LEN, art_fd))
	{
		n = strlen (buf);
		fwrite (buf, n, 1, msg_fd);
		out_bytes += n;

		if (n < BUF_LEN-1)
		{
			fputc (QWK_EOL, msg_fd);
			out_bytes++;
		}
	}

	/* Pad block as necessary */
	n = out_bytes % 128;
	for (;n<128;n++) fputc (' ', msg_fd);

	fclose (art_fd);
#ifdef SERVER
	unlink(art_file);
#endif

	return (1);
}





int ReadActive()
/*
 *  Read active file
 */
{
	char group_name[PATH_LEN];
	struct act_ent *ap;
	char *ps;
	int n;

	/* Don't bother if it's already here */
	if (act_list != NULL) return (1);

if (!NNTP_ON)
{
	/* Open the active file */
	if (NULL == (act_fd = fopen (act_file, "r")))
	{
		fprintf (stderr, "%s: can't open %s\n", progname, act_file);
		return (0);
	}
} else
{  /* NNTP-Act */
   printf("\nnntp: connecting to %s ..... ", nntpserver);
   nntp_connect_port(nntpserver,nntpport);
   nntp_send("LIST\n");
   if (OK_GROUPS!=atoi(cut_bef(cut_leer(strings(nntp_read()))))) {
     printf("\nunknown server Message:\n"); sleep(2);
     exit(-1);
   }
}

	/* Read through it */
if (!NNTP_ON)
{	
	while (NULL != Fgets (buf, BUF_LEN, act_fd))
	{
		/* Get new act entry */
		ap = (struct act_ent *) malloc (sizeof (struct act_ent));
		if (ap == NULL) OutOfMemory();

		/* Parse name, message numbers */
		sscanf (buf, "%s %d %d", group_name, &ap->hi, &ap->lo);
		ap->name = (char *) malloc (1+strlen(group_name));
		if (ap->name == NULL) OutOfMemory();
		strcpy (ap->name, group_name);

		/* Add to list */
		ap->next = act_list;
		act_list = ap;
	}
	fclose (act_fd);
} else
{  /* nntp_proc */
	while ( (ps=nntp_read()) !=NULL  )
	{
		/* Get new act entry */
		ap = (struct act_ent *) malloc (sizeof (struct act_ent));
		if (ap == NULL) OutOfMemory();

		/* Parse name, message numbers */
		sscanf (ps, "%s %d %d", group_name, &ap->hi, &ap->lo);
		ap->name = (char *) malloc (1+strlen(group_name));
		if (ap->name == NULL) OutOfMemory();
		strcpy (ap->name, group_name);

		/* Add to list */
		ap->next = act_list;
		act_list = ap;
	}
	close(NNTP_ON);

}
	return (1);
}










void nntp_connect_port(char *server, int port) 
{
struct hostent *host;
struct sockaddr_in sockin;
int i;


    host = gethostbyname(server);
    if (host == NULL) {
        printf("\n");
        printf("\ncan not connect to server %s", server); 
        printf("\n%s",NNTP1); sleep(1);
        NNTP_ON=0;
        exit(-1);
    }
    bzero((char *) &sockin, sizeof(sockin));
    
    bcopy(host->h_addr, (char *) &sockin.sin_addr, host->h_length);
    sockin.sin_port = htons(port);
    sockin.sin_family = host->h_addrtype;
    

    NNTP_ON = socket(AF_INET, SOCK_STREAM, NULL);
/* connect zum socket */
    if (connect(NNTP_ON, (struct sockaddr *) &sockin, sizeof(sockin)) == -1) {
      printf("\n");
      printf("\nnntp-server (%s) is down", nntpserver);
      printf("\n%s",NNTP2);
      sleep(2);
      exit(-2);
    }
    NNTPSetStat();
}


void NNTPSetStat()
{
int bef;
unsigned char s[2*STRING];

strcpy(s,nntp_read());

/* settting*/
bef=atoi(cut_bef(s));

if (!((bef==OK_CANPOST)||(bef==OK_NOPOST)))  /* Test, ob Server bereit ist */
{
 printf("\nnntp-server in not ok: \n%s",s);
 sleep(2);
 exit(-3);
}

}



void nntp_send(arg) 
unsigned char *arg[];
{
  if (send(NNTP_ON,arg, strlen(arg), 0 )<0) 
  {
      close(NNTP_ON);
      printf("\nnntp --> send()-error: Connection closed by tbbs!");  
  }
}


char *nntp_read() 
{
int sfd;
char s[NNTP_STRLEN];
int x;
char ch;

   
    x=s[0]=0;
     do
     {
      if (read(NNTP_ON, &ch, 1)<0) {
       close(NNTP_ON);
       printf("\nnntp -> error for reading: Connection closed by foreign host!\r\n");
       return(NULL);
      } else {
       s[x++]=ch;
      }
     } while ((x<NNTP_STRLEN)&&(ch!=CR)&&(ch!=0));
     s[x]=0;
     if (s[1]=='\.') return ((unsigned char *) NULL);  /*Ende der Uebertragung */
     return((unsigned char *) &s);
}


#endif /* TTTTTTTTTTTTTTTTTTTTTT*/



OutOfMemory()
{
	printf ("\ntbbs-qwk: out of memory\n");
	exit (0);
}

