/*Copyright (C) 1998 Darren Braun
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *   Any comments or questions can be directed to darren@theboard.dyn.ml.org
 */

/*misc.c - Misc. Functions for The Board*/

#include <headers.h>

extern int linenum;
extern int chk_pl;
extern int command_max;
extern int displogon_max;
extern int box_max;


char tb_logon[10][80];
int displogon_max = 0;
struct tb_dat dat_main;
int Node = 0;
char temp_buf[4096];
int to_int_return = 0;
struct tm *cur_time;
int orig_timeon = 0;
time_t cur_rawtime, logon_time, cur_time2;
struct user_dat user;
struct user_stat user2;
struct user_dat alt_user;
struct user_stat alt_user2;
struct user_index user3;
char prompt_str[200][200];
char dir_file[80], file_list[20][80];
int dir_num = 1, max_files = 0;
int time_limit[1002];
char logs[20][80];



int read_usetup(void)
{
   FILE *fp_user, *fp_allias, *fp_menu;
   int a = 0, quit = 0, quitb = 0, end = 0, temp = 0;
   char home_dir[80], udat_file[80];
   char temp2[80];
   user.pagelen = 24;
   strcpy(user.login, getlogin());
   if(!(strcmp(user.login, "root"))){

      strcpy(home_dir, "/");
      strcat(home_dir, user.login);
      
   }
   else{
      strcpy(home_dir, "/home/");
      strcat(home_dir, user.login);
      
   }
   strcat(home_dir, "/");
   strcpy(udat_file, home_dir);
   strcat(udat_file, ".tbsetup");
   fp_user = fopen(udat_file, "r");
   if(!fp_user){
      disp_prompt(15);
      putcolor('0','E');
      tbc_newline();
      printf("Enter your First Name: ");
      putcolor('0','F');
      get_input(user.fname,20,0,1,0,0,0);
      putcolor('0','E');
      tbc_newline();
      printf("Enter your Last Name: ");
      putcolor('0','F');
      get_input(user.lname,20,0,1,0,0,0);
      strcpy(user.homedir,home_dir);
      tbc_newline();
      printf("Now you need to enter your address.\n");
      tbc_newline();
      putcolor('0','E');
      printf("Enter your Street(APT#): ");
      putcolor('0','F');
      get_input(user.saddress,50,1,1,1,0,0);
      putcolor('0','E');
      tbc_newline();
      printf("Enter your City: ");
      putcolor('0','F');
      get_input(user.city,20,1,1,1,0,0);
      putcolor('0','E');
      tbc_newline();
      printf("Enter your State: ");
      putcolor('0','F');
      get_input(user.state,20,0,1,1,0,0);
      putcolor('0','E');
      tbc_newline();
      printf("Enter your Zip Code: ");
      putcolor('0','F');
      get_input(user.zip,10,1,0,1,0,1);
      putcolor('0','E');
      tbc_newline();
      printf("Enter your Country: ");
      putcolor('0','F');
      get_input(user.country,25,0,1,1,0,0);
      tbc_newline();
      user.pagelen = 24;
      user.colormode = 'A';
      putcolor('0','E');
      printf("Enter your Home Phone Number: ");
      putcolor('0','F');
      get_input(user.hphone,15,1,1,1,0,2);
      tbc_newline();
      putcolor('0','E');
      printf("Enter your Buisness/Data Phone Number: ");
      putcolor('0','F');
      get_input(user.dphone,15,1,1,1,0,2);
      fp_user = fopen(udat_file, "w+");
      fwrite(&user, sizeof(user), 1, fp_user);
   }
   fseek(fp_user, 0, SEEK_SET);
   fread(&user, sizeof(user), 1, fp_user);
   fclose(fp_user);
   
   return 0;
}


int read_ustats(void)
{
   FILE *fp_user;
   char home_dir[80], udat_file[80];
   strcpy(udat_file, user.homedir);
   strcat(udat_file, ".tbstat");
   fp_user = fopen(udat_file, "r");
   if(!fp_user){
      user2.sec = 20;
      user2.files_dl = 0;
      user2.files_ul = 0;
      user2.mess_rd = 0;
      user2.mess_wr = 0;
      user2.total_calls = 0;
      user2.page_sys = 0;
      user2.comment_sys = 0;
      user2.last_on = 0;
      user2.time_on = 0;
      fp_user = fopen(udat_file, "w");
      fwrite(&user2, sizeof(user2), 1, fp_user);
   }
   
   fseek(fp_user, 0, SEEK_SET);
   fread(&user2, sizeof(user2), 1, fp_user);
   fclose(fp_user);
   
   return 0;
}

int write_ustats(void){
   char udat_file[80];
   FILE *fp_user;
   strcpy(udat_file, user.homedir);
   strcat(udat_file, ".tbstat");
   fp_user = fopen(udat_file, "w");
   fwrite(&user2, sizeof(user2), 1, fp_user);
   fclose(fp_user);
   return 0;
}

int write_usetup(void){
   char udat_file[80];
   FILE *fp_user;
   strcpy(udat_file, user.homedir);
   strcat(udat_file, ".tbsetup");
   fp_user = fopen(udat_file, "w");
   fwrite(&user, sizeof(user), 1, fp_user);
   fclose(fp_user);
   return 0;
}

int update_time(void)
{
   cur_rawtime = time(NULL);
   return 0;
}


int update_timeon(void)
{
   update_time();
   user2.time_on = ((cur_rawtime - logon_time) / 60) + orig_timeon;
   return 0;
}


int get_daynum(void)
{
   cur_time = localtime(&cur_rawtime);
   return cur_time->tm_yday;
}


int check_timeleft(void)
{
   int time_left;
   if(time_limit[user2.sec] > user2.time_on){
      time_left = time_limit[user2.sec] - user2.time_on;
      return time_left;
   }
   else{
      return 0;
   }
   return 0;
}


int log_error(char message[])
{
   FILE *fp_error;
   fp_error = fopen(dat_main.errlog, "a");
   fputs(message, fp_error);
   fputc('\n', fp_error);
   fclose(fp_error);
   return 0;
}

int log_message(char message[], int log_num)
{
   FILE *fp_log;
   umask(0000);
   fp_log = fopen(logs[log_num], "a");
   fputs(message, fp_log);
   fputc('\n', fp_log);
   fclose(fp_log);
   return 0;
}

int tbc_more(void)
{
   int quit = 0;
   char ans;
   disp_prompt(6);
   while(!quit){
      ans = getchar();
      if(ans != EOF){
	 quit = 1;
      }
   }
   printf("\b\b\b\b\b\b\b\b\b\b\b");
   printf("           ");
   printf("\b\b\b\b\b\b\b\b\b\b\b");
   linenum = 1;
   if(ans == 'n' || ans == 'N'){
      return 0;
   }
   return 1;
}

int tbc_wait(void)
{
   int quit = 0;
   char ans;
   disp_prompt(5);
   while(!quit){
      ans = getchar();
      if(ans != EOF){
	 quit = 1;
      }
   }
   printf("\n");
   linenum = 1;
   return 0;
}

int disp_prompt(int num)
{
   int a = 0, b = 0, quit = 0, quitb = 0;
   char dispvar[20], fg = 7, bg = 0, fname[80];
   strcpy(dispvar, "");
   if(num > 200){
      return -1;
   }
   a = 0;
   quit = 0;
   while(!quit){
      if(prompt_str[num][a] == '\0'){
	 quit = 1;
	 continue;
      }
      else if((prompt_str[num][a] == '%') && (prompt_str[num][a + 1] != '%')){
	 a++;
	 b = 0;
	 quitb = 0;
	 while(!quitb){
	    if(prompt_str[num][a] == '\0'){
	       fname[b] = '\0';
	       tbc_dispfile(fname);
	       quitb = 1;
	       continue;
	    }
	    else{
	       fname[b] = prompt_str[num][a];
	       b++;
	    }
	    a++;
	 }
      }
      else if((prompt_str[num][a] == '%') && (prompt_str[num][a + 1] == '%')){
	 printf("%");
	 a = a + 2;
      }
      else if((prompt_str[num][a] == '@') && (prompt_str[num][a + 1] == 'X')){
	 a = a + 2;
	 bg = prompt_str[num][a];
	 a++;
	 fg = prompt_str[num][a];
	 a++;
	 putcolor(bg,fg);
      }
      else if(prompt_str[num][a] == '@'){
	 a++;
	 b = 0;
	 quitb = 0;
	 while(!quitb){
	    if(prompt_str[num][a] == '\0'){
	       dispvar[b] = '\0';
	       tbc_dispfile(dispvar);
	       quitb = 1;
	       continue;
	    }
	    else if(prompt_str[num][a] == '@'){
	       dispvar[b] = '\0';
	       quitb = 1;
	       a++;
	       continue;
	    }
	    else{
	       dispvar[b] = prompt_str[num][a];
	       b++;
	       a++;
	    }
	    
	 }
	 if(!(strcmp(dispvar,"CLS"))){
	    clrscr();
	 }
	 else if(!(strcmp(dispvar,"FNAME"))){
	    printf("%s",user.fname);
	 }
	 else if(!(strcmp(dispvar,"LNAME"))){
	    printf("%s",user.lname);
	 }
	 else if(!(strcmp(dispvar,"ALLIAS"))){
	    printf("%s",user.allias);
	 }
	 else if(!(strcmp(dispvar,"LOGIN"))){
	    printf("%s",user.login);
	 }
	 else if(!(strcmp(dispvar,"MINLEFT"))){
	    printf("%d",check_timeleft());
	 }
	 else if(!(strcmp(dispvar,"TCALLS"))){
	    printf("%d",user2.total_calls);
	 }
	 
      }
      else{
	 printf("%c",prompt_str[num][a]);
	 a++;
      }
      
   }
   linenum++;
   fflush(stdout);
   return 0;
}

int tbc_getyn(void)
{
   int quit = 0;
   char temp;
   linenum = 1;
   while(!quit){
      temp = tolower(getchar());
      if(temp == 'y' || temp == '\n'){
	 return 1;
      }
      else if(temp == 'n'){
	 return 0;
      }
   }
   
   return 0;
}

int tbc_readline(FILE *fp_file, int line_num, int type)
{
   int a = 0, quit = 0, end = 0;
   char temp;
   fseek(fp_file, 0, SEEK_SET);
   if(line_num <= 0){
      return -1;
   }
   if(line_num == 1){
      quit = 1;
   }
   while(!quit){
      end = fread(&temp, sizeof(temp), 1, fp_file);
      if(!end){
	 return -1;
      }
      if(temp == '\n'){
	 a++;
	 if(a + 1 == line_num){
	    quit = 1;
	    continue;
	 }
      }
   }
   if(type == 1){
      a = 0;
      quit = 0;
      while(!quit){
	 prompt_str[line_num][a] = fgetc(fp_file);
	 if(prompt_str[line_num][a] == '\n' || a == 4094){
	    prompt_str[line_num][a] = '\0';
	    quit = 1;
	    continue;
	 }
	 a++;
      }
   }
   else if(type == 2){
      a = 0;
      quit = 0;
      while(!quit){
	 temp_buf[a] = fgetc(fp_file);
	 if(temp_buf[a] == '\n' || a == 4094 || temp_buf[a] == EOF || temp_buf[a] == '\0'){
	    temp_buf[a] = '\0';
	    quit = 1;
	    continue;
	 }
	 a++;
      }
   }
   
   return 0;
}


int tbc_read_line(FILE *fp_file)
{
   int a = 0, quit = 0, end = 0;
   char temp;
   while(!quit){
      end = fread(&temp, sizeof(temp), 1, fp_file);
      if(!end){
	 return -1;
      }
      else{
	 temp_buf[a] = temp;
      }
      if(temp_buf[a] == '\n' || a == 4094 || temp_buf[a] == EOF || temp_buf[a] == '\0'){
	 temp_buf[a] = '\0';
	 quit = 1;
	 continue;
      }
      a++;
   }
   
   return 0;
}


int tbc_dispfile(char filen[])
{
   int quit = 0, quitb = 0, a, b, cont;
   char fg, bg, temp, dispvar[32];
   FILE *fp_file;
   linenum = 1;
   fp_file = fopen(filen, "r");
   if(!fp_file){
      return 1;
   }
   fseek(fp_file,0,SEEK_SET);
   quit = 0;
   while(!quit){
      temp = fgetc(fp_file);
      if(temp == EOF){
	 quit = 1;
	 continue;
      }
      if(temp == '@'){
	 temp = fgetc(fp_file);
	 if(temp == '@'){
	    printf("@");
	 }
	 else if(temp == 'X'){
	    temp = fgetc(fp_file);
	    bg = temp;
	    temp = fgetc(fp_file);
	    fg = temp;
	    putcolor(bg,fg);
	 }
	 else{
	    b = 0;
	    quitb = 0;
	    while(!quitb){
	       if(temp == '@'){
		  dispvar[b] = '\0';
		  quitb = 1;
		  continue;
	       }
	       else if(b >=30){
		  dispvar[b] = '\0';
		  printf("@5%s", dispvar);
		  quitb = 1;
		  continue;
	       }
	       else{
		  dispvar[b] = temp;
		  b++;
	       }
	       temp = fgetc(fp_file);
	       
	    }
	    if(!(strcmp(dispvar,"CLS"))){
	       clrscr();
	    }
	    else if(!(strcmp(dispvar,"FNAME"))){
	       printf("%s",user.fname);
	    }
	    else if(!(strcmp(dispvar,"LNAME"))){
	       printf("%s",user.lname);
	    }
	    else if(!(strcmp(dispvar,"ALLIAS"))){
	       printf("%s",user.allias);
	    }
	    else if(!(strcmp(dispvar,"LOGIN"))){
	       printf("%s",user.login);
	    }
	    else if(!(strcmp(dispvar,"MINLEFT"))){
	       printf("%d",check_timeleft());
	    }
	    else if(!(strcmp(dispvar,"TCALLS"))){
	       printf("%d",user2.total_calls);
	    }
	    
	 }
      }
      else{
	 printf("%c", temp);
	 if(temp == '\n'){
	    linenum++;
	    if(linenum >= user.pagelen && chk_pl == 1){
	       cont = tbc_more();
	       if(!cont){
		  quit = 1;
		  continue;
	       }
	    }
	 }
      }
   }
   fclose(fp_file);
   return 0;
}


int to_int(char temp[])
{
   int temp1 = 0,temp2 = 0, temp3 = 0, temp4 = 0;
   int length;
   length = strlen(temp);
   if(length == 1){
      switch(temp[0]){
       case '0':
	 to_int_return = 0;
	 break;
       case '1':
	 to_int_return = 1;
	 break;
       case '2':
	 to_int_return = 2;
	 break;
       case '3':
	 to_int_return = 3;
	 break;
       case '4':
	 to_int_return = 4;
	 break;
       case '5':
	 to_int_return = 5;
	 break;
       case '6':
	 to_int_return = 6;
	 break;
       case '7':
	 to_int_return = 7;
	 break;
       case '8':
	 to_int_return = 8;
	 break;
       case '9':
	 to_int_return = 9;
	 break;
       default:
	 to_int_return = 0;
	 break;
      }
   }
   else if(length == 2){
      switch(temp[0]){
       case '0':
	 temp2 = 0;
	 break;
       case '1':
	 temp2 = 10;
	 break;
       case '2':
	 temp2 = 20;
	 break;
       case '3':
	 temp2 = 30;
	 break;
       case '4':
	 temp2 = 40;
	 break;
       case '5':
	 temp2 = 50;
	 break;
       case '6':
	 temp2 = 60;
	 break;
       case '7':
	 temp2 = 70;
	 break;
       case '8':
	 temp2 = 80;
	 break;
       case '9':
	 temp2 = 90;
	 break;
       default:
	 temp2 = 0;
	 break;
      }
      switch(temp[1]){
       case '0':
	 temp1 = 0;
	 break;
       case '1':
	 temp1 = 1;
	 break;
       case '2':
	 temp1 = 2;
	 break;
       case '3':
	 temp1 = 3;
	 break;
       case '4':
	 temp1 = 4;
	 break;
       case '5':
	 temp1 = 5;
	 break;
       case '6':
	 temp1 = 6;
	 break;
       case '7':
	 temp1 = 7;
	 break;
       case '8':
	 temp1 = 8;
	 break;
       case '9':
	 temp1 = 9;
	 break;
       default:
	 temp1 = 0;
	 break;
      }
      to_int_return = temp1 + temp2;
   }
   else if(length == 3){
      switch(temp[0]){
       case '0':
	 temp3 = 0;
	 break;
       case '1':
	 temp3 = 100;
	 break;
       case '2':
	 temp3 = 200;
	 break;
       case '3':
	 temp3 = 300;
	 break;
       case '4':
	 temp3 = 400;
	 break;
       case '5':
	 temp3 = 500;
	 break;
       case '6':
	 temp3 = 600;
	 break;
       case '7':
	 temp3 = 700;
	 break;
       case '8':
	 temp3 = 800;
	 break;
       case '9':
	 temp3 = 900;
	 break;
       default:
	 temp3 = 0;
	 break;
      }
      switch(temp[1]){
       case '0':
	 temp2 = 0;
	 break;
       case '1':
	 temp2 = 10;
	 break;
       case '2':
	 temp2 = 20;
	 break;
       case '3':
	 temp2 = 30;
	 break;
       case '4':
	 temp2 = 40;
	 break;
       case '5':
	 temp2 = 50;
	 break;
       case '6':
	 temp2 = 60;
	 break;
       case '7':
	 temp2 = 70;
	 break;
       case '8':
	 temp2 = 80;
	 break;
       case '9':
	 temp2 = 90;
	 break;
       default:
	 temp2 = 0;
	 break;
      }
      switch(temp[2]){
       case '0':
	 temp1 = 0;
	 break;
       case '1':
	 temp1 = 1;
	 break;
       case '2':
	 temp1 = 2;
	 break;
       case '3':
	 temp1 = 3;
	 break;
       case '4':
	 temp1 = 4;
	 break;
       case '5':
	 temp1 = 5;
	 break;
       case '6':
	 temp1 = 6;
	 break;
       case '7':
	 temp1 = 7;
	 break;
       case '8':
	 temp1 = 8;
	 break;
       case '9':
	 temp1 = 9;
	 break;
       default:
	 temp1 = 0;
	 break;
      }
      to_int_return = temp1 + temp2 + temp3;
   }
   else if(length == 4){
      switch(temp[0]){
       case '0':
	 temp4 = 0;
	 break;
       case '1':
	 temp4 = 1000;
	 break;
       case '2':
	 temp4 = 2000;
	 break;
       case '3':
	 temp4 = 3000;
	 break;
       case '4':
	 temp4 = 4000;
	 break;
       case '5':
	 temp4 = 5000;
	 break;
       case '6':
	 temp4 = 6000;
	 break;
       case '7':
	 temp4 = 7000;
	 break;
       case '8':
	 temp4 = 8000;
	 break;
       case '9':
	 temp4 = 9000;
	 break;
       default:
	 temp4 = 0;
	 break;
      }
      switch(temp[1]){
       case '0':
	 temp3 = 0;
	 break;
       case '1':
	 temp3 = 100;
	 break;
       case '2':
	 temp3 = 200;
	 break;
       case '3':
	 temp3 = 300;
	 break;
       case '4':
	 temp3 = 400;
	 break;
       case '5':
	 temp3 = 500;
	 break;
       case '6':
	 temp3 = 600;
	 break;
       case '7':
	 temp3 = 700;
	 break;
       case '8':
	 temp3 = 800;
	 break;
       case '9':
	 temp3 = 900;
	 break;
       default:
	 temp3 = 0;
	 break;
      }
      switch(temp[2]){
       case '0':
	 temp2 = 0;
	 break;
       case '1':
	 temp2 = 10;
	 break;
       case '2':
	 temp2 = 20;
	 break;
       case '3':
	 temp2 = 30;
	 break;
       case '4':
	 temp2 = 40;
	 break;
       case '5':
	 temp2 = 50;
	 break;
       case '6':
	 temp2 = 60;
	 break;
       case '7':
	 temp2 = 70;
	 break;
       case '8':
	 temp2 = 80;
	 break;
       case '9':
	 temp2 = 90;
	 break;
       default:
	 temp2 = 0;
	 break;
      }
      switch(temp[3]){
       case '0':
	 temp1 = 0;
	 break;
       case '1':
	 temp1 = 1;
	 break;
       case '2':
	 temp1 = 2;
	 break;
       case '3':
	 temp1 = 3;
	 break;
       case '4':
	 temp1 = 4;
	 break;
       case '5':
	 temp1 = 5;
	 break;
       case '6':
	 temp1 = 6;
	 break;
       case '7':
	 temp1 = 7;
	 break;
       case '8':
	 temp1 = 8;
	 break;
       case '9':
	 temp1 = 9;
	 break;
       default:
	 temp1 = 0;
	 break;
      }
      to_int_return = temp1 + temp2 + temp3 + temp4;
   }
   
   
   return 0;
}


int tbc_jedsettings(void)
{
   int quit = 0, quitb = 0, x = 19, y = 5, a = 0, b = 0, display1 = 1, display2 = 1, display3 = 1, timechk = 0, warned = 0, warned2 = 0, option = 1;
   char temp, temp2[80], cmd[41];
   clrscr();
   box_3d(4,2,72,21,1,1);
   ansipos(33,10);
   putcolor(0,'F');
   printf("Not Finished yet");
   ansipos(1,23);
   tbc_wait();
   return 0;
}


int tbc_muttsettings(void)
{
   int quit = 0, quitb = 0, x = 20, y = 4, a = 0, b = 0, display1 = 1, display2 = 1, display3 = 1, timechk = 0, warned = 0, warned2 = 0, option = 1, end = 0, word = 1, page = 1, loop = 0;
   char temp, temp2[80], cmd[41];
   struct mutt_conf mutt_orig;
   FILE *fp_muttrc, *fp_newrc;
   strcpy(temp2, user.homedir);
   strcat(temp2, ".muttrc");
   fp_muttrc = fopen(temp2, "r");
   strcpy(mutt_orig.c_default, "");
   strcpy(mutt_orig.c_hdrdefault, "");
   strcpy(mutt_orig.c_quoted, "");
   strcpy(mutt_orig.c_signature, "");
   strcpy(mutt_orig.c_header_from, "");
   strcpy(mutt_orig.c_header_subject, "");
   strcpy(mutt_orig.c_indicator, "");
   strcpy(mutt_orig.c_error, "");
   strcpy(mutt_orig.c_status, "");
   strcpy(mutt_orig.c_tree, "");
   strcpy(mutt_orig.c_body_url, "");
   strcpy(mutt_orig.c_body_mail, "");
   strcpy(mutt_orig.list1, "");
   strcpy(mutt_orig.list2, "");
   strcpy(mutt_orig.list3, "");
   strcpy(mutt_orig.list4, "");
   strcpy(mutt_orig.list5, "");
   strcpy(mutt_orig.list6, "");
   strcpy(mutt_orig.list7, "");
   strcpy(mutt_orig.list8, "");
   strcpy(mutt_orig.list9, "");
   strcpy(mutt_orig.list10, "");
   ansipos(1,23);printf("%-50s", "Checking for 'color default'...");
   quit = 0;
   a = 1;
   while(!quit){
      end = tbc_readline(fp_muttrc,a,2);
      if(end == -1){
	 strcpy(mutt_orig.c_default, "");
	 quit = 1;
	 continue;
      }
      if(!(strncasecmp(temp_buf, "color default", 13))){
	 quitb = 0;
	 b = 0;
	 while(!quitb){
	    if(temp_buf[b+14] == '\0'){
	       quitb = 1;
	       continue;
	    }
	    mutt_orig.c_default[b] = temp_buf[b+14];
	    b++;
	    
	 }
	 mutt_orig.c_default[b] = '\0';
	 quit = 1;
	 continue;
      }
      a++;
   }
   ansipos(1,23);printf("%-50s", "Checking for 'color hdrdefault'...");
   quit = 0;
   a = 1;
   while(!quit){
      end = tbc_readline(fp_muttrc,a,2);
      if(end == -1){
	 strcpy(mutt_orig.c_hdrdefault, "");
	 quit = 1;
	 continue;
      }
      if(!(strncasecmp(temp_buf, "color hdrdefault", 16))){
	 quitb = 0;
	 b = 0;
	 while(!quitb){
	    if(temp_buf[b+17] == '\0'){
	       quitb = 1;
	       continue;
	    }
	    mutt_orig.c_hdrdefault[b] = temp_buf[b+17];
	    b++;
	    
	 }
	 mutt_orig.c_hdrdefault[b] = '\0';
	 quit = 1;
	 continue;
      }
      a++;
   }
   ansipos(1,23);printf("%-50s", "Checking for 'color quoted'...");
   quit = 0;
   a = 1;
   while(!quit){
      end = tbc_readline(fp_muttrc,a,2);
      if(end == -1){
	 strcpy(mutt_orig.c_quoted, "");
	 quit = 1;
	 continue;
      }
      if(!(strncasecmp(temp_buf, "color quoted", 12))){
	 quitb = 0;
	 b = 0;
	 while(!quitb){
	    if(temp_buf[b+13] == '\0'){
	       quitb = 1;
	       continue;
	    }
	    mutt_orig.c_quoted[b] = temp_buf[b+13];
	    b++;
	    
	 }
	 mutt_orig.c_quoted[b] = '\0';
	 quit = 1;
	 continue;
      }
      a++;
   }
   ansipos(1,23);printf("%-50s", "Checking for 'color signature'...");
   quit = 0;
   a = 1;
   while(!quit){
      end = tbc_readline(fp_muttrc,a,2);
      if(end == -1){
	 strcpy(mutt_orig.c_signature, "");
	 quit = 1;
	 continue;
      }
      if(!(strncasecmp(temp_buf, "color signature", 15))){
	 quitb = 0;
	 b = 0;
	 while(!quitb){
	    if(temp_buf[b+16] == '\0'){
	       quitb = 1;
	       continue;
	    }
	    mutt_orig.c_signature[b] = temp_buf[b+16];
	    b++;
	    
	 }
	 mutt_orig.c_signature[b] = '\0';
	 quit = 1;
	 continue;
      }
      a++;
   }
   ansipos(1,23);printf("%-50s", "Checking for 'color header  From:'...");
   quit = 0;
   a = 1;
   while(!quit){
      end = tbc_readline(fp_muttrc,a,2);
      if(end == -1){
	 strcpy(mutt_orig.c_header_from, "");
	 quit = 1;
	 continue;
      }
      if(!(strncasecmp(temp_buf, "color header", 12)) && temp_buf[strlen(temp_buf) - 6] == '^' && temp_buf[strlen(temp_buf) - 5] == 'F' && temp_buf[strlen(temp_buf) - 4] == 'r' && temp_buf[strlen(temp_buf) - 3] == 'o' && temp_buf[strlen(temp_buf) - 2] == 'm' && temp_buf[strlen(temp_buf) - 1] == ':' ){
	 quitb = 0;
	 b = 0;
	 word = 1;
	 while(!quitb){
	    if(temp_buf[b+13] == '\0' || temp_buf[b+13] == ' ' && word >= 2){
	       quitb = 1;
	       continue;
	    }
	    if(temp_buf[b+13] == ' ' && word < 2){
	       word++;
	    }
	    mutt_orig.c_header_from[b] = temp_buf[b+13];
	    b++;
	    
	 }
	 mutt_orig.c_header_from[b] = '\0';
	 quit = 1;
	 continue;
      }
      a++;
   }
   ansipos(1,23);printf("%-50s", "Checking for 'color header  Subject:'...");
   quit = 0;
   a = 1;
   while(!quit){
      end = tbc_readline(fp_muttrc,a,2);
      if(end == -1){
	 strcpy(mutt_orig.c_header_subject, "");
	 quit = 1;
	 continue;
      }
      if(!(strncasecmp(temp_buf, "color header", 12)) && temp_buf[strlen(temp_buf) - 9] == '^' && temp_buf[strlen(temp_buf) - 8] == 'S' && temp_buf[strlen(temp_buf) - 7] == 'u' && temp_buf[strlen(temp_buf) - 6] == 'b' && temp_buf[strlen(temp_buf) - 5] == 'j' && temp_buf[strlen(temp_buf) - 4] == 'e' && temp_buf[strlen(temp_buf) - 3] == 'c' && temp_buf[strlen(temp_buf) - 2] == 't' && temp_buf[strlen(temp_buf) - 1] == ':' ){
	 quitb = 0;
	 b = 0;
	 word = 1;
	 while(!quitb){
	    if(temp_buf[b+13] == '\0' || temp_buf[b+13] == ' ' && word >= 2){
	       quitb = 1;
	       continue;
	    }
	    if(temp_buf[b+13] == ' ' && word < 2){
	       word++;
	    }
	    mutt_orig.c_header_subject[b] = temp_buf[b+13];
	    b++;
	    
	 }
	 mutt_orig.c_header_subject[b] = '\0';
	 quit = 1;
	 continue;
      }
      a++;
   }
   ansipos(1,23);printf("%-50s", "Checking for 'color indicator'...");
   quit = 0;
   a = 1;
   while(!quit){
      end = tbc_readline(fp_muttrc,a,2);
      if(end == -1){
	 strcpy(mutt_orig.c_indicator, "");
	 quit = 1;
	 continue;
      }
      if(!(strncasecmp(temp_buf, "color indicator", 15))){
	 quitb = 0;
	 b = 0;
	 while(!quitb){
	    if(temp_buf[b+16] == '\0'){
	       quitb = 1;
	       continue;
	    }
	    mutt_orig.c_indicator[b] = temp_buf[b+16];
	    b++;
	    
	 }
	 mutt_orig.c_indicator[b] = '\0';
	 quit = 1;
	 continue;
      }
      a++;
   }
   ansipos(1,23);printf("%-50s", "Checking for 'color error'...");
   quit = 0;
   a = 1;
   while(!quit){
      end = tbc_readline(fp_muttrc,a,2);
      if(end == -1){
	 strcpy(mutt_orig.c_error, "");
	 quit = 1;
	 continue;
      }
      if(!(strncasecmp(temp_buf, "color error", 11))){
	 quitb = 0;
	 b = 0;
	 while(!quitb){
	    if(temp_buf[b+12] == '\0'){
	       quitb = 1;
	       continue;
	    }
	    mutt_orig.c_error[b] = temp_buf[b+12];
	    b++;
	    
	 }
	 mutt_orig.c_error[b] = '\0';
	 quit = 1;
	 continue;
      }
      a++;
   }
   ansipos(1,23);printf("%-50s", "Checking for 'color status'...");
   quit = 0;
   a = 1;
   while(!quit){
      end = tbc_readline(fp_muttrc,a,2);
      if(end == -1){
	 strcpy(mutt_orig.c_status, "");
	 quit = 1;
	 continue;
      }
      if(!(strncasecmp(temp_buf, "color status", 12))){
	 quitb = 0;
	 b = 0;
	 while(!quitb){
	    if(temp_buf[b+13] == '\0'){
	       quitb = 1;
	       continue;
	    }
	    mutt_orig.c_status[b] = temp_buf[b+13];
	    b++;
	    
	 }
	 mutt_orig.c_status[b] = '\0';
	 quit = 1;
	 continue;
      }
      a++;
   }
   ansipos(1,23);printf("%-50s", "Checking for 'color tree'...");
   quit = 0;
   a = 1;
   while(!quit){
      end = tbc_readline(fp_muttrc,a,2);
      if(end == -1){
	 strcpy(mutt_orig.c_tree, "");
	 quit = 1;
	 continue;
      }
      if(!(strncasecmp(temp_buf, "color tree", 10))){
	 quitb = 0;
	 b = 0;
	 while(!quitb){
	    if(temp_buf[b+11] == '\0'){
	       quitb = 1;
	       continue;
	    }
	    mutt_orig.c_tree[b] = temp_buf[b+11];
	    b++;
	    
	 }
	 mutt_orig.c_tree[b] = '\0';
	 quit = 1;
	 continue;
      }
      a++;
   }
   ansipos(1,23);printf("%-50s", "Checking for 'color body  URL'...");
   quit = 0;
   a = 1;
   while(!quit){
      end = tbc_readline(fp_muttrc,a,2);
      if(end == -1){
	 strcpy(mutt_orig.c_body_url, "");
	 quit = 1;
	 continue;
      }
      if(!(strncasecmp(temp_buf, "color body", 10)) && strlen(temp_buf) > 33 && temp_buf[strlen(temp_buf) - 32] == '(' && temp_buf[strlen(temp_buf) - 31] == 'h' && temp_buf[strlen(temp_buf) - 30] == 't' && temp_buf[strlen(temp_buf) - 29] == 't' && temp_buf[strlen(temp_buf) - 28] == 'p' && temp_buf[strlen(temp_buf) - 27] == '|' && temp_buf[strlen(temp_buf) - 26] == 'f' && temp_buf[strlen(temp_buf) - 25] == 't' && temp_buf[strlen(temp_buf) - 24] == 'p' && temp_buf[strlen(temp_buf) - 23] == ')' ){
	 quitb = 0;
	 b = 0;
	 word = 1;
	 while(!quitb){
	    if(temp_buf[b+11] == '\0' || temp_buf[b+11] == ' ' && word >= 2){
	       quitb = 1;
	       continue;
	    }
	    if(temp_buf[b+11] == ' ' && word < 2){
	       word++;
	    }
	    mutt_orig.c_body_url[b] = temp_buf[b+11];
	    b++;
	    
	 }
	 mutt_orig.c_body_url[b] = '\0';
	 quit = 1;
	 continue;
      }
      a++;
   }
   ansipos(1,23);printf("%-50s", "Checking for 'color body  E-MAIL'...");
   quit = 0;
   a = 1;
   while(!quit){
      end = tbc_readline(fp_muttrc,a,2);
      if(end == -1){
	 strcpy(mutt_orig.c_body_mail, "");
	 quit = 1;
	 continue;
      }
      if(!(strncasecmp(temp_buf, "color body", 10)) && strlen(temp_buf) > 33 && temp_buf[strlen(temp_buf) - 18] == '@'){
	 quitb = 0;
	 b = 0;
	 word = 1;
	 while(!quitb){
	    if(temp_buf[b+11] == '\0' || temp_buf[b+11] == ' ' && word >= 2){
	       quitb = 1;
	       continue;
	    }
	    if(temp_buf[b+11] == ' ' && word < 2){
	       word++;
	    }
	    mutt_orig.c_body_mail[b] = temp_buf[b+11];
	    b++;
	    
	 }
	 mutt_orig.c_body_mail[b] = '\0';
	 quit = 1;
	 continue;
      }
      a++;
   }
   fclose(fp_muttrc);
   page = 1;
   loop = 0;
   while (!loop){
      switch(page){
       case 1:
	 quit = 0;
	 strcpy(temp2, mutt_orig.c_default);
	 x = 20;
	 y = 4;
	 display1 = 1;
	 display2 = 1;
	 while(!quit){
	    if(display1){
	       putcolor('0','F');
	       clrscr();
	       box_3d(4,2,72,21,1,1);
	       box_3d(19,3,20,3,1,1);
	       box_3d(19,6,20,3,1,1);
	       box_3d(19,9,20,3,1,1);
	       box_3d(19,12,20,3,1,1);
	       box_3d(19,15,20,3,1,1);
	       box_3d(19,18,20,3,1,1);
	       box_3d(54,3,20,3,1,1);
	       box_3d(54,6,20,3,1,1);
	       box_3d(54,9,20,3,1,1);
	       box_3d(54,12,20,3,1,1);
	       box_3d(54,15,20,3,1,1);
	       box_3d(54,18,20,3,1,1);
	       putcolor('0','F');
	       ansipos(35,1);printf("Color Settings");
	       putcolor('1','F');
	       ansipos(6,4);printf("Default");
	       ansipos(6,7);printf("Header");
	       ansipos(6,10);printf("From");
	       ansipos(6,13);printf("Subject");
	       ansipos(6,16);printf("Signature");
	       ansipos(6,19);printf("URLs");
	       ansipos(41,4);printf("E-Mail Addrs");
	       ansipos(41,7);printf("Quotes");
	       ansipos(41,10);printf("Message Tree");
	       ansipos(41,13);printf("Indicator");
	       ansipos(41,16);printf("Statusbar");
	       ansipos(41,19);printf("Error Msgs");
	       ansipos(10,21);printf("(Q)uit     (N)ext Page      (P)revious Page     (H)elp");
	       ansipos(20,4);printf("%-18s",mutt_orig.c_default);
	       ansipos(20,7);printf("%-18s",mutt_orig.c_hdrdefault);
	       ansipos(20,10);printf("%-18s",mutt_orig.c_header_from);
	       ansipos(20,13);printf("%-18s",mutt_orig.c_header_subject);
	       ansipos(20,16);printf("%-18s",mutt_orig.c_signature);
	       ansipos(20,19);printf("%-18s",mutt_orig.c_body_url);
	       ansipos(55,4);printf("%-18s",mutt_orig.c_body_mail);
	       ansipos(55,7);printf("%-18s",mutt_orig.c_quoted);
	       ansipos(55,10);printf("%-18s",mutt_orig.c_tree);
	       ansipos(55,13);printf("%-18s",mutt_orig.c_indicator);
	       ansipos(55,16);printf("%-18s",mutt_orig.c_status);
	       ansipos(55,19);printf("%-18s",mutt_orig.c_error);
	       display1 = 0;
	       display2 = 1;
	    }
	    if(display2){
	       ansipos(x,y);
	       putcolor('3','F');
	       printf("%-18s",temp2);
	       display2 = 0;
	    }
	    temp = tolower(getchar());
	    if(temp != EOF){
	       linenum = 1;
	       if(temp == 'a'){
		  ansipos(x,y);
		  putcolor('1','F');
		  printf("%-18s",temp2);
		  if(option == 1){
		     option = 12;
		     x = 55;
		     y = 19;
		     strcpy(temp2, mutt_orig.c_error);
		  }
		  else if(option == 2){
		     option = 1;
		     x = 20;
		     y = 4;
		     strcpy(temp2, mutt_orig.c_default);
		  }
		  else if(option == 3){
		     option = 2;
		     x = 20;
		     y = 7;
		     strcpy(temp2, mutt_orig.c_hdrdefault);
		  }
		  else if(option == 4){
		     option = 3;
		     x = 20;
		     y = 10;
		     strcpy(temp2, mutt_orig.c_header_from);
		  }
		  else if(option == 5){
		     option = 4;
		     x = 20;
		     y = 13;
		     strcpy(temp2, mutt_orig.c_header_subject);
		  }
		  else if(option == 6){
		     option = 5;
		     x = 20;
		     y = 16;
		     strcpy(temp2, mutt_orig.c_signature);
		  }
		  else if(option == 7){
		     option = 6;
		     x = 20;
		     y = 19;
		     strcpy(temp2, mutt_orig.c_body_url);
		  }
		  else if(option == 8){
		     option = 7;
		     x = 55;
		     y = 4;
		     strcpy(temp2, mutt_orig.c_body_mail);
		  }
		  else if(option == 9){
		     option = 8;
		     x = 55;
		     y = 7;
		     strcpy(temp2, mutt_orig.c_quoted);
		  }
		  else if(option == 10){
		     option = 9;
		     x = 55;
		     y = 10;
		     strcpy(temp2, mutt_orig.c_tree);
		  }
		  else if(option == 11){
		     option = 10;
		     x = 55;
		     y = 13;
		     strcpy(temp2, mutt_orig.c_indicator);
		  }
		  else if(option == 12){
		     option = 11;
		     x = 55;
		     y = 16;
		     strcpy(temp2, mutt_orig.c_status);
		  }
		  
		  display2 = 1;
	       }
	       if(temp == 'b'){
		  ansipos(x,y);
		  putcolor('1','F');
		  printf("%-18s",temp2);
		  if(option == 6){
		     option = 7;
		     x = 55;
		     y = 4;
		     strcpy(temp2, mutt_orig.c_body_mail);
		  }
		  else if(option == 7){
		     option = 8;
		     x = 55;
		     y = 7;
		     strcpy(temp2, mutt_orig.c_quoted);
		  }
		  else if(option == 8){
		     option = 9;
		     x = 55;
		     y = 10;
		     strcpy(temp2, mutt_orig.c_tree);
		  }
		  else if(option == 9){
		     option = 10;
		     x = 55;
		     y = 13;
		     strcpy(temp2, mutt_orig.c_indicator);
		  }
		  else if(option == 10){
		     option = 11;
		     x = 55;
		     y = 16;
		     strcpy(temp2, mutt_orig.c_status);
		  }
		  else if(option == 11){
		     option = 12;
		     x = 55;
		     y = 19;
		     strcpy(temp2, mutt_orig.c_error);
		  }
		  else if(option == 12){
		     option = 1;
		     x = 20;
		     y = 4;
		     strcpy(temp2, mutt_orig.c_default);
		  }
		  else if(option == 1){
		     option = 2;
		     x = 20;
		     y = 7;
		     strcpy(temp2, mutt_orig.c_hdrdefault);
		  }
		  else if(option == 2){
		     option = 3;
		     x = 20;
		     y = 10;
		     strcpy(temp2, mutt_orig.c_header_from);
		  }
		  else if(option == 3){
		     option = 4;
		     x = 20;
		     y = 13;
		     strcpy(temp2, mutt_orig.c_header_subject);
		  }
		  else if(option == 4){
		     option = 5;
		     x = 20;
		     y = 16;
		     strcpy(temp2, mutt_orig.c_signature);
		  }
		  else if(option == 5){
		     option = 6;
		     x = 20;
		     y = 19;
		     strcpy(temp2, mutt_orig.c_body_url);
		  }
		  
		  display2 = 1;
	       }
	       else if(temp == '\n'){
		  ansipos(x,y);
		  putcolor('1','F');
		  if(option == 1){
		     get_input(mutt_orig.c_default,18,0,1,1,0,0);
		     strcpy(temp2, mutt_orig.c_default);
		     display2 = 1;
		  }
		  if(option == 2){
		     get_input(mutt_orig.c_hdrdefault,18,0,1,1,0,0);
		     strcpy(temp2, mutt_orig.c_hdrdefault);
		     display2 = 1;
		  }
		  if(option == 3){
		     get_input(mutt_orig.c_header_from,18,0,1,1,0,0);
		     strcpy(temp2, mutt_orig.c_header_from);
		     display2 = 1;
		  }
		  if(option == 4){
		     get_input(mutt_orig.c_header_subject,18,0,1,1,0,0);
		     strcpy(temp2, mutt_orig.c_header_subject);
		     display2 = 1;
		  }
		  if(option == 5){
		     get_input(mutt_orig.c_signature,18,0,1,1,0,0);
		     strcpy(temp2, mutt_orig.c_signature);
		     display2 = 1;
		  }
		  if(option == 6){
		     get_input(mutt_orig.c_body_url,18,0,1,1,0,0);
		     strcpy(temp2, mutt_orig.c_body_url);
		     display2 = 1;
		  }
		  if(option == 7){
		     get_input(mutt_orig.c_body_mail,18,0,1,1,0,0);
		     strcpy(temp2, mutt_orig.c_body_mail);
		     display2 = 1;
		  }
		  if(option == 8){
		     get_input(mutt_orig.c_quoted,18,0,1,1,0,0);
		     strcpy(temp2, mutt_orig.c_quoted);
		     display2 = 1;
		  }
		  if(option == 9){
		     get_input(mutt_orig.c_tree,18,0,1,1,0,0);
		     strcpy(temp2, mutt_orig.c_tree);
		     display2 = 1;
		  }
		  if(option == 10){
		     get_input(mutt_orig.c_indicator,18,0,1,1,0,0);
		     strcpy(temp2, mutt_orig.c_indicator);
		     display2 = 1;
		  }
		  if(option == 11){
		     get_input(mutt_orig.c_status,18,0,1,1,0,0);
		     strcpy(temp2, mutt_orig.c_status);
		     display2 = 1;
		  }
		  if(option == 12){
		     get_input(mutt_orig.c_error,18,0,1,1,0,0);
		     strcpy(temp2, mutt_orig.c_error);
		     display2 = 1;
		  }
		  else{
		     display2 = 1;
		  }
	       }
	       else if(temp == 'h'){
		  box_3d(7,4,65,18,3,1);
		  putcolor(0,'F');
		  ansipos(20,5);printf("Help on Setting up Colors for Mutt");
		  ansipos(9,7);printf("On this screen you must enter the colors you want displayed in");
		  ansipos(9,8);printf("the mail program Mutt.  You must enter them as:");
		  putcolor(0,'E');
		  ansipos(9,10);printf("            <foreground color> <background color>");
		  putcolor(0,'F');
		  ansipos(9,12);printf("These are the valid colors:");
		  putcolor(0,'E');
		  ansipos(9,14);printf("               white                   blue");
		  ansipos(9,15);printf("               black                   cyan");
		  ansipos(9,16);printf("               green                   yellow");
		  ansipos(9,17);printf("               magenta                 red");
		  putcolor(0,'F');
		  ansipos(9,19);printf("You can add the prefix 'bright' to the foreground colors");
		  ansipos(9,20);printf("All colors must be entered in lowercase");
		  putcolor(0,'E');
		  ansipos(33,21);printf(" Hit Any Key ");
		  quitb = 0;
		  while(!quitb){
		     temp = tolower(getchar());
		     if(temp != EOF){
			quitb = 1;
		     }
		  }
		  display1 = 1;
	       }
	       else if(temp == 'n'){
		  page = 2;
		  quit = 1;
	       }
	       else if(temp == 'p'){
		  page = 3;
		  quit = 1;
	       }
	       else if(temp == 'q'){
		  ansipos(1,23);
		  disp_prompt(69);
		  if(tbc_getyn()){
		     strcpy(temp2, user.homedir);
		     strcat(temp2, ".muttrc");
		     fp_newrc = fopen(temp2, "w");
		     fputs("# File Created by The Board on ", fp_newrc);
		     time(&cur_time2);
		     fputs(ctime(&cur_time2), fp_newrc);
		     fputc('\n', fp_newrc);
		     fputc('\n', fp_newrc);
		     fputs("ignore \"from \" received content- mime-version status x-status message-id\n", fp_newrc);
		     fputs("ignore sender references return-path lines\n", fp_newrc);
		     fputs("ignore x-warning x-mime-autoconverted\n", fp_newrc);
		     fputc('\n', fp_newrc);
		     fputs("macro index \\eb '/~b '\n", fp_newrc);
		     fputs("macro index \\cb |urlview\\n\n", fp_newrc);
		     fputs("macro pager \\cb |urlview\\n\n", fp_newrc);
		     fputc('\n', fp_newrc);
		     fputs("set hostname=theboard.dyn.ml.org\n", fp_newrc);
		     fputs("set use_8bitmime\n", fp_newrc);
		     fputs("set abort_nosubject=ask-yes\n", fp_newrc);
		     fputs("set abort_unmodified=yes\n", fp_newrc);
		     fputs("set allow_8bit\n", fp_newrc);
		     fputs("set attribution=\"On \%d, \%n wrote:\"\n", fp_newrc);
		     fputs("set auto_tag\n", fp_newrc);
		     fputs("set beep\n", fp_newrc);
		     fputs("set beep_new\n", fp_newrc);
		     fputs("set check_new\n", fp_newrc);
		     fputs("unset confirmappend\n", fp_newrc);
		     fputs("set confirmcreate\n", fp_newrc);
		     fputs("set copy=yes\n", fp_newrc);
		     fputs("set delete=ask-yes\n", fp_newrc);
		     fputs("set editor=\"jed\"\n", fp_newrc);
		     fputs("set folder=\"~/.muttmail\"\n", fp_newrc);
		     fputs("set force_name\n", fp_newrc);
		     fputs("set help\n", fp_newrc);
		     fputs("set ispell=\"/usr/bin/ispell\"\n", fp_newrc);
		     fputs("set mail_check=5\n", fp_newrc);
		     fputs("set mbox=\"=mbox\"\n", fp_newrc);
		     fputs("set move=ask-yes\n", fp_newrc);
		     fputs("set pager_index_lines=6\n", fp_newrc);
		     fputs("set pager_stop\n", fp_newrc);
		     fputs("set quit=ask-yes\n", fp_newrc);
		     fputs("set sendmail=\"/usr/sbin/sendmail -oem -io\"\n", fp_newrc);
		     fputs("set signature=\"~./.signature\"\n", fp_newrc);
		     fputs("set sort=threads\n", fp_newrc);
		     fputc('\n', fp_newrc);
		     if(strcmp(mutt_orig.c_default, "")){
			fputs("color default ", fp_newrc);
			fputs(mutt_orig.c_default, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_hdrdefault, "")){
			fputs("color hdrdefault ", fp_newrc);
			fputs(mutt_orig.c_hdrdefault, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_quoted, "")){
			fputs("color quoted ", fp_newrc);
			fputs(mutt_orig.c_quoted, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_signature, "")){
			fputs("color signature ", fp_newrc);
			fputs(mutt_orig.c_signature, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_header_from, "")){
			fputs("color header ", fp_newrc);
			fputs(mutt_orig.c_header_from, fp_newrc);
			fputs(" ^From:", fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_header_subject, "")){
			fputs("color header ", fp_newrc);
			fputs(mutt_orig.c_header_subject, fp_newrc);
			fputs(" ^Subject:", fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_indicator, "")){
			fputs("color indicator ", fp_newrc);
			fputs(mutt_orig.c_indicator, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_error, "")){
			fputs("color error ", fp_newrc);
			fputs(mutt_orig.c_error, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_status, "")){
			fputs("color status ", fp_newrc);
			fputs(mutt_orig.c_status, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_tree, "")){
			fputs("color tree ", fp_newrc);
			fputs(mutt_orig.c_tree, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_body_url, "")){
			fputs("color body ", fp_newrc);
			fputs(mutt_orig.c_body_url, fp_newrc);
			fputs(" (http|ftp)://[_a-zA-Z0-9\\./~\\-]+", fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_body_mail, "")){
			fputs("color body ", fp_newrc);
			fputs(mutt_orig.c_body_mail, fp_newrc);
			fputs(" [a-z\\.\\$A-Z0-9-]+@[a-zA-Z0-9\\./\\-]+", fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     fputc('\n', fp_newrc);
		     fputs("# End of File\n", fp_newrc);
		     fclose(fp_newrc);
		  }
		  quit = 1;
		  loop = 1;
	       }
	    }
	 }
	 break;
       case 2:
	 quit = 0;
	 x = 20;
	 y = 4;
	 display1 = 1;
	 display2 = 1;
	 strcpy(temp2, mutt_orig.c_default);
	 while(!quit){
	    if(display1){
	       putcolor('0','F');
	       clrscr();
	       box_3d(4,2,72,21,1,1);
	       putcolor('0','F');
	       ansipos(35,1);printf("Page 2");
	       putcolor('1','F');
	       ansipos(10,21);printf("(Q)uit     (N)ext Page      (P)revious Page     (H)elp");
	       putcolor('1','F');
	       display1 = 0;
	       display2 = 1;
	    }
	    if(display2){
	       ansipos(x,y);
	       putcolor('3','F');
	       printf("%-18s",temp2);
	       display2 = 0;
	    }
	    temp = tolower(getchar());
	    if(temp != EOF){
	       if(temp == 'h'){
		  box_3d(7,4,65,18,3,1);
		  putcolor(0,'F');
		  ansipos(20,5);printf("Help on Setting up Page 2 for Mutt");
		  ansipos(9,12);printf("                      No Help Yet");
		  putcolor(0,'E');
		  ansipos(33,21);printf(" Hit Any Key ");
		  quitb = 0;
		  while(!quitb){
		     temp = tolower(getchar());
		     if(temp != EOF){
			quitb = 1;
		     }
		  }
		  display1 = 1;
	       }
	       else if(temp == 'n'){
		  page = 3;
		  quit = 1;
	       }
	       else if(temp == 'p'){
		  page = 1;
		  quit = 1;
	       }
	       else if(temp == 'q'){
		  ansipos(1,23);
		  disp_prompt(69);
		  if(tbc_getyn()){
		     strcpy(temp2, user.homedir);
		     strcat(temp2, ".muttrc");
		     fp_newrc = fopen(temp2, "w");
		     fputs("# File Created by The Board on ", fp_newrc);
		     time(&cur_time2);
		     fputs(ctime(&cur_time2), fp_newrc);
		     fputc('\n', fp_newrc);
		     fputc('\n', fp_newrc);
		     fputs("ignore \"from \" received content- mime-version status x-status message-id\n", fp_newrc);
		     fputs("ignore sender references return-path lines\n", fp_newrc);
		     fputs("ignore x-warning x-mime-autoconverted\n", fp_newrc);
		     fputc('\n', fp_newrc);
		     fputs("macro index \\eb '/~b '\n", fp_newrc);
		     fputs("macro index \\cb |urlview\\n\n", fp_newrc);
		     fputs("macro pager \\cb |urlview\\n\n", fp_newrc);
		     fputc('\n', fp_newrc);
		     fputs("set hostname=theboard.dyn.ml.org\n", fp_newrc);
		     fputs("set use_8bitmime\n", fp_newrc);
		     fputs("set abort_nosubject=ask-yes\n", fp_newrc);
		     fputs("set abort_unmodified=yes\n", fp_newrc);
		     fputs("set allow_8bit\n", fp_newrc);
		     fputs("set attribution=\"On \%d, \%n wrote:\"\n", fp_newrc);
		     fputs("set auto_tag\n", fp_newrc);
		     fputs("set beep\n", fp_newrc);
		     fputs("set beep_new\n", fp_newrc);
		     fputs("set check_new\n", fp_newrc);
		     fputs("unset confirmappend\n", fp_newrc);
		     fputs("set confirmcreate\n", fp_newrc);
		     fputs("set copy=yes\n", fp_newrc);
		     fputs("set delete=ask-yes\n", fp_newrc);
		     fputs("set editor=\"jed\"\n", fp_newrc);
		     fputs("set folder=\"~/.muttmail\"\n", fp_newrc);
		     fputs("set force_name\n", fp_newrc);
		     fputs("set help\n", fp_newrc);
		     fputs("set ispell=\"/usr/bin/ispell\"\n", fp_newrc);
		     fputs("set mail_check=5\n", fp_newrc);
		     fputs("set mbox=\"=mbox\"\n", fp_newrc);
		     fputs("set move=ask-yes\n", fp_newrc);
		     fputs("set pager_index_lines=6\n", fp_newrc);
		     fputs("set pager_stop\n", fp_newrc);
		     fputs("set quit=ask-yes\n", fp_newrc);
		     fputs("set sendmail=\"/usr/sbin/sendmail -oem -io\"\n", fp_newrc);
		     fputs("set signature=\"~./.signature\"\n", fp_newrc);
		     fputs("set sort=threads\n", fp_newrc);
		     fputc('\n', fp_newrc);
		     if(strcmp(mutt_orig.c_default, "")){
			fputs("color default ", fp_newrc);
			fputs(mutt_orig.c_default, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_hdrdefault, "")){
			fputs("color hdrdefault ", fp_newrc);
			fputs(mutt_orig.c_hdrdefault, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_quoted, "")){
			fputs("color quoted ", fp_newrc);
			fputs(mutt_orig.c_quoted, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_signature, "")){
			fputs("color signature ", fp_newrc);
			fputs(mutt_orig.c_signature, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_header_from, "")){
			fputs("color header ", fp_newrc);
			fputs(mutt_orig.c_header_from, fp_newrc);
			fputs(" ^From:", fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_header_subject, "")){
			fputs("color header ", fp_newrc);
			fputs(mutt_orig.c_header_subject, fp_newrc);
			fputs(" ^Subject:", fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_indicator, "")){
			fputs("color indicator ", fp_newrc);
			fputs(mutt_orig.c_indicator, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_error, "")){
			fputs("color error ", fp_newrc);
			fputs(mutt_orig.c_error, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_status, "")){
			fputs("color status ", fp_newrc);
			fputs(mutt_orig.c_status, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_tree, "")){
			fputs("color tree ", fp_newrc);
			fputs(mutt_orig.c_tree, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_body_url, "")){
			fputs("color body ", fp_newrc);
			fputs(mutt_orig.c_body_url, fp_newrc);
			fputs(" (http|ftp)://[_a-zA-Z0-9\\./~\\-]+", fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_body_mail, "")){
			fputs("color body ", fp_newrc);
			fputs(mutt_orig.c_body_mail, fp_newrc);
			fputs(" [a-z\\.\\$A-Z0-9-]+@[a-zA-Z0-9\\./\\-]+", fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     fputc('\n', fp_newrc);
		     fputs("# End of File\n", fp_newrc);
		     fclose(fp_newrc);
		  }
		  quit = 1;
		  loop = 1;
	       }
	    }
	 }
	 break;
       case 3:
	 quit = 0;
	 x = 20;
	 y = 4;
	 display1 = 1;
	 display2 = 1;
	 strcpy(temp2, mutt_orig.c_default);
	 while(!quit){
	    if(display1){
	       putcolor('0','F');
	       clrscr();
	       box_3d(4,2,72,21,1,1);
	       putcolor('0','F');
	       ansipos(35,1);printf("Page 3");
	       putcolor('1','F');
	       ansipos(10,21);printf("(Q)uit     (N)ext Page      (P)revious Page     (H)elp");
	       display1 = 0;
	       display2 = 1;
	    }
	    if(display2){
	       ansipos(x,y);
	       putcolor('3','F');
	       printf("%-18s",temp2);
	       display2 = 0;
	    }
	    temp = tolower(getchar());
	    if(temp != EOF){
	       if(temp == 'h'){
		  box_3d(7,4,65,18,3,1);
		  putcolor(0,'F');
		  ansipos(20,5);printf("Help on Setting Page 3 for Mutt");
		  putcolor(0,'F');
		  ansipos(9,12);printf("                        No Help Yet");
		  putcolor(0,'E');
		  ansipos(33,21);printf(" Hit Any Key ");
		  quitb = 0;
		  while(!quitb){
		     temp = tolower(getchar());
		     if(temp != EOF){
			quitb = 1;
		     }
		  }
		  display1 = 1;
	       }
	       else if(temp == 'n'){
		  page = 1;
		  quit = 1;
	       }
	       else if(temp == 'p'){
		  page = 2;
		  quit = 1;
	       }
	       else if(temp == 'q'){
		  ansipos(1,23);
		  disp_prompt(69);
		  if(tbc_getyn()){
		     strcpy(temp2, user.homedir);
		     strcat(temp2, ".muttrc");
		     fp_newrc = fopen(temp2, "w");
		     fputs("# File Created by The Board on ", fp_newrc);
		     time(&cur_time2);
		     fputs(ctime(&cur_time2), fp_newrc);
		     fputc('\n', fp_newrc);
		     fputc('\n', fp_newrc);
		     fputs("ignore \"from \" received content- mime-version status x-status message-id\n", fp_newrc);
		     fputs("ignore sender references return-path lines\n", fp_newrc);
		     fputs("ignore x-warning x-mime-autoconverted\n", fp_newrc);
		     fputc('\n', fp_newrc);
		     fputs("macro index \\eb '/~b '\n", fp_newrc);
		     fputs("macro index \\cb |urlview\\n\n", fp_newrc);
		     fputs("macro pager \\cb |urlview\\n\n", fp_newrc);
		     fputc('\n', fp_newrc);
		     fputs("set hostname=theboard.dyn.ml.org\n", fp_newrc);
		     fputs("set use_8bitmime\n", fp_newrc);
		     fputs("set abort_nosubject=ask-yes\n", fp_newrc);
		     fputs("set abort_unmodified=yes\n", fp_newrc);
		     fputs("set allow_8bit\n", fp_newrc);
		     fputs("set attribution=\"On \%d, \%n wrote:\"\n", fp_newrc);
		     fputs("set auto_tag\n", fp_newrc);
		     fputs("set beep\n", fp_newrc);
		     fputs("set beep_new\n", fp_newrc);
		     fputs("set check_new\n", fp_newrc);
		     fputs("unset confirmappend\n", fp_newrc);
		     fputs("set confirmcreate\n", fp_newrc);
		     fputs("set copy=yes\n", fp_newrc);
		     fputs("set delete=ask-yes\n", fp_newrc);
		     fputs("set editor=\"jed\"\n", fp_newrc);
		     fputs("set folder=\"~/.muttmail\"\n", fp_newrc);
		     fputs("set force_name\n", fp_newrc);
		     fputs("set help\n", fp_newrc);
		     fputs("set ispell=\"/usr/bin/ispell\"\n", fp_newrc);
		     fputs("set mail_check=5\n", fp_newrc);
		     fputs("set mbox=\"=mbox\"\n", fp_newrc);
		     fputs("set move=ask-yes\n", fp_newrc);
		     fputs("set pager_index_lines=6\n", fp_newrc);
		     fputs("set pager_stop\n", fp_newrc);
		     fputs("set quit=ask-yes\n", fp_newrc);
		     fputs("set sendmail=\"/usr/sbin/sendmail -oem -io\"\n", fp_newrc);
		     fputs("set signature=\"~./.signature\"\n", fp_newrc);
		     fputs("set sort=threads\n", fp_newrc);
		     fputc('\n', fp_newrc);
		     if(strcmp(mutt_orig.c_default, "")){
			fputs("color default ", fp_newrc);
			fputs(mutt_orig.c_default, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_hdrdefault, "")){
			fputs("color hdrdefault ", fp_newrc);
			fputs(mutt_orig.c_hdrdefault, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_quoted, "")){
			fputs("color quoted ", fp_newrc);
			fputs(mutt_orig.c_quoted, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_signature, "")){
			fputs("color signature ", fp_newrc);
			fputs(mutt_orig.c_signature, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_header_from, "")){
			fputs("color header ", fp_newrc);
			fputs(mutt_orig.c_header_from, fp_newrc);
			fputs(" ^From:", fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_header_subject, "")){
			fputs("color header ", fp_newrc);
			fputs(mutt_orig.c_header_subject, fp_newrc);
			fputs(" ^Subject:", fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_indicator, "")){
			fputs("color indicator ", fp_newrc);
			fputs(mutt_orig.c_indicator, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_error, "")){
			fputs("color error ", fp_newrc);
			fputs(mutt_orig.c_error, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_status, "")){
			fputs("color status ", fp_newrc);
			fputs(mutt_orig.c_status, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_tree, "")){
			fputs("color tree ", fp_newrc);
			fputs(mutt_orig.c_tree, fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_body_url, "")){
			fputs("color body ", fp_newrc);
			fputs(mutt_orig.c_body_url, fp_newrc);
			fputs(" (http|ftp)://[_a-zA-Z0-9\\./~\\-]+", fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     if(strcmp(mutt_orig.c_body_mail, "")){
			fputs("color body ", fp_newrc);
			fputs(mutt_orig.c_body_mail, fp_newrc);
			fputs(" [a-z\\.\\$A-Z0-9-]+@[a-zA-Z0-9\\./\\-]+", fp_newrc);
			fputc('\n', fp_newrc);
		     }
		     fputc('\n', fp_newrc);
		     fputs("# End of File\n", fp_newrc);
		     fclose(fp_newrc);
		  }
		  quit = 1;
		  loop = 1;
	       }
	    }
	 }
	 break;
       default:
	 loop = 1;
	 break;
      }
   }
   return 0;
}


int tbc_lynxsettings(void)
{
   int quit = 0, quitb = 0, x = 19, y = 5, a = 0, b = 0, display1 = 1, display2 = 1, display3 = 1, timechk = 0, warned = 0, warned2 = 0, option = 1;
   char temp, temp2[80], cmd[41];
   clrscr();
   box_3d(4,2,72,21,1,1);
   ansipos(33,10);
   putcolor(0,'F');
   printf("Not Finished yet");
   ansipos(1,23);
   tbc_wait();
   return 0;
}


int tbc_psettings(void)
{
   int quit = 0, quitb = 0, x = 19, y = 5, a = 0, b = 0, display1 = 1, display2 = 1, display3 = 1, timechk = 0, warned = 0, warned2 = 0, option = 1;
   char temp, temp2[80], cmd[41];
   strcpy(temp2, user.fname);
   while(!quit){
      if(display1){
	 clrscr();
	 box_3d(4,2,72,21,1,1);
	 box_3d(17,4,22,3,1,1);
	 box_3d(51,4,22,3,1,1);
	 box_3d(17,7,53,3,1,1);
	 box_3d(17,10,22,3,1,1);
	 box_3d(51,10,22,3,1,1);
	 box_3d(17,13,15,3,1,1);
	 box_3d(17,16,25,3,1,1);
	 box_3d(55,13,16,3,1,1);
	 box_3d(55,16,16,3,1,1);
	 display1 = 0;
      }
      if(display2){
	 putcolor(0,'F');
	 ansipos(34,3); printf("User Settings");
	 ansipos(20,21); printf("Press <ENTER> to edit  Q to quit");
	 ansipos(6,5); printf("First Name");
	 ansipos(41,5); printf("Last Name");
	 ansipos(6,7); printf("Street");
	 ansipos(6,8); printf("Address");
	 ansipos(6,11); printf("City");
	 ansipos(41,11); printf("State");
	 ansipos(6,14); printf("Zip Code");
	 ansipos(6,17); printf("Country");
	 ansipos(43,14); printf("Home Phone");
	 ansipos(43,17); printf("Data Phone");
	 ansipos(19,5); printf("%s",user.fname);
	 ansipos(53,5); printf("%s",user.lname);
	 ansipos(19,8); printf("%s",user.saddress);
	 ansipos(19,11); printf("%s",user.city);
	 ansipos(53,11); printf("%s",user.state);
	 ansipos(19,14); printf("%s",user.zip);
	 ansipos(19,17); printf("%s",user.country);
	 ansipos(56,14); printf("%s",user.hphone);
	 ansipos(56,17); printf("%s",user.dphone);
	 display2 = 0;
      }
      if(display3){
	 ansipos(x,y);
	 putcolor('3','F');
	 printf("%s",temp2);
	 display3 = 0;
      }
      temp = tolower(getchar());
      if(temp != EOF){
	 linenum = 1;
	 if(temp == 'a'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option == 1){
	       option = 9;
	       x = 56;
	       y = 17;
	       strcpy(temp2, user.dphone);
	    }
	    else if(option == 2){
	       option = 1;
	       x = 19;
	       y = 5;
	       strcpy(temp2, user.fname);
	    }
	    else if(option == 3){
	       option = 2;
	       x = 53;
	       y = 5;
	       strcpy(temp2, user.lname);
	    }
	    else if(option == 4){
	       option = 3;
	       x = 19;
	       y = 8;
	       strcpy(temp2, user.saddress);
	    }
	    else if(option == 5){
	       option = 4;
	       x = 19;
	       y = 11;
	       strcpy(temp2, user.city);
	    }
	    else if(option == 6){
	       option = 5;
	       x = 53;
	       y = 11;
	       strcpy(temp2, user.state);
	    }
	    else if(option == 7){
	       option = 6;
	       x = 19;
	       y = 14;
	       strcpy(temp2, user.zip);
	    }
	    else if(option == 8){
	       option = 7;
	       x = 19;
	       y = 17;
	       strcpy(temp2, user.country);
	    }
	    else if(option == 9){
	       option = 8;
	       x = 56;
	       y = 14;
	       strcpy(temp2, user.hphone);
	    }
	    
	    display3 = 1;
	 }
	 if(temp == 'b'){
	    ansipos(x,y);
	    putcolor('1','F');
	    printf("%s",temp2);
	    if(option == 6){
	       option = 7;
	       x = 19;
	       y = 17;
	       strcpy(temp2, user.country);
	    }
	    else if(option == 7){
	       option = 8;
	       x = 56;
	       y = 14;
	       strcpy(temp2, user.hphone);
	    }
	    else if(option == 8){
	       option = 9;
	       x = 56;
	       y = 17;
	       strcpy(temp2, user.dphone);
	    }
	    else if(option == 9){
	       option = 1;
	       x = 19;
	       y = 5;
	       strcpy(temp2, user.fname);
	    }
	    else if(option == 1){
	       option = 2;
	       x = 53;
	       y = 5;
	       strcpy(temp2, user.lname);
	    }
	    else if(option == 2){
	       option = 3;
	       x = 19;
	       y = 8;
	       strcpy(temp2, user.saddress);
	    }
	    else if(option == 3){
	       option = 4;
	       x = 19;
	       y = 11;
	       strcpy(temp2, user.city);
	    }
	    else if(option == 4){
	       option = 5;
	       x = 53;
	       y = 11;
	       strcpy(temp2, user.state);
	    }
	    else if(option == 5){
	       option = 6;
	       x = 19;
	       y = 14;
	       strcpy(temp2, user.zip);
	    }
	    
	    display3 = 1;
	 }
	 else if(temp == '\n'){
	    ansipos(x,y);
	    putcolor('1','F');
	    if(option == 1){
	       get_input(user.fname,20,0,1,0,0,0);
	       strcpy(temp2, user.fname);
	       display3 = 1;
	    }
	    if(option == 2){
	       get_input(user.lname,20,0,1,0,0,0);
	       strcpy(temp2, user.lname);
	       display3 = 1;
	    }
	    if(option == 3){
	       get_input(user.saddress,50,1,1,1,0,0);
	       strcpy(temp2, user.saddress);
	       display3 = 1;
	    }
	    if(option == 4){
	       get_input(user.city,20,1,1,1,0,0);
	       strcpy(temp2, user.city);
	       display3 = 1;
	    }
	    if(option == 5){
	       get_input(user.state,20,1,1,1,0,0);
	       strcpy(temp2, user.state);
	       display3 = 1;
	    }
	    if(option == 6){
	       get_input(user.zip,10,1,0,0,0,1);
	       strcpy(temp2, user.zip);
	       display3 = 1;
	    }
	    if(option == 7){
	       get_input(user.country,25,1,1,1,0,0);
	       strcpy(temp2, user.country);
	       display3 = 1;
	    }
	    if(option == 8){
	       get_input(user.hphone,14,1,0,0,0,2);
	       strcpy(temp2, user.hphone);
	       display3 = 1;
	    }
	    if(option == 9){
	       get_input(user.dphone,14,1,0,0,0,2);
	       strcpy(temp2, user.dphone);
	       display3 = 1;
	    }
	    else{
	       display3 = 1;
	    }
	 }
	 else if(temp == 'q'){
	    ansipos(1,23);
	    disp_prompt(69);
	    if(tbc_getyn()){
	       write_usetup();
	    }
	    quit = 1;
	 }
      }
   }
   
   
   return 0;
}

int read_vars(void)
{
   FILE *fp_tbdat, *fp_prompt, *fp_menu, *fp_logon, *fp_sec, *fp_dir, *fp_log;
   int quit = 0, quitb = 0, end = 0, a = 0, line = 0;
   char temp2[200];
   /*Read theboard.dat file*/
   strcpy(temp2, ROOT_DIR);
   strcat(temp2, "/dat/theboard.dat");
   fp_tbdat = fopen(temp2, "r");
   tbc_readline(fp_tbdat,1,2);
   strcpy(dat_main.root, temp_buf);
   tbc_readline(fp_tbdat,2,2);
   strcpy(dat_main.bin, temp_buf);
   tbc_readline(fp_tbdat,3,2);
   strcpy(dat_main.dat, temp_buf);
   tbc_readline(fp_tbdat,4,2);
   strcpy(dat_main.log, temp_buf);
   tbc_readline(fp_tbdat,5,2);
   strcpy(dat_main.util, temp_buf);
   tbc_readline(fp_tbdat,6,2);
   strcpy(dat_main.prompt, temp_buf);
   tbc_readline(fp_tbdat,7,2);
   strcpy(dat_main.errlog, temp_buf);
   tbc_readline(fp_tbdat,8,2);
   strcpy(dat_main.logon_disp, temp_buf);
   tbc_readline(fp_tbdat,9,2);
   strcpy(dat_main.dir_list, temp_buf);
   tbc_readline(fp_tbdat,10,2);
   strcpy(dat_main.sec_list, temp_buf);
   tbc_readline(fp_tbdat,11,2);
   strcpy(dat_main.allias_list, temp_buf);
   fclose(fp_tbdat);
   strcpy(temp2, dat_main.dat);
   strcat(temp2, "/logs.dat");
   fp_log = fopen(temp2, "r");
   tbc_readline(fp_log,1,2);
   strcpy(logs[1], temp_buf);
   tbc_readline(fp_log,2,2);
   strcpy(logs[2], temp_buf);
   tbc_readline(fp_log,3,2);
   strcpy(logs[3], temp_buf);
   tbc_readline(fp_log,4,2);
   strcpy(logs[4], temp_buf);
   tbc_readline(fp_log,5,2);
   strcpy(logs[5], temp_buf);
   tbc_readline(fp_log,5,2);
   strcpy(logs[6], temp_buf);
   tbc_readline(fp_log,5,2);
   strcpy(logs[7], temp_buf);
   tbc_readline(fp_log,5,2);
   strcpy(logs[8], temp_buf);
   tbc_readline(fp_log,5,2);
   strcpy(logs[9], temp_buf);
   tbc_readline(fp_log,5,2);
   strcpy(logs[10], temp_buf);
   fclose(fp_log);
   /*Read in prompt files*/
   strcpy(prompt_str[0], "");
   fp_prompt = fopen(dat_main.prompt, "r");
   for(a = 1;a < 200;a++){
      end = tbc_readline(fp_prompt,a,1);
      if(end == -1){
	 a = 200 + 1;
	 continue;
      }
   }
   fclose(fp_prompt);
   /*Read in Login Display Files*/
   quit = 0;
   a = 1;
   fp_logon = fopen(dat_main.logon_disp, "r");
   while(!quit){
      end = tbc_readline(fp_logon,a,2);
      if(end == -1 || temp_buf[0] == '\n'){
	 quit = 1;
	 displogon_max = a - 2;
	 continue;
      }
      else{
	 strcpy(tb_logon[a - 1],temp_buf);
	 a++;
      }
      
   }
   fclose(fp_logon);
   /*Read in time limits*/
   quit = 0;
   quitb = 0;
   a = 1;
   fp_sec = fopen(dat_main.sec_list, "r");
   fseek(fp_sec, 0, SEEK_SET);
   while(!quit){
      end = tbc_read_line(fp_sec);
      if(end == -1){
	 quit = 1;
	 continue;
      }
      else{
	 to_int(temp_buf);
	 time_limit[a] = to_int_return;
	 a++;
      }
      
   }
   fclose(fp_sec);
   
   return 0;
}

int read_dirfile(void){
   FILE *fp_dir;
   int end = 0, quit = 0, a = 0;
   fp_dir = fopen(dat_main.dir_list, "r");
   end = tbc_readline(fp_dir,dir_num,2);
   if(end == -1 || temp_buf[0] == '\n' || temp_buf[0] == '\0'){
      return -1;
   }
   else{
      strcpy(dir_file,temp_buf);
   }
   fclose(fp_dir);
   return 0;
}

int copy_file(char dest[], char source[]){
   FILE *fp_dest, *fp_source;
   int quit = 0;
   char temp;
   fp_source = fopen(source, "r");
   if(!fp_source){
      return 1;
   }
   fp_dest = fopen(dest, "w");
   if(!fp_dest){
      fclose(fp_source);
      return 1;
   }
   while(!quit){
      temp = fgetc(fp_source);
      if(temp == EOF){
	 quit = 1;
	 continue;
      }
      else{
	 fputc(temp, fp_dest);
      }
   }
   fclose(fp_source);
   fclose(fp_dest);
   return 0;
}

