/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* upload.c - Upload files! */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include "os.h"
#include "ask_str.h"
#include "bbs_func.h"
#include "logfile.h"
#include "lastcall.h"
#include "fsearch.h"
#include "nodes.h"
#include "userbase.h"
#include "download.h"
#include "grabmsgs.h"
#include "timeslic.h"
#include "files.h"
#include "modem.h"
#include "output.h"
#include "fareas.h"
#include "language.h"
#include "setup.h"
#include "config.h"

#include "smodem.h"

void add_description(char *path, char *fname)
{
    int Fdes,F;
    char str[256], str2[128], old_path[MAX_PATH_LEN];
    unsigned char *strp;
    int diz,lines,spos,ignore_space;
    size_t readed;

    time_t _tim;
    struct tm *tim;

    output("\r\n");

    /* Update descript.ion */
    sprintf(str,"%s"SSLASH"descript.ion",path);
    Fdes = FileOpen(str, O_WRONLY | O_BINARY, SH_DENYRW);
    if (Fdes == -1)
    {
        /* Doesn't exist, create. */
        Fdes = FileCreate(str, CREATE_MODE);
        if (Fdes == -1)
        {
            write_log("Could not create %s",str);
            output("Could not create descript.ion!\r\n");
            return;
        }
        FileMode(Fdes,O_BINARY);
    }
    FileSeek(Fdes,0,SEEK_END);

    sprintf(str,"%s"SSLASH"%s",path,fname);
    F = FileOpen(str, O_RDONLY | O_BINARY, SH_DENYNO);
    if (F == -1)
    {
        output("Can't find uploaded file!\r\n");
        FileClose(F);
        return;
    }

    getcwd(old_path, sizeof(old_path));
    change_dir(hold_farea.path);
#ifdef __FILES_CASE_SENSITIVE__
    strcpy(str, "file_id.diz");
    while (search_ign_file(str) != NULL) remove(str);
#else
    remove("file_id.diz");
#endif

    diz = 0;
    if (FileRead(F,str,5) == 5)
    {
        if ((str[0] == 'P') && (str[1] == 'K'))
        {
            sprintf(str,"unzip -CjLo %s"SSLASH"%s file_id.diz",path,fname);
            if (system(str) == 0) diz = 1;
        }
        else if (strncmp(str,"Rar!\032",5) == 0)
        {
            sprintf(str,"rar e -cl -c- -o+ %s"SSLASH"%s file_id.diz",path,fname);
            if (system(str) == 0) diz = 1;
        }
        else
        {
            /* Check if it is self-extracting.. */
            sprintf(str,"unzip -CjLo %s"SSLASH"%s file_id.diz",path,fname);
            if (system(str) == 0) diz = 1;
            else
            {
                sprintf(str,"rar e -cl -c- -o+ %s"SSLASH"%s file_id.diz",path,fname);
                if (system(str) == 0) diz = 1;
            }
        }
    }
    FileClose(F);

    FileWrite(Fdes, fname, strlen(fname));
    FileWrite(Fdes, " ", 1);

    inactivity = 0; told_inactivity = 0; last_tim = last_min = time(NULL);
    if (!diz)
    {
        F = FileCreate("file_id.diz", CREATE_MODE);
        if (F == -1)
        {
            write_log("Could not create file 'file_id.diz'");
            output("Could not create file 'file_id.diz'!\r\n");
        }
        else
        {
            /* file_id.diz not in archive, ask description.. */
            output(lang[LANG_ASK_DESCRIPTION]);
            for (lines=1; lines<100; lines++)
            {
                sprintf(str2, "\r\n%2d: ", lines);
                str[0] = '\0'; if (!ask_string(str2, str, 45, 0, NULL)) break;

                if (str[0] == '\0')
                {
                    if (lines == 1) continue;
                    break;
                }
                FileWrite(F,str,strlen(str));
                FileWrite(F, " ", 1);
            }
            outtext("\r\n");

            FileClose(F);
        }
    }

    F = FileOpenIgn("file_id.diz", O_RDONLY | O_BINARY, SH_DENYNO);
    if (F == -1)
    {
        write_log("Couldn't find file_id.diz, and it _should_ have be here!\n");
        output("ERROR: Couldn't find file_id.diz, and it _should_ have be here!\n");
        FileWrite(Fdes,"<file_id.diz got lost>",24);
    }
    else
    {
        /* Read diz */
        ignore_space = 1;
        while ((readed = FileRead(F,str2,sizeof(str2))) > 0)
        {
            strp = (unsigned char *) str2; spos = 0;
            if (*strp == 26) break;
            while (readed > 0)
            {
                if (*strp == 26) break;
                if (*strp == 13 || *strp == 10 || *strp == 9) *strp = ' '; /* cr/lf -> ' ' */
                if (*strp == 228) *strp = 132; /*  ->  */
                //if (*strp == 196) *strp = 142; /*  ->  */
                if (*strp == 246) *strp = 148; /*  ->  */
                if (*strp == 214) *strp = 153; /*  ->  */
                if (*strp == 229) *strp = 134; /*  ->  */
                //if (*strp == 197) *strp = 143; /*  ->  */
                if (*strp < 32) *strp = ' ';

                if (*strp == ' ' && !ignore_space)
                {
                    str[spos++] = *strp;
                    ignore_space = 1;
                }
                else if (*strp < 155 && *strp != ' ')
                {
                    str[spos++] = *strp;
                    ignore_space = 0;
                    if (*strp == '@') str[spos++] = '@';
                }
                strp++; readed--;
            }
            str[spos] = '\0';
            FileWrite(Fdes,str,spos);
        }
    }

    /* Upload time */
    _tim = time(NULL);
    tim = localtime(&_tim);
    spos = sprintf(str,"@_DOWNS=0000_@@_ULDATE=%02d%02d%02d_@\n",tim->tm_mday,tim->tm_mon+1,tim->tm_year);
    FileWrite(Fdes,str,spos);

    FileClose(Fdes);

#ifdef __FILES_CASE_SENSITIVE__
    strcpy(str, "file_id.diz");
    while (search_ign_file(str) != NULL) remove(str);
#else
    remove("file_id.diz");
#endif
    change_dir(old_path);
}

void add_file(char *fname)
{
    char src[256],dest[256];
    struct stat statbuf;
    unsigned long rec;
    int f;

    if (stricmp(fname,"SKYLINER.NEW") == 0)
    {
        toss_bw_packet(fname);
        return;
    }

    if (stricmp(fname,"SKYLINER.REP") == 0)
    {
        toss_qwk_packet(fname);
        return;
    }

    current_lastrec.done_flags |= DONE_UPLOAD;

    /* Get file size */
    sprintf(src,"%s"SSLASH"upload"SSLASH"%s", hold_farea.path, fname);
    if (stat(src, &statbuf) != 0) statbuf.st_size = 0;

    /* Scan for dupes */
    for (rec = 1; read_filebase_record(rec) != 0; rec++)
    {
        if (stricmp(fb_fname, fname) == 0)
        {
            /* Dupe file */
            remove(src);
            output(lang[LANG_UPLOAD_DUPE], fname);
            write_log("File is duplicate");
            return;
        }
    }

    /* Update user statistics */
    user.UploadFiles++;
    user.UploadBytes += statbuf.st_size;
    user.TodayUploadFiles++;
    user.TodayUploadBytes += statbuf.st_size;

    /* Move to upload area */
    sprintf(dest,"%s"SSLASH"%s",ul_farea.path,fname);
    if (rename(src,dest) != 0)
    {
        /* Could not rename, try copying.. */
        if (copyfile(src,dest) != 0)
        {
            /* Copy OK */
            remove(src);
        }
        else
        {
            output("\r\nCould not copy file to upload area!\r\n");
            write_log("Could not copy file '%s' to upload area",src);
            return;
        }
    }

    add_description(ul_farea.path,fname);
    output(lang[LANG_UPLOAD_OK], fname);

    /* Create semafore so buildfb script doesn't always have to rebuild filebase.. */
    sprintf(src, "%s"SSLASH"buildfb.sem", common_path);
    f = FileCreate(src, CREATE_MODE);
    if (f != -1) FileClose(f);
}

void upload_files(int start_proto)
{
    char str[256], old_path[MAX_PATH_LEN], val;
    PROTO_REC *proto;
    DIR *dirp;
    struct dirent *direntp;
    struct stat statbuf;

    output("\r\n");

    proto = NULL;
    if (start_proto)
    {
        /* Get protocol */
        val = 0;
        while (val < 2)
        {
            val++;
            proto = firstproto;
            while (proto != NULL)
            {
                if (toupper(user.Protocol) == toupper(proto->key))
                {
                    break;
                }
                proto = proto->next;
            }
            if (proto == NULL && val == 1) edit_setup("protocol");
        }
        if (proto == NULL) return;

        /* Create upload path if it doesn't exist */
        sprintf(str,"%s"SSLASH"upload", hold_farea.path);
        if (stat(str, &statbuf) != 0 && !mkpath(str))
        {
            printf("Could not create upload path!!\n");
            write_log("Could not create upload path '%s'", str);
            return;
        }
    }

    if (hCom != 0 && start_proto)
    {
        getcwd(old_path, sizeof(old_path));
        change_dir(str);

        noderec.doing = DOING_UPLOAD;
        update_nodefile(0);

        output(lang[LANG_EXECUTING_PROTO]);
        if (proto->mode == PROTO_MODE_SMODEM)
        {
#ifdef BUILDIN_SMODEM
            write_log("Executing SModem");
            execute_smodem(NULL, NULL, bpsrate, 0);
#endif
        }
        else
        {
            conv_macros(proto->upload, str);
            printf("Command line: '%s'\n", str);
            write_log("Executing %s: %s", proto->name, str);
            execute_protocol(str, proto->mode == PROTO_MODE_STDIO); output("\r\n");
        }
        inactivity = 0; told_inactivity = 0; last_tim = last_min = time(NULL);
        usleep(300000);
        while (mdm_kbhit())
        {
            mdm_getch();
            usleep(100000);
        }
        change_dir(old_path);
    }

    output(lang[LANG_CHECKING_UPLOADS]);

    sprintf(str,"%s"SSLASH"upload", hold_farea.path);
    dirp = opendir(str);
    if (dirp != NULL)
    {
        for (;;)
        {
            direntp = readdir(dirp);
            if (direntp == NULL) break;

            sprintf(str,"%s"SSLASH"upload"SSLASH"%s", hold_farea.path, direntp->d_name);
            if (stat(str,&statbuf) == 0 && !ISDIR(statbuf))
            {
                /* Not a directory */
                write_log("Uploaded file: %s", direntp->d_name);
                add_file(direntp->d_name);
            }
        }
        closedir(dirp);
        inactivity = 0; told_inactivity = 0; last_tim = last_min = time(NULL);
    }
    else
    {
        write_log("Couldn't open directory '%s'",str);
        output("\r\nCouldn't read upload directory! Can't check uploaded files!\r\n");
    }

    noderec.doing = DOING_NOTHING;
    update_nodefile(0);
}
