/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

#ifndef __USERBASE_H
#define __USERBASE_H

#include <time.h>

#define USER_ATTRIB_DELETED             0x00000001
#define USER_ATTRIB_FEMALE              0x00000002
#define USER_ATTRIB_NOREMOVE            0x00000004
#define USER_ATTRIB_VT100_KEYB          0x00000008

#define USER_EMULATION_ASCII            0x00
#define USER_EMULATION_ANSI             0x01
#define USER_EMULATION_ANSI_X364        0x02
#define USER_EMULATION_AVATAR           0x03

typedef struct
{
    unsigned long UserCRC;              /* CRC32 of user name */
    unsigned long PassCRC;              /* CRC32 of password (-1 = not used) */
    unsigned long SubfieldLen;          /* Total size of subfields */

    unsigned char Emulation;            /* Terminal emulation */
    unsigned char DateFormat;           /* Date format */

    unsigned long Attrib1;              /* User attributes #1 */
    unsigned long Attrib2;              /* User attributes #2 */
    unsigned long Attrib3;              /* User attributes #3 */
    unsigned long Attrib4;              /* User attributes #4 */

    unsigned char ScreenLen;            /* Screen length */
    unsigned char ScreenWidth;          /* Screen width */

    unsigned long FirstTime;            /* First logon time */
    unsigned long LastTime[5];          /* Last five logon times */

    unsigned long TotalCalls;           /* Total times called */
    unsigned long TotalMinutes;         /* Total minutes used */
    unsigned short TotalPages;          /* Total times paged sysop */

    unsigned long UploadBytes;          /* Uploaded kilobytes */
    unsigned long UploadFiles;          /* Uploaded files */
    unsigned long DownloadBytes;        /* Downloaded kilobytes */
    unsigned long DownloadFiles;        /* Downloaded files */

    char Protocol;                      /* Protocol key */
    char Editor;                        /* Editor key */
    char Packer;                        /* Packer key */
    char CharSet;                       /* Charset key */
    char Language;                      /* Language key */

    unsigned long LastFileChk;          /* Last new files check */
    unsigned long LastBullChk;          /* Last new bulletins check */

    unsigned short TodayCalls;          /* Times called today */
    unsigned long TodayMinutes;         /* Minutes used today */
    unsigned short TodayPages;          /* Times paged sysop today */

    unsigned long TodayUploadBytes;     /* Uploaded kilobytes today */
    unsigned long TodayUploadFiles;     /* Uploaded files today */
    unsigned long TodayDownloadBytes;   /* Downloaded kilobytes today */
    unsigned long TodayDownloadFiles;   /* Downloaded files today */

    unsigned char TodayMsgPkts;         /* Message packets downloaded today */
    unsigned long MaxMsgs;              /* Max number of messages to pack */

    unsigned long MsgsRead;             /* Messages read */
    unsigned long MsgsWritten;          /* Messages written */
    char fill[92];                      /* Reserved */
}
USER_REC;

typedef struct
{
    char name[36];
    char alias[36];
    char password[21];
    char address1[61];
    char address2[61];
    char address3[61];
    char address4[61];
    char address5[61];
    char sysop_cmnt[61];
    char voice[26];
    char data[26];
    char city[26];
    char birthday[9];
}
USER_SUBRECORDS;

typedef struct
{
    unsigned long AreaCRC;
    unsigned long AreaPtr;
    char Selected;
}
USER_LASTREAD_REC;

#define USERSUB_NAME            0x0001
#define USERSUB_ALIAS           0x0002
#define USERSUB_PASSWORD        0x0003
#define USERSUB_PASSWORD_MD5    0x0004
#define USERSUB_ADDRESS1        0x0005
#define USERSUB_ADDRESS2        0x0006
#define USERSUB_ADDRESS3        0x0007
#define USERSUB_ADDRESS4        0x0008
#define USERSUB_ADDRESS5        0x0009
#define USERSUB_SYSOP_CMNT      0x000a
#define USERSUB_VOICE           0x000b
#define USERSUB_DATA            0x000c
#define USERSUB_CITY            0x000d
#define USERSUB_BIRTHDAY        0x000e
#define USERSUB_LASTREAD        0x000f

typedef struct
{
    unsigned short ID;                  /* See USERSUB_xxx defines */
    unsigned long Len;                  /* Length of data following */
}
USER_SUBFIELD;

typedef struct
{
    unsigned long UserCRC; /* CRC32 of user name */
    unsigned long SeekPos; /* Seek position to USER_REC record in userbase */
}
USER_IDX;

extern char current_charset[20];
extern char current_emulation[20];

extern unsigned long user_num;          /* Current user number */
extern time_t checked_newfiles;         /* Newfiles check time */
extern int time_left;                   /* Time left in minutes */

int open_userbase(char *fname);         /* Open or create userbase files */
void close_userbase(void);              /* Close userbase files */
unsigned long users(void);              /* Return number of users in userbase */

int pack_userbase(void);                /* Pack userbase */
int create_useridx(void);               /* Create userbase indexes */

unsigned long scan_user(char *name);    /* Search user from userbase */
int read_user(unsigned long usernum, int justread); /* Read user from userbase */

void read_lastread(void);               /* Read area settings and lastread pointers */

unsigned long write_new_user(void);     /* Write new user record to userbase */
unsigned long write_user(void);         /* Write existing user record to userbase */

extern USER_SUBRECORDS usrsub;
extern USER_REC user;

unsigned long scan_concord_user(char *name);/* Search user from Concord's userbase */

int in_group(char *group);              /* Is user in group? */
void read_groups(void);                 /* Read usergroup file */

void close_groups(void);                /* Release memory used by user groups, close_userbase() calls also this.. */

void userlist(char *data);              /* Show userbase */

#endif
