#include <stdio.h>
#include <string.h>

#include "os.h"
#include "files.h"
#include "bbs_func.h"
#include "config.h"
#include "modem.h"
#include "keyb.h"
#include "output.h"
#include "logfile.h"

int wait_string(char *wait, int timeout)
{
    char *pos;
    int ch;

    loc_output("@X07");
    pos = wait;
    while (timeout > 0)
    {
        if (kbhit())
        {
            ch = getch();
            if (ch == 'q') return 0;
            if (ch == 0) ch = getch();
        }

        if (mdm_datain(&ch, 1))
        {
            loc_outchr((unsigned char) ch);
            if (*pos == *wait) pos++; else pos = wait;
            if (pos == '\0') return 1;
        }
        else if (timeout == -1)
        {
            sleep(1);
        }
        else
        {
            timeout--;
            if (timeout > 0) sleep(1);
        }
    }

    return 0;
}

void save_string(char *out, int timeout)
{
    char *pos;
    int ch;

    pos = out;
    while (timeout > 0)
    {
        if (mdm_datain(&ch, 1))
        {
            *pos++ = (char) ch;
        }
        else
        {
            timeout--;
            if (timeout > 0) sleep(1);
        }
    }

    *pos = '\0';
}

int initialize_modem(void)
{
    char str[100], *strp;
    int tries;

    loc_output("Initializing modem..\r\n");
    strcpy(str, init_string); strp = str; while (*strp == '|') *strp++ = '\r';
    tries = 3;
    while (tries > 0)
    {
        output("@X0F%s\r\n", init_string);
        mdm_strout(str);
        if (wait_string(ok_string, 5)) break;
        output("\r\n");
        tries--;
    }

    return tries != 0;
}

int wait_caller(void)
{
    char connect[100], *strp;

    for (;;)
    {
        loc_output("@X07Press 'Q' anytime to quit.\r\n");
        if (!initialize_modem())
        {
            write_log("Can't initialize modem!");
            return 91;
        }

        loc_output("@X07Waiting for RING..\r\n");
        if (!wait_string(resp_ring, -1)) return 90;

        loc_output("\r\n@X07Answering call..\r\n");
        if (!wait_string("CONNECT ", 60)) continue;

        save_string(connect, 1);
        strp = strchr(connect, '/'); /* split from '/' */
        if (strp != NULL) *strp = '\0';
        strp = strchr(connect, '\r'); /* or split from cr */
        if (strp != NULL) *strp = '\0';

        strp = connect; while (*strp == ' ') strp++;

        sscanf(connect, "%lu", &bpsrate);
        break;
    }

    loc_output("\r\n@X07Connected with %lu BPS rate\r\n", bpsrate);
    return 0;
}
