(******************************************************************************)
(*                          ALLFIX sample procedures                          *)
(*    Copyright (C) 1992,99 Harms Software Engineering, all rights reserved   *)
(*                                                                            *)
(*                 All information in this documentation is                   *)
(*                  subject to change without prior notice                    *)
(******************************************************************************)

UNIT UUencode;

Interface

const enBase64 : array[0..63] of char = '`!"#$%&'#39'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_';
var   deBase64 : array[0..255] of byte;

const uu_bufsize   = 60;
      EncodeFactor = 8/6;

      (* This unit was developed for creating uuencoded data for email   *)
      (* messages in ALLFIX. By changing the uu_bufsize to 45, it will   *)
      (* create standard uuencoded data which can be decoded by other    *)
      (* applications. In order to do that, simply preceed the uuencoded *)
      (* data with the string "begin 644 <filename>", where <filename>   *)
      (* is the name of the file. And, at the end of the uuencoded data  *)
      (* put the character ` on a line by itself, followed by the string *)
      (* "end". That's all there is to it.                               *)

type uu_inbuffer  = array[0..uu_bufsize-1] of byte;    { binary data    }
     uu_outbuffer = array[0..2*uu_bufsize-1] of byte;  { uuencoded data }

function  uu_encode(input : uu_inbuffer; size: word): string;

procedure uu_decode(       str: string;
                    var output: uu_inbuffer;
                    var size  : word);

Implementation

Procedure Build_deBase64;

  var cnt : word;

  begin
    for cnt := 0 to 63 do
      deBase64[Byte(enBase64[cnt])] := cnt;
  end;

{$R-}
function PullBits(a: byte; var c: byte; s: byte; var n: byte): byte;

  var mask : byte;

  begin
    mask := $FF shl (8-n);

    PullBits := c or ((a and mask) shr (8-n));

    n := s-(8-n);

    c := (a and not mask) shl n;
  end;
{$R+}

{$R-}
function PushBits(a: byte; var b: byte; s: byte; var n: byte): byte;

  var mask : byte;

  begin
    mask := $FF shl (s-n);

    PushBits := a shl n or ((b and mask) shr (s-n));

    b := b and not mask;

    n := 8-(s-n);
  end;
{$R+}

function  uu_encode(input : uu_inbuffer; size: word): string;

  var cnt : word;
      s   : string;

      c   : byte;
      n   : byte;
      t   : byte;

  begin
    { uuencode input buffer and store in output buffer }

    cnt  := 0;
    s    := enBase64[size];

    c := 0;
    n := 6;
    while cnt < size do
    begin
      if n > 0 then
        t := PullBits(input[cnt], c, 6, n) else
      begin
        t := c;
        c := 0;
        n := 6;
      end;

      if n > 0 then inc(cnt);

      s := s+enBase64[t];
    end;


    if n <> 6 {size > (length(s)*6/8)} then
      s := s+enBase64[c];

    uu_encode := s;
  end;

procedure uu_decode(       str: string;
                    var output: uu_inbuffer;
                    var size  : word);

  var len,
      s,
      n,
      t1,
      t2,
      cnt : byte;

  begin
    { uudecode input buffer and store in output buffer }

    len  := deBase64[byte(str[1])];

    if len > sizeof(output) then
      len := sizeof(output);
    size := 0;

    s := 6;
    n := 2;

    t1 := deBase64[byte(str[2])];

    cnt := 3;
    while (size < len) do
    begin
      t2 := deBase64[byte(str[cnt])];
      inc(cnt);

      output[size] := PushBits(t1,t2,s,n);

      if n = 8 then
      begin
        t1 := deBase64[byte(str[cnt])];
        inc(cnt);
        n  := 2;
      end else
        t1 := t2;

      inc(size);
    end;
  end;

begin
  Build_deBase64;
end.
