if bbs_user_has_ansi() ~= true then
    bbs_write_string("\r\nSorry, the TOP 5 requires ANSI support.\r\n")
    bbs_pause()
    return
end

bbs_clear_screen()
bbs_display_gfile("top5")

for i = 1, 5 do
    local caller, calls = bbs_get_top_user("calls", i - 1)
    local msg_writer, posts = bbs_get_top_user("msgs_posted", i - 1)
    local uploader, ups = bbs_get_top_user("uploads", i - 1)
    local downloader, downs = bbs_get_top_user("downloads", i - 1)
    local player, doors = bbs_get_top_user("doors_run", i - 1)

    if i == 1 then
        bbs_write_string("|14")
    elseif i == 2 then
        bbs_write_string("|07")
    elseif i == 3 then
        bbs_write_string("|06")
    else
        bbs_write_string("|08")
    end
    bbs_write_string(string.format("\027[%d;7H%d.%-15.15s %4d", 6 + i, i, caller, calls))
    bbs_write_string(string.format("\027[%d;30H%d.%-15.15s %4d", 6 + i, i, msg_writer, posts))
    bbs_write_string(string.format("\027[%d;53H%d.%-15.15s %4d", 6 + i, i, player, doors))

    bbs_write_string(string.format("\027[%d;7H%d.%-15.15s %4d", 13 + i, i, uploader, ups))
    bbs_write_string(string.format("\027[%d;30H%d.%-15.15s %4d", 13 + i, i, downloader, downs))

end
bbs_write_string("\027[24;1H|07")
bbs_pause()


