REM 1Msearch searchs converted data file for digit string. v1.1a PD 2006.
On Error Goto Error.Routine
' define a byte
DIM Byte AS STRING * 1
' open input file
OPEN "digits.dat" FOR BINARY AS #1
' check filelength
IF LOF(1) = 0 THEN
   GOTO BootError
END IF
' display header
COLOR 15, 0
PRINT "1Msearch v1.1a"
' get search string
Search$ = COMMAND$
IF Search$ = "/?" THEN
   GOTO BootUsage
END IF
IF Search$ = "" THEN
   PRINT "Enter digit sequence";
   INPUT Search$
END IF
IF Search$ = "" THEN
   GOTO BootUsage
END IF
' verify search string
FOR Count = 1 TO LEN(Search$)
   ' get next digit
   Char$ = MID$(Search$, Count, 1)
   ' verify digit
   SELECT CASE Char$
   CASE "0" TO "9", "?"
      ' nul
   CASE ELSE
      GOTO BootUsage
   END SELECT
NEXT
' display search header
COLOR 14, 0
PRINT "Searching"; LOF(1); "digits."
PRINT "Searching for: "; Search$
PRINT "Press <esc> to quit."
' search entire file
FOR Position& = 1 TO LOF(1)
   ' store last position searched
   LastPosition& = Position&
   ' check to break
   IF INKEY$ = CHR$(27) THEN
      EXIT FOR
   END IF
   ' display a dot
   GOSUB DisplayDot
   ' clear comparison string
   Strng$ = ""
   Strng2$ = ""
   ' construct comparison string
   FOR Count& = 1 TO LEN(Search$)
      ' check string can be created
      IF Position& + Count& - 1& > LOF(1) THEN
         EXIT FOR
      END IF
      ' read in binary stored digit
      GET 1, Position& + Count& - 1&, Byte
      ' add to string
      IF MID$(Search$, Count&, 1) = "?" THEN
         Strng$ = Strng$ + "?"
      ELSE
         Strng$ = Strng$ + Byte
      END IF
      Strng2$ = Strng2$ + Byte
      ' compare partially formed string is equivalent
      IF Strng$ <> LEFT$(Search$, LEN(Strng$)) THEN
         EXIT FOR
      END IF
   NEXT
   ' check entire string
   IF Strng$ = Search$ THEN
      ' clear dots
      GOSUB ClearDots
      ' set found flag
      Found = -1
      ' display search string found
      PRINT Strng2$; " is at position"; Position&
      ' increment digits found
      Digits.Found& = Digits.Found& + 1
   END IF
NEXT
' clear dots
GOSUB ClearDots
' check found flag
IF Found = 0 THEN
   PRINT "No digit sequences found."
ELSE
   IF Digits.Found& = 1& THEN
      PRINT "1 digit sequence found."
   ELSE
      PRINT MID$(STR$(Digits.Found&), 2); " digit sequences found."
   END IF
END IF
' display digits searched
PRINT "Searched"; LastPosition&; "digits."
GOTO StopProgram

' display a dot
DisplayDot:
 Dot.Count = Dot.Count + 1
 IF Dot.Count = 1024 THEN
    Dot.Count = 0
    Dot.Kilo = Dot.Kilo + 1
    IF Dot.Kilo > 16 THEN
       Dot.Kilo = 1
       Dot.Flag = NOT Dot.Flag
    END IF
    IF Dot.Flag THEN
       PRINT CHR$(29); " "; CHR$(29);
       Dots = Dots - 1
    ELSE
       PRINT ".";
       Dots = Dots + 1
    END IF
    LOCATE , , 1
 END IF
 RETURN

' clear a line of dots
ClearDots:
 FOR Dot.Count = 1 TO Dots
    PRINT CHR$(29); " "; CHR$(29);
 NEXT
 Dot.Count = 0
 Dot.Kilo = 0
 Dot.Flag = 0
 Dots = 0
 RETURN

' display error line
BootError:
 Print "Run 1Mmake first..
 Goto StopProgram

' display boot usage
BootUsage:
 PRINT "  Searchs database for random digits."
 COLOR 14, 0
 PRINT "Usage:"
 PRINT "  1Msearch <digits>"
 PRINT "Example:"
 PRINT "  1Msearch 999999"
 PRINT "Note: Stop with <esc> key,"
 PRINT "  <digits> may include ? match character."

' anything goes here stops program
StopProgram:
 COLOR 7, 0
 PRINT "Returning to system."
 END

Error.Routine:
 Print "Fatal error;";Err
 End
