REM Lowerdtr v1.2a: Modem port DTR utility;

DEFINT A-Z
REM $DYNAMIC

TYPE RegType
 AX AS INTEGER
 BX AS INTEGER
 CX AS INTEGER
 DX AS INTEGER
 BP AS INTEGER
 SI AS INTEGER
 DI AS INTEGER
 Flags AS INTEGER
END TYPE

 COMMON SHARED Inregs AS RegType, Outregs AS RegType, Port AS INTEGER
 DECLARE SUB Interrupt (N AS INTEGER, I AS RegType, O AS RegType)

 IF COMMAND$ = "" THEN
    GOTO BootUsage
 END IF
 Port = INT(VAL(COMMAND$))
 IF Port < 1 OR Port > 4 THEN
    GOTO BootUsage
 END IF
 Port = Port - 1
 COLOR 15, 0
 PRINT "Lowerdtr v1.2: Modem port utility;"
 COLOR 14, 0
 PRINT "Comm"; Port + 1; "(port "; MID$(STR$(Port), 2); ") DTR lowered."
 Inregs.AX = &H300
 Inregs.DX = Port
 CALL Interrupt(&H14, Inregs, Outregs)
 IF (Outregs.AX AND &HFF00) = &HFF00 THEN
    PRINT "No modem."
 ELSE
    GOSUB SendATZ
 END IF
 GOSUB DetectFossil
 IF Fossil.Active THEN
    GOSUB DropFossilDTR
 ELSE
    GOSUB DropPortDTR
 END IF
 COLOR 7, 0
 END

BootUsage:
 COLOR 15, 0
 PRINT "Lowerdtr v1.2: Modem port utility;"
 COLOR 14, 0
 PRINT "Usage:"
 PRINT "   Lowerdtr <comm port>"
 PRINT "Where:"
 PRINT "   Comm port=1 to 4"
 COLOR 7, 0
 END

DropPortDTR:
 Inregs.AX = &HE3
 Inregs.DX = Port
 CALL Interrupt(&H14, Inregs, Outregs)
 SELECT CASE Port
 CASE 0
    PortAddress = &H3FC
 CASE 1
    PortAddress = &H2FC
 CASE 2
    PortAddress = &H3EC
 CASE 3
    PortAddress = &H2EC
 END SELECT
 OUT PortAddress, 3
 OUT PortAddress, 0
 RETURN

DetectFossil:
 Fossil.Active = 0
 Fossil.Version = 0
 Inregs.AX = &H1C00
 Inregs.DX = Port
 CALL Interrupt(&H14, Inregs, Outregs)
 IF Outregs.AX = &H1954 THEN
    Fossil.Active = -1
    Fossil.Version = 1
 ELSE
    Inregs.AX = &H400
    Inregs.DX = Port
    CALL Interrupt(&H14, Inregs, Outregs)
    IF Outregs.AX = &H1954 THEN
       Fossil.Active = -1
       Fossil.Version = 2
    END IF
 END IF
 RETURN

DropFossilDTR:
 IF Fossil.Version = 1 THEN
    Inregs.AX = &H1F01
    Inregs.BX = 0
 ELSE
    Inregs.AX = &H600
 END IF
 Inregs.DX = Port
 CALL Interrupt(&H14, Inregs, Outregs)
 RETURN

SendATZ:
 Strng$ = "ATZ" + CHR$(13)
 FOR Var = 1 TO 4
    DO
       Inregs.AX = &H300
       Inregs.DX = Port
       CALL Interrupt(&H14, Inregs, Outregs)
       IF (Outregs.AX AND &H2000) = &H2000 THEN
          EXIT DO
       END IF
    LOOP
    Inregs.AX = &H100 + ASC(MID$(Strng$, Var, 1))
    Inregs.DX = Port
    CALL Interrupt(&H14, Inregs, Outregs)
 NEXT
 RETURN
