REM Test fastest sort algorithm timings. PD 2005. v2.2a

' declare all subroutines
DECLARE SUB ShellSort ()
DECLARE SUB HeapSort ()

' default variables as integers
DEFINT A-Z

' declare common variables
COMMON SHARED SortArray() AS INTEGER
COMMON SHARED Num AS INTEGER

COLOR 15, 0
PRINT "Sorttest v2.2a: Test fastest sort routine timing."
DO
   PRINT "Elements(128-32766)";
   INPUT Num
   IF Num >= 128 AND Num <= 32766 THEN
      EXIT DO
   END IF
LOOP
REDIM SortArray(1 TO Num) AS INTEGER
PRINT "Sorting"; Num; "Elements:"
COLOR 14, 0
FOR SortNum = 1 TO 2
   FOR Element = 1 TO Num
      SortArray(Element) = INT(RND * Num + 1)
   NEXT
   StartTime! = TIMER
   ' test fastest sort timing
   COLOR 14, 0
   SELECT CASE SortNum
   CASE 1
      PRINT "Shell Sort: ";
      CALL ShellSort
   CASE 2
      PRINT "Heap Sort: ";
      CALL HeapSort
   END SELECT
   ElapsedTime! = TIMER - StartTime!
   IF ElapsedTime! < 0! THEN
      ElapsedTime! = ElapsedTime! + 86400! ' adjust for midnight
   END IF
   COLOR 14, 0
   PRINT "Time elapsed=";
   IF ElapsedTime! = 0! THEN
      PRINT "(unmeasurable)"
   ELSE
      PRINT ElapsedTime!; "seconds."
   END IF
NEXT
COLOR 7, 0
PRINT "Sorttest finished."
END

SUB HeapSort
   FOR I = 2 TO Num
      J = I
      DO UNTIL J = 1
         P = J \ 2
         IF SortArray(J) > SortArray(P) THEN
            SWAP SortArray(P), SortArray(J)
            J = P
         ELSE
            EXIT DO
         END IF
      LOOP
   NEXT
   FOR I = Num TO 2 STEP -1
      SWAP SortArray(1), SortArray(I)
      J = 1
      DO
         IF 2! * CSNG(J) > CSNG(I) - 1! THEN
            EXIT DO
         END IF
         C = 2 * J
         IF C + 1 <= I - 1 THEN
            IF SortArray(C + 1) > SortArray(C) THEN
               C = C + 1
            END IF
         END IF
         IF SortArray(J) < SortArray(C) THEN
            SWAP SortArray(J), SortArray(C)
            J = C
         ELSE
            EXIT DO
         END IF
      LOOP
   NEXT
END SUB

SUB ShellSort
   S = INT(Num / 2)
   DO WHILE S > 0
      FOR T = S TO Num - 1
         FOR E = (T - S + 1) TO 1 STEP -S
            IF SortArray(E) <= SortArray(E + S) THEN
               EXIT FOR
            END IF
            SWAP SortArray(E), SortArray(E + S)
         NEXT
      NEXT
      S = INT(S / 2)
   LOOP
END SUB

