PROGRAM EntryRes;
{ͻ}
{ Creates entry screens in PORTAL.RES           Last changed: 21.10.95 SA  }
{                                                                          }
{                         (C) Copyright 1989-95 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{ͻ}
{                                                                          }
{                        (C) Copyright 1998-2000 by                        }
{                          The German Portal Team                          }
{          Carsten Brandt, Michael Kleefeld and Marcus Roeckrath           }
{                                                                          }
{                                                                          }
{ Changes made                                                             }
{                                                                          }
{ By                : Carsten Brandt                                       }
{                     Marcus Roeckrath                                     }
{ First Modification: 10 September 1998                                    }
{ Last Modification : 16 March 2000                                        }
{                                                                          }
{ Look at HISTORY.TXT for exact information about all changes made to      }
{ the original P063B9 source!                                              }
{                                                                          }
{ͼ}
{$I POPDEFS.INC}

uses use32, oproot,opmenu,opwindow,oproutil,input,globals,poptypes,opframe,opcmd,
     opkey,opentry,opcrt,opselect,opstring,opfield,opedit,opfedit,nodelist,
     mailcfg, resource, Useredit, OpDate, MailScan;

VAR
  Esr : PPoPEntryScreen;
  Lib : OplibraryPtr;
  Status : Word;

CONST
  BinLo          : RangeType = (rtByte:0);
  BinHi          : RangeType = (rtByte:255);
  Bin32Lo        : RangeType = (rtLong:0);
  Bin32Hi        : RangeType = (rtLong:$7FFFFFFF);

  PROCEDURE PutEsr(Num: Byte);
  VAR
    Stat : LongInt;

    FUNCTION To3(B: Byte): String;
    BEGIN
      To3:=LongIntForm('@@@',b);
    END;

  BEGIN
    Esr^.AllocateScreen;
    Lib^.PutEntry('Esr'+To3(Num),Esr^);
    Stat:=Lib^.GetStatus;
    IF Stat<>0 THEN WriteLn('Error ',Stat,' in Esr',To3(Num)) ELSE WriteLn('Writing Esr',To3(Num));
    IF Lib^.AvailableEntries=0 THEN
    BEGIN
      WRITELN('Directory full');
      HALT;
    END;
    Esr^.Done;
  END;



{=== Choice field Inc procedures ============================================}

CONST
  NodeListName : ARRAY[0..2] OF S11 = ('NewNodeList','QuickBBS','R.Access');
  Packers      : Array[1..7] Of S3  = ('ARC','ZIP','LZH','PAK','ZOO','SQZ','ARJ');

  PROCEDURE IncModemType(VAR Value; ID: Word; Factor: Integer; VAR s:String);
  BEGIN
    CASE Factor OF
      +1: IF Byte(Value)<7 THEN Inc(Byte(Value)) ELSE Byte(Value):=0;
      -1: IF Byte(Value)>0 THEN Dec(Byte(Value)) ELSE Byte(Value):=7;
    END;
    S:=Cfg.NLCompiler.MTypeStr[Byte(Value)];
  END;

  PROCEDURE IncNodelist(VAR Value; ID: Word; Factor: Integer; VAR s:String);
  BEGIN
    CASE Factor OF
      +1: IF Byte(Value)<2 THEN Inc(Byte(Value)) ELSE Byte(Value):=0;
      -1: IF Byte(Value)>0 THEN Dec(Byte(Value)) ELSE Byte(Value):=2;
    END;
    S:=NodelistName[Byte(Value)]
  END;

  PROCEDURE IncBBSType(VAR Value; ID:WORD; Factor:Integer; VAR s:STRING);
  CONST
    MaxType=5;
    tab : ARRAY[0..MaxType] OF s8=('None','QuickBBS','Opus 1.03','Opus 1.10','R.Access','Opus 1.20');
  BEGIN
    CASE Factor OF
      +1 : BEGIN
             INC(ShortInt(Value));
             IF ShortInt(Value)>MaxType THEN ShortInt(Value):=0;
           END;
      -1 : BEGIN
             DEC(ShortInt(Value));
             IF ShortInt(Value)<0 THEN ShortInt(Value):=MaxType;
           END;
    END;
    s:=tab[Byte(Value)];
  END;

  PROCEDURE IncTaskType(VAR Value; ID: Word; Factor: Integer; VAR s: STRING);
  BEGIN
    CASE Factor OF
      +1 : BEGIN
             INC(ShortInt(Value));
             IF ShortInt(Value)>2 THEN ShortInt(Value):=0;
           END;
      -1 : BEGIN
             DEC(ShortInt(Value));
             IF ShortInt(Value)<0 THEN ShortInt(Value):=2;
           END;
    END;
    CASE Byte(Value) OF
      0 : s:='Normal';
      1 : s:='Function server';
      2 : s:='Function user';
    END;
  END;

  PROCEDURE IncNodeStat(VAR Value; ID: Word; Factor: Integer; VAR s:String); far;
  BEGIN
    CASE Factor OF
      +1: IF Byte(Value)<2 THEN Inc(Byte(Value)) ELSE Byte(Value):=0;
      -1: IF Byte(Value)>0 THEN Dec(Byte(Value)) ELSE Byte(Value):=2;
    END;
    S:='';
  END;

  PROCEDURE IncFreeArea(VAR Value; ID: Word; Factor: Integer; VAR s:String);
  BEGIN
    CASE Factor OF
      +1: IF Byte(Value)<2 THEN Inc(Byte(Value)) ELSE Byte(Value):=0;
      -1: IF Byte(Value)>0 THEN Dec(Byte(Value)) ELSE Byte(Value):=2;
    END;
    s:='';
  END;

  PROCEDURE IncReqOnUs(VAR Value; ID: Word; Factor: Integer; VAR s:String);
  BEGIN
    CASE Factor OF
      +1: IF Byte(Value)<2 THEN Inc(Byte(Value)) ELSE Byte(Value):=0;
      -1: IF Byte(Value)>0 THEN Dec(Byte(Value)) ELSE Byte(Value):=2;
    END;
    s:='';
  END;


{=== Setup ==================================================================}

  PROCEDURE matrix_info;
  VAR
    i:BYTE;
  BEGIN
    WITH Esr^, cfg DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-1,2,'Matrix information');
      EsFieldOptionsOff(efRightJustify);
      AddStringField('SysOp name   :',1,2,'',1,17,20,102,cfg.sysop);
      AddStringField('System name  :',2,2,'',2,17,60,103,cfg.system);
      AddIntField(   'Point Net    :',3,2,'#####',3,17,104,0,0,cfg.pointnet);
      AddYesNoField( 'Use fake     :',4,2,'',4,17,105,Cfg.UseFakeAddress);
      AddByteField(  'Main address :',5,2,'###',5,17,101,1,MaxAddresses,cfg.MainAdrNum);
      EsFieldOptionsOn(efRightJustify);
      FOR i:=1 TO MaxAddresses DO
      BEGIN
        WITH Cfg.Addresses[i] DO
        BEGIN
          AddIntField('Address '+LongIntForm('###',i)+'  :',i+5,2,'#####',i+5,17,100,0,32767,Zone);
          AddIntField(':',i+5,22,'#####',i+5,23,100,0,32767,Net);
          AddIntField('/',i+5,28,'#####',i+5,29,100,0,32767,Node);
          AddIntField('.',i+5,34,'#####',i+5,35,100,0,32767,Point);
        END;
      END;
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE ModemOptions;
  BEGIN
    WITH Cfg,Esr^ DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-1,2,'Standard modem options');


      addbytefield(  'Comm port      :', 2,2,'#',2,19,120,1,16,modem.commport);
      AddWordField(  'Baud rate      :', 3,2,'#####',3,19,121,300,38400,modem.BaudRate);
      addstringfield('Locked response:', 4,2,'!!!!!!!!!!',4,19,10,122,Modem.LockedBaud);

      addstringfield('Modem preinit  :', 5,2,CharStr('X', 40), 5,19,40,123,modem.preinit);
      addstringfield('Modem init     :', 6,2,CharStr('X', 80), 6,19,60,124,modem.Init);
      addstringfield('No answer cmd  :', 7,2,CharStr('X', 40), 7,19,40,125,modem.NoAnswer);
      addstringfield('Hang-up cmd    :', 8,2,CharStr('X', 40), 8,19,40,126,modem.Hangup);
      addstringfield('Modem dial     :', 9,2,CharStr('X', 40), 9,19,40,127,modem.dial);
      addstringfield('Modem answer   :',10,2,CharStr('X', 40),10,19,40,128,modem.answer);
      addstringfield('Modem busy     :',11,2,CharStr('X', 40),11,19,40,129,modem.busy);

      AddYesNoField( 'Check connect  :',12,2,'',12,19,130,ConnectFastest);
      AddTimeField(  'Modem re-init  :',13,2,'hh:mm:ss',13,19,131,0,0,modem.reinit);
      AddTimeField(  'Time to Wait   :',14,2,'hh:mm:ss',14,19,132,0,SecondsInDay,Modem.WaitTime);
      AddByteField(  'Time to Connect:',15,2,'##',15,19,133,0,99,Modem.ConnectTime);
      AddYesNoField( 'LeastCostRouter:',16,2,'',16,19,134,Modem.UseLCR);
      AddYesNoField( 'Ring Analyzer  :',17,2,'',17,19,135,Modem.UseRingAnaly);
      AddYesNoField( 'NoCon Analyzer :',18,2,'',18,19,136,Modem.UseNConAnaly);
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE AdvModemOptions;
  VAR
    i:BYTE;
  BEGIN
    WITH Cfg,Esr^ DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-1,2,'Advanced modem options');
      AddYesNoField(   'Internal fax  :',2,2,'',2,18,146,Modem.InternalFax);
      AddStringField(  'Link stat cmd :',4,2,'',4,18,10,147,Modem.LinkStat);
      AddByteField(    'Log # of lines:',5,2,'###',5,18,148,0,255,Modem.LogLines);
      FOR i:=1 TO 5 DO
      BEGIN
        AddStringField('Exit connect '+Long2Str(i)+':',6+i,2,'!!!!!!!!!!',6+i,18,10,140,Modem.ExitStr[i].ConStr);
        AddByteField(  'Errorlevel :',6+i,31,'###',6+i,44,141,0,255,Modem.ExitStr[i].ErrLvl);
      END;

      FOR i:=0 TO 7 DO
      BEGIN
        addchoicefield('Type',13,2,'XXXXX',14+i,2,142,1,IncModemType,Modem.ModemType[i].Bit);
        addstringfield('Dial string',13,9,CharStr('X',30),14+i,9,40,143,Modem.ModemType[i].Dial);
        AddWordField(  'Baud rate',13,41,'#####',14+i,41,144,0,38400,Modem.ModemType[i].Baud);
        AddYesNoField( 'Call',13,60,'',14+i,60,145,modem.modemtype[i].DialOut);
      END;
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE MakeMdmConnStat;
  VAR
    i : Byte;
  BEGIN
    WITH Cfg,Esr^ DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-1,2,'Connect statistics');
      for i:=1 to 5 do
      addstringfield('Protocol #'+Long2Str(i)+':', 1+i,2,'!!!!!',1+i,15,5,820,Statistics.MdmProtocol[i]);
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;


  procedure dirandfiles;
  begin
    WITH Esr^ DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-2,2,'Directories & files');
      addstringfield('Unknown inbound  :',2,2,charstr('!',67),2,21,50,160,cfg.inbound[nsUnknown]);
      addstringfield('Known inbound    :',3,2,charstr('!',67),3,21,50,160,cfg.inbound[nsKnown]);
      addstringfield('Password inbound :',4,2,charstr('!',67),4,21,50,160,cfg.inbound[nsPassword]);
      addstringfield('Outbound         :',5,2,charstr('!',67),5,21,50,161,cfg.outbound);
      addstringfield('Ext Outb.-Manager:',6,2,charstr('X',67),6,21,50,174,cfg.ExtOutboundMan);
      addstringfield('Nodelist         :',7,2,charstr('!',67),7,21,50,162,cfg.NodeList);
      addstringfield('User filename    :',8,2,charstr('!',67),8,21,50,163,cfg.BBS.UserFile);
      addstringfield('Log filename     :',10,2,charstr('!',67),10,21,50,164,cfg.logfilename);
      addbytefield(  'Log level        :',11,2,'#',11,21,165,0,5,cfg.loglevel);
      AddYesNoField( 'Use year in log  :',12,2,'',12,21,166,cfg.UseYearInLog);
      addstringfield('Default macros   :',14,2,charstr('!',67),14,21,50,167,cfg.Defaultmacro);
      addstringfield('Editor           :',15,2,charstr('X',67),15,21,50,168,cfg.editor);
      addstringfield('BBS path         :',16,2,charstr('!',67),16,21,50,169,cfg.BBS.Path);
      addstringfield('Swap path        :',17,2,charstr('!',67),17,21,50,170,cfg.SwapDir);
      addchoicefield('BBS type         :',18,2,'XXXXXXXXXXXXXXX',18,21,171,1,IncBBSType,cfg.BBS.BBSType);
      addstringfield('Banner           :',19,2,charstr('!',67),19,21,50,172,cfg.banner);
      addchoicefield('Nodelist type    :',20,2,'XXXXXXXXXXX',20,21,173,1,IncNodelist,Cfg.NodelistTyp);
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END ;

  PROCEDURE MakeEventScreen;
  BEGIN
    Esr^.init(2,3,79,22,3,'Event');
    WITH Esr^,CurrentEvent DO
    BEGIN
      addtimefield(  'Start time       :',2,2,'hh:mm',2,21,180,0,0,Start);
      addtextfield(  'Init  Mail  Poll  File',3,21);
{      EsFieldOptionsOn(efRightJustify);}
      addbytefield(  'Exit errorlevels :',4,2,'###',4,21,181,0,255,initexit);
      addbytefield(  'Exit errorlevels :',4,2,'###',4,27,182,0,255,mailexit);
      addbytefield(  'Exit errorlevels :',4,2,'###',4,33,183,0,255,pollexit);
      addbytefield(  'Exit errorlevels :',4,2,'###',4,39,184,0,255,filesexit);

      addbytefield(  'Max. bad WaZoo   :',5,2,'###',5,21,185,0,0,tries.bad);
      addbytefield(  'Max. busy    :',5,40,'###',5,55,186,0,0,tries.busy);
{      EsFieldOptionsOff(efRightJustify);}

      addtimefield(  'Call frequency   :',6,2,'hh:mm:ss',6,21,187,0,0,calltime);
      addtimefield(  'Max. delay   :',6,40,'hh:mm:ss',6,55,188,0,0,callwidth);

      addstringfield('Description      :',7,2,CharStr('X',20),7,21,20,189,Description);
      WITH ConnectTo DO
      BEGIN
        EsFieldOptionsOn(efRightJustify);
        AddIntField( 'Connect to       :',8,2,'#####',8,21,190,0,0,Zone);
        AddIntField( ':',8,26,'#####',8,27,190,0,0,Net);
        AddIntField( '/',8,32,'#####',8,33,190,0,0,Node);
        AddIntField( '.',8,38,'#####',8,39,190,0,0,Point);
        EsFieldOptionsOff(efRightJustify);
    END;
      addtextfield(  'MTWTFSSA',9,21);
      AddUserField(  'Active days      :',10,2,'22222222',10,21,8,191,BinLo,BinHi,1,0,ValidateBin,BinConv,DrawString,
                    StringEditor,Active);
{      EsFieldOptionsOn(efRightJustify);}
      addbytefield(  'Date to run      :',11,2,'##',11,21,192,0,31,Day);
      addbytefield(  'Month to run :',11,40,'##',11,55,193,0,12,Month);

      addbytefield(  'Task number      :',12,2,'###',12,21,194,0,99,TaskNumber);
      addbytefield(  'Special dial     :',13,2,'###',13,21,195,0,3,SpecDial);
      addbytefield(  'Schedule number  :',14,2,'###',14,21,196,0,0,SchedNumber);

      AddWordField(  'Max. cost        :',15,2,'#####',15,21,197,0,0,MaxCost);
      AddLongField(  'Min. mail    :',15, 40,'########',15,55,198,0,0, MinMail);
{      EsFieldOptionsOff(efRightJustify);}

      AddTextField(  'Event flags (F7) :',19,2);
      SetUserRecord(CurrentEvent, SizeOf(CurrentEvent));
    END;
  END;

  PROCEDURE ConnectionSetup;
  VAR
    I   : BYTE;
  BEGIN
    WITH Esr^ DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-2,2,'Connection SetUp');
      WITH Cfg.BiMail DO
      BEGIN
        AddStringField('BiModem name        :', 2,2,CharStr('!',79),2,24,54,200,BimodemPath);
        AddWordField(  'Max FullDuplex baud :', 3,2,'#####',3,24,201,0,0,MaxBaud);
        AddStringField('FullDuplex override :', 4,2,'',4,24,10,202,BiOverride[1]);
        FOR i:=2 TO 5 DO
          AddStringField('',4,2,'',4,13+(i*11),10,202,BiOverride[i]);
        AddYesNoField( 'Override NoSend     :', 5,2,'',5,24,203,NoSendOverride);
      END;
      AddYesNoField(   'Use Janus transfers :', 6,2,'', 6,24,204,Cfg.UseJanus);
      AddYesNoField(   'Use EMSI handshake  :', 7,2,'', 7,24,205,Cfg.UseEMSI);
      AddYesNoField(   'SendDummyPkt ZModem :', 8,2,'', 8,24,218,Cfg.ZModemDummyPkt);
      AddYesNoField(   'Call faster systems :', 9,2,'', 9,24,206,Cfg.FastCalls);
      AddYesNoField(   'Curmudgeon          :',10,2,'',10,24,217,Cfg.Curmudgeon);
      AddWordField(    'Minimum BBS Baud    :',11,2,'#####',11,24,207,0,38400,Cfg.BBS.MinBaud);
      AddStringField(  'Slow caller infofile:',12,2,CharStr('!',79),12,24,54,208,Cfg.BBS.MinBaudFile);
      AddByteField(    'User errorlevel     :',13,2,'###',13,24,209,0,255,Cfg.BBS.usererrorlevel);
      Addtimefield(    'Call frequency      :',14,2,'hh:mm:ss',14,24,210,0,0,cfg.calltime);
      Addtimefield(    'Max call delay      :',15,2,'hh:mm:ss',15,24,211,0,0,cfg.callwidth);
      Addtimefield(    'Zone Mail Hour      :',16,2,'hh:mm',16,24,212,0,0,cfg.ZMHStart);
      Addtimefield(    '-',16,30,'hh:mm',16,32,212,0,0,cfg.ZMHEnd);
      AddByteField(    'Max RINGING         :',17,2,'##',17,24,213,0,10,Cfg.MaxRinging);
      AddStringField(  'Press ESC prompt    :',18,2,CharStr('X',79),18,24,54,214,Cfg.PressESCText);
      AddStringField(  'Doing mail text     :',19,2,CharStr('X',79),19,24,54,215,Cfg.DoingMailText);
      AddStringField(  'Enter BBS text      :',20,2,CharStr('X',79),20,24,54,216,Cfg.EnterBBSText);
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE NetMail;
  BEGIN
    Esr^.init(2,3,79,ScreenHeight-2,2,'Mail scanner: Netmail Options');
    WITH Esr^,Cfg.MailScanner DO
    BEGIN
      AddStringField('Netmail dir   :',2,2,CharStr('!',79),2,18,60,220,NetMailDIr);
      AddYesNoField('Strip crash   :',4,2,'',4,18,221,StripCrash);
      AddYesNoField('Set AKA sent  :',6,2,'',6,18,222,SetAKASent);
      AddYesNoField('Save fwd mail :',8,2,'',8,18,223,SaveFWDMail);
      AddYesNoField('Forward mail  :',10,2,'',10,18,224,ForwardMail);
      AddYesNoField('Kill fwd files:',12,2,'',12,18,225,KillFWDFiles);
      AddByteField( 'Hudson netmail:',14,2,'###',14,18,226,0,0,NetMailBoard);
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE EchoMail;
  BEGIN
    Esr^.init(2,3,79,Screenheight-1,2,'Mail scanner: Echomail Options');
    WITH Esr^,Cfg.MailScanner DO
    BEGIN
      AddStringField('Save dupes dir:',2,2,CharStr('!',79),2,18,60,240,SaveDupesDir);
      AddWordField(  'Max dupes     :',4,2,'####',4,18,241,0,0,MaxDupes);
      AddStringField('Echotoss log  :',6,2,CharStr('!',79),6,18,60,242,EchoTossLog);
      AddYesNoField( 'Secure        :',8,2,'',8,18,243,Secure);
      AddYesNoField( 'Old extension :',10,2,'',10,18,244,OldExt);
      AddYesNoField( 'Private EMail :',12,2,'',12,18,245,PvtEchoMail);
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE MakeSchedulerScreen;
  VAR
    i:BYTE;
    Schedule:TSchedule;
  BEGIN
    Esr^.init(2,3,79,24,2,'Schedule');
    WITH Esr^,Schedule DO
    BEGIN
      addbytefield(  'Schedule number    : ',2,2,'###',2,23,280,0,0,Number);
      addbytefield(  'Sched. sub line    : ',4,2,'###',4,23,284,0,0,SubLine);
      AddChoiceField('Action             : ',6,2,'XXXXXXXXXXXXXXXXXXXX',6,23,281,1,MailCfg.IncSCDAction,Schedule.Action);
      AddStringField('Send to            : ',8,2,'',8,23,50,282,Adr[1]);
      AddStringField('',9,2,'',9,23,50,282,Adr[2]);
      AddCharField(  'Stat               :',11,2,'!',11,23,283,#32,#127,Stat);
      SetUserRecord(Schedule, SizeOf(Schedule));
    END;
  END;

  PROCEDURE MakeEchoAreas;
  var
    areasrec : TMsgArea;
  BEGIN
    Esr^.init(2,3,79,ScreenHeight-3,2,'Conferences');
    WITH Esr^, AreasRec DO
    BEGIN
      EsFieldOptionsOn(EfRequired);
      AddStringField('Echonames   :',2,2,CharStr('!',32),2,16,20,300,Echonames[1]);
      EsFieldOptionsOff(EfRequired);
      AddStringField('',2,2,CharStr('!',32),2,38,19,300,EchoNames[2]);
      AddStringField('',2,2,CharStr('!',32),2,59,19,300,EchoNames[3]);
      AddStringField('Directory   :',3,2,CharStr('!',79),3,16,62,301,Directory);
      AddStringField('Origin      :',5,2,'',5,16,50,302,Origin);
      AddStringField('Description :',6,2,'',6,16,40,304,Description);
      AddStringField('Send To     :',7,2,'',7,16,50,305,SendTo[1]);
      AddStringField('',8,2,'',8,16,50,305,SendTo[2]);
      AddStringField('Send ONLY   :',10,2,'',10,16,50,306,SendOnly[1]);
      AddStringField('',11,2,'',11,16,50,306,SendOnly[2]);
      AddChoiceField('Address used:',12,2,'XXXXXXXXXXXXXXXXXXXX',12,16,303,1,MailCfg.IncAkaUsed,UsedAKA);
      EsFieldOptionsOn(EfProtected);
      AddStringField('Scramble Pwd:',13,2,'',13,16,20,307,ScramblePwd);
      AddYesNoField( 'Strip SEENBY:',14,2,'',14,16,308,StripSeenBy);
      AddYesNoField( 'Pvt by EMail:',15,2,'',15,16,309,Pvt2EMail);
      EsFieldOptionsOff(EfProtected);
      AddByteField(  'Level       :',16,2,'###',16,16,311,0,0,Level);
      AddYesNoField( 'Import SEEN-BY''s:',15,20,'',15,38,310,ImportSB);
      AddUserField(  'Keys        :',17,2,'11111111',17,16,8,312,BinLo,BinHi,1,0,ValidateBin,BinConv,DrawString,
                     StringEditor,Keys);
      AddWordField(  'Max Scan    :',18,2,'#####',18,16,313,0,0,MaxScan);
      EsFieldOptionsOn(EfProtected);
      AddWordField(  'Scanned     :',13,42,'#####',13,56,0,0,0,Scanned);
      AddDateField(  'Scan date   :',14,42,'dd/mm-yy',14,56,0,0,0,ScanDate);
      EsFieldOptionsOff(EfProtected);
      AddWordField(  'Msg.Max     :',16,42,'#####',16,56,0,0,0,msgcount);
      AddWordField(  'Days old    :',17,42,'#####',17,56,0,0,0,datecount);
      AddByteField(  'Keep msg.   :',18,42,'###',18,56,0,0,0,msgkeep);
      AddByteField(  'Area Type   :',19,42,'#',19,56,0,0,0,AreaType);

      SetUserRecord(AreasRec,SizeOf(AreasRec));
    END;
  END;

  PROCEDURE MiscOptions;
  BEGIN
    Esr^.init(2,3,79,ScreenHeight-1,2,'Mail scanner: Misc. Options');
    WITH Cfg.MailScanner,Esr^ DO
    BEGIN
      AddStringField('Bad msg. dir. :',2,2,CharStr('!',79),2,18,60,591,BadMsgs);
      AddChoiceField('Default packer:',4,2,'XXX',4,18,593,1,IncArcType,DefaultPacker);
      AddIntField(   'Renum limit   :',6,2,'#####',6,18,0,0,0,renumthresh);
      AddYesNoField( 'Force Write in place mode : ',8,2,'X',8,30,0,ForceWIPMode);
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE nodelistsegSetup;  { Menu = 25 }
  var
    nodelistsegrec : TNodeListSeg;
  begin
    Esr^.init(2,3,79,ScreenHeight-3,2,'Nodelist Segment Setup');
    WITH Esr^,NodeListSegRec DO
    BEGIN
      AddStringField('Nodelist name      :', 2, 2,'!!!!!!!!', 2, 23, 8,340, NodeListName);
      AddStringField('Nodediff name      :', 4, 2,'!!!!!!!!', 4, 23, 8,341, DiffFileName);
      AddIntField(   'Default zone       :', 6, 2,'#####',6,23,346,0,0,DefaultZone);
      AddYesNoField( 'Check CRC          :', 8, 2,'Y', 8, 23,342, CheckCRC);
      AddStringField('New packed NL path :', 10, 2,CharStr('!', 79), 10, 23, 55,343, NewNLPath);
      AddStringField('Include nodes      :', 12, 2,CharStr('X', 50), 12, 23, 50,344, Include[1]);
      AddStringField(                    '', 13, 17,CharStr('X', 50), 13, 23, 50,344, Include[2]);
      AddStringField('Exclude nodes      :', 15, 2,CharStr('X', 50), 15, 23, 50,345, Exclude[1]);
      AddStringField(                    '', 16, 17,CharStr('X', 50), 16, 23, 50,345, Exclude[2]);
      AddStringField('New packed desc.   :', 18, 2,CharStr('X', 79), 18, 23, 55,347, NewNLDesc);
      SetUserRecord(NodeListSegRec,SizeOf(NodeListSegRec));
    end;
  END;

  PROCEDURE NLCompilerTranslationSetup;
  VAR
    Nl : TNLTranslat;
  BEGIN
    Esr^.init(2,3,79,ScreenHeight-3,2,'NodeList Compiler: Translation table');
    WITH Esr^ DO
    BEGIN
      AddTextField('Original                        New',1,2);
      EsFieldOptionsOn(efRequired);
      AddStringField('',2,2,CharStr('!',31),2,2,16,360,Nl.NumFrom);
      EsFieldOptionsOff(efRequired);
      AddStringField('',2,2,CharStr('!',31),2,34,16,361,Nl.NumTo);
      SetUserRecord(Nl,SizeOf(Nl));
    END;
  END;

  PROCEDURE NodelistCompilerSetup;  { = 9 }
  VAR
    i : Byte;
  BEGIN
    WITH Esr^ DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-1,2,'Nodelist compiler');
      WITH Cfg.NlCompiler DO
      BEGIN
        AddStringField('Costfile name    :',2,2,CharStr('!',57),2,21,79,380,CostFileName);
        AddStringField('Our dial prefix  :',3,2,'',3,21,10,381,OurPrefix);
        AddStringField('Int. dial prefix :',4,2,'',4,21,10,382,IntPrefix);
        AddYesNoField( 'Use FIDOUSER.LST :',5,2,'',5,21,383,UseFidoUserLst);

        FOR i:=0 TO 7 DO
        BEGIN
          AddStringField('Modem type #'+Long2Str(i+1)+'    :',7+i,2,'!!!!!',7+i,21,5,384,MTypeStr[i]);
        END;

      END;
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE MakeOkFileScreen;
  var
    okfilerec : TOkFile;
  BEGIN
    WITH EntryCommands, Esr^ DO
    BEGIN
      Esr^.init(2, 3, 79, screenheight-3,2,'Ok-File');
    END;
    WITH Esr^,OkFileRec DO
    BEGIN
      addchoicefield('Node status :', 2,2,'XXX', 2,16,400,1,IncNodeStat,Nodestat);
      AddStringField('Magic name  :', 4,2,'!!!!!!!!!!!!!!!!!!!!', 4, 16, 20,401,magicname);
      esFieldOptionsOn(efRequired);
      AddStringField('File path   :', 6,2,CharStr('!', 79), 6, 16, 62,402,FilePath);
      esFieldOptionsOff(efRequired);
      AddStringField('Password    :', 8,2,'!!!!!!!!!!', 8, 16, 10,403, Password);
      AddByteField(  'Level       :', 10, 2,'999', 10, 16,404, 0, 0, Level);
      AddUserField(  'Keys        :', 12, 2,'11111111',12,16,8,405,BinLo,BinHi,1,0,
                     ValidateBin,BinConv,DrawString,StringEditor,Keys);
      AddChoiceField('Free area   :',14,2,'XXXXXXXXX', 14,16,406,1,IncFreeArea,FreeArea);

      AddByteField(  'Task number :', 16, 2,'999', 16, 16,407, 0, 99, TaskNumber);
      SetUserRecord(OkFileRec, SizeOf(okfilerec));
    END;
  END;

  procedure limits;

    function InitEntryScreen : Word;
    const
      Frame1 = 'Ȼͺ';
      WinOptions = wBordered+wClear+wUserContents;
    begin
      with Esr^ do
      begin
        Esr^.init(2,3,79,ScreenHeight-3,2,'Request options');

        AddTextField('--------- Per call ---------',2,12);
        AddTextField('Num.', 3, 14);
        AddTextField('Time', 3, 25);
        AddTextField('Bytes', 3, 35);

        AddTextField('--------- Per day ----------',2,45);
        AddTextField('Num.', 3, 47);
        AddTextField('Time', 3, 58);
        AddTextField('Bytes', 3, 68);
        WITH Cfg.Request DO
        BEGIN
          EsFieldOptionsOn(efRightJustify);
          AddWordField('Password :', 4, 2, '99999', 4, 13, 420, 0, 65535, Limit[nsPassword,rlPrCall].MaxFiles);
          AddTimeField('Password :', 4, 2, 'hh:mm:ss', 4, 21, 421, 0, 0, Limit[nsPassword,rlPrCall].Maxtime);
          AddLongField('Password :', 4, 2,'99999999', 4, 32,422, 0, $7FFFFFFF, Limit[nsPassword,rlPrCall].MaxBytes);

          AddWordField('Password :', 4, 2, '99999', 4, 46, 420, 0, 65535, Limit[nsPassword,rlPrDay].MaxFiles);
          AddTimeField('Password :', 4, 2, 'hh:mm:ss', 4, 54, 421, 0, 0, Limit[nsPassword,rlPrDay].Maxtime);
          AddLongField('Password :', 4, 2,'99999999', 4, 65,422, 0, $7FFFFFFF, Limit[nsPassword,rlPrDay].MaxBytes);

          AddWordField('Known    :', 6, 2,'99999', 6, 13,420, 0, 65535, Limit[nsKnown,rlPrCall].MaxFiles);
          AddTimeField('Known    :', 6, 2,'hh:mm:ss', 6, 21,421, 0, 0, Limit[nsKnown,rlPrCall].Maxtime);
          AddLongField('Known    :', 6, 2,'99999999', 6, 32,422, 0, $7FFFFFFF, Limit[nsKnown,rlPrCall].MaxBytes);

          AddWordField('Known    :', 6, 2,'99999', 6, 46,420, 0, 65535, Limit[nsKnown,rlPrDay].MaxFiles);
          AddTimeField('Known    :', 6, 2,'hh:mm:ss', 6, 54,421, 0, 0, Limit[nsKnown,rlPrDay].Maxtime);
          AddLongField('Known    :', 6, 2,'99999999', 6, 65,422, 0, $7FFFFFFF, Limit[nsKnown,rlPrDay].MaxBytes);

          AddWordField('Unknown  :', 8, 2,'99999', 8, 13,420, 0, 65535, Limit[nsUnKnown,rlPrCall].MaxFiles);
          AddTimeField('Unknown  :', 8, 2,'hh:mm:ss', 8, 21,421, 0, 0, Limit[nsUnKnown,rlPrCall].Maxtime);
          AddLongField('Unknown  :', 8, 2,'99999999', 8, 32,422, 0, $7FFFFFFF, Limit[nsUnKnown,rlPrCall].MaxBytes);

          AddWordField('Unknown  :', 8, 2,'99999', 8, 46,420, 0, 65535, Limit[nsUnKnown,rlPrDay].MaxFiles);
          AddTimeField('Unknown  :', 8, 2,'hh:mm:ss', 8, 54,421, 0, 0, Limit[nsUnKnown,rlPrDay].Maxtime);
          AddLongField('Unknown  :', 8, 2,'99999999', 8, 65,422, 0, $7FFFFFFF, Limit[nsUnKnown,rlPrDay].MaxBytes);

          EsFieldOptionsOff(efRightJustify);

          AddYesNoField( 'Send RSP-file as message :',11,2,'',11,29,423,Cfg.Request.RspAsPkt);
          AddYesNoField( 'Stop search after match  :',13,2,'',13,29,424,Cfg.Request.SkipAfterFirst);
          AddWordField(  'Minimum baud for request :',15,2,'99999', 15, 29,425, 0, 65535, MinBaud);

          AddChoiceField('RequestOnUs              :',17,2,'XXXXXXXXXX', 17,29,426,1,IncReqOnUs,ReqOnUs);
          AddWordField(  'Max cost for RequestOnUs :',18,2,'99999', 18, 29,427, 0, 65535, ReqOnUsCost);
          SetUserRecord(cfg, SizeOf(cfg));
        END;
        InitEntryScreen := RawError;
      end;
    end;

  begin
    Status := InitEntryScreen;
    if Status <> 0 then begin
      WriteLn('Error initializing entry screen: ', Status);
      Halt(1);
    end;
  end;

  PROCEDURE MakeNodesScreen;
  BEGIN
    Esr^.init(2,3,79,ScreenHeight-3,2,'Nodes setup');
    WITH Esr^,NodesRec DO
    BEGIN
      EsFieldOptionsOn(efRightJustify);
      AddIntField(  'Address         :',2,2,'#####',2,20,440,0,0,Address.Zone);
      AddIntField(  ':',2,25,'#####',2,26,440,0,0,Address.Net);
      AddIntField(  '/',2,31,'#####',2,32,440,0,0,Address.Node);
      AddIntField(  '.',2,37,'#####',2,38,440,0,0,Address.Point);
      AddIntField( 'Pointnet :',2,62,'#####',2,73,441,0,0,PointNet);

      EsFieldOptionsOff(efRightJustify);
      AddStringField('Phone number    :',4,2,CharStr('!',19),4,20,22,442,Phone);
      EsFieldOptionsOn(efRightJustify);
      AddChoiceField('Packer          :',4,40,'XXX',4,58,443,1,IncArcType,PackerType);
      AddByteField(  'Level           :',6,2,'###',6,20,444,0,0,Level);
      AddUserField(  'Keys            :',6,40,'11111111',6,58,8,445,BinLo,BinHi,1,0,ValidateBin,BinConv,DrawString,
                     StringEditor,Keys);
      EsFieldOptionsOff(efRightJustify);
      AddStringField('Session password:',8,2,CharStr('!',8),8,20,8,446,SessionPwd);
      AddStringField('PortalFix passwd:',8,40,CharStr('!',20),8,58,20,447,AreafixPwd);
      AddStringField('Packet password :',9,2,CharStr('!',7),9,20,7,448,PktPassword);
      AddStringField('Tick password   :',9,40,CharStr('!',20),9,58,20,449,TickPassword);

      AddStringField('Special dial 0  :',11,2,CharStr('X',20),11,20,20,450,SpecialDials[0]);
      AddStringField('Special dial 1  :',12,2,CharStr('X',20),12,20,20,450,SpecialDials[1]);
      AddStringField('Special dial 2  :',13,2,CharStr('X',20),13,20,20,450,SpecialDials[2]);

      AddCharField(  'Send flavor     :',15,2,'!',15,20,451,' ','Y',Flavor);
      AddYesNoField( 'Send fwd letter :',15,40,'',15,58,452,SendFwdLetter);
      AddCharField(  'Check connect   :',16,2,'!',16,20,453,' ','Y',CheckConnect);
      AddWordField(  'Min baud:',16,23,'#####',16,33,781,0,0,MinConnectBaud);

      AddCharField(  'Use Fake        :',16,40,'!',16,58,454,' ','Y',UseFake);
      AddYesNoField( 'Disallow F.Req. :',17,2,'',17,20,455,DisallowReq);
      AddCharField(  'Use FullDuplex  :',17,40,'!',17,58,456,' ','Y',UseFullDuplex);
      AddCharField(  'Use EMSI        :',18,2 ,'!',18,20,457,' ','Y',UseEmsi);
      AddYesNoField( 'Pack Tick files :',18,40,'',18,58,458,PackTick);

      AddTimeField(  'BBS open from   :',19,2,'hh:mm',19,20,459,0,0,OpenFrom);
      AddTimeField(  'to',19,26,'hh:mm',19,29,459,0,0,OpenTo);
      AddYesNoField( 'Sync. time      :',19,40,'',19,58,780,EMSISetTime);
      SetUserRecord(NodesRec, SizeOf(NodesRec));
    END;
  END;

  PROCEDURE MakeFwdScreen;
  VAR
    FwdRec : TFileFwd;
  BEGIN
    WITH EntryCommands, Esr^ DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-3,2,'Files to forward');
    END;
    WITH Esr^,FwdRec DO
    BEGIN
      AddStringField('Filename         :',1,3,CharStr('!',12),1,22,12,460,FileName);
      EsFieldOptionsOn(efRightJustify);
      AddIntField(  'Accept from:',1,37,'#####',1,50,461,0,0,GetFrom.Zone);
      AddIntField(  ':',1,55,'#####',1,56,461,0,0,GetFrom.Net);
      AddIntField(  '/',1,61,'#####',1,62,461,0,0,GetFrom.Node);
      AddIntField(  '.',1,67,'#####',1,68,461,0,0,GetFrom.Point);
      EsFieldOptionsOff(efRightJustify);
      AddStringField('PortalFix name   :',2,3,'!!!!!!!!!!',2,22,10,462,PortalFixName);
      EsFieldOptionsOn(efRequired);
      AddStringField('Move to          :',3,3,CharStr('!',79),3,22,57,463,WhereToPut);
      EsFieldOptionsOff(efRequired);
      AddYesNoField('Add to FILES.BBS :',4,3,'',4,22,464,AddToFiles);
      AddStringField('Description      :',5,3,CharStr('X',80),5,22,57,465,Description);
      AddWordField('Add before line  :',7,3,'#####',7,22,466,0,0,AddBeforeLine);
      AddYesNoField('Touch file       :',9,3,'',9,22,467,TouchFile);
      AddYesNoField('Kill dupe        :',10,3,'',10,22,468,KillDupe);
      AddYesNoField('Check date       :',11,3,'',11,22,469,CheckDate);
      AddByteField('Keep#:',11,28,'###',11,35,470,0,0,KeepMax);
      AddStringField('Send to          :',13,3,'',13,22,50,471,SendTo[1]);
      AddStringField(':',14,20,'',14,22,50,471,SendTo[2]);
      AddStringField('Do before move   :',16,3,CharStr('X',79),16,22,57,472,BeforeCmd);
      AddStringField('Do after move    :',17,3,CharStr('X',79),17,22,57,473,AfterCmd);
      AddByteField('Level            :',19,3,'###',19,22,474,0,0,Level);
      AddUserField('Keys :',19,28,'11111111',19,35,8,475,BinLo,BinHi,1,0,ValidateBin,BinConv,DrawString,StringEditor,Keys);
      SetUserRecord(fwdrec, SizeOf(fwdrec));
    END;
  END;

  PROCEDURE FwdMiscOptions;
  BEGIN
    WITH Esr^ DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-1,2,'File forward: Misc. options');
    END;
    WITH Esr^, Cfg.FwdFile DO
    BEGIN
      AddStringField('Secure dir.   :',2,2,CharStr('!',79),2,18,60,480,SecureDir);
      AddStringField('Pre command   :',4,2,CharStr('!',79),4,18,60,481,PreCmd);
      AddStringField('Subject       :',6,2,CharStr('X',72),6,18,60,482,Subject);
      AddYesNoField( 'Private       :',7,2,'',7,18,483,MsgPrivate);
      AddYesNoField( 'KillSent      :',8,2,'',8,18,484,KillSent);
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE InitTickSetup;  { Menu = 22 }
  VAR
    TickAreaRec : TTickArea;
  begin
    Esr^.init(2,3,79,ScreenHeight-3,2,'Tick: Area setup');
    WITH Esr^,TickAreaRec DO
    BEGIN
      AddStringField('Area name    :', 2, 2,'!!!!!!!!!!!!!!!!!!!!', 2, 17, 20,500, AreaName);
      AddStringField('Group name   :', 3, 2,'!!!!!!!!!!', 3, 17, 10,501, GroupName);
      AddStringField('Human name   :', 4, 2,CharStr('X', 40), 4, 17, 40,502, HumanName);
      AddStringField('Area path    :', 6, 2,CharStr('!', 79), 6, 17, 61,503, AreaPath);

      EsFieldOptionsOn(efProtected);
      AddYesNoField( 'Write letter :', 8, 2,'Y', 8, 17,504, WriteLetter);
      AddStringField('Message path :', 9, 2,CharStr('!', 79), 9, 17, 61,505, AnnouncePath);
      EsFieldOptionsOff(efProtected);

      AddYesNoField( 'Allow repack :',11, 2,'Y', 11, 17,506, CanBeRepacked);
      AddYesNoField( 'Check CRC :',   11,21,'Y', 11, 33,507, CheckCRC);
      AddChoiceField('Address used:',11,37,'XXXXXXXXXXXXXXXXXXXX',11,50,508,1,MailCfg.IncAkaUsed,AKAToUse);
      AddYesNoField( 'Check dupe   :',12, 2,'Y', 12, 17,514, CheckDupe);

      AddStringField('In nodes     :',14, 2,CharStr('X', 50), 14, 17, 50,509, GetFrom[1]);
      AddStringField('', 15, 17,CharStr('X', 50), 15, 17, 50,509, GetFrom[2]);
      AddStringField('Out nodes    :', 16, 2,CharStr('X', 50), 16, 17, 50,510, SendTo[1]);
      AddStringField('', 17, 17,CharStr('X', 50), 17, 17, 50,510, SendTo[2]);
      AddByteField(  'Level        :', 19, 2,'999', 19, 17,511, 0, 255, Level);
      AddUserField(  'Keys :',19,23,'11111111',19,30,8,512,BinLo,BinHi,1,0,ValidateBin,BinConv,DrawString,StringEditor,Keys);
      AddStringField('FILES.BBS    :', 20, 2,CharStr('!', 12), 20, 17, 50, 513, FilesBBS);
      SetUserRecord(TickAreaRec, SizeOf(TickAreaRec));
    end;
  END;

  PROCEDURE MakeTickMiscScreen;  { Menu = 23 }
  begin
    Esr^.init(2,3,79,ScreenHeight-1,2,'Tick: Misc. setup');
    WITH Esr^,Cfg DO
    BEGIN
      AddStringField('Dupe directory       :', 2, 2,CharStr('!',79), 2, 25, 53,520, Tick.DupeDir);
      AddStringField('Hold directory       :', 3, 2,CharStr('!',79), 3, 25, 53,521, Tick.HoldDir);
      AddStringField('Do before processing :', 4, 2,CharStr('!',79), 4, 25, 53,522, Tick.BeforeMoving);
      AddYesNoField( 'Request missing      :', 5, 2,'Y', 5, 25,523, Tick.RequestMissing);
      SetUserRecord(cfg, SizeOf(cfg));
    end;
  END;

  PROCEDURE MakeFuncKeyScreen;
  VAR
    i:BYTE;
  BEGIN
    WITH Esr^ DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-1,2,'Function keys');
      AddTextField('#  Lvl  Description (CTRL-keys)',1,3);
      FOR i:=1 TO 10 DO
      BEGIN
        EsFieldOptionsOn(efRightJustify);
        addbytefield(LongIntForm('###',i),1+i,2,'###',1+i,6,540,0,0,cfg.fkey[1,i].errorlevel);
        EsFieldOptionsOff(efRightJustify);
        addstringfield('',1+i,2,'',1+i,11,67,541,cfg.fkey[1,i].description);
      END;
      AddTextField('#  Lvl  Description (ALT-Keys)',13,3);
      FOR i:=1 TO 10 DO
      BEGIN
        EsFieldOptionsOn(efRightJustify);
        addbytefield(LongIntForm('###',i),13+i,2,'###',13+i,6,540,0,0,cfg.fkey[2,i].errorlevel);
        EsFieldOptionsOff(efRightJustify);
        Addstringfield('',13+i,2,'',13+i,11,67,541,cfg.fkey[2,i].description);
      END;
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE AreaManagerConfiguration;
  BEGIN
    WITH Esr^ DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-1,2,'AreaManager setup');
      WITH Cfg.AreaMan DO
      BEGIN
        AddCharField( 'DL. count look  :',2,2,'!',2,20,560,#32,#255,DLCntStart);
        AddCharField( '0',2,21,'!',2,22,560,#32,#255,DLCntStop);

        AddByteField( 'Number of digits:',3,2,'#',3,20,567,0,8,DlCDigits);
        AddYesNoField('Zero pad        :',4,2,'',4,20,568,DlCZeroFill);

        AddYesNoField('Adopt always    :',6,2,'',6,20,561,AdoptDefault);
        AddYesNoField('Insert DL. count:',8,2,'',8,20,562,InsDLCnt);
        AddYesNoField('Adopt inbound   :',10,2,'',10,20,563,AddInbound);
        addbytefield( 'File areas      :',12,2,'###',12,20,564,0,255,FirstArea);
        addbytefield( '-',12,23,'###',12,24,565,0,0,LastArea);
        addstringfield('View Picture    :',14,2,charstr('X',60),14,20,50,566,ViewCMD);
      END;
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE DumbTerminalExternalProtocols;
  VAR
    i:BYTE;
  BEGIN
    WITH Cfg, Esr^ DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-1,2,'External protocols');
      FOR i:=1 TO 5 DO
      BEGIN
        AddCharField( 'Key     :',i*4-2,2,'!',i*4-2,12,580,#32,#90,extprot[i].key);
        AddStringField('Name :',i*4-2,16,'',i*4-2,23,8,581,extprot[i].name);
        AddYesNoField( 'Prompt DL. name:',i*4-2,34,'',i*4-2,51,582,extprot[i].AskDLName);
        AddStringField('Auto start :',i*4-2,57,'',i*4-2,68,10,583,extprot[i].autostart);
        AddStringField('Send    :',i*4-1,2,CharStr('X',50),i*4-1,12,79,584,extprot[i].sendcmd);
        AddStringField('Receive :',i*4,2,CharStr('X',50),i*4,12,79,585,extprot[i].recvcmd);
      END;
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE DumbTerminalSetup;
  BEGIN
    WITH Esr^,Cfg.DumbTerm DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-3,2,'Dumb terminal misc. options');
      addstringfield('Modem init            :',2,2,'',2,26,40,600,modemInit);
      AddYesNoField( 'CR sends LF           :',4,2,'',4,26,601,CRSendsLF);
      AddYesNoField( 'Destructive BS        :',6,2,'',6,26,602,DestructiveBS);
      AddWordField(  'TimeOut on No Carrier :',8,2,'####',8,26,603,0,7200,TimeOutNoCarrier);
      AddWordField(  'TimeOut on Carrier    :',10,2,'####',10,26,604,0,7200,TimeOutCarrier);
      AddByteField(  'Ext. Term. Errorlevel :',12,2,'###',12,26,605,0,248,ExtTermErrorlevel);
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE ListFiles;
  BEGIN
    WITH Esr^,Cfg.ListFiles DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-3,2,'PoP-List: Directories and files');
      addstringfield('FileList name  :',2,2,charstr('!',79),2,19,50,620,FileList);
      addstringfield('NewsList name  :',4,2,charstr('!',79),4,19,50,621,NewsList);
      addstringfield('Header name    :',6,2,charstr('!',79),6,19,50,622,Header);
      addstringfield('Footer name    :',8,2,charstr('!',79),8,19,50,623,Footer);
      addstringfield('Statistics file:',10,2,charstr('!',79),10,19,50,624,StatFile);
      addstringfield('TopList file   :',12,2,charstr('!',79),12,19,50,625,TopFile);
      addstringfield('Dupe report    :',14,2,charstr('!',79),14,19,50,626,DupeReport);
      addstringfield('Bimodem Ok-File:',16,2,charstr('!',79),16,19,50,632,OkBimodemPath);
      addstringfield('Run CMD before :',18,2,charstr('X',79),18,19,50,627,DoBefore);
      addstringfield('Run pack CMD   :',19,2,charstr('X',79),19,19,50,628,DoPack);
      addstringfield('Run CMD after  :',20,2,charstr('X',79),20,19,50,629,DoAfter);
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE ListFiles2;
  Var
    x:Byte;
  BEGIN
    WITH Esr^,Cfg.ListFiles DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-3,2,'PoP-List: Misc. options');
      AddYesNoField( 'Adopt files    :',2,2,'',2,19,640,Adopt);
      AddByteField(  'NewsList days  :',2,25,'##',2,42,641,0,255,NewsDays);
      AddYesNoField( 'Update OK-File :',2,48,'',2,65,642,OkPortal);
      AddYesNoField( 'Incl statistics:',3,2,'',3,19,643,Stat);
      AddYesNoField( 'Incl TopList   :',3,25,'',3,42,644,IncludeTop);
        EsFieldOptionsOn(EfProtected);
      AddYesNoField( 'Remove missing :',3,48,'',3,65,645,RemMissing);
        EsFieldOptionsOff(EfProtected);
      AddYesNoField( 'European dates :',4,2,'',4,19,646,DkDate);
      AddByteField(  'Top X (numbers):',4,25,'##',4,42,647,0,50,Top);
      AddByteField(  'Dupe threshold :',4,48,'###',4,65,648,0,100,Threshold);
      AddYesNoField( 'Dupe check     :',5,2,'',5,19,649,DupeCheck);
      AddYesNoField( 'Touch Illegal  :',5,25,'',5,42,650,Touch);
        EsFieldOptionsOn(EfProtected);
      AddYesNoField( 'Zap ZeroLength :',5,48,'',5,65,651,ZapZero);
        EsFieldOptionsOff(EfProtected);
      addstringfield('Adopt comment  :',7,2,'',7,19,40,652,AdoptComment);
      addstringfield('Freq NOT OK    :',8,2,'',8,19,55,631,TXTFreq[0]);
      addstringfield('Freq for ALL   :',9,2,'',9,19,55,630,TXTFreq[1]);
      addstringfield('Freq for KNOWN :',10,2,'',10,19,55,630,TXTFreq[2]);
      addstringfield('Freq for PWD   :',11,2,'',11,19,55,630,TXTFreq[3]);
      AddTextField(  'Delete         Exclude       NoDupeCheck  NoAdopt       NoAdopt  Private',13,2);
      AddTextField(  'FileNames      FileNames     FileNames    FileNames     areas    areas  ',14,2);
      For x:=15 to 24 do
      BEGIN
        addstringfield('',x,2,'',x,2,12,653,CrapFiles[x-14]);
        EsFieldOptionsOn(EfProtected);
        addstringfield('',x,17,'',x,17,12,654,ExcludeFiles[x-14]);
        addstringfield('',x,31,'',x,31,8,655,NoDupeCheck[x-14]);
        addstringfield('',x,44,'',x,44,12,656,NonAdoptFiles[x-14]);
        addstringfield('',x,58,'',x,58,3,657,NonAdoptAreas[x-14]);
        EsFieldOptionsOff(EfProtected);
        addstringfield('',x,67,'',x,67,3,658,PrivateAreas[x-14]);
      END;
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE MultiListSegment;
  Var
    x:Byte;
    FileListSegment: TFileListSegment;
  BEGIN
    WITH Esr^,FileListSegment DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-3,2,'Multiple Filelist Segments');
      addstringfield('Segment Name   :',2,2,'',2,19,20,0,Name);
      addstringfield('Filename       :',3,2,charstr('!',79),3,19,50,0,FileName);
      addstringfield('Header File    :',4,2,charstr('!',79),4,19,50,0,HeaderFile);
      addstringfield('Include areas  :',5,2,charstr('!',50),5,19,50,0,IncludeAreas[1]);
      addstringfield('                ',6,2,charstr('!',50),6,19,50,0,IncludeAreas[2]);
      addstringfield('                ',7,2,charstr('!',50),7,19,50,0,IncludeAreas[3]);
      addstringfield('                ',8,2,charstr('!',50),8,19,50,0,IncludeAreas[4]);
      addstringfield('Do after       :',9,2,charstr('!',79),9,19,50,0,DoAfter);
      SetUserRecord(FileListSegment, SizeOf(FileListSegment));
    END;
  END;

  PROCEDURE MultiBBSSetUp;
  VAR
    i   : BYTE;
  BEGIN
    WITH Esr^ DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-1,2,'Multiple BBS setup');
      AddTextField('Key  Batch file',2,5);
      FOR i:=1 TO 5 DO
        WITH Cfg.BBS.Multi[i] DO
        BEGIN
          AddCharField(  CHR(i+48)+':',2+i*2,3,'!',2+i*2,6,660,' ','Z',Key);
          addstringfield('',1,1,'!!!!!!!!',2+i*2,10,8,661,BatName);
        END;
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE ArchiverSetUp;
  VAR
    i   : BYTE;
  BEGIN
    Esr^.init(2,3,79,ScreenHeight-1,2,'Archiver setup');
    WITH Esr^ DO
    BEGIN
      FOR i:=1 TO 7 DO
        WITH cfg.Packer[i] DO
        BEGIN
          AddStringField(Packers[i]+' :',1+i*2,2,CharStr('X',40),1+i*2,8,17,680,cfg.Packer[i].AddCmd);
          AddStringField('',1,1,CharStr('X',40),1+i*2,26,17,681,cfg.Packer[i].UnPackCmd);
          AddStringField('',1,1,CharStr('X',40),1+i*2,44,17,682,cfg.Packer[i].TestCmd);
          AddStringField('',1,1,CharStr('X',40),1+i*2,62,17,683,cfg.Packer[i].EraseCmd);
        END;
      AddTextField('Add',2,8);
      AddTextField('Unpack',2,26);
      AddTextField('Test',2,44);
      AddTextField('Erase',2,62);
      SetUserRecord(cfg, SizeOf(cfg));
    END;
  END;

  PROCEDURE MiscScreen;
  BEGIN
    WITH Cfg.Screen,Esr^ DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-1,2,'Misc. screen options');
      AddTimeField( 'Screenblank timeout  :',2,2,'hh:mm:ss',2,25,740,0,0,blanktime);
      AddYesNoField('43/50 lines          :',4,2,'',4,25,741,ScrMode);
      AddYesNoField('Check for snow       :',6,2,'',6,25,742,ChkSnow);
      AddYesNoField('Keep off screen mode :',8,2,'',8,25,743,KeepOffScrMode);
      AddYesNoField('Exploding windows    :',10,2,'',10,25,744,ExplodingWin);
      AddYesNoField('Hardware screenblank :',12,2,'',12,25,745,HardwareBlank);
      AddYesNoField('Four digits year     :',14,2,'',14,25,746,FourDigitsYear);
      SetUserRecord(Cfg, SizeOf(cfg));
    END;
  END;

  procedure globalvalues;
  begin
    with Esr^ do
    begin
      Esr^.init(2,3,79,ScreenHeight-1,2,'Global values');
      addbytefield(  'Task number                   :',2,2,'###',2,34,760,0,99,cfg.tasknumber);
      AddYesNoField( 'Task number is in hex         :',3,2,'',3,34,766, Cfg.HexTask);
      AddTimeField(  'Delay between outbound reread :',6,2,'hh:mm:ss',6,34,761,60,SecondsInDay,cfg.OutReReadDelay);
      AddYesNoField( 'Rescan on dial if no mail     :',7,2,'',7,34,765,Cfg.RereadOnCall);
      AddStringField('Password for function request :',9,2,CharStr('!',20),9,34,20,762,Cfg.FuncReqPwd);
      AddYesNoField( 'Swap on exec                  :',11,2,'',11,34,763,Cfg.SwapOnExec);
      AddYesNoField( 'Keep empty outbound dir''s     :',13,2,'',13,34,764,Cfg.KeepEmptyDirs);
      addchoicefield('Task type                     :',15,2,'XXXXXXXXXXXXXXX',15,34,0,1,IncTaskType,cfg.TaskType);
      addstringfield('BBS Definition file           :',17,2,'!!!!!!!!',17,34,8,0,Cfg.BBS.DefFile);
      SetUserRecord(cfg, SizeOf(cfg));
    end;
  end;

  procedure MakeInboundToDoScreen;
  begin
    with Esr^ do
    begin
      Esr^.init(2,3,79,ScreenHeight-1,2,'Inbound Control');
      addtextfield('Unknown', 2, 25);
      addtextfield('Known', 2, 39);
      addtextfield('Password', 2, 55);

      AddBitYesNoField( 'Process tick files :',3,2,'',3,28,800,0,Cfg.InboundToDo[nsUnknown]);
      AddBitYesNoField( 'Process tick files :',3,2,'',3,43,800,0,Cfg.InboundToDo[nsKnown]);
      AddBitYesNoField( 'Process tick files :',3,2,'',3,58,800,0,Cfg.InboundToDo[nsPassword]);

      AddBitYesNoField( 'Forward files      :',4,2,'',4,28,801,1,Cfg.InboundToDo[nsUnknown]);
      AddBitYesNoField( 'Forward files      :',4,2,'',4,43,801,1,Cfg.InboundToDo[nsKnown]);
      AddBitYesNoField( 'Forward files      :',4,2,'',4,58,801,1,Cfg.InboundToDo[nsPassword]);

      AddBitYesNoField( 'Process mail       :',5,2,'',5,28,802,2,Cfg.InboundToDo[nsUnknown]);
      AddBitYesNoField( 'Process mail       :',5,2,'',5,43,802,2,Cfg.InboundToDo[nsKnown]);
      AddBitYesNoField( 'Process mail       :',5,2,'',5,58,802,2,Cfg.InboundToDo[nsPassword]);
      SetUserRecord(cfg, SizeOf(cfg));
    end;
  end;

{=== Misc. entry screens ====================================================}

  PROCEDURE NLMan;
  var
    exitcommand : byte;
  begin
    WITH Esr^,nodelistentry DO
    BEGIN
      Esr^.init(2,3,79,ScreenHeight-3,2,'Nodelist manager');
      AddIntField('Address      :',4,3,'####',4,19,1000,0,0,Adr.Zone);
      AddIntField(':',4,24,'#####',4,25,1000,0,0,Adr.Net);
      AddIntField('/',4,30,'#####',4,31,1000,0,0,Adr.Node);
      AddIntField('.',4,36,'#####',4,37,1000,0,0,Adr.Point);
      addstringfield('System name  :',6,3,'',6,19,34,1001,SystemName);
      addstringfield('SysOp name   :',7,3,'',7,19,30,1002,SysopName);
      AddIntField('Hub node     :',6,58,'#####',6,74,1003,0,32767,HubNode);
      addstringfield('Misc. info   :',8,3,'',8,19,30,1004,MiscInfo);
      AddWordField('Baudrate     :',8,58,'#####',8,74,1005,0,38400,BaudRate);
      AddWordField('Cost         :',10,3,'#####',10,19,1006,0,0,Cost);
      addbytefield('Modem type   :',10,58,'###',10,74,1007,0,0,ModemType);
      AddWordField('Real cost    :',12,3,'#####',12,19,1008,0,65535,RealCost);
      addstringfield('Phone number :',14,3,'',14,19,40,1009,PhoneNumber);
      addstringfield('Password     :',16,3,'',16,19,8,1010,Password);
      AddTextField('Flags        :',18,3);

      FOR ExitCommand:=0 TO 8 DO
        EntryCommands.addcommand(ccUser2+ExitCommand,1,WORD(256*(60+ExitCommand)),0);
      SetUserRecord(nodelistentry, SizeOf(nodelistentry));
    end;
  end;


{=== UserBrowser ============================================================}

  PROCEDURE UserMaxScreen;
  VAR
    Ur:MaximusUserType;
  BEGIN
    Esr^.Init(2,3,79,ScreenHeight-3,3,'Maximus 3.0 user');
    With Esr^ do
    BEGIN
      EsFieldOptionsOff(efClearFirstChar);
      AddTextField(  'User No. :',1,2);
        EsFieldOptionsOn(EfProtected);
      AddStringField('Name     :',2,2,'',2,13,35,1020,Ur.Name);
      AddDateStField('Last date:',3,50,'dd/mm-yy',3,61,1021,Ur.Diverse.TempDate);
      AddTimeField(  'Last time:',4,50,'hh:mm:ss',4,61,1022,0,0,UR.Diverse.TempTime);
        EsFieldOptionsOff(EfProtected);
      AddChoiceField('Level    :',3,2,'XXXXXXXXXXXXXXX',3,13,1023,2,UserEdit.IncMaximusUserLevel,ur.Priv);
      AddStringField('City     :',4,2,'',4,13,35,1024,ur.City);
      AddStringField('Alias    :',5,2,'',5,13,20,1025,ur.Alias);
      AddStringField('Phone    :',6,2,'',6,13,14,1026,ur.Phone);
      AddWordField(  'Calls    :',6,50,'#####',6,61,1027,0,0,ur.Times);
  {    AddStringField('Pwd.     : ',7,2,'',7,13,15,0,UserRecord7.Pwd);}
        EsFieldOptionsOn(EfPassWordMode);
      AddStringField('Password :',7,2,'',7,13,15,1028,ur.Pwd);
        EsFieldOptionsOff(EfPassWordMode);
  {    AddWordField(  'Msg.Area : ',10,2,'###',10,13,5,0,255,UserRecord3.MSG);}
  {    AddWordField(  'FileArea : ',10,50,'###',10,61,5,0,255,UserRecord3.Files);}
      AddlongField(  'Upload Kb:',11,2,'########',11,13,1029,0,0,ur.Up);
      AddWordField(  'TimeToday:',11,50,'#####',11,61,1030,0,0,ur.Time);
      AddLongField(  'Dnload Kb:',12,2,'########',12,13,1031,0,0,ur.Down);
      AddLongField(  'Dnl.Today:',12,50,'#####',12,61,1032,0,0,ur.DownToDay);
      AddTextField(  'UL-Ratio : 1 :',13,50);
  {   AddLongField( 'ExtraInfo: ',13,2,'#####',13,13,5,0,0,ur.Extra); }
      AddChoiceField( 'Help Lvl : ',14,2,'XXXXXXXX',14,13,0,1,UserEdit.IncMaxHelpLevel,Ur.Help);
      AddChoiceField( 'Video    : ',14,50,'XXXXXXXX',14,61,0,1,UserEdit.IncMaxVideoLevel,Ur.Video);
      AddChoiceField( 'Rip      : ',15,50,'XXX',15,61,0,1,UserEdit.ChangeMaxRipStatus,Ur.Bits);
{      AddChoiceField( 'Protocol : ',15,2,'XXXXXXXXX',15,13,0,1,UserEdit.IncMaxProtocol,Ur.DefProto); }
{      AddShortField( 'Protocol : ',15,2,'####',15,13,0,0,0,Ur.DefProto);}

      AddTextField('12345678ABCDEFGHIJKLMNOPQRSTUVWX',17,8);
      EsFieldOptionsOn(efForceOvertype);
      EsFieldOptionsOn(efForceMode);
      AddUserField('Keys :',18,2,'11111111111111111111111111111111',18,8,32,1033,Bin32Lo,Bin32Hi,4,0,UserEdit.ValidateBin32,
                   Useredit.BinConv32,DrawString,StringEditor,ur.xKeys);
      SetUserRecord(ur,SizeOf(ur));
    END;
  END;

  PROCEDURE MakeUserQBBSMain;
  VAR
    ur:QBBSUserType;
  BEGIN
    Esr^.init(2,3,79,ScreenHeight-3,3,'QuickBBS user');
    With Esr^,ur do
    BEGIN
      EsFieldOptionsOff(efClearFirstChar);
      AddTextField(  'User #   :',1,2);
      AddWordField(  'Level    :',2,2,'#####',2,13,1040,0,32767,SecLvl);
      AddStringField('Name     :',3,2,'',3,13,35,1041,Name);
      AddDateStField('Last date:',3,50,'dd/mm-yy',3,61,1042,Diverse.TempDate);
      AddStringField('City     :',4,2,'',4,13,25,1043,City);
      AddTimeField(  'Last time:',4,50,'hh:mm',4,61,1044,0,0,Diverse.TempTime);
      AddStringField('HomePhone:',5,2,'',5,13,12,1045,HomePhone);
      AddStringField('DataPhone:',5,50,'',5,61,12,1046,DataPhone);
      EsFieldOptionsOn(efPassWordMode);
      AddStringField('Password :',6,2,'',6,13,15,1047,Pwd);
      EsFieldOptionsOff(efPassWordMode);
      AddWordField(   'Calls    :',6,50,'#####',6,61,1048,0,0,Times);
      AddWordField(   'Credit   :',7,2,'#####',7,13,1049,0,0,Credit);
      AddWordField(   'Pending  :',7,50,'#####',7,61,1050,0,0,Pending);
      AddWordField(   'Posted   :',8,2,'#####',8,13,1051,0,0,TimesPosted);
      AddWordField(   'HighMsgRd:',8,50,'#####',8,61,1052,0,0,HighMsgRead);
      AddWordField(   'Downloads:',10,2,'#####',10,13,1053,0,0,Downs);
      AddWordField(   'Uploads  :',10,50,'#####',10,61,1054,0,0,Ups);
      AddWordField(   'Dnload Kb:',11,2,'#####',11,13,1055,0,0,DownK);
      AddWordField(   'Upload Kb:',11,50,'#####',11,61,1056,0,0,UpK);
      AddTextField(   'UL-Ratio : 1 :',12,50);
      addDatefield(   'Birthday :',13,2,'dd/mm-yy',13,13,1057,0,0,BirthDay);
      EsFieldOptionsOn(efForceOvertype);
      EsFieldOptionsOn(efForceMode);
      AddTextField(  '87654321',15,13);
      AddUserField(  'A-Flags  :',16,2,'11111111',16,13,32,1058,BinLo,BinHi,1,0,ValidateBin,BinConv,
                   DrawString,StringEditor,Flags.A);
      AddUserField(  'B-Flags  :',17,2,'11111111',17,13,32,1058,BinLo,BinHi,1,0,ValidateBin,BinConv,
                   DrawString,StringEditor,Flags.B);
      AddUserField(  'C-Flags  :',18,2,'11111111',18,13,32,1058,BinLo,BinHi,1,0,ValidateBin,BinConv,
                   DrawString,StringEditor,Flags.C);
      AddUserField(  'D-Flags  :',19,2,'11111111',19,13,32,1058,BinLo,BinHi,1,0,ValidateBin,BinConv,
                   DrawString,StringEditor,Flags.D);
      SetUserRecord(ur,SizeOf(ur));
    END;
  END;

  PROCEDURE MakeUserSBBSMain;
  VAR
    ur:SBBSUserType;
    Ex:ExtraUserRec;
  BEGIN
    Esr^.init(2,3,79,ScreenHeight-3,3,'SuperBBS user');
    With Esr^,ur do
    BEGIN
      EsFieldOptionsOff(efClearFirstChar);
      AddTextField(  'User #   :',1,2);
      AddWordField(  'Level    :',2,2,'#####',2,13,1040,0,32767,SecLvl);
      AddStringField('Name     :',3,2,'',3,13,35,1041,Name);
      AddDateStField('Last date:',3,50,'dd/mm-yy',3,61,1042,Diverse.TempDate);
      AddStringField('City     :',4,2,'',4,13,25,1043,City);
      AddTimeField(  'Last time:',4,50,'hh:mm',4,61,1044,0,0,Diverse.TempTime);
      AddStringField('HomePhone:',5,2,'',5,13,12,1045,HomePhone);
      AddStringField('DataPhone:',5,50,'',5,61,12,1046,DataPhone);
      EsFieldOptionsOn(efPassWordMode);
      AddStringField('Password :',6,2,'',6,13,15,1047,Password);
      EsFieldOptionsOff(efPassWordMode);
      AddWordField(   'Calls    :',6,50,'#####',6,61,1048,0,0,Times);
      AddIntField(    'Credit   :',7,2,'#####',7,13,1049,0,0,Credit);
      AddIntField(    'Pending  :',7,50,'#####',7,61,1050,0,0,Pending);
      AddWordField(   'Posted   :',8,2,'#####',8,13,1051,0,0,MsgsPosted);
      AddWordField(   'HighMsgRd:',8,50,'#####',8,61,1052,0,0,HighMsgRead);
      AddByteField(   'Age      :',9,2,'###',9,13,0,0,255,Age);
      AddWordField(   'Downloads:',10,2,'#####',10,13,1053,0,0,Downs);
      AddWordField(   'Uploads  :',10,50,'#####',10,61,1054,0,0,Ups);
      AddWordField(   'Dnload Kb:',11,2,'#####',11,13,1055,0,0,DownK);
      AddWordField(   'Upload Kb:',11,50,'#####',11,61,1056,0,0,UpK);
      AddTextField(   'UL-Ratio : 1 :',12,50);
      EsFieldOptionsOn(efForceOvertype);
      EsFieldOptionsOn(efForceMode);
      AddTextField(  '87654321',15,13);
      AddUserField(  'A-Flags  :',16,2,'11111111',16,13,32,1058,BinLo,BinHi,1,0,ValidateBin,BinConv,
                   DrawString,StringEditor,Flags.A);
      AddUserField(  'B-Flags  :',17,2,'11111111',17,13,32,1058,BinLo,BinHi,1,0,ValidateBin,BinConv,
                   DrawString,StringEditor,Flags.B);
      AddUserField(  'C-Flags  :',18,2,'11111111',18,13,32,1058,BinLo,BinHi,1,0,ValidateBin,BinConv,
                   DrawString,StringEditor,Flags.C);
      AddUserField(  'D-Flags  :',19,2,'11111111',19,13,32,1058,BinLo,BinHi,1,0,ValidateBin,BinConv,
                   DrawString,StringEditor,Flags.D);
      SetUserRecord(ur,SizeOf(ur));
    END;
  END;

  PROCEDURE MakeUserSBBSExtra;
  VAR
    Ex:ExtraUserRec;
  BEGIN
    WITH Esr^,Ex DO
    BEGIN
      init(2,3,79,ScreenHeight-3,3,'SuperBBS Extra information');
      EsFieldOptionsOff(efClearFirstChar);
      EsFieldOptionsOn(efProtected);
      AddStringField('Name          :',2,2,'',2,18,35,0,Name);
      AddStringField('First date    :',3,2,'XXXXXXXX',3,18,8,0,FirstTime);
      AddStringField('First time    :',4,2,'XXXXX',4,18,5,0,FirstDate);
      EsFieldOptionsOff(efProtected);
      AddDateStField('Birthday      :',5,2,'dd-mm-yy',5,18,0,BirthDay);
      AddStringField('Comment       :',6,2,CharStr('!',50),6,18,80,0,SysopComment);
      AddStringField('Alias         :',7,2,'',7,18,35,0,Alias);
      AddStringField('View file     :',8,2,'',8,18,12,0,ViewFileName);
      AddStringField('First Menu    :',9,2,'',9,18,8,0,MenuToRun);
      AddWordField(  'Time in bank  :',10,2,'#####',10,18,0,0,0,TimeInBank);
      AddByteField(  'Calls today   :',10,2,'#####',10,18,0,0,0,TodayCalls);
      AddStringField('Language      :',11,2,'',11,18,8,0,LanguageFileN);

      SetUserRecord(Ex,SizeOf(Ex));
    END;
  END;

  PROCEDURE MakeUserRAMain;
  VAR
    ur:RAUserType;
  BEGIN
    Esr^.init(2,3,79,ScreenHeight-3,3,'RemoteAccess user');
    With Esr^ do
    BEGIN
      EsFieldOptionsOff(efClearFirstChar);
      AddTextField(  'User #   :',1,2);
      EsFieldOptionsOn(EfProtected);
      AddStringField('Name     :',2,2,'',2,13,35,1060,ur.Name);
      AddDateStField('Last date:',2,50,'dd/mm-yy',2,61,1061,ur.LastDate);
      EsFieldOptionsOff(EfProtected);
      AddWordField(  'Level    :',3,2,'#####',3,13,1062,0,65535,ur.Security);
      AddStringField('City     :',4,2,'',4,13,25,1063,ur.Location);
(*    AddTimeStField('Last Time: ',4,50,'hh:mm',4,61,2005,0,0,ur.LastTime); *)
      AddStringField('HomePhone:',5,2,'',5,13,12,1064,ur.VoicePhone);
      AddStringField('DataPhone:',5,50,'',5,61,12,1065,ur.DataPhone);
      EsFieldOptionsOn(efPassWordMode);
      AddStringField('Password :',6,2,'',6,13,15,1066,ur.Password);
      EsFieldOptionsOff(efPassWordMode);
      AddWordField(  'Calls    :',6,50,'#####',6,61,1067,0,0,ur.NoCalls);
      AddWordField(  'Credit   :',7,2,'#####',7,13,1068,0,0,ur.Credit);
      AddWordField(  'Pending  :',7,50,'#####',7,61,1069,0,0,ur.Pending);
      AddWordField(  'Posted   :',8,2,'#####',8,13,1070,0,0,ur.MsgsPosted);
      AddWordField(  'HighMsgRd:',8,50,'#####',8,61,1071,0,0,ur.LastRead);
      AddWordField(  'Downloads:',10,2,'#####',10,13,1072,0,0,ur.Downloads);
      AddWordField(  'Uploads  :',10,50,'#####',10,61,1073,0,0,ur.Uploads);
      AddWordField(  'Dnload Kb:',11,2,'#####',11,13,1074,0,0,ur.DownloadsK);
      AddWordField(  'Upload Kb:',11,50,'#####',11,61,1075,0,0,ur.UploadsK);
      AddTextField(  'UL-Ratio : 1 :',12,50);
(*    addDatefield(  'Birthday : ',13,2,'dd/mm-yy',13,13,0,0,0,UserRecord1.BirthDay); *)
      EsFieldOptionsOn(efForceOvertype);
      EsFieldOptionsOn(efForceMode);
      AddTextField(  '87654321',15,13);
      AddUserField(  'A-Flags  :',16,2,'11111111',16,13,32,1078,BinLo,BinHi,1,0,ValidateBin,BinConv,
                   DrawString,StringEditor,ur.Flags.A);
      AddUserField(  'B-Flags  :',17,2,'11111111',17,13,32,1078,BinLo,BinHi,1,0,ValidateBin,BinConv,
                   DrawString,StringEditor,ur.Flags.B);
      AddUserField(  'C-Flags  :',18,2,'11111111',18,13,32,1078,BinLo,BinHi,1,0,ValidateBin,BinConv,
                   DrawString,StringEditor,ur.Flags.C);
      AddUserField(  'D-Flags  :',19,2,'11111111',19,13,32,1078,BinLo,BinHi,1,0,ValidateBin,BinConv,
                   DrawString,StringEditor,ur.Flags.D);

      SetUserRecord(ur,SizeOf(ur));
    END;
  END;

  PROCEDURE MakeUserOPUS110Main;
  VAR
    ur:Opus110UserType;
  BEGIN
    Esr^.init(2,3,79,ScreenHeight-3,3,'Opus v1.10 user');
    With Esr^,ur do
    BEGIN
      EsFieldOptionsOff(efClearFirstChar);
      AddTextField(  'User No. :',1,2);
{    AddTextField(  'User CRC : ',1,50);}
      EsFieldOptionsOn(EfProtected);
      AddStringField('Name     :',2,2,'',2,13,35,1080,Name);
      AddDateStField('Last date:',3,50,'dd/mm-yy',3,61,1081,Diverse.TempDate);
      AddTimeField(  'Last time:',4,50,'hh:mm:ss',4,61,1082,0,0,Diverse.TempTime);
      EsFieldOptionsOff(EfProtected);
      AddChoiceField('Level    :',3,2,'XXXXXXXXXXXXXXX',3,13,1083,1,IncOpusUserLevel,ClassPriv);
      AddStringField('City     :',4,2,'',4,13,35,1084,City);
      AddStringField('Alias    :',5,2,'',5,13,31,1085,Alias);
      AddStringField('Phone    :',6,2,'',6,13,15,1086,UsrTel);
      AddWordField(  'Calls    :',6,50,'#####',6,61,1087,0,0,Times);
      EsFieldOptionsOn(efPassWordMode);
      AddStringField('Password :',7,2,'',7,13,15,1088,Pwd);
      EsFieldOptionsOff(efPassWordMode);
      AddWordField(  'Msg.area :',10,2,'###',10,13,1089,0,255,MSG);
      AddWordField(  'Filearea :',10,50,'###',10,61,1090,0,255,Files);
      AddlongField(  'Upload Kb:',11,2,'########',11,13,1091,0,0,Upld);
      AddIntField(   'TimeToday:',11,50,'#####',11,61,1092,0,0,Time);
      AddLongField(  'Dnload Kb:',12,2,'########',12,13,1093,0,0,DnLd);
      AddIntField(   'Dnl.today:',12,50,'#####',12,61,1094,0,0,DnLdl);
      AddTextField(  'UL-Ratio : 1 :',13,50);
      AddTextField('ABCDEFGHIJKLMNOPQRSTUVWXYZ012345',17,8);
      EsFieldOptionsOn(efForceOvertype);
      EsFieldOptionsOn(efForceMode);
      AddUserField('Keys :',18,2,'11111111111111111111111111111111',18,8,32,1095,BinLo,BinHi,1,0,ValidateBin32,BinConv32,
                   DrawString,StringEditor,ClassLock);
      SetUserRecord(ur,SizeOf(ur));
    END;
  END;

  PROCEDURE Edit_Combined;      { EDIT Combined record }
  VAR
    x,y      : byte;
    Combined : CombinedType;
  BEGIN
    Esr^.init(2,3,79,22,4,'Combined record');
    for y := 0 to 19 do
      for x := 1 to 10 do
        Esr^.AddYesNoField(longIntForm('###',y*10+x)+':',y+1,x*7-2,'',y+1,x*7+3,1100,combined[y*10+x]);
    Esr^.SetUserRecord(Combined,SizeOf(Combined));
  END;

  PROCEDURE Edit_LastRead;      { EDIT LastRead record }
  VAR
    x,y      : byte;
    LastRead : LastReadType;
  BEGIN
    Esr^.Init(2, 3, 79, 22, 4,'LastRead Record');
    for y := 0 to 39 do
      for x := 1 to 5 do
          Esr^.AddIntField(longIntForm('###',y*5+x)+':',y+1,x*14-6,'#####',y+1,x*14-1,0,0,32767,LastRead[y*5+x]);
    Esr^.SetUserRecord(LastRead,SizeOf(LastRead));
  END;

  PROCEDURE MakeMailScanScreen;
  VAR
    rp:RunParametersType;
  BEGIN
    Esr^.Init(2,3,79,22,3,'Mailscanner: Run parameters');
    WITH Esr^ DO
    BEGIN
      EsFieldOptionsOn(efClearFirstChar);
      AddYesNoField('Toss  :',1,2,'',1,10,0,rp.Toss);
      AddYesNoField('Scan  :',2,2,'',2,10,0,rp.Scan);
      AddYesNoField('Pack  :',3,2,'',3,10,0,rp.Pack);
      AddByteField( 'Sched :',4,2,'###',4,10,0,0,255,rp.Sched);
      SetNextField(3);
      SetUserRecord(rp,SizeOf(rp));
    END;
  END;

  PROCEDURE MakePOPEDHeader;
  VAR
    th : TPopEdHeader;
  BEGIN
    Esr^.Init(2,2,79,6,3,'PopEd v'+ver);
    WITH Esr^ DO
    BEGIN
      EsFieldOptionsOn(efClearFirstChar);
      AddStringField('From :',2,2,'',2,9,35,0,th.FromName);
      AddStringField(' ',2,44,'',2,45,20,0,th.FromAddr);
      AddStringField('To   :',3,2,'',3,9,35,0,th.ToName);
      AddStringField(' ',3,44,'',3,45,20,0,th.ToAddr);
      AddStringField('Subj.:',4,2,'',4,9,62,0,th.Subj);
      SetUserRecord(th,SizeOf(th));
    END;
  END;

{=== Initialization =========================================================}

  PROCEDURE InitLib;
  BEGIN
    cfg.color[1]:=defaultcolorset;
    cfg.color[2]:=defaultcolorset;
    cfg.color[3]:=defaultcolorset;
    cfg.color[4]:=defaultcolorset;

    New(Lib, Init(PoPResourceFileName,SOpen,10240,'POP-RES'));
    if Lib=NIL then New(Lib, Create(PoPResourceFileName,10240,'POP-RES',2048));
    Lib^.RegisterHier(TPoPMenuStream);
    Lib^.RegisterHier(TPoPEntryScreenStream);
    Lib^.RegisterHier(AllEntryFieldsStream);
    Lib^.RegisterHier(TBitYesNoFieldStream);
    Lib^.RegisterPointer(1000, @Cfg);
    Lib^.RegisterPointer(1001, @IncBBSType);
    Lib^.RegisterPointer(1002, @IncNodelist);
    Lib^.RegisterPointer(1003, @NodelistEntry);
    Lib^.RegisterPointer(1004, @Str2Bin);
    Lib^.RegisterPointer(1005, @ValidateBin);
    Lib^.RegisterPointer(1006, @BinConv);
    Lib^.RegisterPointer(1007, @NodesRec);
    Lib^.RegisterPointer(1008, @IncNodeStat);
    Lib^.RegisterPointer(1009, @IncModemType);
    Lib^.RegisterPointer(1010, @IncFreeArea);
    Lib^.RegisterPointer(1011, @CurrentEvent);
{   Lib^.RegisterPointer(1012, @NodeListSegRec);}
    Lib^.RegisterPointer(1013, @UserEdit.IncOPUSUserLevel);
    Lib^.RegisterPointer(1014, @UserEdit.IncMaximusUserLevel);
    Lib^.RegisterPointer(1015, @UserEdit.BinConv32);
    Lib^.RegisterPointer(1016, @UserEdit.ValidateBin32);
{   Lib^.RegisterPointer(1017, @UserEDit.Combined);
    Lib^.RegisterPointer(1018, @UserEdit.UserRecord7);
    Lib^.RegisterPointer(1019, @UserEdit.UserRecord1);
    Lib^.RegisterPointer(1020, @UserEdit.UserRecord4);
    Lib^.RegisterPointer(1021, @UserEdit.UserRecord3);}
{   Lib^.RegisterPointer(1022, @AreasRec);}
    Lib^.RegisterPointer(1023, @IncArcType);
    Lib^.RegisterPointer(1024, @MailCfg.IncSCDAction);
    Lib^.RegisterPointer(1025, @UserEdit.IncMaxHelpLevel);
    Lib^.RegisterPointer(1026, @UserEdit.IncMaxVideoLevel);
    Lib^.RegisterPointer(1027, @UserEdit.IncMaxProtocol);
    Lib^.RegisterPointer(1028, @MailCfg.IncAKAUsed);
    Lib^.RegisterPointer(1029, @IncTaskType);
    Lib^.RegisterPointer(1030, @IncReqOnUs);
    Lib^.RegisterPointer(1031, @UserEdit.ChangeMaxRipStatus);
  END;

BEGIN
  New(Esr);
  InitLib;

  MiscScreen;                    PutEsr(EsrMiscScreen);
  GlobalValues;                  PutEsr(EsrGlobalVal);
  ArchiverSetUp;                 PutEsr(EsrArcSetup);
  DirAndFiles;                   PutEsr(EsrDirAndFiles) ;
  ModemOptions;                  PutEsr(EsrMdmOptions) ;
  Matrix_Info;                   PutEsr(EsrMatrixInfo) ;
  DumbTerminalSetup;             PutEsr(EsrDumbTermSetup) ;
  DumbTerminalExternalProtocols; PutEsr(EsrDumbTermExt) ;
  NodelistCompilerSetup;         PutEsr(EsrNLCompSetup) ;
  NLCompilerTranslationSetup;    PutEsr(EsrNLTranslatSetup) ;
  ConnectionSetup;               PutEsr(EsrConnectionSetup) ;
  AreaManagerConfiguration;      PutEsr(EsrAreaManSetup) ;
  MultiBBSSetUp;                 PutEsr(EsrMultiBBSSetup) ;
  NetMail;                       PutEsr(EsrNetmailSetup) ;
  EchoMail;                      PutEsr(EsrEchoMailSetup) ;
  MiscOptions;                   PutEsr(EsrMailScanMisc) ;
  FwdMiscOptions;                PutEsr(EsrFileFwdMisc) ;
  NLMan;                         PutEsr(EsrNLManager) ;
  Limits;                        PutEsr(EsrReqLimits) ;
  MakeNodesScreen;               PutEsr(EsrNodesSetup) ;
  MakeFwdScreen;                 PutEsr(EsrFileFwdSetup) ;
  MakeOkFileScreen;              PutEsr(EsrOkFileSetup) ;
  InitTickSetup;                 PutEsr(EsrTickSetup) ;
  MakeTickMiscScreen;            PutEsr(EsrMiscTickSetup) ;
  MakeEventScreen;               PutEsr(EsrEventSetup) ;
  NodelistSegSetup;              PutEsr(EsrNodelistSeg) ;
  MakeEchoAreas;                 PutEsr(EsrEchoAreas);
  ListFiles;                     PutEsr(EsrListFiles) ;
  ListFiles2;                    PutEsr(EsrListFiles2) ;
  MultiListSegment;              PutEsr(EsrMFSSetup) ;
  Edit_combined;                 PutEsr(EsrUserQBBSCombined);
  Edit_LastRead;                 PutEsr(EsrUserLastRead);
  UserMaxScreen;                 PutEsr(EsrUserMaximusMain);
  MakeUserSBBSMain;              PutEsr(EsrUserSBBSMain);
  MakeUserSBBSExtra;             PutEsr(EsrUserSBBSExtra);
  MakeUserQBBSMain;              PutEsr(EsrUserQBBSMain);
  MakeUserRAMain;                PutEsr(EsrUserRAMain);
  MakeUserOPUS110Main;           PutEsr(EsrUserOPUS110Main);
  MakeFuncKeyScreen;             PutEsr(EsrFuncKeys);
  AdvModemOPtions;               PutEsr(EsrAdvMdmOptions);
  MakeSchedulerScreen;           PutEsr(EsrScheduleSetup);
  MakeInboundToDoScreen;         PutEsr(EsrInboundToDoSetup);
  MakePopEdHeader;               PutEsr(EsrPopEdHeader);
  MakeMdmConnStat;               PutEsr(EsrMdmConnStat);
{$IFNDEF NOMAILSCANNER}
  MakeMailScanScreen;            PutEsr(EsrMailScanParams);
{$ENDIF}
  Lib^.Pack;
  Dispose(Lib, Done);
  Dispose(Esr);
end.
